/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeadersFactory;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.spdy.DefaultSpdyRstStreamFrame;
import io.netty.handler.codec.spdy.DefaultSpdySynReplyFrame;
import io.netty.handler.codec.spdy.SpdyCodecUtil;
import io.netty.handler.codec.spdy.SpdyDataFrame;
import io.netty.handler.codec.spdy.SpdyFrame;
import io.netty.handler.codec.spdy.SpdyHeaders;
import io.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.netty.handler.codec.spdy.SpdyHttpHeaders;
import io.netty.handler.codec.spdy.SpdyRstStreamFrame;
import io.netty.handler.codec.spdy.SpdyStreamStatus;
import io.netty.handler.codec.spdy.SpdySynReplyFrame;
import io.netty.handler.codec.spdy.SpdySynStreamFrame;
import io.netty.handler.codec.spdy.SpdyVersion;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ObjectUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SpdyHttpDecoder
extends MessageToMessageDecoder<SpdyFrame> {
    private final int spdyVersion;
    private final int maxContentLength;
    private final Map<Integer, FullHttpMessage> messageMap;
    private final HttpHeadersFactory headersFactory;
    private final HttpHeadersFactory trailersFactory;

    public SpdyHttpDecoder(SpdyVersion spdyVersion, int n) {
        this(spdyVersion, n, new HashMap<Integer, FullHttpMessage>(), DefaultHttpHeadersFactory.headersFactory(), DefaultHttpHeadersFactory.trailersFactory());
    }

    @Deprecated
    public SpdyHttpDecoder(SpdyVersion spdyVersion, int n, boolean bl) {
        this(spdyVersion, n, new HashMap<Integer, FullHttpMessage>(), bl);
    }

    protected SpdyHttpDecoder(SpdyVersion spdyVersion, int n, Map<Integer, FullHttpMessage> map) {
        this(spdyVersion, n, map, DefaultHttpHeadersFactory.headersFactory(), DefaultHttpHeadersFactory.trailersFactory());
    }

    @Deprecated
    protected SpdyHttpDecoder(SpdyVersion spdyVersion, int n, Map<Integer, FullHttpMessage> map, boolean bl) {
        this(spdyVersion, n, map, DefaultHttpHeadersFactory.headersFactory().withValidation(bl), DefaultHttpHeadersFactory.trailersFactory().withValidation(bl));
    }

    protected SpdyHttpDecoder(SpdyVersion spdyVersion, int n, Map<Integer, FullHttpMessage> map, HttpHeadersFactory httpHeadersFactory, HttpHeadersFactory httpHeadersFactory2) {
        this.spdyVersion = ((SpdyVersion)((Object)ObjectUtil.checkNotNull((Object)((Object)spdyVersion), (String)"version"))).version();
        this.maxContentLength = ObjectUtil.checkPositive((int)n, (String)"maxContentLength");
        this.messageMap = map;
        this.headersFactory = httpHeadersFactory;
        this.trailersFactory = httpHeadersFactory2;
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        for (Map.Entry<Integer, FullHttpMessage> entry : this.messageMap.entrySet()) {
            ReferenceCountUtil.safeRelease((Object)entry.getValue());
        }
        this.messageMap.clear();
        super.channelInactive(channelHandlerContext);
    }

    protected FullHttpMessage putMessage(int n, FullHttpMessage fullHttpMessage) {
        return this.messageMap.put(n, fullHttpMessage);
    }

    protected FullHttpMessage getMessage(int n) {
        return this.messageMap.get(n);
    }

    protected FullHttpMessage removeMessage(int n) {
        return this.messageMap.remove(n);
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, SpdyFrame spdyFrame, List<Object> list) {
        block37: {
            if (spdyFrame instanceof SpdySynStreamFrame) {
                SpdySynStreamFrame spdySynStreamFrame = (SpdySynStreamFrame)spdyFrame;
                int n = spdySynStreamFrame.streamId();
                if (SpdyCodecUtil.isServerId(n)) {
                    int n2 = spdySynStreamFrame.associatedStreamId();
                    if (n2 == 0) {
                        DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n, SpdyStreamStatus.INVALID_STREAM);
                        channelHandlerContext.writeAndFlush((Object)defaultSpdyRstStreamFrame);
                        return;
                    }
                    if (spdySynStreamFrame.isLast()) {
                        DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n, SpdyStreamStatus.PROTOCOL_ERROR);
                        channelHandlerContext.writeAndFlush((Object)defaultSpdyRstStreamFrame);
                        return;
                    }
                    if (spdySynStreamFrame.isTruncated()) {
                        DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n, SpdyStreamStatus.INTERNAL_ERROR);
                        channelHandlerContext.writeAndFlush((Object)defaultSpdyRstStreamFrame);
                        return;
                    }
                    try {
                        FullHttpRequest fullHttpRequest = SpdyHttpDecoder.createHttpRequest(spdySynStreamFrame, channelHandlerContext.alloc());
                        fullHttpRequest.headers().setInt((CharSequence)SpdyHttpHeaders.Names.STREAM_ID, n);
                        fullHttpRequest.headers().setInt((CharSequence)SpdyHttpHeaders.Names.ASSOCIATED_TO_STREAM_ID, n2);
                        fullHttpRequest.headers().setInt((CharSequence)SpdyHttpHeaders.Names.PRIORITY, spdySynStreamFrame.priority());
                        list.add(fullHttpRequest);
                    }
                    catch (Throwable throwable) {
                        DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n, SpdyStreamStatus.PROTOCOL_ERROR);
                        channelHandlerContext.writeAndFlush((Object)defaultSpdyRstStreamFrame);
                    }
                } else {
                    if (spdySynStreamFrame.isTruncated()) {
                        DefaultSpdySynReplyFrame defaultSpdySynReplyFrame = new DefaultSpdySynReplyFrame(n);
                        defaultSpdySynReplyFrame.setLast(true);
                        SpdyHeaders spdyHeaders = defaultSpdySynReplyFrame.headers();
                        spdyHeaders.setInt(SpdyHeaders.HttpNames.STATUS, HttpResponseStatus.REQUEST_HEADER_FIELDS_TOO_LARGE.code());
                        spdyHeaders.setObject(SpdyHeaders.HttpNames.VERSION, HttpVersion.HTTP_1_0);
                        channelHandlerContext.writeAndFlush((Object)defaultSpdySynReplyFrame);
                        return;
                    }
                    try {
                        FullHttpRequest fullHttpRequest = SpdyHttpDecoder.createHttpRequest(spdySynStreamFrame, channelHandlerContext.alloc());
                        fullHttpRequest.headers().setInt((CharSequence)SpdyHttpHeaders.Names.STREAM_ID, n);
                        if (spdySynStreamFrame.isLast()) {
                            list.add(fullHttpRequest);
                            break block37;
                        }
                        this.putMessage(n, fullHttpRequest);
                    }
                    catch (Throwable throwable) {
                        DefaultSpdySynReplyFrame defaultSpdySynReplyFrame = new DefaultSpdySynReplyFrame(n);
                        defaultSpdySynReplyFrame.setLast(true);
                        SpdyHeaders spdyHeaders = defaultSpdySynReplyFrame.headers();
                        spdyHeaders.setInt(SpdyHeaders.HttpNames.STATUS, HttpResponseStatus.BAD_REQUEST.code());
                        spdyHeaders.setObject(SpdyHeaders.HttpNames.VERSION, HttpVersion.HTTP_1_0);
                        channelHandlerContext.writeAndFlush((Object)defaultSpdySynReplyFrame);
                    }
                }
            } else if (spdyFrame instanceof SpdySynReplyFrame) {
                SpdySynReplyFrame spdySynReplyFrame = (SpdySynReplyFrame)spdyFrame;
                int n = spdySynReplyFrame.streamId();
                if (spdySynReplyFrame.isTruncated()) {
                    DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n, SpdyStreamStatus.INTERNAL_ERROR);
                    channelHandlerContext.writeAndFlush((Object)defaultSpdyRstStreamFrame);
                    return;
                }
                try {
                    FullHttpResponse fullHttpResponse = this.createHttpResponse(spdySynReplyFrame, channelHandlerContext.alloc());
                    fullHttpResponse.headers().setInt((CharSequence)SpdyHttpHeaders.Names.STREAM_ID, n);
                    if (spdySynReplyFrame.isLast()) {
                        HttpUtil.setContentLength(fullHttpResponse, 0L);
                        list.add(fullHttpResponse);
                        break block37;
                    }
                    this.putMessage(n, fullHttpResponse);
                }
                catch (Throwable throwable) {
                    DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n, SpdyStreamStatus.PROTOCOL_ERROR);
                    channelHandlerContext.writeAndFlush((Object)defaultSpdyRstStreamFrame);
                }
            } else if (spdyFrame instanceof SpdyHeadersFrame) {
                SpdyHeadersFrame spdyHeadersFrame = (SpdyHeadersFrame)spdyFrame;
                int n = spdyHeadersFrame.streamId();
                FullHttpMessage fullHttpMessage = this.getMessage(n);
                if (fullHttpMessage == null) {
                    if (SpdyCodecUtil.isServerId(n)) {
                        if (spdyHeadersFrame.isTruncated()) {
                            DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n, SpdyStreamStatus.INTERNAL_ERROR);
                            channelHandlerContext.writeAndFlush((Object)defaultSpdyRstStreamFrame);
                            return;
                        }
                        try {
                            fullHttpMessage = this.createHttpResponse(spdyHeadersFrame, channelHandlerContext.alloc());
                            fullHttpMessage.headers().setInt((CharSequence)SpdyHttpHeaders.Names.STREAM_ID, n);
                            if (spdyHeadersFrame.isLast()) {
                                HttpUtil.setContentLength(fullHttpMessage, 0L);
                                list.add(fullHttpMessage);
                            } else {
                                this.putMessage(n, fullHttpMessage);
                            }
                        }
                        catch (Throwable throwable) {
                            DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n, SpdyStreamStatus.PROTOCOL_ERROR);
                            channelHandlerContext.writeAndFlush((Object)defaultSpdyRstStreamFrame);
                        }
                    }
                    return;
                }
                if (!spdyHeadersFrame.isTruncated()) {
                    Iterator iterator = spdyHeadersFrame.headers().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        fullHttpMessage.headers().add((CharSequence)entry.getKey(), entry.getValue());
                    }
                }
                if (spdyHeadersFrame.isLast()) {
                    HttpUtil.setContentLength(fullHttpMessage, fullHttpMessage.content().readableBytes());
                    this.removeMessage(n);
                    list.add(fullHttpMessage);
                }
            } else if (spdyFrame instanceof SpdyDataFrame) {
                SpdyDataFrame spdyDataFrame = (SpdyDataFrame)spdyFrame;
                int n = spdyDataFrame.streamId();
                FullHttpMessage fullHttpMessage = this.getMessage(n);
                if (fullHttpMessage == null) {
                    return;
                }
                ByteBuf byteBuf = fullHttpMessage.content();
                if (byteBuf.readableBytes() > this.maxContentLength - spdyDataFrame.content().readableBytes()) {
                    this.removeMessage(n);
                    throw new TooLongFrameException("HTTP content length exceeded " + this.maxContentLength + " bytes: " + spdyDataFrame.content().readableBytes());
                }
                ByteBuf byteBuf2 = spdyDataFrame.content();
                int n3 = byteBuf2.readableBytes();
                byteBuf.writeBytes(byteBuf2, byteBuf2.readerIndex(), n3);
                if (spdyDataFrame.isLast()) {
                    HttpUtil.setContentLength(fullHttpMessage, byteBuf.readableBytes());
                    this.removeMessage(n);
                    list.add(fullHttpMessage);
                }
            } else if (spdyFrame instanceof SpdyRstStreamFrame) {
                SpdyRstStreamFrame spdyRstStreamFrame = (SpdyRstStreamFrame)spdyFrame;
                int n = spdyRstStreamFrame.streamId();
                this.removeMessage(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FullHttpRequest createHttpRequest(SpdyHeadersFrame spdyHeadersFrame, ByteBufAllocator byteBufAllocator) {
        SpdyHeaders spdyHeaders = spdyHeadersFrame.headers();
        HttpMethod httpMethod = HttpMethod.valueOf(spdyHeaders.getAsString((CharSequence)SpdyHeaders.HttpNames.METHOD));
        String string = spdyHeaders.getAsString((CharSequence)SpdyHeaders.HttpNames.PATH);
        HttpVersion httpVersion = HttpVersion.valueOf(spdyHeaders.getAsString((CharSequence)SpdyHeaders.HttpNames.VERSION));
        spdyHeaders.remove(SpdyHeaders.HttpNames.METHOD);
        spdyHeaders.remove(SpdyHeaders.HttpNames.PATH);
        spdyHeaders.remove(SpdyHeaders.HttpNames.VERSION);
        boolean bl = true;
        ByteBuf byteBuf = byteBufAllocator.buffer();
        try {
            DefaultFullHttpRequest defaultFullHttpRequest = new DefaultFullHttpRequest(httpVersion, httpMethod, string, byteBuf);
            spdyHeaders.remove(SpdyHeaders.HttpNames.SCHEME);
            CharSequence charSequence = (CharSequence)spdyHeaders.get(SpdyHeaders.HttpNames.HOST);
            spdyHeaders.remove(SpdyHeaders.HttpNames.HOST);
            defaultFullHttpRequest.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)charSequence);
            Object object = spdyHeadersFrame.headers().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                defaultFullHttpRequest.headers().add((CharSequence)entry.getKey(), entry.getValue());
            }
            HttpUtil.setKeepAlive(defaultFullHttpRequest, true);
            defaultFullHttpRequest.headers().remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            bl = false;
            object = defaultFullHttpRequest;
            return object;
        }
        finally {
            if (bl) {
                byteBuf.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FullHttpResponse createHttpResponse(SpdyHeadersFrame spdyHeadersFrame, ByteBufAllocator byteBufAllocator) {
        SpdyHeaders spdyHeaders = spdyHeadersFrame.headers();
        HttpResponseStatus httpResponseStatus = HttpResponseStatus.parseLine((CharSequence)spdyHeaders.get(SpdyHeaders.HttpNames.STATUS));
        HttpVersion httpVersion = HttpVersion.valueOf(spdyHeaders.getAsString((CharSequence)SpdyHeaders.HttpNames.VERSION));
        spdyHeaders.remove(SpdyHeaders.HttpNames.STATUS);
        spdyHeaders.remove(SpdyHeaders.HttpNames.VERSION);
        boolean bl = true;
        ByteBuf byteBuf = byteBufAllocator.buffer();
        try {
            DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(httpVersion, httpResponseStatus, byteBuf, this.headersFactory, this.trailersFactory);
            Object object = spdyHeadersFrame.headers().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                defaultFullHttpResponse.headers().add((CharSequence)entry.getKey(), entry.getValue());
            }
            HttpUtil.setKeepAlive(defaultFullHttpResponse, true);
            defaultFullHttpResponse.headers().remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            defaultFullHttpResponse.headers().remove((CharSequence)HttpHeaderNames.TRAILER);
            bl = false;
            object = defaultFullHttpResponse;
            return object;
        }
        finally {
            if (bl) {
                byteBuf.release();
            }
        }
    }
}

