/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.cio.internals;

import io.ktor.http.cio.internals.CharArrayBuilder;
import io.ktor.http.cio.internals.MutableRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\"\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\u001a\u001f\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a'\u0010\n\u001a\u00020\u00072\u0006\u0010\u0001\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0000\u00a2\u0006\u0004\b\n\u0010\u000b\u001a\u001f\u0010\r\u001a\u00020\f2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\r\u0010\u000e\u001a\u001f\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"", "text", "Lio/ktor/http/cio/internals/MutableRange;", "range", "nextToken", "(Ljava/lang/CharSequence;Lio/ktor/http/cio/internals/MutableRange;)Ljava/lang/CharSequence;", "Lio/ktor/http/cio/internals/CharArrayBuilder;", "", "start", "end", "skipSpacesAndHorizontalTabs", "(Lio/ktor/http/cio/internals/CharArrayBuilder;II)I", "", "skipSpaces", "(Ljava/lang/CharSequence;Lio/ktor/http/cio/internals/MutableRange;)V", "findSpaceOrEnd", "(Ljava/lang/CharSequence;Lio/ktor/http/cio/internals/MutableRange;)I", "ktor-http-cio"})
public final class TokenizerKt {
    public static final CharSequence nextToken(CharSequence charSequence, MutableRange mutableRange) {
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"");
        Intrinsics.checkNotNullParameter((Object)mutableRange, (String)"");
        int n2 = TokenizerKt.findSpaceOrEnd(charSequence, mutableRange);
        CharSequence charSequence2 = charSequence.subSequence(mutableRange.getStart(), n2);
        mutableRange.setStart(n2);
        return charSequence2;
    }

    public static final int skipSpacesAndHorizontalTabs(CharArrayBuilder charArrayBuilder, int n2, int n3) {
        char c2;
        int n4;
        Intrinsics.checkNotNullParameter((Object)charArrayBuilder, (String)"");
        for (n4 = n2; n4 < n3 && (CharsKt.isWhitespace((char)(c2 = charArrayBuilder.charAt(n4))) || c2 == '\t'); ++n4) {
        }
        return n4;
    }

    public static final void skipSpaces(CharSequence charSequence, MutableRange mutableRange) {
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"");
        Intrinsics.checkNotNullParameter((Object)mutableRange, (String)"");
        int n2 = mutableRange.getStart();
        int n3 = mutableRange.getEnd();
        if (n2 >= n3 || !CharsKt.isWhitespace((char)charSequence.charAt(n2))) {
            return;
        }
        ++n2;
        while (n2 < n3 && CharsKt.isWhitespace((char)charSequence.charAt(n2))) {
            ++n2;
        }
        mutableRange.setStart(n2);
    }

    public static final int findSpaceOrEnd(CharSequence charSequence, MutableRange mutableRange) {
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"");
        Intrinsics.checkNotNullParameter((Object)mutableRange, (String)"");
        int n2 = mutableRange.getStart();
        int n3 = mutableRange.getEnd();
        if (n2 >= n3 || CharsKt.isWhitespace((char)charSequence.charAt(n2))) {
            return n2;
        }
        ++n2;
        while (n2 < n3) {
            if (CharsKt.isWhitespace((char)charSequence.charAt(n2))) {
                return n2;
            }
            ++n2;
        }
        return n2;
    }
}

