/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.channel.VoidChannelPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PromiseNotificationUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.TimeUnit;

public final class DelegatingChannelPromiseNotifier
implements ChannelFutureListener,
ChannelPromise {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DelegatingChannelPromiseNotifier.class);
    private final ChannelPromise delegate;
    private final boolean logNotifyFailure;

    public DelegatingChannelPromiseNotifier(ChannelPromise channelPromise) {
        this(channelPromise, !(channelPromise instanceof VoidChannelPromise));
    }

    public DelegatingChannelPromiseNotifier(ChannelPromise channelPromise, boolean bl) {
        this.delegate = (ChannelPromise)ObjectUtil.checkNotNull((Object)channelPromise, (String)"delegate");
        this.logNotifyFailure = bl;
    }

    public void operationComplete(ChannelFuture channelFuture) {
        InternalLogger internalLogger;
        Object object = internalLogger = this.logNotifyFailure ? logger : null;
        if (channelFuture.isSuccess()) {
            Void void_ = (Void)channelFuture.get();
            PromiseNotificationUtil.trySuccess((Promise)this.delegate, (Object)void_, (InternalLogger)internalLogger);
        } else if (channelFuture.isCancelled()) {
            PromiseNotificationUtil.tryCancel((Promise)this.delegate, (InternalLogger)internalLogger);
        } else {
            Throwable throwable = channelFuture.cause();
            PromiseNotificationUtil.tryFailure((Promise)this.delegate, (Throwable)throwable, (InternalLogger)internalLogger);
        }
    }

    @Override
    public Channel channel() {
        return this.delegate.channel();
    }

    @Override
    public ChannelPromise setSuccess(Void void_) {
        this.delegate.setSuccess(void_);
        return this;
    }

    @Override
    public ChannelPromise setSuccess() {
        this.delegate.setSuccess();
        return this;
    }

    @Override
    public boolean trySuccess() {
        return this.delegate.trySuccess();
    }

    public boolean trySuccess(Void void_) {
        return this.delegate.trySuccess(void_);
    }

    @Override
    public ChannelPromise setFailure(Throwable throwable) {
        this.delegate.setFailure(throwable);
        return this;
    }

    @Override
    public ChannelPromise addListener(GenericFutureListener<? extends Future<? super Void>> genericFutureListener) {
        this.delegate.addListener(genericFutureListener);
        return this;
    }

    @Override
    public ChannelPromise addListeners(GenericFutureListener<? extends Future<? super Void>> ... genericFutureListenerArray) {
        this.delegate.addListeners(genericFutureListenerArray);
        return this;
    }

    @Override
    public ChannelPromise removeListener(GenericFutureListener<? extends Future<? super Void>> genericFutureListener) {
        this.delegate.removeListener(genericFutureListener);
        return this;
    }

    @Override
    public ChannelPromise removeListeners(GenericFutureListener<? extends Future<? super Void>> ... genericFutureListenerArray) {
        this.delegate.removeListeners(genericFutureListenerArray);
        return this;
    }

    public boolean tryFailure(Throwable throwable) {
        return this.delegate.tryFailure(throwable);
    }

    public boolean setUncancellable() {
        return this.delegate.setUncancellable();
    }

    @Override
    public ChannelPromise await() {
        this.delegate.await();
        return this;
    }

    @Override
    public ChannelPromise awaitUninterruptibly() {
        this.delegate.awaitUninterruptibly();
        return this;
    }

    @Override
    public boolean isVoid() {
        return this.delegate.isVoid();
    }

    @Override
    public ChannelPromise unvoid() {
        return this.isVoid() ? new DelegatingChannelPromiseNotifier(this.delegate.unvoid()) : this;
    }

    public boolean await(long l, TimeUnit timeUnit) {
        return this.delegate.await(l, timeUnit);
    }

    public boolean await(long l) {
        return this.delegate.await(l);
    }

    public boolean awaitUninterruptibly(long l, TimeUnit timeUnit) {
        return this.delegate.awaitUninterruptibly(l, timeUnit);
    }

    public boolean awaitUninterruptibly(long l) {
        return this.delegate.awaitUninterruptibly(l);
    }

    public Void getNow() {
        return (Void)this.delegate.getNow();
    }

    public boolean cancel(boolean bl) {
        return this.delegate.cancel(bl);
    }

    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    public boolean isDone() {
        return this.delegate.isDone();
    }

    public Void get() {
        return (Void)this.delegate.get();
    }

    public Void get(long l, TimeUnit timeUnit) {
        return (Void)this.delegate.get(l, timeUnit);
    }

    @Override
    public ChannelPromise sync() {
        this.delegate.sync();
        return this;
    }

    @Override
    public ChannelPromise syncUninterruptibly() {
        this.delegate.syncUninterruptibly();
        return this;
    }

    public boolean isSuccess() {
        return this.delegate.isSuccess();
    }

    public boolean isCancellable() {
        return this.delegate.isCancellable();
    }

    public Throwable cause() {
        return this.delegate.cause();
    }
}

