/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.util.concurrent.AbstractFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import java.util.concurrent.TimeUnit;

public final class VoidChannelPromise
extends AbstractFuture<Void>
implements ChannelPromise {
    private final Channel channel;
    private final ChannelFutureListener fireExceptionListener;

    public VoidChannelPromise(Channel channel, boolean bl) {
        ObjectUtil.checkNotNull((Object)channel, (String)"channel");
        this.channel = channel;
        this.fireExceptionListener = bl ? new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture) {
                Throwable throwable = channelFuture.cause();
                if (throwable != null) {
                    VoidChannelPromise.this.fireException0(throwable);
                }
            }
        } : null;
    }

    @Override
    public VoidChannelPromise addListener(GenericFutureListener<? extends Future<? super Void>> genericFutureListener) {
        VoidChannelPromise.fail();
        return this;
    }

    @Override
    public VoidChannelPromise addListeners(GenericFutureListener<? extends Future<? super Void>> ... genericFutureListenerArray) {
        VoidChannelPromise.fail();
        return this;
    }

    @Override
    public VoidChannelPromise removeListener(GenericFutureListener<? extends Future<? super Void>> genericFutureListener) {
        return this;
    }

    @Override
    public VoidChannelPromise removeListeners(GenericFutureListener<? extends Future<? super Void>> ... genericFutureListenerArray) {
        return this;
    }

    @Override
    public VoidChannelPromise await() {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this;
    }

    public boolean await(long l, TimeUnit timeUnit) {
        VoidChannelPromise.fail();
        return false;
    }

    public boolean await(long l) {
        VoidChannelPromise.fail();
        return false;
    }

    @Override
    public VoidChannelPromise awaitUninterruptibly() {
        VoidChannelPromise.fail();
        return this;
    }

    public boolean awaitUninterruptibly(long l, TimeUnit timeUnit) {
        VoidChannelPromise.fail();
        return false;
    }

    public boolean awaitUninterruptibly(long l) {
        VoidChannelPromise.fail();
        return false;
    }

    @Override
    public Channel channel() {
        return this.channel;
    }

    public boolean isDone() {
        return false;
    }

    public boolean isSuccess() {
        return false;
    }

    public boolean setUncancellable() {
        return true;
    }

    public boolean isCancellable() {
        return false;
    }

    public boolean isCancelled() {
        return false;
    }

    public Throwable cause() {
        return null;
    }

    @Override
    public VoidChannelPromise sync() {
        VoidChannelPromise.fail();
        return this;
    }

    @Override
    public VoidChannelPromise syncUninterruptibly() {
        VoidChannelPromise.fail();
        return this;
    }

    @Override
    public VoidChannelPromise setFailure(Throwable throwable) {
        this.fireException0(throwable);
        return this;
    }

    @Override
    public VoidChannelPromise setSuccess() {
        return this;
    }

    public boolean tryFailure(Throwable throwable) {
        this.fireException0(throwable);
        return false;
    }

    public boolean cancel(boolean bl) {
        return false;
    }

    @Override
    public boolean trySuccess() {
        return false;
    }

    private static void fail() {
        throw new IllegalStateException("void future");
    }

    @Override
    public VoidChannelPromise setSuccess(Void void_) {
        return this;
    }

    public boolean trySuccess(Void void_) {
        return false;
    }

    public Void getNow() {
        return null;
    }

    @Override
    public ChannelPromise unvoid() {
        DefaultChannelPromise defaultChannelPromise = new DefaultChannelPromise(this.channel);
        if (this.fireExceptionListener != null) {
            defaultChannelPromise.addListener(this.fireExceptionListener);
        }
        return defaultChannelPromise;
    }

    @Override
    public boolean isVoid() {
        return true;
    }

    private void fireException0(Throwable throwable) {
        if (this.fireExceptionListener != null && this.channel.isRegistered()) {
            this.channel.pipeline().fireExceptionCaught(throwable);
        }
    }
}

