/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.nio;

import java.nio.channels.SelectionKey;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class SelectedSelectionKeySet
extends AbstractSet<SelectionKey> {
    SelectionKey[] keys = new SelectionKey[1024];
    int size;

    SelectedSelectionKeySet() {
    }

    @Override
    public boolean add(SelectionKey selectionKey) {
        if (selectionKey == null) {
            return false;
        }
        if (this.size == this.keys.length) {
            this.increaseCapacity();
        }
        this.keys[this.size++] = selectionKey;
        return true;
    }

    @Override
    public boolean remove(Object object) {
        return false;
    }

    @Override
    public boolean contains(Object object) {
        SelectionKey[] selectionKeyArray = this.keys;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            SelectionKey selectionKey = selectionKeyArray[i];
            if (!selectionKey.equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterator<SelectionKey> iterator() {
        return new Iterator<SelectionKey>(){
            private int idx;

            @Override
            public boolean hasNext() {
                return this.idx < SelectedSelectionKeySet.this.size;
            }

            @Override
            public SelectionKey next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return SelectedSelectionKeySet.this.keys[this.idx++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    void reset() {
        this.reset(0);
    }

    void reset(int n) {
        Arrays.fill(this.keys, n, this.size, null);
        this.size = 0;
    }

    private void increaseCapacity() {
        SelectionKey[] selectionKeyArray = new SelectionKey[this.keys.length << 1];
        System.arraycopy(this.keys, 0, selectionKeyArray, 0, this.size);
        this.keys = selectionKeyArray;
    }
}

