/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.oio;

import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.ThreadPerChannelEventLoop;
import java.net.SocketAddress;

@Deprecated
public abstract class AbstractOioChannel
extends AbstractChannel {
    protected static final int SO_TIMEOUT = 1000;
    boolean readPending;
    boolean readWhenInactive;
    final Runnable readTask = new Runnable(){

        @Override
        public void run() {
            AbstractOioChannel.this.doRead();
        }
    };
    private final Runnable clearReadPendingRunnable = new Runnable(){

        @Override
        public void run() {
            AbstractOioChannel.this.readPending = false;
        }
    };

    protected AbstractOioChannel(Channel channel) {
        super(channel);
    }

    @Override
    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new DefaultOioUnsafe();
    }

    @Override
    protected boolean isCompatible(EventLoop eventLoop) {
        return eventLoop instanceof ThreadPerChannelEventLoop;
    }

    protected abstract void doConnect(SocketAddress var1, SocketAddress var2);

    @Override
    protected void doBeginRead() {
        if (this.readPending) {
            return;
        }
        if (!this.isActive()) {
            this.readWhenInactive = true;
            return;
        }
        this.readPending = true;
        this.eventLoop().execute(this.readTask);
    }

    protected abstract void doRead();

    @Deprecated
    protected boolean isReadPending() {
        return this.readPending;
    }

    @Deprecated
    protected void setReadPending(final boolean bl) {
        if (this.isRegistered()) {
            EventLoop eventLoop = this.eventLoop();
            if (eventLoop.inEventLoop()) {
                this.readPending = bl;
            } else {
                eventLoop.execute(new Runnable(){

                    @Override
                    public void run() {
                        AbstractOioChannel.this.readPending = bl;
                    }
                });
            }
        } else {
            this.readPending = bl;
        }
    }

    protected final void clearReadPending() {
        if (this.isRegistered()) {
            EventLoop eventLoop = this.eventLoop();
            if (eventLoop.inEventLoop()) {
                this.readPending = false;
            } else {
                eventLoop.execute(this.clearReadPendingRunnable);
            }
        } else {
            this.readPending = false;
        }
    }

    private final class DefaultOioUnsafe
    extends AbstractChannel.AbstractUnsafe {
        private DefaultOioUnsafe() {
        }

        @Override
        public void connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
            if (!channelPromise.setUncancellable() || !this.ensureOpen(channelPromise)) {
                return;
            }
            try {
                boolean bl = AbstractOioChannel.this.isActive();
                AbstractOioChannel.this.doConnect(socketAddress, socketAddress2);
                boolean bl2 = AbstractOioChannel.this.isActive();
                this.safeSetSuccess(channelPromise);
                if (!bl && bl2) {
                    AbstractOioChannel.this.pipeline().fireChannelActive();
                }
            }
            catch (Throwable throwable) {
                this.safeSetFailure(channelPromise, this.annotateConnectException(throwable, socketAddress));
                this.closeIfClosed();
            }
        }
    }
}

