/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.pool;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoop;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.util.Deque;
import java.util.concurrent.Callable;

public class SimpleChannelPool
implements ChannelPool {
    private static final AttributeKey<SimpleChannelPool> POOL_KEY = AttributeKey.newInstance((String)"io.netty.channel.pool.SimpleChannelPool");
    private final Deque<Channel> deque = PlatformDependent.newConcurrentDeque();
    private final ChannelPoolHandler handler;
    private final ChannelHealthChecker healthCheck;
    private final Bootstrap bootstrap;
    private final boolean releaseHealthCheck;
    private final boolean lastRecentUsed;

    public SimpleChannelPool(Bootstrap bootstrap, ChannelPoolHandler channelPoolHandler) {
        this(bootstrap, channelPoolHandler, ChannelHealthChecker.ACTIVE);
    }

    public SimpleChannelPool(Bootstrap bootstrap, ChannelPoolHandler channelPoolHandler, ChannelHealthChecker channelHealthChecker) {
        this(bootstrap, channelPoolHandler, channelHealthChecker, true);
    }

    public SimpleChannelPool(Bootstrap bootstrap, ChannelPoolHandler channelPoolHandler, ChannelHealthChecker channelHealthChecker, boolean bl) {
        this(bootstrap, channelPoolHandler, channelHealthChecker, bl, true);
    }

    public SimpleChannelPool(Bootstrap bootstrap, final ChannelPoolHandler channelPoolHandler, ChannelHealthChecker channelHealthChecker, boolean bl, boolean bl2) {
        this.handler = (ChannelPoolHandler)ObjectUtil.checkNotNull((Object)channelPoolHandler, (String)"handler");
        this.healthCheck = (ChannelHealthChecker)ObjectUtil.checkNotNull((Object)channelHealthChecker, (String)"healthCheck");
        this.releaseHealthCheck = bl;
        this.bootstrap = ((Bootstrap)ObjectUtil.checkNotNull((Object)bootstrap, (String)"bootstrap")).clone();
        this.bootstrap.handler(new ChannelInitializer<Channel>(){

            @Override
            protected void initChannel(Channel channel) {
                assert (channel.eventLoop().inEventLoop());
                channelPoolHandler.channelCreated(channel);
            }
        });
        this.lastRecentUsed = bl2;
    }

    protected Bootstrap bootstrap() {
        return this.bootstrap;
    }

    protected ChannelPoolHandler handler() {
        return this.handler;
    }

    protected ChannelHealthChecker healthChecker() {
        return this.healthCheck;
    }

    protected boolean releaseHealthCheck() {
        return this.releaseHealthCheck;
    }

    @Override
    public final Future<Channel> acquire() {
        return this.acquire((Promise<Channel>)this.bootstrap.config().group().next().newPromise());
    }

    @Override
    public Future<Channel> acquire(Promise<Channel> promise) {
        return this.acquireHealthyFromPoolOrNew((Promise<Channel>)((Promise)ObjectUtil.checkNotNull(promise, (String)"promise")));
    }

    private Future<Channel> acquireHealthyFromPoolOrNew(final Promise<Channel> promise) {
        try {
            final Channel channel = this.pollChannel();
            if (channel == null) {
                Bootstrap bootstrap = this.bootstrap.clone();
                bootstrap.attr(POOL_KEY, this);
                ChannelFuture channelFuture = this.connectChannel(bootstrap);
                if (channelFuture.isDone()) {
                    this.notifyConnect(channelFuture, promise);
                } else {
                    channelFuture.addListener(new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture channelFuture) {
                            SimpleChannelPool.this.notifyConnect(channelFuture, (Promise<Channel>)promise);
                        }
                    });
                }
            } else {
                EventLoop eventLoop = channel.eventLoop();
                if (eventLoop.inEventLoop()) {
                    this.doHealthCheck(channel, promise);
                } else {
                    eventLoop.execute(new Runnable(){

                        @Override
                        public void run() {
                            SimpleChannelPool.this.doHealthCheck(channel, (Promise<Channel>)promise);
                        }
                    });
                }
            }
        }
        catch (Throwable throwable) {
            promise.tryFailure(throwable);
        }
        return promise;
    }

    private void notifyConnect(ChannelFuture channelFuture, Promise<Channel> promise) {
        Channel channel = null;
        try {
            if (channelFuture.isSuccess()) {
                channel = channelFuture.channel();
                this.handler.channelAcquired(channel);
                if (!promise.trySuccess((Object)channel)) {
                    this.release(channel);
                }
            } else {
                promise.tryFailure(channelFuture.cause());
            }
        }
        catch (Throwable throwable) {
            this.closeAndFail(channel, throwable, promise);
        }
    }

    private void doHealthCheck(final Channel channel, final Promise<Channel> promise) {
        try {
            assert (channel.eventLoop().inEventLoop());
            Future<Boolean> future = this.healthCheck.isHealthy(channel);
            if (future.isDone()) {
                this.notifyHealthCheck(future, channel, promise);
            } else {
                future.addListener((GenericFutureListener)new FutureListener<Boolean>(){

                    public void operationComplete(Future<Boolean> future) {
                        SimpleChannelPool.this.notifyHealthCheck((Future<Boolean>)future, channel, (Promise<Channel>)promise);
                    }
                });
            }
        }
        catch (Throwable throwable) {
            this.closeAndFail(channel, throwable, promise);
        }
    }

    private void notifyHealthCheck(Future<Boolean> future, Channel channel, Promise<Channel> promise) {
        try {
            assert (channel.eventLoop().inEventLoop());
            if (future.isSuccess() && ((Boolean)future.getNow()).booleanValue()) {
                channel.attr(POOL_KEY).set((Object)this);
                this.handler.channelAcquired(channel);
                promise.setSuccess((Object)channel);
            } else {
                this.closeChannel(channel);
                this.acquireHealthyFromPoolOrNew(promise);
            }
        }
        catch (Throwable throwable) {
            this.closeAndFail(channel, throwable, promise);
        }
    }

    protected ChannelFuture connectChannel(Bootstrap bootstrap) {
        return bootstrap.connect();
    }

    @Override
    public final Future<Void> release(Channel channel) {
        return this.release(channel, (Promise<Void>)channel.eventLoop().newPromise());
    }

    @Override
    public Future<Void> release(final Channel channel, final Promise<Void> promise) {
        try {
            ObjectUtil.checkNotNull((Object)channel, (String)"channel");
            ObjectUtil.checkNotNull(promise, (String)"promise");
            EventLoop eventLoop = channel.eventLoop();
            if (eventLoop.inEventLoop()) {
                this.doReleaseChannel(channel, promise);
            } else {
                eventLoop.execute(new Runnable(){

                    @Override
                    public void run() {
                        SimpleChannelPool.this.doReleaseChannel(channel, (Promise<Void>)promise);
                    }
                });
            }
        }
        catch (Throwable throwable) {
            this.closeAndFail(channel, throwable, promise);
        }
        return promise;
    }

    private void doReleaseChannel(Channel channel, Promise<Void> promise) {
        try {
            assert (channel.eventLoop().inEventLoop());
            if (channel.attr(POOL_KEY).getAndSet(null) != this) {
                this.closeAndFail(channel, new IllegalArgumentException("Channel " + channel + " was not acquired from this ChannelPool"), promise);
            } else if (this.releaseHealthCheck) {
                this.doHealthCheckOnRelease(channel, promise);
            } else {
                this.releaseAndOffer(channel, promise);
            }
        }
        catch (Throwable throwable) {
            this.closeAndFail(channel, throwable, promise);
        }
    }

    private void doHealthCheckOnRelease(final Channel channel, final Promise<Void> promise) {
        final Future<Boolean> future = this.healthCheck.isHealthy(channel);
        if (future.isDone()) {
            this.releaseAndOfferIfHealthy(channel, promise, future);
        } else {
            future.addListener((GenericFutureListener)new FutureListener<Boolean>(){

                public void operationComplete(Future<Boolean> future2) {
                    SimpleChannelPool.this.releaseAndOfferIfHealthy(channel, (Promise<Void>)promise, (Future<Boolean>)future);
                }
            });
        }
    }

    private void releaseAndOfferIfHealthy(Channel channel, Promise<Void> promise, Future<Boolean> future) {
        try {
            if (((Boolean)future.getNow()).booleanValue()) {
                this.releaseAndOffer(channel, promise);
            } else {
                this.handler.channelReleased(channel);
                promise.setSuccess(null);
            }
        }
        catch (Throwable throwable) {
            this.closeAndFail(channel, throwable, promise);
        }
    }

    private void releaseAndOffer(Channel channel, Promise<Void> promise) {
        if (this.offerChannel(channel)) {
            this.handler.channelReleased(channel);
            promise.setSuccess(null);
        } else {
            this.closeAndFail(channel, new ChannelPoolFullException(), promise);
        }
    }

    private void closeChannel(Channel channel) {
        channel.attr(POOL_KEY).getAndSet(null);
        channel.close();
    }

    private void closeAndFail(Channel channel, Throwable throwable, Promise<?> promise) {
        if (channel != null) {
            try {
                this.closeChannel(channel);
            }
            catch (Throwable throwable2) {
                promise.tryFailure(throwable2);
            }
        }
        promise.tryFailure(throwable);
    }

    protected Channel pollChannel() {
        return this.lastRecentUsed ? this.deque.pollLast() : this.deque.pollFirst();
    }

    protected boolean offerChannel(Channel channel) {
        return this.deque.offer(channel);
    }

    @Override
    public void close() {
        Channel channel;
        while ((channel = this.pollChannel()) != null) {
            channel.close().awaitUninterruptibly();
        }
    }

    public Future<Void> closeAsync() {
        return GlobalEventExecutor.INSTANCE.submit((Callable)new Callable<Void>(){

            @Override
            public Void call() {
                SimpleChannelPool.this.close();
                return null;
            }
        });
    }

    private static final class ChannelPoolFullException
    extends IllegalStateException {
        private ChannelPoolFullException() {
            super("ChannelPool full");
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

