/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.gnomeShell;

import dorkbox.executor.Executor;
import dorkbox.os.OS;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.util.KotlinUtils;
import dorkbox.util.IO;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ExtensionSupport {
    static final List<String> enabledExtensions = ExtensionSupport.getEnabledExtensions();
    private final String name;
    private final String UID;
    private final String zipFile;

    public ExtensionSupport(String string, String string2, String string3) {
        this.UID = string2;
        this.name = string;
        this.zipFile = string3;
    }

    public void uninstall() {
        ExtensionSupport.unInstall(this.UID, null);
    }

    public boolean isInstalled() {
        return enabledExtensions.contains(this.UID);
    }

    public void install() {
        boolean bl;
        String string;
        if (SystemTray.DEBUG) {
            SystemTray.logger.debug("Installing the " + this.name + " gnome-shell extension.");
        }
        if ((string = ExtensionSupport.getGnomeVersion()) == null) {
            return;
        }
        boolean bl2 = enabledExtensions.contains(this.UID);
        String string2 = System.getProperty("user.home");
        File file = new File(string2 + "/.local/share/gnome-shell/extensions/" + this.UID);
        File file2 = new File(file, "metadata.json");
        String string3 = ExtensionSupport.createMetadata(this.UID, SystemTray.getVersion(), "SystemTray", string);
        if (SystemTray.DEBUG) {
            SystemTray.logger.debug("Checking the " + this.name + " gnome-shell extension");
        }
        if (bl2 && !ExtensionSupport.needsUpgrade(string3, file2)) {
            return;
        }
        if (SystemTray.DEBUG) {
            SystemTray.logger.debug("Installing " + this.name + " gnome-shell extension");
        }
        if (bl = ExtensionSupport.writeFile(string3, file2)) {
            boolean bl3 = ExtensionSupport.installZip(this.zipFile, file);
            if (!bl3) {
                SystemTray.logger.error("Unable to install " + this.zipFile + " gnome-shell extension!");
            } else if (SystemTray.DEBUG) {
                SystemTray.logger.debug("Enabling " + this.zipFile + " gnome-shell extension");
            }
            if (!enabledExtensions.contains(this.UID)) {
                enabledExtensions.add(this.UID);
            }
            ExtensionSupport.setEnabledExtensions(enabledExtensions);
        }
    }

    public static List<String> getEnabledExtensions() {
        String string2;
        try {
            string2 = KotlinUtils.INSTANCE.execute("/usr/bin/gsettings", "get", "org.gnome.shell", "enabled-extensions");
        }
        catch (Exception exception) {
            SystemTray.logger.error("Unable to get gnome shell extensions!", (Throwable)exception);
            string2 = "";
        }
        StringBuilder stringBuilder = new StringBuilder(string2);
        int n = string2.indexOf("]");
        if (n > 0) {
            stringBuilder.delete(n, stringBuilder.length());
        }
        if ((n = string2.indexOf("[")) >= 0) {
            stringBuilder.delete(0, n + 1);
        }
        String string3 = stringBuilder.toString();
        String[] stringArray = string3.split(", ");
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            int n2 = string4.indexOf("'");
            int n3 = string4.lastIndexOf("'");
            if (n2 != 0 || n3 != string4.length() - 1) continue;
            stringArray[i] = string4.substring(1, string4.length() - 1);
        }
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        arrayList.removeIf(string -> string.trim().isEmpty());
        if (SystemTray.DEBUG) {
            SystemTray.logger.debug("Installed extensions are: {}", arrayList);
        }
        return arrayList;
    }

    public static void setEnabledExtensions(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder("[");
        int n = list.size();
        int n2 = n - 1;
        for (int i = 0; i < n; ++i) {
            String string = list.get(i);
            if (string.isEmpty()) continue;
            stringBuilder.append("'").append(string).append("'");
            if (i >= n2) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
        if (SystemTray.DEBUG) {
            SystemTray.logger.debug("Setting installed extensions to: {}", (Object)stringBuilder.toString());
        }
        try {
            KotlinUtils.INSTANCE.execute("/usr/bin/gsettings", "set", "org.gnome.shell", "enabled-extensions", stringBuilder.toString());
        }
        catch (Exception exception) {
            SystemTray.logger.error("Unable to set gnome shell extensions!", (Throwable)exception);
        }
    }

    public static void unInstall(String string, String string2) {
        String string3;
        File file;
        boolean bl = enabledExtensions.contains(string);
        if (bl) {
            enabledExtensions.remove(string);
            ExtensionSupport.setEnabledExtensions(enabledExtensions);
        }
        if ((file = new File((string3 = System.getProperty("user.home")) + "/.local/share/gnome-shell/extensions/" + string)).canRead()) {
            KotlinUtils.INSTANCE.delete(file);
        }
        if (bl) {
            ExtensionSupport.restartShell(string2);
        }
    }

    public static void restartShell(String string) {
        if (string == null) {
            return;
        }
        SystemTray.logger.info("Restarting gnome-shell via '{}' so tray notification changes can be applied.", (Object)string);
        try {
            new Executor().command(new String[]{string}).startAsShellBlocking();
        }
        catch (Exception exception) {
            SystemTray.logger.error("Unable to restart gnome shell!", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean writeFile(String string, File file) {
        boolean bl;
        File file2 = file.getParentFile();
        if (!file2.isDirectory() && !(bl = file2.mkdirs())) {
            String string2 = "Unable to create extension location: " + file2;
            SystemTray.logger.error(string2);
            return false;
        }
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file, false));
            bufferedWriter.write(string);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            SystemTray.logger.error("Error installing extension metadata file", (Throwable)iOException);
            boolean bl2 = true;
            return bl2;
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    SystemTray.logger.error("Error closing: {}", (Object)bufferedWriter, (Object)iOException);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean installFile(String string, File file, String string2) {
        File file2 = new File(file, string);
        try {
            InputStream inputStream = ExtensionSupport.class.getResourceAsStream(string);
            if (inputStream == null) {
                SystemTray.logger.error("The {} file resource cannot be found. Something is severely wrong.", (Object)string);
                return false;
            }
            FileWriter fileWriter = new FileWriter(file2);
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            try {
                String string3;
                String string4 = OS.INSTANCE.getLINE_SEPARATOR();
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                while ((string3 = bufferedReader.readLine()) != null) {
                    if (string3.startsWith("let APP_NAME = \"")) {
                        string3 = "let APP_NAME = \"" + string2 + "\";";
                    }
                    fileWriter.write(string3);
                    fileWriter.write(string4);
                }
            }
            finally {
                IO.closeQuietly((Closeable)inputStreamReader);
                IO.closeQuietly((Closeable)fileWriter);
            }
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            SystemTray.logger.error("Cannot find gnome-shell extension", (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            SystemTray.logger.error("Unable to get gnome-shell extension", (Throwable)iOException);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean installZip(String string, File file) {
        ZipInputStream zipInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            ZipEntry zipEntry;
            InputStream inputStream = ExtensionSupport.class.getResourceAsStream(string);
            if (inputStream == null) {
                SystemTray.logger.error("The appindicator extension resource cannot be found. This is unexpected!");
                boolean bl = false;
                return bl;
            }
            zipInputStream = new ZipInputStream(inputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                String string2 = zipEntry.getName();
                try {
                    boolean bl;
                    File file2 = new File(file, string2);
                    File file3 = file2.getParentFile();
                    if (!file3.exists() && !(bl = file3.mkdirs())) {
                        SystemTray.logger.error("Error creating target directory '{}' for Zip support.", (Object)file3);
                    }
                    fileOutputStream = new FileOutputStream(file2);
                    IO.copyStream((InputStream)zipInputStream, (OutputStream)fileOutputStream);
                }
                catch (IOException iOException) {
                    SystemTray.logger.error("Error extracting zip contents to {}", (Object)file);
                }
                finally {
                    if (fileOutputStream == null) continue;
                    IO.closeQuietly((Closeable)fileOutputStream);
                    fileOutputStream = null;
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            SystemTray.logger.error("Cannot find gnome-shell extension", (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            SystemTray.logger.error("Unable to get gnome-shell extension", (Throwable)iOException);
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {
                    SystemTray.logger.error("Error closing: {}", (Object)zipInputStream, (Object)iOException);
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    SystemTray.logger.error("Error closing: {}", (Object)fileOutputStream, (Object)iOException);
                }
            }
        }
        return false;
    }

    protected static String createMetadata(String string, String string2, String string3, String string4) {
        return "{\n  \"description\": \"Moves the java SystemTray icon from inside the notification drawer to alongside the clock.\",\n  \"name\": \"Dorkbox SystemTray\",\n  \"app-name-id\": \"" + string3 + "\",\n  \"shell-version\": [\n    \"" + string4 + "\"\n  ],\n  \"url\": \"https://git.dorkbox.com/dorkbox/SystemTray\",\n  \"uuid\": \"" + string + "\",\n  \"version\": " + string2 + "\n}\n";
    }

    protected static String getGnomeVersion() {
        int n;
        String string = OS.DesktopEnv.INSTANCE.getGnomeVersion();
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf(46);
        if (n2 < (n = string.indexOf(46, n2 + 1))) {
            return string.substring(0, n);
        }
        return string;
    }

    protected static boolean needsUpgrade(String string, File file) {
        String string2 = KotlinUtils.INSTANCE.readText(file);
        if (SystemTray.DEBUG) {
            SystemTray.logger.debug("Extension already installed, checking for upgrade");
        }
        if (string.equals(string2)) {
            if (!SystemTray.DEBUG) {
                return false;
            }
            SystemTray.logger.debug("Always upgrading extension in DEBUG mode");
        } else if (SystemTray.DEBUG) {
            SystemTray.logger.debug("Need to upgrade extension");
        }
        return true;
    }
}

