/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.osx;

import dorkbox.collections.ArrayMap;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.Tray;
import dorkbox.systemTray.ui.osx.AwtOsxMenu;
import dorkbox.systemTray.util.AwtAccessor;
import dorkbox.systemTray.util.ImageResizeUtil;
import dorkbox.util.SwingUtil;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import javax.swing.ImageIcon;

public class _OsxAwtTray
extends Tray {
    private volatile java.awt.SystemTray tray;
    private volatile TrayIcon trayIcon;
    private volatile boolean visible = false;
    private volatile File imageFile;
    private volatile String tooltipText = "";
    private volatile CountDownLatch keepAliveLatch = new CountDownLatch(1);
    private volatile Thread keepAliveThread;
    private final ArrayMap<String, Image> imageCache = new ArrayMap(false, 10);

    public _OsxAwtTray(String string, ImageResizeUtil imageResizeUtil, Runnable runnable) {
        super(runnable);
        if (!java.awt.SystemTray.isSupported()) {
            throw new RuntimeException("System Tray is not supported in this configuration! Please write an issue and include your OS type and configuration");
        }
        this.keepAliveThread = new Thread(() -> {
            CountDownLatch countDownLatch = this.keepAliveLatch;
            synchronized (countDownLatch) {
                this.keepAliveLatch.countDown();
                this.keepAliveLatch = new CountDownLatch(1);
            }
        }, "TrayKeepAliveThread");
        this.keepAliveThread.start();
        AwtOsxMenu awtOsxMenu = new AwtOsxMenu(null){

            @Override
            public void setEnabled(MenuItem menuItem) {
                SwingUtil.INSTANCE.invokeLater(() -> {
                    if (_OsxAwtTray.this.tray == null) {
                        _OsxAwtTray.this.tray = java.awt.SystemTray.getSystemTray();
                    }
                    boolean bl = menuItem.getEnabled();
                    if (_OsxAwtTray.this.keepAliveThread != null) {
                        CountDownLatch countDownLatch = _OsxAwtTray.this.keepAliveLatch;
                        synchronized (countDownLatch) {
                            _OsxAwtTray.this.keepAliveLatch.countDown();
                        }
                    }
                    _OsxAwtTray.this.keepAliveThread = null;
                    if (_OsxAwtTray.this.visible && !bl) {
                        _OsxAwtTray.this.tray.remove(_OsxAwtTray.this.trayIcon);
                        _OsxAwtTray.this.visible = false;
                    } else if (!_OsxAwtTray.this.visible && bl && _OsxAwtTray.this.trayIcon != null) {
                        try {
                            _OsxAwtTray.this.tray.add(_OsxAwtTray.this.trayIcon);
                            _OsxAwtTray.this.visible = true;
                            _OsxAwtTray.this.trayIcon.setToolTip(_OsxAwtTray.this.tooltipText);
                        }
                        catch (AWTException aWTException) {
                            SystemTray.logger.error("Error adding the icon back to the tray", (Throwable)aWTException);
                        }
                    }
                });
            }

            @Override
            public void setImage(MenuItem menuItem) {
                _OsxAwtTray.this.imageFile = menuItem.getImage();
                SwingUtil.INSTANCE.invokeLater(() -> {
                    Image image;
                    Object object;
                    if (_OsxAwtTray.this.tray == null) {
                        _OsxAwtTray.this.tray = java.awt.SystemTray.getSystemTray();
                    }
                    if (_OsxAwtTray.this.imageFile != null) {
                        object = _OsxAwtTray.this.imageFile.getAbsolutePath();
                        ArrayMap arrayMap = _OsxAwtTray.this.imageCache;
                        synchronized (arrayMap) {
                            Image image2 = (Image)_OsxAwtTray.this.imageCache.get(object);
                            if (image2 == null) {
                                image2 = new ImageIcon((String)object).getImage();
                                _OsxAwtTray.this.imageCache.put(object, (Object)image2);
                                if (_OsxAwtTray.this.imageCache.getSize() > 120) {
                                    SystemTray.logger.error("More than 120 different images used for the SystemTray icon. This will lead to performance issues.");
                                }
                            }
                            image = image2;
                        }
                    } else {
                        image = null;
                    }
                    if (_OsxAwtTray.this.trayIcon == null) {
                        if (image == null) {
                            return;
                        }
                        _OsxAwtTray.this.trayIcon = new TrayIcon(image);
                        _OsxAwtTray.this.trayIcon.setPopupMenu((PopupMenu)this._native);
                        object = this;
                        if (SystemTray.AUTO_FIX_INCONSISTENCIES) {
                            SystemTray.logger.debug("Auto-fixing right-click for macOS system tray");
                            _OsxAwtTray.this.trayIcon.addMouseListener(new MouseAdapter(){

                                @Override
                                public void mouseClicked(MouseEvent mouseEvent) {
                                    if (!mouseEvent.isPopupTrigger() && mouseEvent.getButton() != 1) {
                                        final Point2D point2D = AwtAccessor.getLocation(_OsxAwtTray.this.trayIcon);
                                        Component component = new Component(){

                                            @Override
                                            public Point getLocationOnScreen() {
                                                return new Point((int)point2D.getX() - 4, (int)point2D.getY() + 6);
                                            }
                                        };
                                        AwtAccessor.showPopup(component, _native);
                                    }
                                }
                            });
                        }
                        try {
                            _OsxAwtTray.this.tray.add(_OsxAwtTray.this.trayIcon);
                            _OsxAwtTray.this.visible = true;
                        }
                        catch (AWTException aWTException) {
                            SystemTray.logger.error("TrayIcon could not be added.", (Throwable)aWTException);
                        }
                    } else {
                        _OsxAwtTray.this.trayIcon.setImage(image);
                    }
                    _OsxAwtTray.this.trayIcon.setToolTip(_OsxAwtTray.this.tooltipText);
                });
            }

            @Override
            public void setText(MenuItem menuItem) {
            }

            @Override
            public void setShortcut(MenuItem menuItem) {
            }

            @Override
            public void setTooltip(MenuItem menuItem) {
                String string = menuItem.getTooltip();
                if (_OsxAwtTray.this.tooltipText != null && _OsxAwtTray.this.tooltipText.equals(string)) {
                    return;
                }
                _OsxAwtTray.this.tooltipText = string;
                SwingUtil.INSTANCE.invokeLater(() -> {
                    if (_OsxAwtTray.this.trayIcon != null) {
                        _OsxAwtTray.this.trayIcon.setToolTip(string);
                    }
                });
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove() {
                Object object = _OsxAwtTray.this.imageCache;
                synchronized (object) {
                    for (Image image : _OsxAwtTray.this.imageCache.getValues()) {
                        image.flush();
                    }
                    _OsxAwtTray.this.imageCache.clear();
                }
                SwingUtil.INSTANCE.invokeAndWaitQuietly(() -> {
                    if (_OsxAwtTray.this.trayIcon != null) {
                        _OsxAwtTray.this.trayIcon.setPopupMenu(null);
                        if (_OsxAwtTray.this.tray != null) {
                            _OsxAwtTray.this.tray.remove(_OsxAwtTray.this.trayIcon);
                        }
                        _OsxAwtTray.this.trayIcon = null;
                    }
                    _OsxAwtTray.this.tray = null;
                    super.remove();
                });
                if (_OsxAwtTray.this.keepAliveThread != null) {
                    object = _OsxAwtTray.this.keepAliveLatch;
                    synchronized (object) {
                        _OsxAwtTray.this.keepAliveLatch.countDown();
                    }
                }
            }
        };
        this.bind(awtOsxMenu, null, imageResizeUtil);
    }

    @Override
    public boolean hasImage() {
        return this.imageFile != null;
    }
}

