/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.swing;

import dorkbox.systemTray.Checkbox;
import dorkbox.systemTray.Entry;
import dorkbox.systemTray.Menu;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.Separator;
import dorkbox.systemTray.Status;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.peer.MenuPeer;
import dorkbox.systemTray.ui.swing.SwingMenuItem;
import dorkbox.systemTray.ui.swing.SwingMenuItemCheckbox;
import dorkbox.systemTray.ui.swing.SwingMenuItemSeparator;
import dorkbox.systemTray.ui.swing.SwingMenuItemStatus;
import dorkbox.systemTray.ui.swing.TrayPopup;
import dorkbox.util.SwingUtil;
import java.awt.Component;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

public class SwingMenu
implements MenuPeer {
    private final SwingMenu parent;
    final JComponent _native;

    SwingMenu(String string) {
        this.parent = null;
        TrayPopup trayPopup = new TrayPopup(string);
        if (SystemTray.SWING_UI != null) {
            trayPopup.setUI(SystemTray.SWING_UI.getMenuUI(trayPopup, null));
        }
        this._native = trayPopup;
    }

    public SwingMenu(SwingMenu swingMenu, Menu menu, int n) {
        this.parent = swingMenu;
        JMenu jMenu = new JMenu();
        JPopupMenu jPopupMenu = jMenu.getPopupMenu();
        if (SystemTray.SWING_UI != null) {
            jMenu.setUI(SystemTray.SWING_UI.getItemUI(jMenu, menu));
            jPopupMenu.setUI(SystemTray.SWING_UI.getMenuUI(jPopupMenu, menu));
        }
        this._native = jMenu;
        swingMenu._native.add((Component)jMenu, n);
    }

    @Override
    public void add(Menu menu, Entry entry, int n) {
        SwingUtil.INSTANCE.invokeAndWaitQuietly(() -> {
            if (entry.hasPeer()) {
                return;
            }
            if (entry instanceof Menu) {
                SwingMenu swingMenu = new SwingMenu(this, (Menu)entry, n);
                ((Menu)entry).bind(swingMenu, menu, menu.getImageResizeUtil());
            } else if (entry instanceof Separator) {
                SwingMenuItemSeparator swingMenuItemSeparator = new SwingMenuItemSeparator(this, n);
                entry.bind(swingMenuItemSeparator, menu, menu.getImageResizeUtil());
            } else if (entry instanceof Checkbox) {
                SwingMenuItemCheckbox swingMenuItemCheckbox = new SwingMenuItemCheckbox(this, entry, n);
                ((Checkbox)entry).bind(swingMenuItemCheckbox, menu, menu.getImageResizeUtil());
            } else if (entry instanceof Status) {
                SwingMenuItemStatus swingMenuItemStatus = new SwingMenuItemStatus(this, entry);
                ((Status)entry).bind(swingMenuItemStatus, menu, menu.getImageResizeUtil());
            } else if (entry instanceof MenuItem) {
                SwingMenuItem swingMenuItem = new SwingMenuItem(this, entry, n);
                ((MenuItem)entry).bind(swingMenuItem, menu, menu.getImageResizeUtil());
            }
        });
    }

    @Override
    public void setImage(MenuItem menuItem) {
        SwingUtil.INSTANCE.invokeLater(() -> {
            File file = menuItem.getImage();
            if (file != null) {
                ImageIcon imageIcon = new ImageIcon(file.getAbsolutePath());
                ((JMenu)this._native).setIcon(imageIcon);
            } else {
                ((JMenu)this._native).setIcon(null);
            }
        });
    }

    @Override
    public void setEnabled(MenuItem menuItem) {
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setEnabled(menuItem.getEnabled()));
    }

    @Override
    public void setText(MenuItem menuItem) {
        SwingUtil.INSTANCE.invokeLater(() -> ((JMenu)this._native).setText(menuItem.getText()));
    }

    @Override
    public void setCallback(MenuItem menuItem) {
    }

    @Override
    public void setShortcut(MenuItem menuItem) {
        int n = SwingUtil.INSTANCE.getVirtualKey(menuItem.getShortcut());
        SwingUtil.INSTANCE.invokeLater(() -> ((JMenu)this._native).setMnemonic(n));
    }

    @Override
    public void setTooltip(MenuItem menuItem) {
    }

    @Override
    public synchronized void remove() {
        SwingUtil.INSTANCE.invokeLater(() -> {
            this._native.setVisible(false);
            this._native.removeAll();
            if (this.parent != null) {
                this.parent._native.remove(this._native);
            } else {
                ((TrayPopup)this._native).close();
            }
        });
    }

    @Override
    public boolean hasParent() {
        return this.parent != null;
    }
}

