/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.util;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import dorkbox.jna.linux.GObject;
import dorkbox.jna.linux.Gtk;
import dorkbox.jna.linux.Gtk2;
import dorkbox.jna.linux.GtkEventDispatch;
import dorkbox.jna.linux.structs.GtkRequisition;
import dorkbox.jna.linux.structs.GtkStyle;
import dorkbox.jna.linux.structs.PangoRectangle;
import dorkbox.os.OS;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.util.KotlinUtils;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.LoggerFactory;

public class GtkTheme {
    public static volatile int TRAY_IMAGE_SIZE_FALLBACK = OS.INSTANCE.getInt(GtkTheme.class.getSimpleName() + ".TRAY_IMAGE_SIZE_FALLBACK", 24);
    public static volatile int TRAY_MENU_IMAGE_SIZE_FALLBACK = OS.INSTANCE.getInt(GtkTheme.class.getSimpleName() + ".TRAY_MENU_IMAGE_SIZE_FALLBACK", 16);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Rectangle getPixelTextHeight(String string) {
        Rectangle rectangle;
        Pointer pointer = null;
        Pointer pointer2 = null;
        try {
            pointer = Gtk2.Gtk2.gtk_menu_new();
            pointer2 = Gtk2.Gtk2.gtk_image_menu_item_new_with_mnemonic(string);
            Gtk2.Gtk2.gtk_container_add(pointer, pointer2);
            Gtk2.Gtk2.gtk_widget_realize(pointer);
            Gtk2.Gtk2.gtk_widget_realize(pointer2);
            Gtk2.Gtk2.gtk_widget_show_all(pointer);
            Pointer pointer3 = Gtk2.Gtk2.gtk_bin_get_child(pointer2);
            Pointer pointer4 = Gtk2.Gtk2.gtk_label_get_layout(pointer3);
            PangoRectangle pangoRectangle = new PangoRectangle();
            Gtk2.Gtk2.pango_layout_get_pixel_extents(pointer4, pangoRectangle.getPointer(), null);
            pangoRectangle.read();
            rectangle = new Rectangle(pangoRectangle.width, pangoRectangle.height);
        }
        catch (Throwable throwable) {
            Gtk2.Gtk2.gtk_widget_destroy(pointer2);
            Gtk2.Gtk2.gtk_widget_destroy(pointer);
            throw throwable;
        }
        Gtk2.Gtk2.gtk_widget_destroy(pointer2);
        Gtk2.Gtk2.gtk_widget_destroy(pointer);
        return rectangle;
    }

    public static int getMenuEntryImageSize() {
        AtomicReference atomicReference = new AtomicReference();
        GtkEventDispatch.dispatchAndWait(() -> {
            Pointer pointer = Gtk2.Gtk2.gtk_offscreen_window_new();
            Pointer pointer2 = null;
            try {
                pointer2 = Gtk2.Gtk2.gtk_image_menu_item_new_from_stock("gtk-paste", null);
                Gtk2.Gtk2.gtk_image_menu_item_set_always_show_image(pointer2, true);
                Gtk2.Gtk2.gtk_container_add(pointer, pointer2);
                Gtk2.Gtk2.gtk_widget_realize(pointer);
                Gtk2.Gtk2.gtk_widget_realize(pointer2);
                Gtk2.Gtk2.gtk_widget_show_all(pointer2);
                PointerByReference pointerByReference = new PointerByReference();
                GObject.g_object_get((Pointer)pointer2, (String)"image", (Pointer)pointerByReference.getPointer(), null);
                Pointer pointer3 = pointerByReference.getValue();
                GtkRequisition gtkRequisition = new GtkRequisition();
                Gtk2.Gtk2.gtk_widget_size_request(pointer3, gtkRequisition.getPointer());
                gtkRequisition.read();
                atomicReference.set(gtkRequisition.height);
            }
            finally {
                if (pointer2 != null) {
                    Gtk2.Gtk2.gtk_widget_destroy(pointer2);
                    Gtk2.Gtk2.gtk_widget_destroy(pointer);
                }
            }
        });
        int n = (Integer)atomicReference.get();
        if (n > 0) {
            return n;
        }
        LoggerFactory.getLogger(GtkTheme.class).warn("Unable to get tray menu image size. Using fallback: " + TRAY_MENU_IMAGE_SIZE_FALLBACK);
        return TRAY_MENU_IMAGE_SIZE_FALLBACK;
    }

    public static int getScreenDPI() {
        int n;
        Object object;
        int n2 = 96;
        AtomicInteger atomicInteger = new AtomicInteger();
        atomicInteger.set(0);
        GtkEventDispatch.dispatchAndWait(() -> {
            Pointer pointer = Gtk2.Gtk2.gdk_screen_get_default();
            if (pointer != null) {
                atomicInteger.set((int)Gtk2.Gtk2.gdk_screen_get_resolution(pointer));
            }
        });
        if (atomicInteger.get() <= 0 && (object = Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Xft/DPI")) instanceof Integer && (n = ((Integer)object).intValue()) > 1024) {
            int n3 = n / 1024;
            atomicInteger.set(n3);
        }
        if (atomicInteger.get() < 50) {
            atomicInteger.set(96);
        }
        if (SystemTray.DEBUG) {
            SystemTray.logger.debug("screen DPI: " + atomicInteger.get());
        }
        return atomicInteger.get();
    }

    public static double getScreenScale() {
        AtomicReference<Double> atomicReference;
        block21: {
            Object object;
            Object object2;
            atomicReference = new AtomicReference<Double>();
            atomicReference.set(0.0);
            if (Gtk2.isGtk3) {
                GtkEventDispatch.dispatchAndWait(() -> {
                    Pointer pointer = Gtk2.Gtk2.gdk_get_default_root_window();
                    if (pointer != null) {
                        double d = Gtk.Gtk3.gdk_window_get_scale_factor(pointer);
                        atomicReference.set(d);
                    }
                });
            }
            if ((Double)atomicReference.get() == 0.0 && (object2 = System.getenv("QT_AUTO_SCREEN_SCALE_FACTOR")) != null) {
                try {
                    atomicReference.set(Double.parseDouble((String)object2));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((Double)atomicReference.get() == 0.0 && (object2 = System.getenv("QT_SCALE_FACTOR")) != null) {
                try {
                    atomicReference.set(Double.parseDouble((String)object2));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((Double)atomicReference.get() == 0.0 && (object2 = System.getenv("GDK_SCALE")) != null) {
                try {
                    atomicReference.set(Double.parseDouble((String)object2));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((Double)atomicReference.get() == 0.0 && (object2 = System.getenv("ELM_SCALE")) != null) {
                try {
                    atomicReference.set(Double.parseDouble((String)object2));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((Double)atomicReference.get() == 0.0) {
                try {
                    double d;
                    object2 = KotlinUtils.INSTANCE.execute("/usr/bin/gsettings", "get", "org.gnome.desktop.interface", "scaling-factor");
                    if (!((String)object2).isEmpty() && !((String)object2).endsWith("not found") && ((String)object2).contains("uint32") && (d = Double.parseDouble((String)(object = ((String)object2).substring(((String)object2).indexOf("uint") + 7)))) >= 1.0) {
                        atomicReference.set(d);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (OS.DesktopEnv.INSTANCE.isKDE()) {
                try {
                    object2 = new File("/usr/bin/startkde-custom");
                    if (!((File)object2).canRead()) break block21;
                    object = KotlinUtils.INSTANCE.readLines((File)object2);
                    Iterator<String> iterator = object.iterator();
                    while (iterator.hasNext()) {
                        String string;
                        double d;
                        String string2;
                        String string3 = iterator.next();
                        int n = string3.indexOf(string2 = "export GDK_SCALE=");
                        if (n <= -1 || !((d = Double.parseDouble(string = string3.substring(n + string2.length()))) >= 1.0)) continue;
                        atomicReference.set(d);
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return (Double)atomicReference.get();
    }

    public static int getIndicatorSize(double d) {
        Object object;
        String string;
        int n;
        Object object2;
        Object object3;
        if (OS.DesktopEnv.INSTANCE.isKDE()) {
            int n2;
            object3 = new File("/usr/share/plasma/plasmoids/org.kde.plasma.private.systemtray/contents/config/main.xml");
            if (((File)object3).canRead()) {
                object2 = KotlinUtils.INSTANCE.readLines((File)object3);
                n = 0;
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    if (string2.contains("<entry name=\"iconSize\" type=\"Int\">")) {
                        n = 1;
                    }
                    String string3 = "<default>";
                    if (n == 0 || (n2 = string2.indexOf(string3)) <= -1) continue;
                    string = string2.substring(n2 + string3.length(), string2.indexOf("</default>", n2));
                    int n3 = 0;
                    object = KotlinUtils.INSTANCE.toInteger(string);
                    if (object == null) continue;
                    switch ((Integer)object) {
                        case 0: {
                            n3 = 16;
                            break;
                        }
                        case 1: {
                            n3 = 22;
                            break;
                        }
                        case 2: {
                            n3 = 32;
                            break;
                        }
                        case 3: {
                            n3 = 48;
                            break;
                        }
                        case 4: {
                            n3 = 64;
                            break;
                        }
                        case 5: {
                            n3 = 128;
                        }
                    }
                    if (n3 <= 0) continue;
                    return (int)(d * (double)n3);
                }
            }
            if ((object2 = OS.DesktopEnv.INSTANCE.getPlasmaVersionFull()) != null) {
                String[] stringArray = ((String)object2).split("\\.");
                n2 = Integer.parseInt(stringArray[0]);
                int n4 = Integer.parseInt(stringArray[1]);
                if (n2 < 5 || n2 == 5 && n4 < 5) {
                    return 22;
                }
                return 128;
            }
        }
        object3 = OS.DesktopEnv.INSTANCE.getEnv();
        if (OS.Linux.INSTANCE.isUbuntu() && OS.DesktopEnv.INSTANCE.isUnity((OS.DesktopEnv.Env)object3)) {
            return 22;
        }
        if (object3 == OS.DesktopEnv.Env.XFCE) {
            String[] stringArray;
            object2 = OS.DesktopEnv.INSTANCE.queryXfce("xfce4-panel", null);
            for (String string3 : stringArray = ((String)object2).split(OS.INSTANCE.getLINE_SEPARATOR())) {
                String string4;
                if (!string3.startsWith("/plugins/") || !string3.endsWith("/size-max") || !(string4 = OS.DesktopEnv.INSTANCE.queryXfce("xfce4-panel", string = string3.substring(0, string3.indexOf("/size-max"))).trim()).equals("systray")) continue;
                object = OS.DesktopEnv.INSTANCE.queryXfce("xfce4-panel", string3).trim();
                try {
                    return Integer.parseInt((String)object);
                }
                catch (Exception exception) {
                    LoggerFactory.getLogger(GtkTheme.class).error("Unable to get XFCE notification panel size for channel '{}', property '{}'", new Object[]{"xfce4-panel", string3, exception});
                }
            }
        }
        object2 = new AtomicInteger();
        GtkEventDispatch.dispatchAndWait(() -> GtkTheme.lambda$getIndicatorSize$3((AtomicInteger)object2));
        n = ((AtomicInteger)object2).get();
        if (n != 0) {
            return n;
        }
        LoggerFactory.getLogger(GtkTheme.class).warn("Unable to get tray image size. Using fallback: " + TRAY_IMAGE_SIZE_FALLBACK);
        return TRAY_IMAGE_SIZE_FALLBACK;
    }

    public static Color getTextColor() {
        AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
        GtkEventDispatch.dispatchAndWait(() -> {
            Pointer pointer = null;
            Pointer pointer2 = null;
            try {
                pointer = Gtk2.Gtk2.gtk_menu_new();
                pointer2 = Gtk2.Gtk2.gtk_image_menu_item_new_with_mnemonic("a");
                Gtk2.Gtk2.gtk_container_add(pointer, pointer2);
                Gtk2.Gtk2.gtk_widget_realize(pointer);
                Gtk2.Gtk2.gtk_widget_realize(pointer2);
                Gtk2.Gtk2.gtk_widget_show_all(pointer);
                GtkStyle gtkStyle = Gtk2.Gtk2.gtk_rc_get_style(pointer2);
                gtkStyle.read();
                Color color = gtkStyle.fg[0].getColor();
                atomicReference.set(color);
            }
            catch (Throwable throwable) {
                Gtk2.Gtk2.gtk_widget_destroy(pointer2);
                Gtk2.Gtk2.gtk_widget_destroy(pointer);
                throw throwable;
            }
            Gtk2.Gtk2.gtk_widget_destroy(pointer2);
            Gtk2.Gtk2.gtk_widget_destroy(pointer);
        });
        return atomicReference.get();
    }

    private static /* synthetic */ void lambda$getIndicatorSize$3(AtomicInteger atomicInteger) {
        Pointer pointer = Gtk2.Gtk2.gdk_screen_get_default();
        Pointer pointer2 = null;
        if (pointer != null) {
            pointer2 = Gtk2.Gtk2.gtk_settings_get_for_screen(pointer);
        }
        if (pointer2 != null) {
            PointerByReference pointerByReference = new PointerByReference();
            GObject.g_object_get((Pointer)pointer2, (String)"gtk-icon-sizes", (Pointer)pointerByReference.getPointer(), null);
            Pointer pointer3 = pointerByReference.getValue();
            if (pointer3 != null) {
                String[] stringArray;
                String string = pointer3.getString(0L);
                for (String string2 : stringArray = new String[]{"panel-menu-bar=", "panel=", "gtk-large-toolbar=", "gtk-small-toolbar="}) {
                    String string3;
                    Integer n;
                    int n2 = string.indexOf(string2);
                    if (n2 < 0 || (n = KotlinUtils.INSTANCE.toInteger(string3 = string.substring(n2 + string2.length(), string.indexOf(",", n2)))) == null) continue;
                    atomicInteger.set(n);
                    return;
                }
            }
        }
    }
}

