/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.util;

import c.f;
import c.i;
import c.j;
import c.o;
import dorkbox.jna.ClassUtils;
import dorkbox.os.OS;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.util.SizeAndScaling;
import dorkbox.systemTray.util.SystemTrayFixes;
import java.awt.Robot;
import java.util.concurrent.atomic.AtomicBoolean;

public class SystemTrayFixesWindows {
    private static final AtomicBoolean loaded = new AtomicBoolean(false);

    public static void fix(SystemTray.TrayType trayType) {
        if (trayType != SystemTray.TrayType.Swing) {
            return;
        }
        if (loaded.getAndSet(true)) {
            return;
        }
        if (OS.INSTANCE.getJavaVersion() > 8) {
            return;
        }
        if (SystemTrayFixes.isSwingTrayLoaded("sun.awt.windows.WTrayIconPeer")) {
            throw new RuntimeException("Unable to initialize the Swing System Tray, it has already been created!");
        }
        int n = SizeAndScaling.TRAY_SIZE;
        try {
            Robot robot = new Robot();
            f f2 = f.a();
            j j2 = f2.c("sun.awt.windows.WSystemTrayPeer");
            j2.a(j2.c() & 1);
            j2.g()[0].a(j2.g()[0].c() & 1);
            o o2 = j2.b("getTrayIconSize");
            o o3 = new o[]{o2};
            SystemTrayFixes.fixTraySize((i[])o3, 16, n);
            o2.a().b(j2.a());
            byte[] byArray = j2.x();
            j2 = f2.c("sun.awt.windows.WTrayIconPeer");
            o2 = j2.b("createNativeImage");
            o3 = j2.b("updateNativeImage");
            int n2 = n * n / 8;
            o2.a("{java.awt.image.BufferedImage bufferedImage = $1;java.awt.image.Raster rasterImage = bufferedImage.getRaster();final byte[] mask = new byte[" + n2 + "];final int pixels[] = ((java.awt.image.DataBufferInt)rasterImage.getDataBuffer()).getData();int numberOfPixels = pixels.length;int rasterImageWidth = rasterImage.getWidth();for (int i = 0; i < numberOfPixels; i++) {int iByte = i / 8;int augmentMask = 1 << (7 - (i % 8));if ((pixels[i] & 0xFF000000) == 0) {if (iByte < mask.length) {mask[iByte] |= augmentMask;}}}if (rasterImage instanceof sun.awt.image.IntegerComponentRaster) {rasterImageWidth = ((sun.awt.image.IntegerComponentRaster)rasterImage).getScanlineStride();}setNativeIcon(((java.awt.image.DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData(), mask, rasterImageWidth, rasterImage.getWidth(), rasterImage.getHeight());}");
            o3.a("{java.awt.Image image = $1;if (isDisposed()) {return;}int imageWidth = image.getWidth(observer);int imageHeight = image.getWidth(observer);java.awt.image.BufferedImage trayIcon = new java.awt.image.BufferedImage(imageWidth, imageHeight, java.awt.image.BufferedImage.TYPE_INT_ARGB);java.awt.Graphics2D g = trayIcon.createGraphics();if (g != null) {try {g.addRenderingHints(new java.awt.RenderingHints(java.awt.RenderingHints.KEY_RENDERING,java.awt.RenderingHints.VALUE_RENDER_QUALITY));g.drawImage(image, 0, 0, imageWidth, imageHeight, observer);createNativeImage(trayIcon);updateNativeIcon(!firstUpdate);if (firstUpdate) {firstUpdate = false;}} finally {g.dispose();}}}");
            o2.a().b(j2.a());
            o3.a().b(j2.a());
            byte[] byArray2 = j2.x();
            ClassUtils.defineClass((byte[])byArray);
            ClassUtils.defineClass((byte[])byArray2);
            if (SystemTray.DEBUG) {
                SystemTray.logger.debug("Successfully changed tray icon size to: {}", (Object)n);
            }
        }
        catch (Exception exception) {
            SystemTray.logger.error("Error setting tray icon size to: {}", (Object)n, (Object)exception);
        }
    }
}

