/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.c2s.internal.ModularXmppClientToServerConnectionInternal;
import org.jivesoftware.smack.fsm.ConnectionStateEvent;
import org.jivesoftware.smack.fsm.StateTransitionResult;
import org.jivesoftware.smack.tcp.TcpHostEvent;
import org.jivesoftware.smack.tcp.XmppTcpTransportModule;
import org.jivesoftware.smack.tcp.rce.Rfc6120TcpRemoteConnectionEndpoint;
import org.jivesoftware.smack.util.Async;
import org.jivesoftware.smack.util.rce.RemoteConnectionEndpoint;
import org.jivesoftware.smack.util.rce.RemoteConnectionException;

public final class ConnectionAttemptState {
    private final ModularXmppClientToServerConnectionInternal connectionInternal;
    private final XmppTcpTransportModule.XmppTcpNioTransport.DiscoveredTcpEndpoints discoveredEndpoints;
    private final XmppTcpTransportModule.EstablishingTcpConnectionState establishingTcpConnectionState;
    final SocketChannel socketChannel;
    final List<RemoteConnectionException<?>> connectionExceptions;
    SmackException.EndpointConnectionException connectionException;
    boolean connected;
    long deadline;
    final Iterator<Rfc6120TcpRemoteConnectionEndpoint> connectionEndpointIterator;
    Rfc6120TcpRemoteConnectionEndpoint connectionEndpoint;
    Iterator<? extends InetAddress> inetAddressIterator;

    ConnectionAttemptState(ModularXmppClientToServerConnectionInternal modularXmppClientToServerConnectionInternal, XmppTcpTransportModule.XmppTcpNioTransport.DiscoveredTcpEndpoints discoveredTcpEndpoints, XmppTcpTransportModule.EstablishingTcpConnectionState establishingTcpConnectionState) {
        this.connectionInternal = modularXmppClientToServerConnectionInternal;
        this.discoveredEndpoints = discoveredTcpEndpoints;
        this.establishingTcpConnectionState = establishingTcpConnectionState;
        this.socketChannel = SocketChannel.open();
        this.socketChannel.configureBlocking(false);
        List list = discoveredTcpEndpoints.result.discoveredRemoteConnectionEndpoints;
        this.connectionEndpointIterator = list.iterator();
        this.connectionExceptions = new ArrayList(list.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StateTransitionResult.Failure establishTcpConnection() {
        RemoteConnectionEndpoint.InetSocketAddressCoupling<Rfc6120TcpRemoteConnectionEndpoint> inetSocketAddressCoupling = this.nextAddress();
        this.establishTcpConnection(inetSocketAddressCoupling);
        ConnectionAttemptState connectionAttemptState = this;
        synchronized (connectionAttemptState) {
            while (!this.connected && this.connectionException == null) {
                long l = System.currentTimeMillis();
                if (l >= this.deadline) {
                    return new StateTransitionResult.FailureCausedByTimeout("Timeout waiting to establish connection");
                }
                this.wait(this.deadline - l);
            }
        }
        if (this.connected) {
            assert (this.connectionException == null);
            return null;
        }
        return new StateTransitionResult.FailureCausedByException((Exception)this.connectionException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void establishTcpConnection(RemoteConnectionEndpoint.InetSocketAddressCoupling<Rfc6120TcpRemoteConnectionEndpoint> inetSocketAddressCoupling) {
        TcpHostEvent.ConnectingToHostEvent connectingToHostEvent = new TcpHostEvent.ConnectingToHostEvent(this.establishingTcpConnectionState, inetSocketAddressCoupling);
        this.connectionInternal.invokeConnectionStateMachineListener((ConnectionStateEvent)connectingToHostEvent);
        InetSocketAddress inetSocketAddress = inetSocketAddressCoupling.getInetSocketAddress();
        this.deadline = System.currentTimeMillis() + this.connectionInternal.connection.getReplyTimeout();
        try {
            this.connected = this.socketChannel.connect(inetSocketAddress);
        }
        catch (IOException iOException) {
            this.onIOExceptionWhenEstablishingTcpConnection(iOException, inetSocketAddressCoupling);
            return;
        }
        if (this.connected) {
            TcpHostEvent.ConnectedToHostEvent connectedToHostEvent = new TcpHostEvent.ConnectedToHostEvent(this.establishingTcpConnectionState, inetSocketAddressCoupling, true);
            this.connectionInternal.invokeConnectionStateMachineListener((ConnectionStateEvent)connectedToHostEvent);
            ConnectionAttemptState connectionAttemptState = this;
            synchronized (connectionAttemptState) {
                this.notifyAll();
            }
            return;
        }
        try {
            this.connectionInternal.registerWithSelector((SelectableChannel)this.socketChannel, 8, (selectableChannel, selectionKey) -> {
                boolean bl;
                SocketChannel socketChannel = (SocketChannel)selectableChannel;
                try {
                    bl = socketChannel.finishConnect();
                }
                catch (IOException iOException) {
                    Async.go(() -> this.onIOExceptionWhenEstablishingTcpConnection(iOException, inetSocketAddressCoupling));
                    return;
                }
                if (!bl) {
                    Async.go(() -> this.onIOExceptionWhenEstablishingTcpConnection(new IOException("finishConnect() failed"), inetSocketAddressCoupling));
                    return;
                }
                TcpHostEvent.ConnectedToHostEvent connectedToHostEvent = new TcpHostEvent.ConnectedToHostEvent(this.establishingTcpConnectionState, inetSocketAddressCoupling, false);
                this.connectionInternal.invokeConnectionStateMachineListener((ConnectionStateEvent)connectedToHostEvent);
                this.connected = true;
                ConnectionAttemptState connectionAttemptState = this;
                synchronized (connectionAttemptState) {
                    this.notifyAll();
                }
            });
        }
        catch (ClosedChannelException closedChannelException) {
            this.onIOExceptionWhenEstablishingTcpConnection(closedChannelException, inetSocketAddressCoupling);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onIOExceptionWhenEstablishingTcpConnection(IOException iOException, RemoteConnectionEndpoint.InetSocketAddressCoupling<Rfc6120TcpRemoteConnectionEndpoint> inetSocketAddressCoupling) {
        RemoteConnectionEndpoint.InetSocketAddressCoupling<Rfc6120TcpRemoteConnectionEndpoint> inetSocketAddressCoupling2 = this.nextAddress();
        if (inetSocketAddressCoupling2 == null) {
            this.connectionException = SmackException.EndpointConnectionException.from(this.discoveredEndpoints.result.lookupFailures, this.connectionExceptions);
            ConnectionAttemptState connectionAttemptState = this;
            synchronized (connectionAttemptState) {
                this.notifyAll();
            }
            return;
        }
        RemoteConnectionException remoteConnectionException = new RemoteConnectionException(inetSocketAddressCoupling, (Exception)iOException);
        this.connectionExceptions.add(remoteConnectionException);
        TcpHostEvent.ConnectionToHostFailedEvent connectionToHostFailedEvent = new TcpHostEvent.ConnectionToHostFailedEvent(this.establishingTcpConnectionState, inetSocketAddressCoupling2, iOException);
        this.connectionInternal.invokeConnectionStateMachineListener((ConnectionStateEvent)connectionToHostFailedEvent);
        this.establishTcpConnection(inetSocketAddressCoupling2);
    }

    private RemoteConnectionEndpoint.InetSocketAddressCoupling<Rfc6120TcpRemoteConnectionEndpoint> nextAddress() {
        if (this.inetAddressIterator == null || !this.inetAddressIterator.hasNext()) {
            if (!this.connectionEndpointIterator.hasNext()) {
                return null;
            }
            this.connectionEndpoint = this.connectionEndpointIterator.next();
            this.inetAddressIterator = this.connectionEndpoint.getInetAddresses().iterator();
            assert (this.inetAddressIterator.hasNext());
        }
        InetAddress inetAddress = this.inetAddressIterator.next();
        return new RemoteConnectionEndpoint.InetSocketAddressCoupling((RemoteConnectionEndpoint)this.connectionEndpoint, inetAddress);
    }
}

