/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.tcp.rce;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.h.b.a;
import org.h.d.d;
import org.h.d.e;
import org.h.e.b;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.datatypes.UInt16;
import org.jivesoftware.smack.tcp.rce.IpTcpRemoteConnectionEndpoint;
import org.jivesoftware.smack.tcp.rce.Rfc6120TcpRemoteConnectionEndpoint;
import org.jivesoftware.smack.tcp.rce.SrvXmppRemoteConnectionEndpoint;
import org.jivesoftware.smack.util.DNSUtil;
import org.jivesoftware.smack.util.dns.DNSResolver;
import org.jivesoftware.smack.util.rce.RemoteConnectionEndpoint;
import org.jivesoftware.smack.util.rce.RemoteConnectionEndpointLookupFailure;

public class RemoteXmppTcpConnectionEndpoints {
    private static final Logger LOGGER = Logger.getLogger(RemoteXmppTcpConnectionEndpoints.class.getName());
    public static final String XMPP_CLIENT_DNS_SRV_PREFIX = "_xmpp-client._tcp";
    public static final String XMPP_SERVER_DNS_SRV_PREFIX = "_xmpp-server._tcp";

    public static Result<Rfc6120TcpRemoteConnectionEndpoint> lookup(ConnectionConfiguration connectionConfiguration) {
        List<Rfc6120TcpRemoteConnectionEndpoint> list;
        List<RemoteConnectionEndpointLookupFailure> list2;
        InetAddress inetAddress = connectionConfiguration.getHostAddress();
        a a2 = connectionConfiguration.getHost();
        if (inetAddress != null) {
            list2 = Collections.emptyList();
            IpTcpRemoteConnectionEndpoint<d<?>> ipTcpRemoteConnectionEndpoint = IpTcpRemoteConnectionEndpoint.from(inetAddress.toString(), connectionConfiguration.getPort(), inetAddress);
            list = Collections.singletonList(ipTcpRemoteConnectionEndpoint);
        } else if (a2 != null) {
            list2 = new ArrayList(1);
            List list3 = DNSUtil.getDNSResolver().lookupHostAddress(a2, list2, connectionConfiguration.getDnssecMode());
            if (list3 != null) {
                list = new ArrayList(list3.size());
                UInt16 uInt16 = connectionConfiguration.getPort();
                for (InetAddress inetAddress2 : list3) {
                    IpTcpRemoteConnectionEndpoint<d<?>> ipTcpRemoteConnectionEndpoint = IpTcpRemoteConnectionEndpoint.from((CharSequence)a2, uInt16, inetAddress2);
                    list.add(ipTcpRemoteConnectionEndpoint);
                }
            } else {
                list = Collections.emptyList();
            }
        } else {
            list2 = new ArrayList();
            a a3 = connectionConfiguration.getXmppServiceDomainAsDnsNameIfPossible();
            if (a3 == null) {
                throw new IllegalStateException();
            }
            list = RemoteXmppTcpConnectionEndpoints.resolveXmppServiceDomain(a3, list2, connectionConfiguration.getDnssecMode());
        }
        assert (!list.isEmpty() || !list2.isEmpty());
        return new Result<Rfc6120TcpRemoteConnectionEndpoint>(list, list2);
    }

    public static List<Rfc6120TcpRemoteConnectionEndpoint> resolveXmppServiceDomain(a a2, List<RemoteConnectionEndpointLookupFailure> list, ConnectionConfiguration.DnssecMode dnssecMode) {
        DNSResolver dNSResolver = RemoteXmppTcpConnectionEndpoints.getDnsResolverOrThrow();
        return RemoteXmppTcpConnectionEndpoints.resolveDomain(a2, DomainType.client, list, dnssecMode, dNSResolver);
    }

    public static List<Rfc6120TcpRemoteConnectionEndpoint> resolveXmppServerDomain(a a2, List<RemoteConnectionEndpointLookupFailure> list, ConnectionConfiguration.DnssecMode dnssecMode) {
        DNSResolver dNSResolver = RemoteXmppTcpConnectionEndpoints.getDnsResolverOrThrow();
        return RemoteXmppTcpConnectionEndpoints.resolveDomain(a2, DomainType.server, list, dnssecMode, dNSResolver);
    }

    private static List<Rfc6120TcpRemoteConnectionEndpoint> resolveDomain(a a2, DomainType domainType, List<RemoteConnectionEndpointLookupFailure> list, ConnectionConfiguration.DnssecMode dnssecMode, DNSResolver dNSResolver) {
        Rfc6120TcpRemoteConnectionEndpoint rfc6120TcpRemoteConnectionEndpoint;
        Object object;
        Object object2;
        Object object32;
        Object object4;
        ArrayList<Rfc6120TcpRemoteConnectionEndpoint> arrayList = new ArrayList<Rfc6120TcpRemoteConnectionEndpoint>();
        a a3 = a.a((a)domainType.srvPrefix, (a)a2);
        Collection collection = dNSResolver.lookupSrvRecords(a3, list, dnssecMode);
        if (collection != null && !collection.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                object4 = "Resolved SRV RR for " + a3 + ":";
                for (Object object32 : collection) {
                    object4 = (String)object4 + " " + object32;
                }
                LOGGER.fine((String)object4);
            }
            object4 = b.a((Collection)collection);
            object2 = object4.iterator();
            while (object2.hasNext()) {
                object32 = (e)object2.next();
                object = dNSResolver.lookupHostAddress(((e)object32).d, list, dnssecMode);
                if (object == null) continue;
                rfc6120TcpRemoteConnectionEndpoint = new SrvXmppRemoteConnectionEndpoint((e)object32, (List<? extends InetAddress>)object);
                arrayList.add(rfc6120TcpRemoteConnectionEndpoint);
            }
        } else {
            LOGGER.info("Could not resolve DNS SRV resource records for " + a3 + ". Consider adding those.");
        }
        switch (domainType) {
            case client: {
                object4 = UInt16.from((int)5222);
                break;
            }
            case server: {
                object4 = UInt16.from((int)5269);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        object2 = dNSResolver.lookupHostAddress(a2, list, dnssecMode);
        if (object2 != null) {
            object32 = object2.iterator();
            while (object32.hasNext()) {
                object = (InetAddress)object32.next();
                rfc6120TcpRemoteConnectionEndpoint = IpTcpRemoteConnectionEndpoint.from((CharSequence)a2, (UInt16)object4, (InetAddress)object);
                arrayList.add(rfc6120TcpRemoteConnectionEndpoint);
            }
        }
        return arrayList;
    }

    private static DNSResolver getDnsResolverOrThrow() {
        DNSResolver dNSResolver = DNSUtil.getDNSResolver();
        if (dNSResolver == null) {
            throw new IllegalStateException("No DNS resolver configured in Smack");
        }
        return dNSResolver;
    }

    static enum DomainType {
        server("_xmpp-server._tcp"),
        client("_xmpp-client._tcp");

        public final a srvPrefix;

        private DomainType(String string2) {
            this.srvPrefix = a.a((String)string2);
        }
    }

    public static final class Result<RCE extends RemoteConnectionEndpoint> {
        public final List<RCE> discoveredRemoteConnectionEndpoints;
        public final List<RemoteConnectionEndpointLookupFailure> lookupFailures;

        private Result(List<RCE> list, List<RemoteConnectionEndpointLookupFailure> list2) {
            this.discoveredRemoteConnectionEndpoints = list;
            this.lookupFailures = list2;
        }
    }
}

