/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.layout;

import androidx.compose.foundation.layout.AspectRatioNode;
import androidx.compose.foundation.layout.internal.InlineClassHelperKt;
import androidx.compose.ui.node.ModifierNodeElement;
import androidx.compose.ui.platform.InspectorInfo;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B0\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0017\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0014\u001a\u00020\u0002H\u0016J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\f\u0010\u0017\u001a\u00020\n*\u00020\tH\u0016J\u0013\u0010\u0018\u001a\u00020\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\"\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\b\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Landroidx/compose/foundation/layout/AspectRatioElement;", "Landroidx/compose/ui/node/ModifierNodeElement;", "Landroidx/compose/foundation/layout/AspectRatioNode;", "aspectRatio", "", "matchHeightConstraintsFirst", "", "inspectorInfo", "Lkotlin/Function1;", "Landroidx/compose/ui/platform/InspectorInfo;", "", "Lkotlin/ExtensionFunctionType;", "<init>", "(FZLkotlin/jvm/functions/Function1;)V", "getAspectRatio", "()F", "getMatchHeightConstraintsFirst", "()Z", "getInspectorInfo", "()Lkotlin/jvm/functions/Function1;", "create", "update", "node", "inspectableProperties", "equals", "other", "", "hashCode", "", "foundation-layout"})
final class AspectRatioElement
extends ModifierNodeElement<AspectRatioNode> {
    private final float aspectRatio;
    private final boolean matchHeightConstraintsFirst;
    private final Function1<InspectorInfo, Unit> inspectorInfo;

    public AspectRatioElement(float f, boolean bl, Function1<? super InspectorInfo, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"");
        this.aspectRatio = f;
        this.matchHeightConstraintsFirst = bl;
        this.inspectorInfo = function1;
        boolean bl2 = this.aspectRatio > 0.0f;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            InlineClassHelperKt.throwIllegalArgumentException("aspectRatio " + this.aspectRatio + " must be > 0");
        }
    }

    public final float getAspectRatio() {
        return this.aspectRatio;
    }

    public final boolean getMatchHeightConstraintsFirst() {
        return this.matchHeightConstraintsFirst;
    }

    public final Function1<InspectorInfo, Unit> getInspectorInfo() {
        return this.inspectorInfo;
    }

    public AspectRatioNode create() {
        return new AspectRatioNode(this.aspectRatio, this.matchHeightConstraintsFirst);
    }

    public void update(AspectRatioNode aspectRatioNode) {
        Intrinsics.checkNotNullParameter((Object)((Object)aspectRatioNode), (String)"");
        aspectRatioNode.setAspectRatio(this.aspectRatio);
        aspectRatioNode.setMatchHeightConstraintsFirst(this.matchHeightConstraintsFirst);
    }

    public void inspectableProperties(InspectorInfo inspectorInfo) {
        Intrinsics.checkNotNullParameter((Object)inspectorInfo, (String)"");
        this.inspectorInfo.invoke((Object)inspectorInfo);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        AspectRatioElement aspectRatioElement = object instanceof AspectRatioElement ? (AspectRatioElement)((Object)object) : null;
        if (aspectRatioElement == null) {
            return false;
        }
        AspectRatioElement aspectRatioElement2 = aspectRatioElement;
        return this.aspectRatio == aspectRatioElement2.aspectRatio && this.matchHeightConstraintsFirst == ((AspectRatioElement)((Object)object)).matchHeightConstraintsFirst;
    }

    public int hashCode() {
        return Float.hashCode(this.aspectRatio) * 31 + Boolean.hashCode(this.matchHeightConstraintsFirst);
    }
}

