/*
 * Decompiled with CFR 0.152.
 */
package kotlin.text;

import java.util.Locale;
import kotlin.Deprecated;
import kotlin.DeprecatedSinceKotlin;
import kotlin.IgnorableReturnValue;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.CharCategory;
import kotlin.text.CharDirectionality;
import kotlin.text.CharsKt;

@Metadata(mv={2, 3, 0}, k=5, xi=49, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\u001a\u000e\u0010\u0005\u001a\u00020\u0006*\u00020\u0002H\u0087\u0088\u0004\u001a\u000e\u0010\u0007\u001a\u00020\u0006*\u00020\u0002H\u0087\u0088\u0004\u001a\u000e\u0010\b\u001a\u00020\u0006*\u00020\u0002H\u0087\u0088\u0004\u001a\u000e\u0010\t\u001a\u00020\u0006*\u00020\u0002H\u0087\u0088\u0004\u001a\u000e\u0010\n\u001a\u00020\u0006*\u00020\u0002H\u0087\u0088\u0004\u001a\u000e\u0010\u000b\u001a\u00020\u0006*\u00020\u0002H\u0087\u0088\u0004\u001a\u000e\u0010\f\u001a\u00020\u0006*\u00020\u0002H\u0087\u0088\u0004\u001a\u000e\u0010\r\u001a\u00020\u0006*\u00020\u0002H\u0087\u0088\u0004\u001a\u000e\u0010\u000e\u001a\u00020\u0006*\u00020\u0002H\u0086\u0080\u0004\u001a\u000e\u0010\u000f\u001a\u00020\u0006*\u00020\u0002H\u0087\u0088\u0004\u001a\u000e\u0010\u0010\u001a\u00020\u0006*\u00020\u0002H\u0087\u0088\u0004\u001a\u000e\u0010\u0011\u001a\u00020\u0002*\u00020\u0002H\u0087\u0088\u0004\u001a\u000e\u0010\u0012\u001a\u00020\u0002*\u00020\u0002H\u0087\u0088\u0004\u001a\u000e\u0010\u0013\u001a\u00020\u0014*\u00020\u0002H\u0087\u0088\u0004\u001a\u0016\u0010\u0013\u001a\u00020\u0014*\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0087\u0080\u0004\u001a\u000e\u0010\u0017\u001a\u00020\u0002*\u00020\u0002H\u0087\u0088\u0004\u001a\u000e\u0010\u0018\u001a\u00020\u0002*\u00020\u0002H\u0087\u0088\u0004\u001a\u000e\u0010\u0019\u001a\u00020\u0014*\u00020\u0002H\u0087\u0088\u0004\u001a\u0016\u0010\u0019\u001a\u00020\u0014*\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0087\u0080\u0004\u001a\u000e\u0010\u001a\u001a\u00020\u0006*\u00020\u0002H\u0087\u0088\u0004\u001a\u000e\u0010\u001b\u001a\u00020\u0002*\u00020\u0002H\u0087\u0088\u0004\u001a\u000e\u0010\u001c\u001a\u00020\u0002*\u00020\u0002H\u0087\u0088\u0004\u001a\u0016\u0010\u001d\u001a\u00020\u0014*\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0087\u0080\u0004\u001a\u000e\u0010\"\u001a\u00020\u0006*\u00020\u0002H\u0087\u0088\u0004\u001a\u000e\u0010#\u001a\u00020\u0006*\u00020\u0002H\u0087\u0088\u0004\u001a\u001a\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020%H\u0080\u0080\u0004\u001a\u0012\u0010(\u001a\u00020%2\u0006\u0010'\u001a\u00020%H\u0081\u0080\b\"\u0019\u0010\u0000\u001a\u00020\u0001*\u00020\u00028FX\u0086\u0084\b\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0019\u0010\u001e\u001a\u00020\u001f*\u00020\u00028FX\u0086\u0084\b\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006)"}, d2={"category", "Lkotlin/text/CharCategory;", "", "getCategory", "(C)Lkotlin/text/CharCategory;", "isDefined", "", "isLetter", "isLetterOrDigit", "isDigit", "isIdentifierIgnorable", "isISOControl", "isJavaIdentifierPart", "isJavaIdentifierStart", "isWhitespace", "isUpperCase", "isLowerCase", "toUpperCase", "uppercaseChar", "uppercase", "", "locale", "Ljava/util/Locale;", "toLowerCase", "lowercaseChar", "lowercase", "isTitleCase", "toTitleCase", "titlecaseChar", "titlecase", "directionality", "Lkotlin/text/CharDirectionality;", "getDirectionality", "(C)Lkotlin/text/CharDirectionality;", "isHighSurrogate", "isLowSurrogate", "digitOf", "", "char", "radix", "checkRadix", "kotlin-stdlib"}, xs="kotlin/text/CharsKt")
class CharsKt__CharJVMKt {
    public static final CharCategory getCategory(char c) {
        return CharCategory.Companion.valueOf(Character.getType(c));
    }

    private static final boolean isDefined(char c) {
        return Character.isDefined(c);
    }

    private static final boolean isLetter(char c) {
        return Character.isLetter(c);
    }

    private static final boolean isLetterOrDigit(char c) {
        return Character.isLetterOrDigit(c);
    }

    private static final boolean isDigit(char c) {
        return Character.isDigit(c);
    }

    private static final boolean isIdentifierIgnorable(char c) {
        return Character.isIdentifierIgnorable(c);
    }

    private static final boolean isISOControl(char c) {
        return Character.isISOControl(c);
    }

    private static final boolean isJavaIdentifierPart(char c) {
        return Character.isJavaIdentifierPart(c);
    }

    private static final boolean isJavaIdentifierStart(char c) {
        return Character.isJavaIdentifierStart(c);
    }

    public static final boolean isWhitespace(char c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c);
    }

    private static final boolean isUpperCase(char c) {
        return Character.isUpperCase(c);
    }

    private static final boolean isLowerCase(char c) {
        return Character.isLowerCase(c);
    }

    @Deprecated(message="Use uppercaseChar() instead.", replaceWith=@ReplaceWith(expression="uppercaseChar()", imports={}))
    @DeprecatedSinceKotlin(warningSince="1.5", errorSince="2.1")
    private static final char toUpperCase(char c) {
        return Character.toUpperCase(c);
    }

    private static final char uppercaseChar(char c) {
        return Character.toUpperCase(c);
    }

    private static final String uppercase(char c) {
        String string = String.valueOf(c);
        Intrinsics.checkNotNull(string);
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "");
        return string2;
    }

    public static final String uppercase(char c, Locale locale) {
        Intrinsics.checkNotNullParameter(locale, "");
        String string = String.valueOf(c);
        Intrinsics.checkNotNull(string);
        String string2 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue(string2, "");
        return string2;
    }

    @Deprecated(message="Use lowercaseChar() instead.", replaceWith=@ReplaceWith(expression="lowercaseChar()", imports={}))
    @DeprecatedSinceKotlin(warningSince="1.5", errorSince="2.1")
    private static final char toLowerCase(char c) {
        return Character.toLowerCase(c);
    }

    private static final char lowercaseChar(char c) {
        return Character.toLowerCase(c);
    }

    private static final String lowercase(char c) {
        String string = String.valueOf(c);
        Intrinsics.checkNotNull(string);
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "");
        return string2;
    }

    public static final String lowercase(char c, Locale locale) {
        Intrinsics.checkNotNullParameter(locale, "");
        String string = String.valueOf(c);
        Intrinsics.checkNotNull(string);
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string2, "");
        return string2;
    }

    private static final boolean isTitleCase(char c) {
        return Character.isTitleCase(c);
    }

    @Deprecated(message="Use titlecaseChar() instead.", replaceWith=@ReplaceWith(expression="titlecaseChar()", imports={}))
    @DeprecatedSinceKotlin(warningSince="1.5", errorSince="2.1")
    private static final char toTitleCase(char c) {
        return Character.toTitleCase(c);
    }

    private static final char titlecaseChar(char c) {
        return Character.toTitleCase(c);
    }

    public static final String titlecase(char c, Locale locale) {
        Intrinsics.checkNotNullParameter(locale, "");
        String string = CharsKt.uppercase(c, locale);
        if (string.length() > 1) {
            String string2;
            if (c == '\u0149') {
                string2 = string;
            } else {
                char c2 = string.charAt(0);
                String string3 = string;
                int n = 1;
                Intrinsics.checkNotNull(string3);
                String string4 = string3.substring(n);
                Intrinsics.checkNotNullExpressionValue(string4, "");
                string3 = string4;
                Intrinsics.checkNotNull(string3);
                String string5 = string3.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string5, "");
                string3 = string5;
                string2 = c2 + string3;
            }
            return string2;
        }
        String string6 = String.valueOf(c);
        Intrinsics.checkNotNull(string6);
        String string7 = string6.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string7, "");
        if (!Intrinsics.areEqual(string, string7)) {
            return string;
        }
        return String.valueOf(Character.toTitleCase(c));
    }

    public static final CharDirectionality getDirectionality(char c) {
        return CharDirectionality.Companion.valueOf(Character.getDirectionality(c));
    }

    private static final boolean isHighSurrogate(char c) {
        return Character.isHighSurrogate(c);
    }

    private static final boolean isLowSurrogate(char c) {
        return Character.isLowSurrogate(c);
    }

    public static final int digitOf(char c, int n) {
        return Character.digit((int)c, n);
    }

    @IgnorableReturnValue
    public static final int checkRadix(int n) {
        if (!(2 <= n ? n < 37 : false)) {
            throw new IllegalArgumentException("radix " + n + " was not in valid range " + new IntRange(2, 36));
        }
        return n;
    }
}

