/*
 * Decompiled with CFR 0.152.
 */
package kotlin.time;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.time.DurationUnit;
import kotlin.time.DurationUnitKt__DurationUnitJvmKt;

@Metadata(mv={2, 3, 0}, k=5, xi=49, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\u001a\u001a\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0080\u0080\u0004\u001a\u001b\u0010\u0005\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001H\u0082\u0080\u0004\u00a2\u0006\u0002\b\u0007\u001a\u000e\u0010\u000b\u001a\u00020\f*\u00020\u0004H\u0081\u0080\u0004\"\u0019\u0010\b\u001a\u00020\u0001*\u00020\u00048BX\u0082\u0084\b\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"convertDurationUnitToMilliseconds", "", "value", "unit", "Lkotlin/time/DurationUnit;", "multiplyNonNegativeWithoutOverflow", "other", "multiplyNonNegativeWithoutOverflow$DurationUnitKt__DurationUnitKt", "millisMultiplier", "getMillisMultiplier$DurationUnitKt__DurationUnitKt", "(Lkotlin/time/DurationUnit;)J", "shortName", "", "kotlin-stdlib"}, xs="kotlin/time/DurationUnitKt")
class DurationUnitKt__DurationUnitKt
extends DurationUnitKt__DurationUnitJvmKt {
    public static final long convertDurationUnitToMilliseconds(long l, DurationUnit durationUnit) {
        Intrinsics.checkNotNullParameter((Object)durationUnit, "");
        return DurationUnitKt__DurationUnitKt.multiplyNonNegativeWithoutOverflow$DurationUnitKt__DurationUnitKt(l, DurationUnitKt__DurationUnitKt.getMillisMultiplier$DurationUnitKt__DurationUnitKt(durationUnit));
    }

    private static final long multiplyNonNegativeWithoutOverflow$DurationUnitKt__DurationUnitKt(long l, long l2) {
        long l3;
        if (l == 0L) {
            l3 = 0L;
        } else if (l == 1L) {
            l3 = RangesKt.coerceAtMost(l2, 0x3FFFFFFFFFFFFFFFL);
        } else if (l2 == 1L) {
            l3 = RangesKt.coerceAtMost(l, 0x3FFFFFFFFFFFFFFFL);
        } else {
            int n = 128 - Long.numberOfLeadingZeros(l) - Long.numberOfLeadingZeros(l2);
            l3 = n < 63 ? l * l2 : (n > 63 ? 0x3FFFFFFFFFFFFFFFL : RangesKt.coerceAtMost(l * l2, 0x3FFFFFFFFFFFFFFFL));
        }
        return l3;
    }

    private static final long getMillisMultiplier$DurationUnitKt__DurationUnitKt(DurationUnit durationUnit) {
        long l;
        switch (WhenMappings.$EnumSwitchMapping$0[durationUnit.ordinal()]) {
            case 1: {
                l = 86400000L;
                break;
            }
            case 2: {
                l = 3600000L;
                break;
            }
            case 3: {
                l = 60000L;
                break;
            }
            case 4: {
                l = 1000L;
                break;
            }
            case 5: {
                l = 1L;
                break;
            }
            default: {
                throw new IllegalStateException(("Wrong unit for millisMultiplier: " + (Object)((Object)durationUnit)).toString());
            }
        }
        return l;
    }

    public static final String shortName(DurationUnit durationUnit) {
        String string;
        Intrinsics.checkNotNullParameter((Object)durationUnit, "");
        switch (WhenMappings.$EnumSwitchMapping$0[durationUnit.ordinal()]) {
            case 6: {
                string = "ns";
                break;
            }
            case 7: {
                string = "us";
                break;
            }
            case 5: {
                string = "ms";
                break;
            }
            case 4: {
                string = "s";
                break;
            }
            case 3: {
                string = "m";
                break;
            }
            case 2: {
                string = "h";
                break;
            }
            case 1: {
                string = "d";
                break;
            }
            default: {
                throw new IllegalStateException(("Unknown unit: " + (Object)((Object)durationUnit)).toString());
            }
        }
        return string;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DurationUnit.values().length];
            try {
                nArray[DurationUnit.DAYS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DurationUnit.HOURS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DurationUnit.MINUTES.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DurationUnit.SECONDS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DurationUnit.MILLISECONDS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DurationUnit.NANOSECONDS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DurationUnit.MICROSECONDS.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

