/*
 * Decompiled with CFR 0.152.
 */
package kotlin.time;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Instant;
import kotlin.time.InstantParseResult;
import kotlin.time.UnboundLocalDateTime;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\f\n\u0002\u0010\u0015\n\u0002\b\u0006\u001a\u0012\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0082\u0080\u0004\u001a\u0012\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0082\u0080\u0004\u001a(\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0082\u0088\u0004\u001a(\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0082\u0088\u0004\u001a\u0012\u0010%\u001a\u00020\u00012\u0006\u0010&\u001a\u00020\u0015H\u0080\u0080\u0004\u001a\u0016\u0010'\u001a\u00020\u0015*\u00020\u00152\u0006\u0010%\u001a\u00020\u0001H\u0082\u0080\u0004\u001a\u0016\u0010-\u001a\u00020\u0012*\u00020\u00102\u0006\u0010.\u001a\u00020\u0015H\u0082\u0080\u0004\" \u0010\u0000\u001a\u00020\u0001*\u00020\u00028\u00c6\u0002X\u0087\u0084\b\u00a2\u0006\f\u0012\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0000\u0010\u0005\" \u0010\u0006\u001a\u00020\u0001*\u00020\u00028\u00c6\u0002X\u0087\u0084\b\u00a2\u0006\f\u0012\u0004\b\u0007\u0010\u0004\u001a\u0004\b\u0006\u0010\u0005\"\u000f\u0010\b\u001a\u00020\tX\u0082\u00d4\b\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\n\u001a\u00020\tX\u0082\u00d4\b\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u000b\u001a\u00020\tX\u0082\u00d4\b\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\f\u001a\u00020\tX\u0082\u00d4\b\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u0014\u001a\u00020\u0015X\u0082\u00d4\b\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u0016\u001a\u00020\u0015X\u0082\u00d4\b\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u001e\u001a\u00020\u0015X\u0082\u00d4\b\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u001f\u001a\u00020\u0015X\u0082\u00d4\b\u00a2\u0006\u0002\n\u0000\"\u000f\u0010 \u001a\u00020\u0015X\u0082\u00d4\b\u00a2\u0006\u0002\n\u0000\"\u000f\u0010!\u001a\u00020\u0015X\u0082\u00d4\b\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\"\u001a\u00020\u0015X\u0080\u00d4\b\u00a2\u0006\u0002\n\u0000\"\u000f\u0010#\u001a\u00020\u0015X\u0082\u00d4\b\u00a2\u0006\u0002\n\u0000\"\u000f\u0010$\u001a\u00020\u0015X\u0082\u00d4\b\u00a2\u0006\u0002\n\u0000\"\u000f\u0010(\u001a\u00020)X\u0082\u0084\b\u00a2\u0006\u0002\n\u0000\"\u000f\u0010*\u001a\u00020)X\u0082\u0084\b\u00a2\u0006\u0002\n\u0000\"\u000f\u0010+\u001a\u00020)X\u0082\u0084\b\u00a2\u0006\u0002\n\u0000\"\u000f\u0010,\u001a\u00020)X\u0082\u0084\b\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"isDistantPast", "", "Lkotlin/time/Instant;", "isDistantPast$annotations", "(Lkotlin/time/Instant;)V", "(Lkotlin/time/Instant;)Z", "isDistantFuture", "isDistantFuture$annotations", "DISTANT_PAST_SECONDS", "", "DISTANT_FUTURE_SECONDS", "MIN_SECOND", "MAX_SECOND", "parseIso", "Lkotlin/time/InstantParseResult;", "isoString", "", "formatIso", "", "instant", "DAYS_PER_CYCLE", "", "DAYS_0000_TO_1970", "safeAddOrElse", "a", "b", "action", "Lkotlin/Function0;", "", "safeMultiplyOrElse", "SECONDS_PER_HOUR", "SECONDS_PER_MINUTE", "HOURS_PER_DAY", "SECONDS_PER_DAY", "NANOS_PER_SECOND", "NANOS_PER_MILLI", "MILLIS_PER_SECOND", "isLeapYear", "year", "monthLength", "POWERS_OF_TEN", "", "asciiDigitPositionsInIsoStringAfterYear", "colonsInIsoOffsetString", "asciiDigitsInIsoOffsetString", "truncateForErrorMessage", "maxLength", "kotlin-stdlib"})
public final class InstantKt {
    private static final long DISTANT_PAST_SECONDS = -3217862419201L;
    private static final long DISTANT_FUTURE_SECONDS = 3093527980800L;
    private static final long MIN_SECOND = -31557014167219200L;
    private static final long MAX_SECOND = 31556889864403199L;
    private static final int DAYS_PER_CYCLE = 146097;
    private static final int DAYS_0000_TO_1970 = 719528;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int HOURS_PER_DAY = 24;
    private static final int SECONDS_PER_DAY = 86400;
    public static final int NANOS_PER_SECOND = 1000000000;
    private static final int NANOS_PER_MILLI = 1000000;
    private static final int MILLIS_PER_SECOND = 1000;
    private static final int[] POWERS_OF_TEN;
    private static final int[] asciiDigitPositionsInIsoStringAfterYear;
    private static final int[] colonsInIsoOffsetString;
    private static final int[] asciiDigitsInIsoOffsetString;

    private static final boolean isDistantPast(Instant instant) {
        Intrinsics.checkNotNullParameter(instant, "");
        return instant.compareTo(Instant.Companion.getDISTANT_PAST()) <= 0;
    }

    public static /* synthetic */ void isDistantPast$annotations(Instant instant) {
    }

    private static final boolean isDistantFuture(Instant instant) {
        Intrinsics.checkNotNullParameter(instant, "");
        return instant.compareTo(Instant.Companion.getDISTANT_FUTURE()) >= 0;
    }

    public static /* synthetic */ void isDistantFuture$annotations(Instant instant) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final InstantParseResult parseIso(CharSequence charSequence) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        CharSequence charSequence2 = charSequence;
        int n13 = 0;
        if (charSequence2.length() == 0) {
            return new InstantParseResult.Failure("An empty string is not a valid Instant", charSequence);
        }
        int n14 = charSequence2.charAt(n13);
        switch (n14) {
            case 43: 
            case 45: {
                ++n13;
                n12 = n14;
                break;
            }
            default: {
                n12 = 32;
            }
        }
        int n15 = n12;
        n14 = n13;
        int n16 = 0;
        while (n13 < charSequence2.length()) {
            n11 = charSequence2.charAt(n13);
            boolean bl = 48 <= n11 ? n11 < 58 : false;
            if (!bl) break;
            n16 = n16 * 10 + (charSequence2.charAt(n13) - 48);
            ++n13;
        }
        n11 = n13 - n14;
        if (n11 > 10) {
            return InstantKt.parseIso$parseFailure(charSequence, "Expected at most 10 digits for the year number, got " + n11 + " digits");
        }
        if (n11 == 10 && Intrinsics.compare(charSequence2.charAt(n14), 50) >= 0) {
            return InstantKt.parseIso$parseFailure(charSequence, "Expected at most 9 digits for the year number or year 1000000000, got " + n11 + " digits");
        }
        if (n11 < 4) {
            return InstantKt.parseIso$parseFailure(charSequence, "The year number must be padded to 4 digits, got " + n11 + " digits");
        }
        if (n15 == 43 && n11 == 4) {
            return InstantKt.parseIso$parseFailure(charSequence, "The '+' sign at the start is only valid for year numbers longer than 4 digits");
        }
        if (n15 == 32 && n11 != 4) {
            return InstantKt.parseIso$parseFailure(charSequence, "A '+' or '-' sign is required for year numbers longer than 4 digits");
        }
        int n17 = n10 = n15 == 45 ? -n16 : n16;
        if (charSequence2.length() < n13 + 16) {
            return InstantKt.parseIso$parseFailure(charSequence, "The input string is too short");
        }
        Object object = InstantKt.parseIso$expect(charSequence, "'-'", n13, InstantKt::parseIso$lambda$0);
        if (object != null) {
            InstantParseResult.Failure failure = object;
            return failure;
        }
        object = InstantKt.parseIso$expect(charSequence, "'-'", n13 + 3, InstantKt::parseIso$lambda$2);
        if (object != null) {
            InstantParseResult.Failure failure = object;
            return failure;
        }
        object = InstantKt.parseIso$expect(charSequence, "'T' or 't'", n13 + 6, InstantKt::parseIso$lambda$4);
        if (object != null) {
            InstantParseResult.Failure failure = object;
            return failure;
        }
        object = InstantKt.parseIso$expect(charSequence, "':'", n13 + 9, InstantKt::parseIso$lambda$6);
        if (object != null) {
            InstantParseResult.Failure failure = object;
            return failure;
        }
        object = InstantKt.parseIso$expect(charSequence, "':'", n13 + 12, InstantKt::parseIso$lambda$8);
        if (object != null) {
            InstantParseResult.Failure failure = object;
            return failure;
        }
        for (Object object2 : (Object)asciiDigitPositionsInIsoStringAfterYear) {
            InstantParseResult.Failure failure = InstantKt.parseIso$expect(charSequence, "an ASCII digit", n13 + object2, InstantKt::parseIso$lambda$10);
            if (failure == null) continue;
            InstantParseResult.Failure failure2 = failure;
            return failure2;
        }
        int n18 = InstantKt.parseIso$twoDigitNumber(charSequence2, n13 + 1);
        int n19 = InstantKt.parseIso$twoDigitNumber(charSequence2, n13 + 4);
        int n20 = InstantKt.parseIso$twoDigitNumber(charSequence2, n13 + 7);
        int n21 = InstantKt.parseIso$twoDigitNumber(charSequence2, n13 + 10);
        int n22 = InstantKt.parseIso$twoDigitNumber(charSequence2, n13 + 13);
        if (charSequence2.charAt(n13 + 15) == '.') {
            n9 = 0;
            for (n13 = n8 = n13 + 16; n13 < charSequence2.length(); ++n13) {
                n7 = charSequence2.charAt(n13);
                boolean bl = 48 <= n7 ? n7 < 58 : false;
                if (!bl) break;
                n9 = n9 * 10 + (charSequence2.charAt(n13) - 48);
            }
            boolean bl = 1 <= (n7 = n13 - n8) ? n7 < 10 : false;
            if (!bl) return InstantKt.parseIso$parseFailure(charSequence, "1..9 digits are supported for the fraction of the second, got " + n7 + " digits");
            n6 = n9 * POWERS_OF_TEN[9 - n7];
        } else {
            n13 += 15;
            n6 = n5 = 0;
        }
        if (n13 >= charSequence2.length()) {
            return InstantKt.parseIso$parseFailure(charSequence, "The UTC offset at the end of the string is missing");
        }
        n9 = charSequence2.charAt(n13);
        switch (n9) {
            case 90: 
            case 122: {
                if (charSequence2.length() != n13 + 1) return InstantKt.parseIso$parseFailure(charSequence, "Extra text after the instant at position " + (n13 + 1));
                n4 = 0;
                break;
            }
            case 43: 
            case 45: {
                n7 = charSequence2.length() - n13;
                if (n7 > 9) {
                    CharSequence charSequence3 = charSequence2;
                    int n23 = charSequence3.length();
                    return InstantKt.parseIso$parseFailure(charSequence, "The UTC offset string \"" + InstantKt.truncateForErrorMessage(((Object)charSequence3.subSequence(n13, n23)).toString(), 16) + "\" is too long");
                }
                if (n7 % 3 != 0) {
                    CharSequence charSequence4 = charSequence2;
                    int n24 = charSequence4.length();
                    return InstantKt.parseIso$parseFailure(charSequence, "Invalid UTC offset string \"" + ((Object)charSequence4.subSequence(n13, n24)).toString() + '\"');
                }
                for (int n25 : colonsInIsoOffsetString) {
                    if (n13 + n25 >= charSequence2.length()) break;
                    if (charSequence2.charAt(n13 + n25) == ':') continue;
                    return InstantKt.parseIso$parseFailure(charSequence, "Expected ':' at index " + (n13 + n25) + ", got '" + charSequence2.charAt(n13 + n25) + '\'');
                }
                for (int n25 : asciiDigitsInIsoOffsetString) {
                    if (n13 + n25 >= charSequence2.length()) break;
                    n3 = charSequence2.charAt(n13 + n25);
                    if (48 <= n3 ? n3 < 58 : false) continue;
                    return InstantKt.parseIso$parseFailure(charSequence, "Expected an ASCII digit at index " + (n13 + n25) + ", got '" + charSequence2.charAt(n13 + n25) + '\'');
                }
                n2 = InstantKt.parseIso$twoDigitNumber(charSequence2, n13 + 1);
                int n26 = n7 > 3 ? InstantKt.parseIso$twoDigitNumber(charSequence2, n13 + 4) : 0;
                int n27 = n = n7 > 6 ? InstantKt.parseIso$twoDigitNumber(charSequence2, n13 + 7) : 0;
                if (n26 > 59) {
                    return InstantKt.parseIso$parseFailure(charSequence, "Expected offset-minute-of-hour in 0..59, got " + n26);
                }
                if (n > 59) {
                    return InstantKt.parseIso$parseFailure(charSequence, "Expected offset-second-of-minute in 0..59, got " + n);
                }
                if (n2 > 17 && (n2 != 18 || n26 != 0 || n != 0)) {
                    CharSequence charSequence5 = charSequence2;
                    n3 = charSequence5.length();
                    return InstantKt.parseIso$parseFailure(charSequence, "Expected an offset in -18:00..+18:00, got " + ((Object)charSequence5.subSequence(n13, n3)).toString());
                }
                n4 = (n2 * 3600 + n26 * 60 + n) * (n9 == 45 ? -1 : 1);
                break;
            }
            default: {
                return InstantKt.parseIso$parseFailure(charSequence, "Expected the UTC offset at position " + n13 + ", got '" + (char)n9 + '\'');
            }
        }
        n8 = n4;
        if (!(1 <= n18 ? n18 < 13 : false)) {
            return InstantKt.parseIso$parseFailure(charSequence, "Expected a month number in 1..12, got " + n18);
        }
        if (!(1 <= n19 ? n19 <= InstantKt.monthLength(n18, InstantKt.isLeapYear(n10)) : false)) {
            return InstantKt.parseIso$parseFailure(charSequence, "Expected a valid day-of-month for month " + n18 + " of year " + n10 + ", got " + n19);
        }
        if (n20 > 23) {
            return InstantKt.parseIso$parseFailure(charSequence, "Expected hour in 0..23, got " + n20);
        }
        if (n21 > 59) {
            return InstantKt.parseIso$parseFailure(charSequence, "Expected minute-of-hour in 0..59, got " + n21);
        }
        if (n22 > 59) {
            return InstantKt.parseIso$parseFailure(charSequence, "Expected second-of-minute in 0..59, got " + n22);
        }
        UnboundLocalDateTime unboundLocalDateTime = new UnboundLocalDateTime(n10, n18, n19, n20, n21, n22, n5);
        n7 = n8;
        n2 = 0;
        UnboundLocalDateTime unboundLocalDateTime2 = unboundLocalDateTime;
        n = 0;
        UnboundLocalDateTime unboundLocalDateTime3 = unboundLocalDateTime2;
        n3 = 0;
        long l = unboundLocalDateTime3.getYear();
        long l2 = (long)365 * l;
        l2 = l >= 0L ? (l2 += (l + (long)3) / (long)4 - (l + (long)99) / (long)100 + (l + (long)399) / (long)400) : (l2 -= l / (long)-4 - l / (long)-100 + l / (long)-400);
        l2 += (long)((367 * unboundLocalDateTime3.getMonth() - 362) / 12);
        l2 += (long)(unboundLocalDateTime3.getDay() - 1);
        if (unboundLocalDateTime3.getMonth() > 2) {
            l2 += -1L;
            if (!InstantKt.isLeapYear(unboundLocalDateTime3.getYear())) {
                l2 += -1L;
            }
        }
        long l3 = l2 - (long)719528;
        int n28 = unboundLocalDateTime2.getHour() * 3600 + unboundLocalDateTime2.getMinute() * 60 + unboundLocalDateTime2.getSecond();
        long l4 = l3 * (long)86400 + (long)n28 - (long)n7;
        int n29 = unboundLocalDateTime.getNanosecond();
        long l5 = l4;
        return new InstantParseResult.Success(l5, n29);
    }

    private static final String formatIso(Instant instant) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        StringBuilder stringBuilder3 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        UnboundLocalDateTime unboundLocalDateTime = UnboundLocalDateTime.Companion.fromInstant(instant);
        int n = unboundLocalDateTime.getYear();
        if (Math.abs(n) < 1000) {
            StringBuilder stringBuilder4;
            StringBuilder stringBuilder5 = new StringBuilder();
            if (n >= 0) {
                StringBuilder stringBuilder6 = stringBuilder5.append(n + 10000).deleteCharAt(0);
                stringBuilder4 = stringBuilder6;
                Intrinsics.checkNotNullExpressionValue(stringBuilder6, "");
            } else {
                StringBuilder stringBuilder7 = stringBuilder5.append(n - 10000).deleteCharAt(1);
                stringBuilder4 = stringBuilder7;
                Intrinsics.checkNotNullExpressionValue(stringBuilder7, "");
            }
            stringBuilder = stringBuilder3.append((CharSequence)stringBuilder5);
        } else {
            if (n >= 10000) {
                stringBuilder3.append('+');
            }
            stringBuilder = stringBuilder3.append(n);
        }
        stringBuilder3.append('-');
        InstantKt.formatIso$lambda$0$appendTwoDigits(stringBuilder3, stringBuilder3, unboundLocalDateTime.getMonth());
        stringBuilder3.append('-');
        InstantKt.formatIso$lambda$0$appendTwoDigits(stringBuilder3, stringBuilder3, unboundLocalDateTime.getDay());
        stringBuilder3.append('T');
        InstantKt.formatIso$lambda$0$appendTwoDigits(stringBuilder3, stringBuilder3, unboundLocalDateTime.getHour());
        stringBuilder3.append(':');
        InstantKt.formatIso$lambda$0$appendTwoDigits(stringBuilder3, stringBuilder3, unboundLocalDateTime.getMinute());
        stringBuilder3.append(':');
        InstantKt.formatIso$lambda$0$appendTwoDigits(stringBuilder3, stringBuilder3, unboundLocalDateTime.getSecond());
        if (unboundLocalDateTime.getNanosecond() != 0) {
            stringBuilder3.append('.');
            int n2 = 0;
            while (unboundLocalDateTime.getNanosecond() % POWERS_OF_TEN[n2 + 1] == 0) {
                ++n2;
            }
            n2 -= n2 % 3;
            int n3 = unboundLocalDateTime.getNanosecond() / POWERS_OF_TEN[n2];
            String string = String.valueOf(n3 + POWERS_OF_TEN[9 - n2]);
            int n4 = 1;
            Intrinsics.checkNotNull(string);
            String string2 = string.substring(n4);
            Intrinsics.checkNotNullExpressionValue(string2, "");
            stringBuilder3.append(string2);
        }
        stringBuilder3.append('Z');
        return stringBuilder2.toString();
    }

    private static final long safeAddOrElse(long l, long l2, Function0 function0) {
        boolean bl = false;
        long l3 = l + l2;
        if ((l ^ l3) < 0L && (l ^ l2) >= 0L) {
            function0.invoke();
            throw new KotlinNothingValueException();
        }
        return l3;
    }

    private static final long safeMultiplyOrElse(long l, long l2, Function0 function0) {
        boolean bl = false;
        if (l2 == 1L) {
            return l;
        }
        if (l == 1L) {
            return l2;
        }
        if (l == 0L || l2 == 0L) {
            return 0L;
        }
        long l3 = l * l2;
        if (l3 / l2 != l || l == Long.MIN_VALUE && l2 == -1L || l2 == Long.MIN_VALUE && l == -1L) {
            function0.invoke();
            throw new KotlinNothingValueException();
        }
        return l3;
    }

    public static final boolean isLeapYear(int n) {
        return (n & 3) == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    private static final int monthLength(int n, boolean bl) {
        int n2;
        switch (n) {
            case 2: {
                if (bl) {
                    n2 = 29;
                    break;
                }
                n2 = 28;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                n2 = 30;
                break;
            }
            default: {
                n2 = 31;
            }
        }
        return n2;
    }

    private static final String truncateForErrorMessage(CharSequence charSequence, int n) {
        return charSequence.length() <= n ? ((Object)charSequence).toString() : ((Object)charSequence.subSequence(0, n)).toString() + "...";
    }

    private static final InstantParseResult.Failure parseIso$parseFailure(CharSequence charSequence, String string) {
        return new InstantParseResult.Failure(string + " when parsing an Instant from \"" + InstantKt.truncateForErrorMessage(charSequence, 64) + '\"', charSequence);
    }

    private static final InstantParseResult.Failure parseIso$expect(CharSequence charSequence, String string, int n, Function1<? super Character, Boolean> function1) {
        char c = charSequence.charAt(n);
        return function1.invoke(Character.valueOf(c)) != false ? null : InstantKt.parseIso$parseFailure(charSequence, "Expected " + string + ", but got '" + c + "' at position " + n);
    }

    private static final boolean parseIso$lambda$0(char c) {
        return c == '-';
    }

    private static final boolean parseIso$lambda$2(char c) {
        return c == '-';
    }

    private static final boolean parseIso$lambda$4(char c) {
        return c == 'T' || c == 't';
    }

    private static final boolean parseIso$lambda$6(char c) {
        return c == ':';
    }

    private static final boolean parseIso$lambda$8(char c) {
        return c == ':';
    }

    private static final boolean parseIso$lambda$10(char c) {
        return '0' <= c ? c < ':' : false;
    }

    private static final int parseIso$twoDigitNumber(CharSequence charSequence, int n) {
        return (charSequence.charAt(n) - 48) * 10 + (charSequence.charAt(n + 1) - 48);
    }

    private static final void formatIso$lambda$0$appendTwoDigits(Appendable appendable, StringBuilder stringBuilder, int n) {
        if (n < 10) {
            appendable.append('0');
        }
        stringBuilder.append(n);
    }

    public static final /* synthetic */ String access$formatIso(Instant instant) {
        return InstantKt.formatIso(instant);
    }

    public static final /* synthetic */ InstantParseResult access$parseIso(CharSequence charSequence) {
        return InstantKt.parseIso(charSequence);
    }

    public static final /* synthetic */ String access$truncateForErrorMessage(CharSequence charSequence, int n) {
        return InstantKt.truncateForErrorMessage(charSequence, n);
    }

    static {
        int[] nArray = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
        POWERS_OF_TEN = nArray;
        nArray = new int[]{1, 2, 4, 5, 7, 8, 10, 11, 13, 14};
        asciiDigitPositionsInIsoStringAfterYear = nArray;
        nArray = new int[]{3, 6};
        colonsInIsoOffsetString = nArray;
        nArray = new int[]{1, 2, 4, 5, 7, 8};
        asciiDigitsInIsoOffsetString = nArray;
    }
}

