/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.PoolArena;
import io.netty.buffer.PoolChunk;
import io.netty.buffer.PooledByteBuf;
import io.netty.util.Recycler;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.ObjectPool;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;

final class PoolThreadCache {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PoolThreadCache.class);
    private static final int INTEGER_SIZE_MINUS_ONE = 31;
    final PoolArena<byte[]> heapArena;
    final PoolArena<ByteBuffer> directArena;
    private final MemoryRegionCache<byte[]>[] smallSubPageHeapCaches;
    private final MemoryRegionCache<ByteBuffer>[] smallSubPageDirectCaches;
    private final MemoryRegionCache<byte[]>[] normalHeapCaches;
    private final MemoryRegionCache<ByteBuffer>[] normalDirectCaches;
    private final int freeSweepAllocationThreshold;
    private final AtomicBoolean freed = new AtomicBoolean();
    private final FreeOnFinalize freeOnFinalize;
    private int allocations;

    PoolThreadCache(PoolArena<byte[]> poolArena, PoolArena<ByteBuffer> poolArena2, int n, int n2, int n3, int n4, boolean bl) {
        ObjectUtil.checkPositiveOrZero((int)n3, (String)"maxCachedBufferCapacity");
        this.freeSweepAllocationThreshold = n4;
        this.heapArena = poolArena;
        this.directArena = poolArena2;
        if (poolArena2 != null) {
            this.smallSubPageDirectCaches = PoolThreadCache.createSubPageCaches(n, poolArena2.sizeClass.nSubpages);
            this.normalDirectCaches = PoolThreadCache.createNormalCaches(n2, n3, poolArena2);
            poolArena2.numThreadCaches.getAndIncrement();
        } else {
            this.smallSubPageDirectCaches = null;
            this.normalDirectCaches = null;
        }
        if (poolArena != null) {
            this.smallSubPageHeapCaches = PoolThreadCache.createSubPageCaches(n, poolArena.sizeClass.nSubpages);
            this.normalHeapCaches = PoolThreadCache.createNormalCaches(n2, n3, poolArena);
            poolArena.numThreadCaches.getAndIncrement();
        } else {
            this.smallSubPageHeapCaches = null;
            this.normalHeapCaches = null;
        }
        if ((this.smallSubPageDirectCaches != null || this.normalDirectCaches != null || this.smallSubPageHeapCaches != null || this.normalHeapCaches != null) && n4 < 1) {
            throw new IllegalArgumentException("freeSweepAllocationThreshold: " + n4 + " (expected: > 0)");
        }
        this.freeOnFinalize = bl ? new FreeOnFinalize(this) : null;
    }

    private static <T> MemoryRegionCache<T>[] createSubPageCaches(int n, int n2) {
        if (n > 0 && n2 > 0) {
            MemoryRegionCache[] memoryRegionCacheArray = new MemoryRegionCache[n2];
            for (int i = 0; i < memoryRegionCacheArray.length; ++i) {
                memoryRegionCacheArray[i] = new SubPageMemoryRegionCache(n);
            }
            return memoryRegionCacheArray;
        }
        return null;
    }

    private static <T> MemoryRegionCache<T>[] createNormalCaches(int n, int n2, PoolArena<T> poolArena) {
        if (n > 0 && n2 > 0) {
            int n3 = Math.min(poolArena.sizeClass.chunkSize, n2);
            ArrayList arrayList = new ArrayList();
            for (int i = poolArena.sizeClass.nSubpages; i < poolArena.sizeClass.nSizes && poolArena.sizeClass.sizeIdx2size(i) <= n3; ++i) {
                arrayList.add(new NormalMemoryRegionCache(n));
            }
            return arrayList.toArray(new MemoryRegionCache[0]);
        }
        return null;
    }

    static int log2(int n) {
        return 31 - Integer.numberOfLeadingZeros(n);
    }

    boolean allocateSmall(PoolArena<?> poolArena, PooledByteBuf<?> pooledByteBuf, int n, int n2) {
        return this.allocate(this.cacheForSmall(poolArena, n2), pooledByteBuf, n);
    }

    boolean allocateNormal(PoolArena<?> poolArena, PooledByteBuf<?> pooledByteBuf, int n, int n2) {
        return this.allocate(this.cacheForNormal(poolArena, n2), pooledByteBuf, n);
    }

    private boolean allocate(MemoryRegionCache<?> memoryRegionCache, PooledByteBuf pooledByteBuf, int n) {
        if (memoryRegionCache == null) {
            return false;
        }
        boolean bl = memoryRegionCache.allocate(pooledByteBuf, n, this);
        if (++this.allocations >= this.freeSweepAllocationThreshold) {
            this.allocations = 0;
            this.trim();
        }
        return bl;
    }

    boolean add(PoolArena<?> poolArena, PoolChunk poolChunk, ByteBuffer byteBuffer, long l, int n, PoolArena.SizeClass sizeClass) {
        int n2 = poolArena.sizeClass.size2SizeIdx(n);
        MemoryRegionCache<?> memoryRegionCache = this.cache(poolArena, n2, sizeClass);
        if (memoryRegionCache == null) {
            return false;
        }
        if (this.freed.get()) {
            return false;
        }
        return memoryRegionCache.add(poolChunk, byteBuffer, l, n);
    }

    private MemoryRegionCache<?> cache(PoolArena<?> poolArena, int n, PoolArena.SizeClass sizeClass) {
        switch (sizeClass) {
            case Normal: {
                return this.cacheForNormal(poolArena, n);
            }
            case Small: {
                return this.cacheForSmall(poolArena, n);
            }
        }
        throw new Error();
    }

    void free(boolean bl) {
        if (this.freed.compareAndSet(false, true)) {
            int n;
            if (this.freeOnFinalize != null) {
                this.freeOnFinalize.cache = null;
            }
            if ((n = PoolThreadCache.free(this.smallSubPageDirectCaches, bl) + PoolThreadCache.free(this.normalDirectCaches, bl) + PoolThreadCache.free(this.smallSubPageHeapCaches, bl) + PoolThreadCache.free(this.normalHeapCaches, bl)) > 0 && logger.isDebugEnabled()) {
                logger.debug("Freed {} thread-local buffer(s) from thread: {}", (Object)n, (Object)Thread.currentThread().getName());
            }
            if (this.directArena != null) {
                this.directArena.numThreadCaches.getAndDecrement();
            }
            if (this.heapArena != null) {
                this.heapArena.numThreadCaches.getAndDecrement();
            }
        }
    }

    private static int free(MemoryRegionCache<?>[] memoryRegionCacheArray, boolean bl) {
        if (memoryRegionCacheArray == null) {
            return 0;
        }
        int n = 0;
        for (MemoryRegionCache<?> memoryRegionCache : memoryRegionCacheArray) {
            n += PoolThreadCache.free(memoryRegionCache, bl);
        }
        return n;
    }

    private static int free(MemoryRegionCache<?> memoryRegionCache, boolean bl) {
        if (memoryRegionCache == null) {
            return 0;
        }
        return memoryRegionCache.free(bl);
    }

    void trim() {
        PoolThreadCache.trim(this.smallSubPageDirectCaches);
        PoolThreadCache.trim(this.normalDirectCaches);
        PoolThreadCache.trim(this.smallSubPageHeapCaches);
        PoolThreadCache.trim(this.normalHeapCaches);
    }

    private static void trim(MemoryRegionCache<?>[] memoryRegionCacheArray) {
        if (memoryRegionCacheArray == null) {
            return;
        }
        for (MemoryRegionCache<?> memoryRegionCache : memoryRegionCacheArray) {
            PoolThreadCache.trim(memoryRegionCache);
        }
    }

    private static void trim(MemoryRegionCache<?> memoryRegionCache) {
        if (memoryRegionCache == null) {
            return;
        }
        memoryRegionCache.trim();
    }

    private MemoryRegionCache<?> cacheForSmall(PoolArena<?> poolArena, int n) {
        if (poolArena.isDirect()) {
            return PoolThreadCache.cache(this.smallSubPageDirectCaches, n);
        }
        return PoolThreadCache.cache(this.smallSubPageHeapCaches, n);
    }

    private MemoryRegionCache<?> cacheForNormal(PoolArena<?> poolArena, int n) {
        int n2 = n - poolArena.sizeClass.nSubpages;
        if (poolArena.isDirect()) {
            return PoolThreadCache.cache(this.normalDirectCaches, n2);
        }
        return PoolThreadCache.cache(this.normalHeapCaches, n2);
    }

    private static <T> MemoryRegionCache<T> cache(MemoryRegionCache<T>[] memoryRegionCacheArray, int n) {
        if (memoryRegionCacheArray == null || n > memoryRegionCacheArray.length - 1) {
            return null;
        }
        return memoryRegionCacheArray[n];
    }

    private static final class FreeOnFinalize {
        private volatile PoolThreadCache cache;

        private FreeOnFinalize(PoolThreadCache poolThreadCache) {
            this.cache = poolThreadCache;
        }

        protected void finalize() {
            try {
                super.finalize();
            }
            finally {
                PoolThreadCache poolThreadCache = this.cache;
                this.cache = null;
                if (poolThreadCache != null) {
                    poolThreadCache.free(true);
                }
            }
        }
    }

    private static abstract class MemoryRegionCache<T> {
        private final int size;
        private final Queue<Entry<T>> queue;
        private final PoolArena.SizeClass sizeClass;
        private int allocations;
        private static final ObjectPool<Entry> RECYCLER = ObjectPool.newPool((ObjectPool.ObjectCreator)new ObjectPool.ObjectCreator<Entry>(){

            public Entry newObject(ObjectPool.Handle<Entry> handle) {
                return new Entry(handle);
            }
        });

        MemoryRegionCache(int n, PoolArena.SizeClass sizeClass) {
            this.size = MathUtil.safeFindNextPositivePowerOfTwo((int)n);
            this.queue = PlatformDependent.newFixedMpscUnpaddedQueue((int)this.size);
            this.sizeClass = sizeClass;
        }

        protected abstract void initBuf(PoolChunk<T> var1, ByteBuffer var2, long var3, PooledByteBuf<T> var5, int var6, PoolThreadCache var7);

        public final boolean add(PoolChunk<T> poolChunk, ByteBuffer byteBuffer, long l, int n) {
            Entry entry = MemoryRegionCache.newEntry(poolChunk, byteBuffer, l, n);
            boolean bl = this.queue.offer(entry);
            if (!bl) {
                entry.unguardedRecycle();
            }
            return bl;
        }

        public final boolean allocate(PooledByteBuf<T> pooledByteBuf, int n, PoolThreadCache poolThreadCache) {
            Entry<T> entry = this.queue.poll();
            if (entry == null) {
                return false;
            }
            this.initBuf(entry.chunk, entry.nioBuffer, entry.handle, pooledByteBuf, n, poolThreadCache);
            entry.unguardedRecycle();
            ++this.allocations;
            return true;
        }

        public final int free(boolean bl) {
            return this.free(Integer.MAX_VALUE, bl);
        }

        private int free(int n, boolean bl) {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                Entry<T> entry = this.queue.poll();
                if (entry == null) {
                    return n2;
                }
                this.freeEntry(entry, bl);
            }
            return n2;
        }

        public final void trim() {
            int n = this.size - this.allocations;
            this.allocations = 0;
            if (n > 0) {
                this.free(n, false);
            }
        }

        private void freeEntry(Entry entry, boolean bl) {
            PoolChunk poolChunk = entry.chunk;
            long l = entry.handle;
            ByteBuffer byteBuffer = entry.nioBuffer;
            int n = entry.normCapacity;
            if (!bl) {
                entry.recycle();
            }
            poolChunk.arena.freeChunk(poolChunk, l, n, this.sizeClass, byteBuffer, bl);
        }

        private static Entry newEntry(PoolChunk<?> poolChunk, ByteBuffer byteBuffer, long l, int n) {
            Entry entry = (Entry)RECYCLER.get();
            entry.chunk = poolChunk;
            entry.nioBuffer = byteBuffer;
            entry.handle = l;
            entry.normCapacity = n;
            return entry;
        }

        static final class Entry<T> {
            final Recycler.EnhancedHandle<Entry<?>> recyclerHandle;
            PoolChunk<T> chunk;
            ByteBuffer nioBuffer;
            long handle = -1L;
            int normCapacity;

            Entry(ObjectPool.Handle<Entry<?>> handle) {
                this.recyclerHandle = (Recycler.EnhancedHandle)handle;
            }

            void recycle() {
                this.chunk = null;
                this.nioBuffer = null;
                this.handle = -1L;
                this.recyclerHandle.recycle((Object)this);
            }

            void unguardedRecycle() {
                this.chunk = null;
                this.nioBuffer = null;
                this.handle = -1L;
                this.recyclerHandle.unguardedRecycle((Object)this);
            }
        }
    }

    private static final class NormalMemoryRegionCache<T>
    extends MemoryRegionCache<T> {
        NormalMemoryRegionCache(int n) {
            super(n, PoolArena.SizeClass.Normal);
        }

        @Override
        protected void initBuf(PoolChunk<T> poolChunk, ByteBuffer byteBuffer, long l, PooledByteBuf<T> pooledByteBuf, int n, PoolThreadCache poolThreadCache) {
            poolChunk.initBuf(pooledByteBuf, byteBuffer, l, n, poolThreadCache);
        }
    }

    private static final class SubPageMemoryRegionCache<T>
    extends MemoryRegionCache<T> {
        SubPageMemoryRegionCache(int n) {
            super(n, PoolArena.SizeClass.Small);
        }

        @Override
        protected void initBuf(PoolChunk<T> poolChunk, ByteBuffer byteBuffer, long l, PooledByteBuf<T> pooledByteBuf, int n, PoolThreadCache poolThreadCache) {
            poolChunk.initBufWithSubpage(pooledByteBuf, byteBuffer, l, n, poolThreadCache);
        }
    }
}

