/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.UnpooledUnsafeDirectByteBuf;
import io.netty.buffer.UnpooledUnsafeNoCleanerDirectByteBuf;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;

final class UnsafeByteBufUtil {
    private static final boolean UNALIGNED = PlatformDependent.isUnaligned();
    private static final byte ZERO = 0;
    private static final int MAX_HAND_ROLLED_SET_ZERO_BYTES = 64;

    static byte getByte(long l) {
        return PlatformDependent.getByte((long)l);
    }

    static short getShort(long l) {
        if (UNALIGNED) {
            short s = PlatformDependent.getShort((long)l);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? s : Short.reverseBytes(s);
        }
        return (short)(PlatformDependent.getByte((long)l) << 8 | PlatformDependent.getByte((long)(l + 1L)) & 0xFF);
    }

    static short getShortLE(long l) {
        if (UNALIGNED) {
            short s = PlatformDependent.getShort((long)l);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes(s) : s;
        }
        return (short)(PlatformDependent.getByte((long)l) & 0xFF | PlatformDependent.getByte((long)(l + 1L)) << 8);
    }

    static int getUnsignedMedium(long l) {
        if (UNALIGNED) {
            return (PlatformDependent.getByte((long)l) & 0xFF) << 16 | (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? PlatformDependent.getShort((long)(l + 1L)) : Short.reverseBytes(PlatformDependent.getShort((long)(l + 1L)))) & 0xFFFF;
        }
        return (PlatformDependent.getByte((long)l) & 0xFF) << 16 | (PlatformDependent.getByte((long)(l + 1L)) & 0xFF) << 8 | PlatformDependent.getByte((long)(l + 2L)) & 0xFF;
    }

    static int getUnsignedMediumLE(long l) {
        if (UNALIGNED) {
            return PlatformDependent.getByte((long)l) & 0xFF | ((PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes(PlatformDependent.getShort((long)(l + 1L))) : PlatformDependent.getShort((long)(l + 1L))) & 0xFFFF) << 8;
        }
        return PlatformDependent.getByte((long)l) & 0xFF | (PlatformDependent.getByte((long)(l + 1L)) & 0xFF) << 8 | (PlatformDependent.getByte((long)(l + 2L)) & 0xFF) << 16;
    }

    static int getInt(long l) {
        if (UNALIGNED) {
            int n = PlatformDependent.getInt((long)l);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? n : Integer.reverseBytes(n);
        }
        return PlatformDependent.getByte((long)l) << 24 | (PlatformDependent.getByte((long)(l + 1L)) & 0xFF) << 16 | (PlatformDependent.getByte((long)(l + 2L)) & 0xFF) << 8 | PlatformDependent.getByte((long)(l + 3L)) & 0xFF;
    }

    static int getIntLE(long l) {
        if (UNALIGNED) {
            int n = PlatformDependent.getInt((long)l);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Integer.reverseBytes(n) : n;
        }
        return PlatformDependent.getByte((long)l) & 0xFF | (PlatformDependent.getByte((long)(l + 1L)) & 0xFF) << 8 | (PlatformDependent.getByte((long)(l + 2L)) & 0xFF) << 16 | PlatformDependent.getByte((long)(l + 3L)) << 24;
    }

    static long getLong(long l) {
        if (UNALIGNED) {
            long l2 = PlatformDependent.getLong((long)l);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? l2 : Long.reverseBytes(l2);
        }
        return (long)PlatformDependent.getByte((long)l) << 56 | ((long)PlatformDependent.getByte((long)(l + 1L)) & 0xFFL) << 48 | ((long)PlatformDependent.getByte((long)(l + 2L)) & 0xFFL) << 40 | ((long)PlatformDependent.getByte((long)(l + 3L)) & 0xFFL) << 32 | ((long)PlatformDependent.getByte((long)(l + 4L)) & 0xFFL) << 24 | ((long)PlatformDependent.getByte((long)(l + 5L)) & 0xFFL) << 16 | ((long)PlatformDependent.getByte((long)(l + 6L)) & 0xFFL) << 8 | (long)PlatformDependent.getByte((long)(l + 7L)) & 0xFFL;
    }

    static long getLongLE(long l) {
        if (UNALIGNED) {
            long l2 = PlatformDependent.getLong((long)l);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Long.reverseBytes(l2) : l2;
        }
        return (long)PlatformDependent.getByte((long)l) & 0xFFL | ((long)PlatformDependent.getByte((long)(l + 1L)) & 0xFFL) << 8 | ((long)PlatformDependent.getByte((long)(l + 2L)) & 0xFFL) << 16 | ((long)PlatformDependent.getByte((long)(l + 3L)) & 0xFFL) << 24 | ((long)PlatformDependent.getByte((long)(l + 4L)) & 0xFFL) << 32 | ((long)PlatformDependent.getByte((long)(l + 5L)) & 0xFFL) << 40 | ((long)PlatformDependent.getByte((long)(l + 6L)) & 0xFFL) << 48 | (long)PlatformDependent.getByte((long)(l + 7L)) << 56;
    }

    static void setByte(long l, int n) {
        PlatformDependent.putByte((long)l, (byte)((byte)n));
    }

    static void setShort(long l, int n) {
        if (UNALIGNED) {
            PlatformDependent.putShort((long)l, (short)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? (short)n : Short.reverseBytes((short)n)));
        } else {
            PlatformDependent.putByte((long)l, (byte)((byte)(n >>> 8)));
            PlatformDependent.putByte((long)(l + 1L), (byte)((byte)n));
        }
    }

    static void setShortLE(long l, int n) {
        if (UNALIGNED) {
            PlatformDependent.putShort((long)l, (short)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes((short)n) : (short)n));
        } else {
            PlatformDependent.putByte((long)l, (byte)((byte)n));
            PlatformDependent.putByte((long)(l + 1L), (byte)((byte)(n >>> 8)));
        }
    }

    static void setMedium(long l, int n) {
        PlatformDependent.putByte((long)l, (byte)((byte)(n >>> 16)));
        if (UNALIGNED) {
            PlatformDependent.putShort((long)(l + 1L), (short)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? (short)n : Short.reverseBytes((short)n)));
        } else {
            PlatformDependent.putByte((long)(l + 1L), (byte)((byte)(n >>> 8)));
            PlatformDependent.putByte((long)(l + 2L), (byte)((byte)n));
        }
    }

    static void setMediumLE(long l, int n) {
        PlatformDependent.putByte((long)l, (byte)((byte)n));
        if (UNALIGNED) {
            PlatformDependent.putShort((long)(l + 1L), (short)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes((short)(n >>> 8)) : (short)(n >>> 8)));
        } else {
            PlatformDependent.putByte((long)(l + 1L), (byte)((byte)(n >>> 8)));
            PlatformDependent.putByte((long)(l + 2L), (byte)((byte)(n >>> 16)));
        }
    }

    static void setInt(long l, int n) {
        if (UNALIGNED) {
            PlatformDependent.putInt((long)l, (int)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? n : Integer.reverseBytes(n)));
        } else {
            PlatformDependent.putByte((long)l, (byte)((byte)(n >>> 24)));
            PlatformDependent.putByte((long)(l + 1L), (byte)((byte)(n >>> 16)));
            PlatformDependent.putByte((long)(l + 2L), (byte)((byte)(n >>> 8)));
            PlatformDependent.putByte((long)(l + 3L), (byte)((byte)n));
        }
    }

    static void setIntLE(long l, int n) {
        if (UNALIGNED) {
            PlatformDependent.putInt((long)l, (int)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Integer.reverseBytes(n) : n));
        } else {
            PlatformDependent.putByte((long)l, (byte)((byte)n));
            PlatformDependent.putByte((long)(l + 1L), (byte)((byte)(n >>> 8)));
            PlatformDependent.putByte((long)(l + 2L), (byte)((byte)(n >>> 16)));
            PlatformDependent.putByte((long)(l + 3L), (byte)((byte)(n >>> 24)));
        }
    }

    static void setLong(long l, long l2) {
        if (UNALIGNED) {
            PlatformDependent.putLong((long)l, (long)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? l2 : Long.reverseBytes(l2)));
        } else {
            PlatformDependent.putByte((long)l, (byte)((byte)(l2 >>> 56)));
            PlatformDependent.putByte((long)(l + 1L), (byte)((byte)(l2 >>> 48)));
            PlatformDependent.putByte((long)(l + 2L), (byte)((byte)(l2 >>> 40)));
            PlatformDependent.putByte((long)(l + 3L), (byte)((byte)(l2 >>> 32)));
            PlatformDependent.putByte((long)(l + 4L), (byte)((byte)(l2 >>> 24)));
            PlatformDependent.putByte((long)(l + 5L), (byte)((byte)(l2 >>> 16)));
            PlatformDependent.putByte((long)(l + 6L), (byte)((byte)(l2 >>> 8)));
            PlatformDependent.putByte((long)(l + 7L), (byte)((byte)l2));
        }
    }

    static void setLongLE(long l, long l2) {
        if (UNALIGNED) {
            PlatformDependent.putLong((long)l, (long)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Long.reverseBytes(l2) : l2));
        } else {
            PlatformDependent.putByte((long)l, (byte)((byte)l2));
            PlatformDependent.putByte((long)(l + 1L), (byte)((byte)(l2 >>> 8)));
            PlatformDependent.putByte((long)(l + 2L), (byte)((byte)(l2 >>> 16)));
            PlatformDependent.putByte((long)(l + 3L), (byte)((byte)(l2 >>> 24)));
            PlatformDependent.putByte((long)(l + 4L), (byte)((byte)(l2 >>> 32)));
            PlatformDependent.putByte((long)(l + 5L), (byte)((byte)(l2 >>> 40)));
            PlatformDependent.putByte((long)(l + 6L), (byte)((byte)(l2 >>> 48)));
            PlatformDependent.putByte((long)(l + 7L), (byte)((byte)(l2 >>> 56)));
        }
    }

    static byte getByte(byte[] byArray, int n) {
        return PlatformDependent.getByte((byte[])byArray, (int)n);
    }

    static short getShort(byte[] byArray, int n) {
        if (UNALIGNED) {
            short s = PlatformDependent.getShort((byte[])byArray, (int)n);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? s : Short.reverseBytes(s);
        }
        return (short)(PlatformDependent.getByte((byte[])byArray, (int)n) << 8 | PlatformDependent.getByte((byte[])byArray, (int)(n + 1)) & 0xFF);
    }

    static short getShortLE(byte[] byArray, int n) {
        if (UNALIGNED) {
            short s = PlatformDependent.getShort((byte[])byArray, (int)n);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes(s) : s;
        }
        return (short)(PlatformDependent.getByte((byte[])byArray, (int)n) & 0xFF | PlatformDependent.getByte((byte[])byArray, (int)(n + 1)) << 8);
    }

    static int getUnsignedMedium(byte[] byArray, int n) {
        if (UNALIGNED) {
            return (PlatformDependent.getByte((byte[])byArray, (int)n) & 0xFF) << 16 | (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? PlatformDependent.getShort((byte[])byArray, (int)(n + 1)) : Short.reverseBytes(PlatformDependent.getShort((byte[])byArray, (int)(n + 1)))) & 0xFFFF;
        }
        return (PlatformDependent.getByte((byte[])byArray, (int)n) & 0xFF) << 16 | (PlatformDependent.getByte((byte[])byArray, (int)(n + 1)) & 0xFF) << 8 | PlatformDependent.getByte((byte[])byArray, (int)(n + 2)) & 0xFF;
    }

    static int getUnsignedMediumLE(byte[] byArray, int n) {
        if (UNALIGNED) {
            return PlatformDependent.getByte((byte[])byArray, (int)n) & 0xFF | ((PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes(PlatformDependent.getShort((byte[])byArray, (int)(n + 1))) : PlatformDependent.getShort((byte[])byArray, (int)(n + 1))) & 0xFFFF) << 8;
        }
        return PlatformDependent.getByte((byte[])byArray, (int)n) & 0xFF | (PlatformDependent.getByte((byte[])byArray, (int)(n + 1)) & 0xFF) << 8 | (PlatformDependent.getByte((byte[])byArray, (int)(n + 2)) & 0xFF) << 16;
    }

    static int getInt(byte[] byArray, int n) {
        if (UNALIGNED) {
            int n2 = PlatformDependent.getInt((byte[])byArray, (int)n);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? n2 : Integer.reverseBytes(n2);
        }
        return PlatformDependent.getByte((byte[])byArray, (int)n) << 24 | (PlatformDependent.getByte((byte[])byArray, (int)(n + 1)) & 0xFF) << 16 | (PlatformDependent.getByte((byte[])byArray, (int)(n + 2)) & 0xFF) << 8 | PlatformDependent.getByte((byte[])byArray, (int)(n + 3)) & 0xFF;
    }

    static int getIntLE(byte[] byArray, int n) {
        if (UNALIGNED) {
            int n2 = PlatformDependent.getInt((byte[])byArray, (int)n);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Integer.reverseBytes(n2) : n2;
        }
        return PlatformDependent.getByte((byte[])byArray, (int)n) & 0xFF | (PlatformDependent.getByte((byte[])byArray, (int)(n + 1)) & 0xFF) << 8 | (PlatformDependent.getByte((byte[])byArray, (int)(n + 2)) & 0xFF) << 16 | PlatformDependent.getByte((byte[])byArray, (int)(n + 3)) << 24;
    }

    static long getLong(byte[] byArray, int n) {
        if (UNALIGNED) {
            long l = PlatformDependent.getLong((byte[])byArray, (int)n);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? l : Long.reverseBytes(l);
        }
        return (long)PlatformDependent.getByte((byte[])byArray, (int)n) << 56 | ((long)PlatformDependent.getByte((byte[])byArray, (int)(n + 1)) & 0xFFL) << 48 | ((long)PlatformDependent.getByte((byte[])byArray, (int)(n + 2)) & 0xFFL) << 40 | ((long)PlatformDependent.getByte((byte[])byArray, (int)(n + 3)) & 0xFFL) << 32 | ((long)PlatformDependent.getByte((byte[])byArray, (int)(n + 4)) & 0xFFL) << 24 | ((long)PlatformDependent.getByte((byte[])byArray, (int)(n + 5)) & 0xFFL) << 16 | ((long)PlatformDependent.getByte((byte[])byArray, (int)(n + 6)) & 0xFFL) << 8 | (long)PlatformDependent.getByte((byte[])byArray, (int)(n + 7)) & 0xFFL;
    }

    static long getLongLE(byte[] byArray, int n) {
        if (UNALIGNED) {
            long l = PlatformDependent.getLong((byte[])byArray, (int)n);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Long.reverseBytes(l) : l;
        }
        return (long)PlatformDependent.getByte((byte[])byArray, (int)n) & 0xFFL | ((long)PlatformDependent.getByte((byte[])byArray, (int)(n + 1)) & 0xFFL) << 8 | ((long)PlatformDependent.getByte((byte[])byArray, (int)(n + 2)) & 0xFFL) << 16 | ((long)PlatformDependent.getByte((byte[])byArray, (int)(n + 3)) & 0xFFL) << 24 | ((long)PlatformDependent.getByte((byte[])byArray, (int)(n + 4)) & 0xFFL) << 32 | ((long)PlatformDependent.getByte((byte[])byArray, (int)(n + 5)) & 0xFFL) << 40 | ((long)PlatformDependent.getByte((byte[])byArray, (int)(n + 6)) & 0xFFL) << 48 | (long)PlatformDependent.getByte((byte[])byArray, (int)(n + 7)) << 56;
    }

    static void setByte(byte[] byArray, int n, int n2) {
        PlatformDependent.putByte((byte[])byArray, (int)n, (byte)((byte)n2));
    }

    static void setShort(byte[] byArray, int n, int n2) {
        if (UNALIGNED) {
            PlatformDependent.putShort((byte[])byArray, (int)n, (short)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? (short)n2 : Short.reverseBytes((short)n2)));
        } else {
            PlatformDependent.putByte((byte[])byArray, (int)n, (byte)((byte)(n2 >>> 8)));
            PlatformDependent.putByte((byte[])byArray, (int)(n + 1), (byte)((byte)n2));
        }
    }

    static void setShortLE(byte[] byArray, int n, int n2) {
        if (UNALIGNED) {
            PlatformDependent.putShort((byte[])byArray, (int)n, (short)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes((short)n2) : (short)n2));
        } else {
            PlatformDependent.putByte((byte[])byArray, (int)n, (byte)((byte)n2));
            PlatformDependent.putByte((byte[])byArray, (int)(n + 1), (byte)((byte)(n2 >>> 8)));
        }
    }

    static void setMedium(byte[] byArray, int n, int n2) {
        PlatformDependent.putByte((byte[])byArray, (int)n, (byte)((byte)(n2 >>> 16)));
        if (UNALIGNED) {
            PlatformDependent.putShort((byte[])byArray, (int)(n + 1), (short)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? (short)n2 : Short.reverseBytes((short)n2)));
        } else {
            PlatformDependent.putByte((byte[])byArray, (int)(n + 1), (byte)((byte)(n2 >>> 8)));
            PlatformDependent.putByte((byte[])byArray, (int)(n + 2), (byte)((byte)n2));
        }
    }

    static void setMediumLE(byte[] byArray, int n, int n2) {
        PlatformDependent.putByte((byte[])byArray, (int)n, (byte)((byte)n2));
        if (UNALIGNED) {
            PlatformDependent.putShort((byte[])byArray, (int)(n + 1), (short)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes((short)(n2 >>> 8)) : (short)(n2 >>> 8)));
        } else {
            PlatformDependent.putByte((byte[])byArray, (int)(n + 1), (byte)((byte)(n2 >>> 8)));
            PlatformDependent.putByte((byte[])byArray, (int)(n + 2), (byte)((byte)(n2 >>> 16)));
        }
    }

    static void setInt(byte[] byArray, int n, int n2) {
        if (UNALIGNED) {
            PlatformDependent.putInt((byte[])byArray, (int)n, (int)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? n2 : Integer.reverseBytes(n2)));
        } else {
            PlatformDependent.putByte((byte[])byArray, (int)n, (byte)((byte)(n2 >>> 24)));
            PlatformDependent.putByte((byte[])byArray, (int)(n + 1), (byte)((byte)(n2 >>> 16)));
            PlatformDependent.putByte((byte[])byArray, (int)(n + 2), (byte)((byte)(n2 >>> 8)));
            PlatformDependent.putByte((byte[])byArray, (int)(n + 3), (byte)((byte)n2));
        }
    }

    static void setIntLE(byte[] byArray, int n, int n2) {
        if (UNALIGNED) {
            PlatformDependent.putInt((byte[])byArray, (int)n, (int)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Integer.reverseBytes(n2) : n2));
        } else {
            PlatformDependent.putByte((byte[])byArray, (int)n, (byte)((byte)n2));
            PlatformDependent.putByte((byte[])byArray, (int)(n + 1), (byte)((byte)(n2 >>> 8)));
            PlatformDependent.putByte((byte[])byArray, (int)(n + 2), (byte)((byte)(n2 >>> 16)));
            PlatformDependent.putByte((byte[])byArray, (int)(n + 3), (byte)((byte)(n2 >>> 24)));
        }
    }

    static void setLong(byte[] byArray, int n, long l) {
        if (UNALIGNED) {
            PlatformDependent.putLong((byte[])byArray, (int)n, (long)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? l : Long.reverseBytes(l)));
        } else {
            PlatformDependent.putByte((byte[])byArray, (int)n, (byte)((byte)(l >>> 56)));
            PlatformDependent.putByte((byte[])byArray, (int)(n + 1), (byte)((byte)(l >>> 48)));
            PlatformDependent.putByte((byte[])byArray, (int)(n + 2), (byte)((byte)(l >>> 40)));
            PlatformDependent.putByte((byte[])byArray, (int)(n + 3), (byte)((byte)(l >>> 32)));
            PlatformDependent.putByte((byte[])byArray, (int)(n + 4), (byte)((byte)(l >>> 24)));
            PlatformDependent.putByte((byte[])byArray, (int)(n + 5), (byte)((byte)(l >>> 16)));
            PlatformDependent.putByte((byte[])byArray, (int)(n + 6), (byte)((byte)(l >>> 8)));
            PlatformDependent.putByte((byte[])byArray, (int)(n + 7), (byte)((byte)l));
        }
    }

    static void setLongLE(byte[] byArray, int n, long l) {
        if (UNALIGNED) {
            PlatformDependent.putLong((byte[])byArray, (int)n, (long)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Long.reverseBytes(l) : l));
        } else {
            PlatformDependent.putByte((byte[])byArray, (int)n, (byte)((byte)l));
            PlatformDependent.putByte((byte[])byArray, (int)(n + 1), (byte)((byte)(l >>> 8)));
            PlatformDependent.putByte((byte[])byArray, (int)(n + 2), (byte)((byte)(l >>> 16)));
            PlatformDependent.putByte((byte[])byArray, (int)(n + 3), (byte)((byte)(l >>> 24)));
            PlatformDependent.putByte((byte[])byArray, (int)(n + 4), (byte)((byte)(l >>> 32)));
            PlatformDependent.putByte((byte[])byArray, (int)(n + 5), (byte)((byte)(l >>> 40)));
            PlatformDependent.putByte((byte[])byArray, (int)(n + 6), (byte)((byte)(l >>> 48)));
            PlatformDependent.putByte((byte[])byArray, (int)(n + 7), (byte)((byte)(l >>> 56)));
        }
    }

    private static void batchSetZero(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = n2 / 8;
        for (n3 = 0; n3 < n4; ++n3) {
            PlatformDependent.putLong((byte[])byArray, (int)n, (long)0L);
            n += 8;
        }
        n3 = n2 % 8;
        for (int i = 0; i < n3; ++i) {
            PlatformDependent.putByte((byte[])byArray, (int)(n + i), (byte)0);
        }
    }

    static void setZero(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (UNALIGNED && n2 <= 64) {
            UnsafeByteBufUtil.batchSetZero(byArray, n, n2);
        } else {
            PlatformDependent.setMemory((byte[])byArray, (int)n, (long)n2, (byte)0);
        }
    }

    static ByteBuf copy(AbstractByteBuf abstractByteBuf, long l, int n, int n2) {
        abstractByteBuf.checkIndex(n, n2);
        ByteBuf byteBuf = abstractByteBuf.alloc().directBuffer(n2, abstractByteBuf.maxCapacity());
        if (n2 != 0) {
            if (byteBuf.hasMemoryAddress()) {
                PlatformDependent.copyMemory((long)l, (long)byteBuf.memoryAddress(), (long)n2);
                byteBuf.setIndex(0, n2);
            } else {
                byteBuf.writeBytes(abstractByteBuf, n, n2);
            }
        }
        return byteBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int setBytes(AbstractByteBuf abstractByteBuf, long l, int n, InputStream inputStream, int n2) {
        abstractByteBuf.checkIndex(n, n2);
        ByteBuf byteBuf = abstractByteBuf.alloc().heapBuffer(n2);
        try {
            byte[] byArray = byteBuf.array();
            int n3 = byteBuf.arrayOffset();
            int n4 = inputStream.read(byArray, n3, n2);
            if (n4 > 0) {
                PlatformDependent.copyMemory((byte[])byArray, (int)n3, (long)l, (long)n4);
            }
            int n5 = n4;
            return n5;
        }
        finally {
            byteBuf.release();
        }
    }

    static void getBytes(AbstractByteBuf abstractByteBuf, long l, int n, ByteBuf byteBuf, int n2, int n3) {
        abstractByteBuf.checkIndex(n, n3);
        ObjectUtil.checkNotNull((Object)byteBuf, (String)"dst");
        if (MathUtil.isOutOfBounds((int)n2, (int)n3, (int)byteBuf.capacity())) {
            throw new IndexOutOfBoundsException("dstIndex: " + n2);
        }
        if (byteBuf.hasMemoryAddress()) {
            PlatformDependent.copyMemory((long)l, (long)(byteBuf.memoryAddress() + (long)n2), (long)n3);
        } else if (byteBuf.hasArray()) {
            PlatformDependent.copyMemory((long)l, (byte[])byteBuf.array(), (int)(byteBuf.arrayOffset() + n2), (long)n3);
        } else {
            byteBuf.setBytes(n2, abstractByteBuf, n, n3);
        }
    }

    static void getBytes(AbstractByteBuf abstractByteBuf, long l, int n, byte[] byArray, int n2, int n3) {
        abstractByteBuf.checkIndex(n, n3);
        ObjectUtil.checkNotNull((Object)byArray, (String)"dst");
        if (MathUtil.isOutOfBounds((int)n2, (int)n3, (int)byArray.length)) {
            throw new IndexOutOfBoundsException("dstIndex: " + n2);
        }
        if (n3 != 0) {
            PlatformDependent.copyMemory((long)l, (byte[])byArray, (int)n2, (long)n3);
        }
    }

    static void getBytes(AbstractByteBuf abstractByteBuf, long l, int n, ByteBuffer byteBuffer) {
        abstractByteBuf.checkIndex(n, byteBuffer.remaining());
        if (byteBuffer.remaining() == 0) {
            return;
        }
        if (byteBuffer.isDirect()) {
            if (byteBuffer.isReadOnly()) {
                throw new ReadOnlyBufferException();
            }
            long l2 = PlatformDependent.directBufferAddress((ByteBuffer)byteBuffer);
            PlatformDependent.copyMemory((long)l, (long)(l2 + (long)byteBuffer.position()), (long)byteBuffer.remaining());
            byteBuffer.position(byteBuffer.position() + byteBuffer.remaining());
        } else if (byteBuffer.hasArray()) {
            PlatformDependent.copyMemory((long)l, (byte[])byteBuffer.array(), (int)(byteBuffer.arrayOffset() + byteBuffer.position()), (long)byteBuffer.remaining());
            byteBuffer.position(byteBuffer.position() + byteBuffer.remaining());
        } else {
            byteBuffer.put(abstractByteBuf.nioBuffer());
        }
    }

    static void setBytes(AbstractByteBuf abstractByteBuf, long l, int n, ByteBuf byteBuf, int n2, int n3) {
        abstractByteBuf.checkIndex(n, n3);
        ObjectUtil.checkNotNull((Object)byteBuf, (String)"src");
        if (MathUtil.isOutOfBounds((int)n2, (int)n3, (int)byteBuf.capacity())) {
            throw new IndexOutOfBoundsException("srcIndex: " + n2);
        }
        if (n3 != 0) {
            if (byteBuf.hasMemoryAddress()) {
                PlatformDependent.copyMemory((long)(byteBuf.memoryAddress() + (long)n2), (long)l, (long)n3);
            } else if (byteBuf.hasArray()) {
                PlatformDependent.copyMemory((byte[])byteBuf.array(), (int)(byteBuf.arrayOffset() + n2), (long)l, (long)n3);
            } else {
                byteBuf.getBytes(n2, abstractByteBuf, n, n3);
            }
        }
    }

    static void setBytes(AbstractByteBuf abstractByteBuf, long l, int n, byte[] byArray, int n2, int n3) {
        abstractByteBuf.checkIndex(n, n3);
        ObjectUtil.checkNotNull((Object)byArray, (String)"src");
        if (MathUtil.isOutOfBounds((int)n2, (int)n3, (int)byArray.length)) {
            throw new IndexOutOfBoundsException("srcIndex: " + n2);
        }
        if (n3 != 0) {
            PlatformDependent.copyMemory((byte[])byArray, (int)n2, (long)l, (long)n3);
        }
    }

    static void setBytes(AbstractByteBuf abstractByteBuf, long l, int n, ByteBuffer byteBuffer) {
        int n2 = byteBuffer.remaining();
        if (n2 == 0) {
            return;
        }
        if (byteBuffer.isDirect()) {
            abstractByteBuf.checkIndex(n, n2);
            long l2 = PlatformDependent.directBufferAddress((ByteBuffer)byteBuffer);
            PlatformDependent.copyMemory((long)(l2 + (long)byteBuffer.position()), (long)l, (long)n2);
            byteBuffer.position(byteBuffer.position() + n2);
        } else if (byteBuffer.hasArray()) {
            abstractByteBuf.checkIndex(n, n2);
            PlatformDependent.copyMemory((byte[])byteBuffer.array(), (int)(byteBuffer.arrayOffset() + byteBuffer.position()), (long)l, (long)n2);
            byteBuffer.position(byteBuffer.position() + n2);
        } else if (n2 < 8) {
            UnsafeByteBufUtil.setSingleBytes(abstractByteBuf, l, n, byteBuffer, n2);
        } else {
            assert (abstractByteBuf.nioBufferCount() == 1);
            ByteBuffer byteBuffer2 = abstractByteBuf.internalNioBuffer(n, n2);
            byteBuffer2.put(byteBuffer);
        }
    }

    private static void setSingleBytes(AbstractByteBuf abstractByteBuf, long l, int n, ByteBuffer byteBuffer, int n2) {
        abstractByteBuf.checkIndex(n, n2);
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.limit();
        long l2 = l;
        for (int i = n3; i < n4; ++i) {
            byte by = byteBuffer.get(i);
            PlatformDependent.putByte((long)l2, (byte)by);
            ++l2;
        }
        byteBuffer.position(n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void getBytes(AbstractByteBuf abstractByteBuf, long l, int n, OutputStream outputStream, int n2) {
        abstractByteBuf.checkIndex(n, n2);
        if (n2 != 0) {
            int n3 = Math.min(n2, 8192);
            if (n3 <= 1024 || !abstractByteBuf.alloc().isDirectBufferPooled()) {
                UnsafeByteBufUtil.getBytes(l, ByteBufUtil.threadLocalTempArray(n3), 0, n3, outputStream, n2);
            } else {
                ByteBuf byteBuf = abstractByteBuf.alloc().heapBuffer(n3);
                try {
                    byte[] byArray = byteBuf.array();
                    int n4 = byteBuf.arrayOffset();
                    UnsafeByteBufUtil.getBytes(l, byArray, n4, n3, outputStream, n2);
                }
                finally {
                    byteBuf.release();
                }
            }
        }
    }

    private static void getBytes(long l, byte[] byArray, int n, int n2, OutputStream outputStream, int n3) {
        int n4;
        do {
            n4 = Math.min(n2, n3);
            PlatformDependent.copyMemory((long)l, (byte[])byArray, (int)n, (long)n4);
            outputStream.write(byArray, n, n4);
            l += (long)n4;
        } while ((n3 -= n4) > 0);
    }

    private static void batchSetZero(long l, int n) {
        int n2;
        int n3 = n / 8;
        for (n2 = 0; n2 < n3; ++n2) {
            PlatformDependent.putLong((long)l, (long)0L);
            l += 8L;
        }
        n2 = n % 8;
        for (int i = 0; i < n2; ++i) {
            PlatformDependent.putByte((long)(l + (long)i), (byte)0);
        }
    }

    static void setZero(long l, int n) {
        if (n == 0) {
            return;
        }
        if (n <= 64) {
            if (!UNALIGNED) {
                int n2 = UnsafeByteBufUtil.zeroTillAligned(l, n);
                l += (long)n2;
                if ((n -= n2) == 0) {
                    return;
                }
                assert (l % 8L == 0L);
            }
            UnsafeByteBufUtil.batchSetZero(l, n);
        } else {
            PlatformDependent.setMemory((long)l, (long)n, (byte)0);
        }
    }

    private static int zeroTillAligned(long l, int n) {
        int n2 = Math.min((int)(l % 8L), n);
        for (int i = 0; i < n2; ++i) {
            PlatformDependent.putByte((long)(l + (long)i), (byte)0);
        }
        return n2;
    }

    static UnpooledUnsafeDirectByteBuf newUnsafeDirectByteBuf(ByteBufAllocator byteBufAllocator, int n, int n2) {
        if (PlatformDependent.useDirectBufferNoCleaner()) {
            return new UnpooledUnsafeNoCleanerDirectByteBuf(byteBufAllocator, n, n2);
        }
        return new UnpooledUnsafeDirectByteBuf(byteBufAllocator, n, n2);
    }

    private UnsafeByteBufUtil() {
    }
}

