/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.core;

import java.sql.SQLException;
import org.sqlite.core.DB;

public class SafeStmtPtr {
    private final DB db;
    private final long ptr;
    private volatile boolean closed = false;
    private int closedRC;
    private SQLException closeException;

    public SafeStmtPtr(DB dB, long l) {
        this.db = dB;
        this.ptr = l;
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int close() {
        DB dB = this.db;
        synchronized (dB) {
            return this.internalClose();
        }
    }

    private int internalClose() {
        try {
            if (this.closed) {
                if (this.closeException != null) {
                    throw this.closeException;
                }
                int n = this.closedRC;
                return n;
            }
            int n = this.closedRC = this.db.finalize(this, this.ptr);
            return n;
        }
        catch (SQLException sQLException) {
            this.closeException = sQLException;
            throw sQLException;
        }
        finally {
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Throwable> int safeRunInt(SafePtrIntFunction<E> safePtrIntFunction) {
        DB dB = this.db;
        synchronized (dB) {
            this.ensureOpen();
            return safePtrIntFunction.run(this.db, this.ptr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Throwable> long safeRunLong(SafePtrLongFunction<E> safePtrLongFunction) {
        DB dB = this.db;
        synchronized (dB) {
            this.ensureOpen();
            return safePtrLongFunction.run(this.db, this.ptr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Throwable> double safeRunDouble(SafePtrDoubleFunction<E> safePtrDoubleFunction) {
        DB dB = this.db;
        synchronized (dB) {
            this.ensureOpen();
            return safePtrDoubleFunction.run(this.db, this.ptr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Throwable> T safeRun(SafePtrFunction<T, E> safePtrFunction) {
        DB dB = this.db;
        synchronized (dB) {
            this.ensureOpen();
            return safePtrFunction.run(this.db, this.ptr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Throwable> void safeRunConsume(SafePtrConsumer<E> safePtrConsumer) {
        DB dB = this.db;
        synchronized (dB) {
            this.ensureOpen();
            safePtrConsumer.run(this.db, this.ptr);
        }
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new SQLException("stmt pointer is closed");
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SafeStmtPtr safeStmtPtr = (SafeStmtPtr)object;
        return this.ptr == safeStmtPtr.ptr;
    }

    public int hashCode() {
        return Long.hashCode(this.ptr);
    }

    @FunctionalInterface
    public static interface SafePtrConsumer<E extends Throwable> {
        public void run(DB var1, long var2);
    }

    @FunctionalInterface
    public static interface SafePtrFunction<T, E extends Throwable> {
        public T run(DB var1, long var2);
    }

    @FunctionalInterface
    public static interface SafePtrDoubleFunction<E extends Throwable> {
        public double run(DB var1, long var2);
    }

    @FunctionalInterface
    public static interface SafePtrLongFunction<E extends Throwable> {
        public long run(DB var1, long var2);
    }

    @FunctionalInterface
    public static interface SafePtrIntFunction<E extends Throwable> {
        public int run(DB var1, long var2);
    }
}

