/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation;

import androidx.compose.animation.BoundsAnimationKt;
import androidx.compose.animation.BoundsTransform;
import androidx.compose.animation.SharedTransitionScope;
import androidx.compose.animation.core.AnimationVector4D;
import androidx.compose.animation.core.FiniteAnimationSpec;
import androidx.compose.animation.core.Transition;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.compose.ui.geometry.Rect;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0001\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u001c\u0010\u0007\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bR\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ,\u0010\u001a\u001a\u00020\u001b2\u001c\u0010\u0007\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bR\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u00103\u001a\u00020\u001b2\u0006\u00104\u001a\u00020\t2\u0006\u00105\u001a\u00020\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012RW\u0010\u0007\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bR\b\u0012\u0004\u0012\u00020\u00060\u00052\u001c\u0010\u0013\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bR\b\u0012\u0004\u0012\u00020\u00060\u00058F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R+\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b \u0010\u0019\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0011\u0010!\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R \u0010#\u001a\b\u0012\u0004\u0012\u00020\t0$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R;\u0010*\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010)2\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010)8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b/\u0010\u0019\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u0013\u00100\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0011\u00106\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b7\u0010\"\u00a8\u0006\u0007"}, d2={"Landroidx/compose/animation/BoundsAnimation;", "", "transitionScope", "Landroidx/compose/animation/SharedTransitionScope;", "transition", "Landroidx/compose/animation/core/Transition;", "", "animation", "Landroidx/compose/animation/core/Transition$DeferredAnimation;", "Landroidx/compose/ui/geometry/Rect;", "Landroidx/compose/animation/core/AnimationVector4D;", "boundsTransform", "Landroidx/compose/animation/BoundsTransform;", "<init>", "(Landroidx/compose/animation/SharedTransitionScope;Landroidx/compose/animation/core/Transition;Landroidx/compose/animation/core/Transition$DeferredAnimation;Landroidx/compose/animation/BoundsTransform;)V", "getTransitionScope", "()Landroidx/compose/animation/SharedTransitionScope;", "getTransition", "()Landroidx/compose/animation/core/Transition;", "<set-?>", "getAnimation", "()Landroidx/compose/animation/core/Transition$DeferredAnimation;", "setAnimation", "(Landroidx/compose/animation/core/Transition$DeferredAnimation;)V", "animation$delegate", "Landroidx/compose/runtime/MutableState;", "updateAnimation", "", "getBoundsTransform", "()Landroidx/compose/animation/BoundsTransform;", "setBoundsTransform", "(Landroidx/compose/animation/BoundsTransform;)V", "boundsTransform$delegate", "isRunning", "()Z", "animationSpec", "Landroidx/compose/animation/core/FiniteAnimationSpec;", "getAnimationSpec", "()Landroidx/compose/animation/core/FiniteAnimationSpec;", "setAnimationSpec", "(Landroidx/compose/animation/core/FiniteAnimationSpec;)V", "Landroidx/compose/runtime/State;", "animationState", "getAnimationState", "()Landroidx/compose/runtime/State;", "setAnimationState", "(Landroidx/compose/runtime/State;)V", "animationState$delegate", "value", "getValue", "()Landroidx/compose/ui/geometry/Rect;", "animate", "currentBounds", "targetBounds", "target", "getTarget"})
public final class BoundsAnimation {
    private final SharedTransitionScope transitionScope;
    private final Transition<Boolean> transition;
    private final MutableState animation$delegate;
    private final MutableState boundsTransform$delegate;
    private FiniteAnimationSpec<Rect> animationSpec;
    private final MutableState animationState$delegate;
    public static final int $stable = 8;

    public BoundsAnimation(SharedTransitionScope sharedTransitionScope, Transition<Boolean> transition, Transition.DeferredAnimation<Rect, AnimationVector4D> deferredAnimation, BoundsTransform boundsTransform) {
        Intrinsics.checkNotNullParameter((Object)sharedTransitionScope, (String)"");
        Intrinsics.checkNotNullParameter(transition, (String)"");
        Intrinsics.checkNotNullParameter(deferredAnimation, (String)"");
        Intrinsics.checkNotNullParameter((Object)boundsTransform, (String)"");
        this.transitionScope = sharedTransitionScope;
        this.transition = transition;
        this.animation$delegate = SnapshotStateKt.mutableStateOf$default(deferredAnimation, null, (int)2, null);
        this.boundsTransform$delegate = SnapshotStateKt.mutableStateOf$default((Object)boundsTransform, null, (int)2, null);
        this.animationSpec = (FiniteAnimationSpec)BoundsAnimationKt.access$getDefaultBoundsAnimation$p();
        this.animationState$delegate = SnapshotStateKt.mutableStateOf$default(null, null, (int)2, null);
    }

    public final SharedTransitionScope getTransitionScope() {
        return this.transitionScope;
    }

    public final Transition<Boolean> getTransition() {
        return this.transition;
    }

    public final Transition.DeferredAnimation<Rect, AnimationVector4D> getAnimation() {
        State state = (State)this.animation$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Transition.DeferredAnimation)state.getValue();
    }

    private final void setAnimation(Transition.DeferredAnimation<Rect, AnimationVector4D> deferredAnimation) {
        MutableState mutableState = this.animation$delegate;
        Object var3_3 = null;
        boolean bl = false;
        mutableState.setValue(deferredAnimation);
    }

    public final void updateAnimation(Transition.DeferredAnimation<Rect, AnimationVector4D> deferredAnimation, BoundsTransform boundsTransform) {
        Intrinsics.checkNotNullParameter(deferredAnimation, (String)"");
        Intrinsics.checkNotNullParameter((Object)boundsTransform, (String)"");
        if (!Intrinsics.areEqual(this.getAnimation(), deferredAnimation)) {
            this.setAnimation(deferredAnimation);
            this.setAnimationState(null);
            this.animationSpec = (FiniteAnimationSpec)BoundsAnimationKt.access$getDefaultBoundsAnimation$p();
        }
        this.setBoundsTransform(boundsTransform);
    }

    private final BoundsTransform getBoundsTransform() {
        State state = (State)this.boundsTransform$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (BoundsTransform)state.getValue();
    }

    private final void setBoundsTransform(BoundsTransform boundsTransform) {
        MutableState mutableState = this.boundsTransform$delegate;
        Object var3_3 = null;
        boolean bl = false;
        mutableState.setValue((Object)boundsTransform);
    }

    public final boolean isRunning() {
        Transition transition = this.transition;
        while (transition.getParentTransition() != null) {
            Intrinsics.checkNotNull((Object)transition.getParentTransition());
        }
        return !Intrinsics.areEqual((Object)transition.getCurrentState(), (Object)transition.getTargetState());
    }

    public final FiniteAnimationSpec<Rect> getAnimationSpec() {
        return this.animationSpec;
    }

    public final void setAnimationSpec(FiniteAnimationSpec<Rect> finiteAnimationSpec) {
        Intrinsics.checkNotNullParameter(finiteAnimationSpec, (String)"");
        this.animationSpec = finiteAnimationSpec;
    }

    public final State<Rect> getAnimationState() {
        State state = (State)this.animationState$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (State)state.getValue();
    }

    public final void setAnimationState(State<Rect> state) {
        MutableState mutableState = this.animationState$delegate;
        Object var3_3 = null;
        boolean bl = false;
        mutableState.setValue(state);
    }

    public final Rect getValue() {
        Object object;
        if (this.transitionScope.isTransitionActive()) {
            State<Rect> state = this.getAnimationState();
            object = state != null ? (Rect)state.getValue() : null;
        } else {
            object = null;
        }
        return object;
    }

    public final void animate(Rect rect, Rect rect2) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"");
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"");
        if (this.transitionScope.isTransitionActive()) {
            if (this.getAnimationState() == null) {
                this.animationSpec = this.getBoundsTransform().transform(rect, rect2);
            }
            this.setAnimationState((State<Rect>)this.getAnimation().animate(arg_0 -> BoundsAnimation.animate$lambda$0(this, arg_0), arg_0 -> BoundsAnimation.animate$lambda$1(this, rect2, rect, arg_0)));
        }
    }

    public final boolean getTarget() {
        return (Boolean)this.transition.getTargetState();
    }

    private static final FiniteAnimationSpec animate$lambda$0(BoundsAnimation boundsAnimation, Transition.Segment segment) {
        Intrinsics.checkNotNullParameter((Object)segment, (String)"");
        return boundsAnimation.animationSpec;
    }

    private static final Rect animate$lambda$1(BoundsAnimation boundsAnimation, Rect rect, Rect rect2, boolean bl) {
        return bl == (Boolean)boundsAnimation.transition.getTargetState() ? rect : rect2;
    }
}

