/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.util;

import dorkbox.os.OS;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.Tray;
import dorkbox.systemTray.gnomeShell.AppIndicatorExtension;
import dorkbox.systemTray.gnomeShell.DummyFile;
import dorkbox.systemTray.gnomeShell.LegacyExtension;
import dorkbox.systemTray.gnomeShell.TrayIconsReloadedIndicatorExtension;
import dorkbox.systemTray.ui.awt._AwtTray;
import dorkbox.systemTray.ui.gtk._AppIndicatorNativeTray;
import dorkbox.systemTray.ui.gtk._GtkStatusIconNativeTray;
import dorkbox.systemTray.ui.osx._OsxAwtTray;
import dorkbox.systemTray.ui.swing._SwingTray;
import dorkbox.systemTray.ui.swing._WindowsNativeTray;
import dorkbox.systemTray.util.EventDispatch;
import dorkbox.util.FileUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class AutoDetectTrayType {
    private static final Map<String, SystemTray> traySingletons = new HashMap<String, SystemTray>();

    public static Class<? extends Tray> selectType(SystemTray.TrayType trayType) {
        if (trayType == SystemTray.TrayType.Gtk) {
            return _GtkStatusIconNativeTray.class;
        }
        if (trayType == SystemTray.TrayType.AppIndicator) {
            return _AppIndicatorNativeTray.class;
        }
        if (trayType == SystemTray.TrayType.WindowsNative) {
            return _WindowsNativeTray.class;
        }
        if (trayType == SystemTray.TrayType.Swing) {
            return _SwingTray.class;
        }
        if (trayType == SystemTray.TrayType.Osx) {
            return _OsxAwtTray.class;
        }
        if (trayType == SystemTray.TrayType.Awt) {
            return _AwtTray.class;
        }
        return null;
    }

    public static SystemTray.TrayType fromClass(Class<? extends Tray> clazz) {
        if (clazz == _GtkStatusIconNativeTray.class) {
            return SystemTray.TrayType.Gtk;
        }
        if (clazz == _AppIndicatorNativeTray.class) {
            return SystemTray.TrayType.AppIndicator;
        }
        if (clazz == _WindowsNativeTray.class) {
            return SystemTray.TrayType.WindowsNative;
        }
        if (clazz == _SwingTray.class) {
            return SystemTray.TrayType.Swing;
        }
        if (clazz == _OsxAwtTray.class) {
            return SystemTray.TrayType.Osx;
        }
        if (clazz == _AwtTray.class) {
            return SystemTray.TrayType.Awt;
        }
        return null;
    }

    public static SystemTray.TrayType get(String string) {
        if (OS.INSTANCE.isWindows()) {
            return SystemTray.TrayType.WindowsNative;
        }
        if (OS.INSTANCE.isMacOsX()) {
            return SystemTray.TrayType.Osx;
        }
        if (OS.INSTANCE.isLinux() || OS.INSTANCE.isUnix()) {
            block52: {
                OS.DesktopEnv.Env env = OS.DesktopEnv.INSTANCE.getEnv();
                if (SystemTray.DEBUG) {
                    SystemTray.logger.debug("Currently using the '{}' desktop environment" + OS.INSTANCE.getLINE_SEPARATOR() + OS.Linux.INSTANCE.getInfo(), (Object)env);
                }
                switch (env) {
                    case Gnome: {
                        String string2 = System.getenv("GDMSESSION");
                        if (string2 == null) {
                            if (SystemTray.DEBUG) {
                                SystemTray.logger.debug("GDMSESSION value is not set by OS. Checking '/etc/os-release' for more info.");
                            }
                            if (OS.Linux.INSTANCE.isPop()) {
                                string2 = "ubuntu";
                                if (SystemTray.DEBUG) {
                                    SystemTray.logger.debug("Detected popOS! Using 'ubuntu' for that configuration.");
                                }
                            }
                        }
                        if (SystemTray.DEBUG) {
                            SystemTray.logger.debug("Currently using the '{}' session type", (Object)string2);
                        }
                        if ("gnome".equalsIgnoreCase(string2) || "default".equalsIgnoreCase(string2)) {
                            if (OS.Linux.INSTANCE.isUbuntu()) {
                                return SystemTray.TrayType.Gtk;
                            }
                            String string3 = OS.DesktopEnv.INSTANCE.getGnomeVersion();
                            if (string3 == null) {
                                SystemTray.logger.error("GNOME shell detected, but UNDEFINED shell version. This should never happen. Falling back to GtkStatusIcon. Please create an issue with as many details as possible.");
                                return SystemTray.TrayType.Gtk;
                            }
                            if (SystemTray.DEBUG) {
                                SystemTray.logger.debug("Gnome Version: {}", (Object)string3);
                            }
                            int n = 0;
                            double d = 0.0;
                            String[] stringArray = string3.split("\\.", 2);
                            try {
                                n = Integer.parseInt(stringArray[0]);
                                d = Double.parseDouble(stringArray[1]);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (n == 2) {
                                return SystemTray.TrayType.Gtk;
                            }
                            if (n == 3) {
                                if (d < 16.0) {
                                    SystemTray.logger.warn("SystemTray works, but will only show via SUPER+M.");
                                    return SystemTray.TrayType.Gtk;
                                }
                                if (d < 26.0) {
                                    Tray.gtkGnomeWorkaround = true;
                                    LegacyExtension.install(string);
                                    return SystemTray.TrayType.Gtk;
                                }
                                if (!AppIndicatorExtension.isInstalled()) {
                                    AppIndicatorExtension.install();
                                    SystemTray.logger.error("You must log out and then in again for system tray settings to apply.");
                                    return null;
                                }
                                return SystemTray.TrayType.AppIndicator;
                            }
                            if (n >= 40) {
                                if (AppIndicatorExtension.isInstalled()) {
                                    AppIndicatorExtension.unInstall();
                                }
                                if (!TrayIconsReloadedIndicatorExtension.isInstalled()) {
                                    TrayIconsReloadedIndicatorExtension.install();
                                }
                                return SystemTray.TrayType.Gtk;
                            }
                            SystemTray.logger.error("GNOME shell detected, but UNSUPPORTED shell version (" + string3 + "). Falling back to GtkStatusIcon. Please create an issue with as many details as possible.");
                            return SystemTray.TrayType.Gtk;
                        }
                        if ("cinnamon".equalsIgnoreCase(string2)) {
                            return SystemTray.TrayType.Gtk;
                        }
                        if ("gnome-classic".equalsIgnoreCase(string2)) {
                            return SystemTray.TrayType.Gtk;
                        }
                        if ("gnome-fallback".equalsIgnoreCase(string2)) {
                            return SystemTray.TrayType.Gtk;
                        }
                        if ("awesome".equalsIgnoreCase(string2)) {
                            return SystemTray.TrayType.Gtk;
                        }
                        if ("ubuntu".equalsIgnoreCase(string2)) {
                            int[] nArray = OS.Linux.INSTANCE.getUbuntuVersion();
                            if (nArray[0] == 17 && nArray[1] == 10) {
                                Tray.gtkGnomeWorkaround = true;
                                LegacyExtension.install(string);
                            } else if (nArray[0] >= 18) {
                                DummyFile.install();
                            }
                            return SystemTray.TrayType.AppIndicator;
                        }
                        SystemTray.logger.error("GNOME shell detected, but UNKNOWN type. This should never happen. Falling back to GtkStatusIcon. Please create an issue with as many details as possible.");
                        return SystemTray.TrayType.Gtk;
                    }
                    case KDE: {
                        String string4 = OS.DesktopEnv.INSTANCE.getPlasmaVersionFull();
                        if (SystemTray.DEBUG) {
                            SystemTray.logger.debug("KDE Plasma Version: {}", (Object)string4);
                        }
                        if (string4 == null) {
                            SystemTray.logger.error("KDE Plasma detected, but UNDEFINED shell version. This should never happen. Falling back to GtkStatusIcon. Please create an issue with as many details as possible.");
                            return SystemTray.TrayType.Gtk;
                        }
                        String[] stringArray = string4.split("\\.");
                        int n = Integer.parseInt(stringArray[0]);
                        int n2 = Integer.parseInt(stringArray[1]);
                        if (n < 5 || n == 5 && n2 < 5) {
                            return SystemTray.TrayType.Gtk;
                        }
                        return SystemTray.TrayType.AppIndicator;
                    }
                    case Unity: {
                        return SystemTray.TrayType.AppIndicator;
                    }
                    case Unity7: {
                        return SystemTray.TrayType.AppIndicator;
                    }
                    case XFCE: {
                        return SystemTray.TrayType.Gtk;
                    }
                    case LXDE: {
                        return SystemTray.TrayType.Gtk;
                    }
                    case MATE: {
                        return SystemTray.TrayType.Gtk;
                    }
                    case Pantheon: {
                        return SystemTray.TrayType.AppIndicator;
                    }
                    case ChromeOS: {
                        return null;
                    }
                }
                Object var2_4 = null;
                try {
                    File file = new File("/proc");
                    File[] fileArray = file.listFiles();
                    if (fileArray != null) {
                        for (File file2 : fileArray) {
                            String string5;
                            File file3;
                            String string6 = file2.getName();
                            if (!Character.isDigit(string6.charAt(0)) || !(file3 = new File(file2, "status")).canRead() || (string5 = FileUtil.INSTANCE.readFirstLine(file3)) == null || !string5.contains("indicator-app")) continue;
                            return SystemTray.TrayType.AppIndicator;
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (!SystemTray.DEBUG) break block52;
                    SystemTray.logger.error("Error detecting appindicator status", throwable);
                }
            }
            if (OS.INSTANCE.isLinux()) {
                if (OS.Linux.INSTANCE.isUbuntu()) {
                    return SystemTray.TrayType.AppIndicator;
                }
                if (OS.Linux.INSTANCE.isFedora()) {
                    return SystemTray.TrayType.Gtk;
                }
                return SystemTray.TrayType.AppIndicator;
            }
        }
        throw new RuntimeException("This OS is not supported. Please create an issue with the details from `SystemTray.DEBUG=true;`");
    }

    public static Runnable getShutdownHook(String string) {
        return () -> {
            Map<String, SystemTray> map = traySingletons;
            synchronized (map) {
                if (traySingletons.containsKey(string)) {
                    EventDispatch.runLater(() -> {
                        Map<String, SystemTray> map = traySingletons;
                        synchronized (map) {
                            SystemTray systemTray = traySingletons.remove(string);
                            if (systemTray != null) {
                                systemTray.shutdown();
                            }
                        }
                    });
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInstance(String string, SystemTray systemTray) {
        Map<String, SystemTray> map = traySingletons;
        synchronized (map) {
            traySingletons.put(string, systemTray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSystemTrayHook(String string) {
        Map<String, SystemTray> map = traySingletons;
        synchronized (map) {
            traySingletons.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasOtherTrays() {
        Map<String, SystemTray> map = traySingletons;
        synchronized (map) {
            return !traySingletons.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SystemTray getInstance(String string) {
        Map<String, SystemTray> map = traySingletons;
        synchronized (map) {
            return traySingletons.get(string);
        }
    }
}

