/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements.jdbc;

import java.math.BigDecimal;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ForeignKeyConstraint;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.OpKt;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.SchemaUtils;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.api.ExposedDatabaseMetadata;
import org.jetbrains.exposed.sql.statements.api.IdentifierManagerApi;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcDatabaseMetadataImpl;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcDatabaseMetadataImplKt;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcIdentifierManager;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.ColumnMetadata;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.H2Kt;
import org.jetbrains.exposed.sql.vendors.MariaDBDialect;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.OracleDialect;
import org.jetbrains.exposed.sql.vendors.PostgreSQLDialect;
import org.jetbrains.exposed.sql.vendors.PrimaryKeyMetadata;
import org.jetbrains.exposed.sql.vendors.SQLServerDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;
import org.jetbrains.exposed.sql.vendors.SchemaMetadata;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 e2\u00020\u0001:\u0002deB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010C\u001a\u00020DH\u0016J3\u0010E\u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020F0\u001f082\u0012\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0H\"\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010IJ3\u0010J\u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f082\u0012\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0H\"\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010IJ/\u0010K\u001a\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0006\u0012\u0004\u0018\u00010L082\u0012\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0H\"\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010IJ-\u0010M\u001a\b\u0012\u0004\u0012\u0002HO0N\"\u0004\b\u0000\u0010O2\u0017\u0010P\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002HO0Q\u00a2\u0006\u0002\bRH\u0002J\b\u0010S\u001a\u00020DH\u0016J\u0010\u0010T\u001a\u00020\u00032\u0006\u0010U\u001a\u00020\u0003H\u0002J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00030\u001fH\u0002J\u000e\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00030\u001fH\u0016J\u001c\u0010W\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030X2\u0006\u0010Y\u001a\u00020\u001eH\u0002J(\u0010Z\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020[0\u001f082\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001fH\u0016J$\u0010\\\u001a\u00020]2\u001a\u0010^\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001f\u0018\u000108H\u0016J\u0016\u0010_\u001a\b\u0012\u0004\u0012\u00020\u00030\u001f2\u0006\u0010`\u001a\u00020\u0003H\u0002J\f\u0010a\u001a\u00020F*\u00020bH\u0002J\u0012\u0010c\u001a\b\u0012\u0004\u0012\u00020F0\u001f*\u00020bH\u0002R\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00038BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u00038VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\tR\u001b\u0010\u000e\u001a\u00020\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000f\u0010\tR\u0014\u0010\u0012\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\tR\u001b\u0010\u0014\u001a\u00020\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0011\u001a\u0004\b\u0015\u0010\tR\u001b\u0010\u0017\u001a\u00020\u00188VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0011\u001a\u0004\b\u0019\u0010\u001aR6\u0010\u001c\u001a*\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001dj\u0014\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f`!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\"\u001a\u00020#8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u0011\u001a\u0004\b$\u0010%R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00030\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u001b\u0010,\u001a\u00020-8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u0010\u0011\u001a\u0004\b.\u0010/R\u001b\u00101\u001a\u00020-8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b3\u0010\u0011\u001a\u0004\b2\u0010/R\u001b\u00104\u001a\u00020-8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b6\u0010\u0011\u001a\u0004\b5\u0010/R&\u00107\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001f088VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u001b\u0010;\u001a\u00020\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b=\u0010\u0011\u001a\u0004\b<\u0010\tR\u001b\u0010>\u001a\u00020?8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bB\u0010\u0011\u001a\u0004\b@\u0010A\u00a8\u0006f"}, d2={"Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl;", "Lorg/jetbrains/exposed/sql/statements/api/ExposedDatabaseMetadata;", "database", "", "metadata", "Ljava/sql/DatabaseMetaData;", "(Ljava/lang/String;Ljava/sql/DatabaseMetaData;)V", "currentSchema", "getCurrentSchema", "()Ljava/lang/String;", "currentScheme", "getCurrentScheme$annotations", "()V", "getCurrentScheme", "databaseDialectName", "getDatabaseDialectName", "databaseDialectName$delegate", "Lkotlin/Lazy;", "databaseName", "getDatabaseName", "databaseProductVersion", "getDatabaseProductVersion", "databaseProductVersion$delegate", "defaultIsolationLevel", "", "getDefaultIsolationLevel", "()I", "defaultIsolationLevel$delegate", "existingIndicesCache", "Ljava/util/HashMap;", "Lorg/jetbrains/exposed/sql/Table;", "", "Lorg/jetbrains/exposed/sql/Index;", "Lkotlin/collections/HashMap;", "identifierManager", "Lorg/jetbrains/exposed/sql/statements/api/IdentifierManagerApi;", "getIdentifierManager", "()Lorg/jetbrains/exposed/sql/statements/api/IdentifierManagerApi;", "identifierManager$delegate", "getMetadata", "()Ljava/sql/DatabaseMetaData;", "schemaNames", "getSchemaNames", "()Ljava/util/List;", "supportsAlterTableWithAddColumn", "", "getSupportsAlterTableWithAddColumn", "()Z", "supportsAlterTableWithAddColumn$delegate", "supportsMultipleResultSets", "getSupportsMultipleResultSets", "supportsMultipleResultSets$delegate", "supportsSelectForUpdate", "getSupportsSelectForUpdate", "supportsSelectForUpdate$delegate", "tableNames", "", "getTableNames", "()Ljava/util/Map;", "url", "getUrl", "url$delegate", "version", "Ljava/math/BigDecimal;", "getVersion", "()Ljava/math/BigDecimal;", "version$delegate", "cleanCache", "", "columns", "Lorg/jetbrains/exposed/sql/vendors/ColumnMetadata;", "tables", "", "([Lorg/jetbrains/exposed/sql/Table;)Ljava/util/Map;", "existingIndices", "existingPrimaryKeys", "Lorg/jetbrains/exposed/sql/vendors/PrimaryKeyMetadata;", "lazyMetadata", "Lkotlin/Lazy;", "T", "body", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "resetCurrentScheme", "sanitizedDefault", "defaultValue", "sequences", "tableCatalogAndSchema", "Lkotlin/Pair;", "table", "tableConstraints", "Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "tableNamesByCurrentSchema", "Lorg/jetbrains/exposed/sql/vendors/SchemaMetadata;", "tableNamesCache", "tableNamesFor", "scheme", "asColumnMetadata", "Ljava/sql/ResultSet;", "extractColumns", "CachableMapWithDefault", "Companion", "exposed-jdbc"})
public final class JdbcDatabaseMetadataImpl
extends ExposedDatabaseMetadata {
    public static final Companion Companion = new Companion(null);
    private final DatabaseMetaData metadata;
    private final Lazy url$delegate;
    private final Lazy version$delegate;
    private final Lazy databaseDialectName$delegate;
    private final Lazy databaseProductVersion$delegate;
    private final Lazy defaultIsolationLevel$delegate;
    private final Lazy supportsAlterTableWithAddColumn$delegate;
    private final Lazy supportsMultipleResultSets$delegate;
    private final Lazy supportsSelectForUpdate$delegate;
    private final Lazy identifierManager$delegate;
    private String currentSchema;
    private final HashMap<Table, List<Index>> existingIndicesCache;
    private static final ConcurrentHashMap<String, JdbcIdentifierManager> identityManagerCache = new ConcurrentHashMap();

    public JdbcDatabaseMetadataImpl(String string, DatabaseMetaData databaseMetaData) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)databaseMetaData, (String)"");
        super(string);
        this.metadata = databaseMetaData;
        this.url$delegate = this.lazyMetadata(url.2.INSTANCE);
        this.version$delegate = this.lazyMetadata(version.2.INSTANCE);
        this.databaseDialectName$delegate = this.lazyMetadata(databaseDialectName.2.INSTANCE);
        this.databaseProductVersion$delegate = this.lazyMetadata(databaseProductVersion.2.INSTANCE);
        this.defaultIsolationLevel$delegate = this.lazyMetadata(defaultIsolationLevel.2.INSTANCE);
        this.supportsAlterTableWithAddColumn$delegate = this.lazyMetadata(supportsAlterTableWithAddColumn.2.INSTANCE);
        this.supportsMultipleResultSets$delegate = this.lazyMetadata(supportsMultipleResultSets.2.INSTANCE);
        this.supportsSelectForUpdate$delegate = this.lazyMetadata(supportsSelectForUpdate.2.INSTANCE);
        this.identifierManager$delegate = this.lazyMetadata(identifierManager.2.INSTANCE);
        this.existingIndicesCache = new HashMap();
    }

    public final DatabaseMetaData getMetadata() {
        return this.metadata;
    }

    public String getUrl() {
        Lazy lazy = this.url$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"");
        return (String)object;
    }

    public BigDecimal getVersion() {
        Lazy lazy = this.version$delegate;
        return (BigDecimal)lazy.getValue();
    }

    public String getDatabaseDialectName() {
        Lazy lazy = this.databaseDialectName$delegate;
        return (String)lazy.getValue();
    }

    private final String getDatabaseName() {
        String string;
        String string2 = this.getDatabaseDialectName();
        if (Intrinsics.areEqual((Object)string2, (Object)MysqlDialect.Companion.getDialectName()) ? true : Intrinsics.areEqual((Object)string2, (Object)MariaDBDialect.Companion.getDialectName())) {
            String string3 = this.getCurrentSchema();
            string = string3;
            Intrinsics.checkNotNull((Object)string3);
        } else {
            string = this.getDatabase();
        }
        return string;
    }

    public String getDatabaseProductVersion() {
        Lazy lazy = this.databaseProductVersion$delegate;
        return (String)lazy.getValue();
    }

    public int getDefaultIsolationLevel() {
        Lazy lazy = this.defaultIsolationLevel$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public boolean getSupportsAlterTableWithAddColumn() {
        Lazy lazy = this.supportsAlterTableWithAddColumn$delegate;
        return (Boolean)lazy.getValue();
    }

    public boolean getSupportsMultipleResultSets() {
        Lazy lazy = this.supportsMultipleResultSets$delegate;
        return (Boolean)lazy.getValue();
    }

    public boolean getSupportsSelectForUpdate() {
        Lazy lazy = this.supportsSelectForUpdate$delegate;
        return (Boolean)lazy.getValue();
    }

    public IdentifierManagerApi getIdentifierManager() {
        Lazy lazy = this.identifierManager$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"");
        return (IdentifierManagerApi)object;
    }

    private final String getCurrentSchema() {
        if (this.currentSchema == null) {
            String string;
            JdbcDatabaseMetadataImpl jdbcDatabaseMetadataImpl;
            JdbcDatabaseMetadataImpl jdbcDatabaseMetadataImpl2 = this;
            try {
                String string2;
                jdbcDatabaseMetadataImpl = jdbcDatabaseMetadataImpl2;
                string = this.getDatabaseDialectName();
                if (Intrinsics.areEqual((Object)string, (Object)MysqlDialect.Companion.getDialectName()) ? true : Intrinsics.areEqual((Object)string, (Object)MariaDBDialect.Companion.getDialectName())) {
                    string2 = this.metadata.getConnection().getCatalog();
                    if (string2 == null) {
                        string2 = "";
                    }
                } else if (Intrinsics.areEqual((Object)string, (Object)OracleDialect.Companion.getDialectName())) {
                    string2 = this.metadata.getConnection().getSchema();
                    if (string2 == null) {
                        string2 = this.getDatabaseName();
                    }
                } else {
                    string2 = this.metadata.getConnection().getSchema();
                    if (string2 == null) {
                        string2 = "";
                    }
                }
                string = string2;
            }
            catch (Throwable throwable) {
                jdbcDatabaseMetadataImpl = jdbcDatabaseMetadataImpl2;
                string = "";
            }
            jdbcDatabaseMetadataImpl.currentSchema = string;
        }
        String string = this.currentSchema;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    public /* synthetic */ String getCurrentScheme() {
        String string = this.getCurrentSchema();
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Deprecated(message="This will be removed when the interface property is fully deprecated", level=DeprecationLevel.HIDDEN)
    public static /* synthetic */ void getCurrentScheme$annotations() {
    }

    public void resetCurrentScheme() {
        this.currentSchema = null;
    }

    public Map<String, List<String>> getTableNames() {
        return new CachableMapWithDefault(this, null, (Function1)new Function1<String, List<? extends String>>(this){
            final /* synthetic */ JdbcDatabaseMetadataImpl this$0;
            {
                this.this$0 = jdbcDatabaseMetadataImpl;
                super(1);
            }

            public final List<String> invoke(String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"");
                return JdbcDatabaseMetadataImpl.access$tableNamesFor(this.this$0, string);
            }
        }, 1, null);
    }

    private final List<String> tableNamesFor(String string) {
        boolean bl;
        String string2;
        CharSequence charSequence;
        Pair pair;
        DatabaseMetaData databaseMetaData = this.metadata;
        boolean bl2 = false;
        boolean bl3 = DatabaseDialectKt.getCurrentDialect() instanceof MysqlDialect;
        if (bl3) {
            pair = TuplesKt.to((Object)string, (Object)"%");
        } else if (DatabaseDialectKt.getCurrentDialect() instanceof OracleDialect) {
            CharSequence charSequence2;
            String string3 = this.getDatabaseName();
            charSequence = string;
            if (charSequence.length() == 0) {
                string2 = string3;
                bl = false;
                charSequence2 = this.getDatabaseName();
                string3 = string2;
            } else {
                charSequence2 = charSequence;
            }
            pair = TuplesKt.to((Object)string3, (Object)charSequence2);
        } else {
            CharSequence charSequence3;
            String string4 = this.getDatabaseName();
            charSequence = string;
            if (charSequence.length() == 0) {
                string2 = string4;
                bl = false;
                charSequence3 = "%";
                string4 = string2;
            } else {
                charSequence3 = charSequence;
            }
            pair = TuplesKt.to((Object)string4, (Object)charSequence3);
        }
        Pair pair2 = pair;
        charSequence = (String)pair2.component1();
        String string5 = (String)pair2.component2();
        String[] stringArray = new String[]{"TABLE"};
        ResultSet resultSet = databaseMetaData.getTables((String)charSequence, string5, "%", stringArray);
        Intrinsics.checkNotNull((Object)resultSet);
        return JdbcDatabaseMetadataImplKt.access$iterate(resultSet, (Function1)new Function1<ResultSet, String>(bl3, this){
            final /* synthetic */ boolean $useCatalogInsteadOfScheme;
            final /* synthetic */ JdbcDatabaseMetadataImpl this$0;
            {
                this.$useCatalogInsteadOfScheme = bl;
                this.this$0 = jdbcDatabaseMetadataImpl;
                super(1);
            }

            public final String invoke(ResultSet resultSet) {
                String string;
                String string2;
                Intrinsics.checkNotNullParameter((Object)resultSet, (String)"");
                String string3 = resultSet.getString("TABLE_NAME");
                Intrinsics.checkNotNull((Object)string3);
                String string4 = string3;
                if (this.$useCatalogInsteadOfScheme) {
                    String string5 = resultSet.getString("TABLE_CAT");
                    if (string5 != null) {
                        String string6 = string5;
                        boolean bl = false;
                        string2 = string6 + '.' + string4;
                    } else {
                        string2 = null;
                    }
                } else {
                    String string7 = resultSet.getString("TABLE_SCHEM");
                    if (string7 != null) {
                        String string8 = string7;
                        boolean bl = false;
                        string2 = string8 + '.' + string4;
                    } else {
                        string2 = string = null;
                    }
                }
                if (string2 == null) {
                    string = string4;
                }
                String string9 = string;
                return this.this$0.getIdentifierManager().inProperCase(string9);
            }
        });
    }

    public List<String> getSchemaNames() {
        return this.schemaNames();
    }

    private final List<String> schemaNames() {
        List list;
        DatabaseMetaData databaseMetaData = this.metadata;
        boolean bl = false;
        boolean bl2 = DatabaseDialectKt.getCurrentDialect() instanceof MysqlDialect;
        if (bl2) {
            ResultSet resultSet = databaseMetaData.getCatalogs();
            Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"");
            list = JdbcDatabaseMetadataImplKt.access$iterate(resultSet, schemaNames.1.schemas.1.INSTANCE);
        } else {
            ResultSet resultSet = databaseMetaData.getSchemas();
            Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"");
            list = JdbcDatabaseMetadataImplKt.access$iterate(resultSet, schemaNames.1.schemas.2.INSTANCE);
        }
        List list2 = list;
        Iterable iterable = list2;
        boolean bl3 = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl4 = false;
        for (Object t : iterable2) {
            String string = (String)t;
            Collection collection2 = collection;
            boolean bl5 = false;
            IdentifierManagerApi identifierManagerApi = this.getIdentifierManager();
            Intrinsics.checkNotNull((Object)string);
            collection2.add(identifierManagerApi.inProperCase(string));
        }
        return (List)collection;
    }

    public SchemaMetadata tableNamesByCurrentSchema(Map<String, ? extends List<String>> map) {
        Map<String, List<String>> map2 = map;
        if (map2 == null) {
            map2 = this.getTableNames();
        }
        String string = this.getCurrentSchema();
        Intrinsics.checkNotNull((Object)string);
        List list = (List)MapsKt.getValue(map2, (Object)string);
        String string2 = this.getCurrentSchema();
        Intrinsics.checkNotNull((Object)string2);
        return new SchemaMetadata(string2, list);
    }

    private final List<ColumnMetadata> extractColumns(ResultSet resultSet) {
        List list = new ArrayList();
        while (resultSet.next()) {
            list.add(this.asColumnMetadata(resultSet));
        }
        return list;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public Map<Table, List<ColumnMetadata>> columns(Table ... var1_1) {
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"");
        var2_2 = new LinkedHashMap<K, V>();
        var3_3 = DatabaseDialectKt.getCurrentDialect() instanceof MysqlDialect;
        var5_4 = var1_1;
        var6_5 = false;
        var7_7 /* !! */  = var5_4;
        var8_8 = new LinkedHashMap<K, V>();
        var9_9 = false;
        for (Object var12_15 : var7_7 /* !! */ ) {
            var13_16 /* !! */  = var12_15;
            var14_17 = false;
            v0 = this.getIdentifierManager();
            v1 = var13_16 /* !! */ .getSchemaName();
            if (v1 == null) {
                v2 = this.getCurrentSchema();
                v1 = v2;
                Intrinsics.checkNotNull((Object)v2);
            }
            var15_18 = v0.inProperCase(v1);
            var16_19 = var8_8;
            var17_20 = false;
            var18_21 = var16_19.get(var15_18);
            if (var18_21 == null) {
                var19_23 = false;
                var19_22 = new ArrayList<E>();
                var16_19.put(var15_18, var19_22);
                v3 /* !! */  = var19_22;
            } else {
                v3 /* !! */  = var18_21;
            }
            var20_24 = (List)v3 /* !! */ ;
            var20_24.add(var12_15);
        }
        var4_25 = var8_8;
        for (Map.Entry var6_6 : var4_25.entrySet()) {
            var7_7 /* !! */  = (String)var6_6.getKey();
            var8_8 = (List)var6_6.getValue();
            var9_10 = var8_8.iterator();
            while (var9_10.hasNext()) {
                var10_12 = (Table)var9_10.next();
                if (!var3_3) ** GOTO lbl-1000
                v4 = this.getCurrentSchema();
                Intrinsics.checkNotNull((Object)v4);
                if (Intrinsics.areEqual((Object)var7_7 /* !! */ , (Object)v4)) lbl-1000:
                // 2 sources

                {
                    v5 /* !! */  = this.getDatabaseName();
                } else {
                    v5 /* !! */  = var7_7 /* !! */ ;
                }
                var11_14 = v5 /* !! */ ;
                var12_15 = this.metadata.getColumns((String)var11_14, (String)var7_7 /* !! */ , var10_12.nameInDatabaseCaseUnquoted(), "%");
                Intrinsics.checkNotNull((Object)var12_15);
                var13_16 /* !! */  = this.extractColumns((ResultSet)var12_15);
                if (!(((Collection)var13_16 /* !! */ ).isEmpty() == false)) {
                    var15_18 = "Check failed.";
                    throw new IllegalStateException(var15_18.toString());
                }
                var2_2.put(var10_12, var13_16 /* !! */ );
                var12_15.close();
            }
        }
        return var2_2;
    }

    private final ColumnMetadata asColumnMetadata(ResultSet resultSet) {
        Object object;
        String string;
        int n;
        Object object2;
        String string2 = resultSet.getString("COLUMN_DEF");
        if (string2 != null) {
            object2 = string2;
            n = 0;
            string = this.sanitizedDefault((String)object2);
        } else {
            string = null;
        }
        String string3 = string;
        boolean bl = Intrinsics.areEqual((Object)resultSet.getString("IS_AUTOINCREMENT"), (Object)"YES");
        int n2 = resultSet.getInt("DATA_TYPE");
        String string4 = resultSet.getString("COLUMN_NAME");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"");
        object2 = resultSet.getInt("COLUMN_SIZE");
        n = ((Number)object2).intValue();
        boolean bl2 = resultSet.getBoolean("NULLABLE");
        int n3 = n2;
        String string5 = string4;
        boolean bl3 = false;
        Object object3 = n != 0;
        String string6 = string5;
        int n4 = n3;
        boolean bl4 = bl2;
        Object object4 = ((Boolean)object3).booleanValue() ? object2 : null;
        boolean bl5 = bl;
        String string7 = string3;
        if (string7 != null) {
            Object object5 = object2 = string7;
            boolean bl6 = bl5;
            object3 = object4;
            bl2 = bl4;
            n3 = n4;
            string5 = string6;
            bl3 = false;
            boolean bl7 = !bl;
            string6 = string5;
            n4 = n3;
            bl4 = bl2;
            object4 = object3;
            bl5 = bl6;
            object = bl7 ? object2 : null;
        } else {
            object = null;
        }
        Object object6 = object;
        boolean bl8 = bl5;
        Object object7 = object4;
        boolean bl9 = bl4;
        int n5 = n4;
        String string8 = string6;
        return new ColumnMetadata(string8, n5, bl9, (Integer)object7, bl8, object6);
    }

    private final String sanitizedDefault(String string) {
        String string2;
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        H2Dialect.H2CompatibilityMode h2CompatibilityMode = H2Kt.getH2Mode((DatabaseDialect)databaseDialect);
        if (databaseDialect instanceof SQLServerDialect) {
            char[] cArray = new char[]{'(', ')', '\''};
            string2 = StringsKt.trim((String)string, (char[])cArray);
        } else if (databaseDialect instanceof OracleDialect || h2CompatibilityMode == H2Dialect.H2CompatibilityMode.Oracle) {
            String string3 = ((Object)StringsKt.trim((CharSequence)string)).toString();
            boolean bl = false;
            if (StringsKt.startsWith$default((CharSequence)string3, (char)'\'', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)string3, (char)'\'', (boolean)false, (int)2, null)) {
                char[] cArray = new char[]{'\''};
                string2 = StringsKt.trim((String)string3, (char[])cArray);
            } else {
                string2 = string3;
            }
        } else if (databaseDialect instanceof MysqlDialect || h2CompatibilityMode == H2Dialect.H2CompatibilityMode.MySQL || h2CompatibilityMode == H2Dialect.H2CompatibilityMode.MariaDB) {
            char[] cArray = new char[]{'\''};
            string2 = StringsKt.trim((String)StringsKt.substringAfter$default((String)string, (String)"b'", null, (int)2, null), (char[])cArray);
        } else if (databaseDialect instanceof PostgreSQLDialect || h2CompatibilityMode == H2Dialect.H2CompatibilityMode.PostgreSQL) {
            if (StringsKt.startsWith$default((CharSequence)string, (char)'\'', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)string, (char)'\'', (boolean)false, (int)2, null)) {
                char[] cArray = new char[]{'\''};
                string2 = StringsKt.trim((String)string, (char[])cArray);
            } else {
                string2 = string;
            }
        } else {
            char[] cArray = new char[]{'\''};
            string2 = StringsKt.trim((String)string, (char[])cArray);
        }
        return string2;
    }

    /*
     * Could not resolve type clashes
     */
    public Map<Table, List<Index>> existingIndices(Table ... tableArray) {
        Intrinsics.checkNotNullParameter((Object)tableArray, (String)"");
        for (Table table : tableArray) {
            List list;
            Object object;
            Map.Entry entry;
            boolean bl;
            Object object2;
            Object object3;
            int n;
            Object object4;
            Object object5;
            Transaction transaction = TransactionManager.Companion.current();
            Pair<String, String> pair = this.tableCatalogAndSchema(table);
            String string = (String)pair.component1();
            String string2 = (String)pair.component2();
            Map map = this.existingIndicesCache;
            boolean bl2 = false;
            Object v = map.get(table);
            if (v != null) continue;
            boolean bl3 = false;
            ResultSet resultSet = this.metadata.getPrimaryKeys(string, string2, table.nameInDatabaseCaseUnquoted());
            boolean bl4 = false;
            Object object6 = new ArrayList();
            while (resultSet.next()) {
                object5 = resultSet.getString("PK_NAME");
                String string3 = object5;
                if (string3 == null) continue;
                Intrinsics.checkNotNull((Object)string3);
                object4 = object5;
                n = 0;
                ((Collection)object6).add(object4);
            }
            resultSet.close();
            ArrayList arrayList = object6;
            String string4 = this.getCurrentSchema();
            Intrinsics.checkNotNull((Object)string4);
            String string5 = Intrinsics.areEqual((Object)string2, (Object)string4) && DatabaseDialectKt.getCurrentDialect() instanceof OracleDialect ? table.nameInDatabaseCase() : table.nameInDatabaseCaseUnquoted();
            resultSet = this.metadata.getIndexInfo(string, string2, string5, false, false);
            HashMap hashMap = new HashMap();
            while (resultSet.next()) {
                Object object7;
                Object object8 = object6 = resultSet.getString("INDEX_NAME");
                if (object8 == null) continue;
                Intrinsics.checkNotNull((Object)object8);
                object4 = object6;
                n = 0;
                String string6 = resultSet.getString("COLUMN_NAME");
                if (string6 == null) {
                    object3 = DatabaseDialectKt.getCurrentDialect();
                    string6 = (object3 instanceof MysqlDialect ? true : object3 instanceof SQLiteDialect) ? "\"\"" : null;
                }
                if ((object2 = string6) == null) continue;
                bl = false;
                entry = transaction.getDb().getIdentifierManager().quoteIdentifierWhenWrongCaseOrNecessary((String)object3);
                boolean bl5 = !resultSet.getBoolean("NON_UNIQUE");
                object = resultSet.getString("FILTER_CONDITION");
                Op.TRUE tRUE = object == null || object.length() == 0 ? null : Op.TRUE.INSTANCE;
                object = hashMap;
                Triple triple = new Triple(object4, (Object)bl5, (Object)tRUE);
                boolean bl6 = false;
                Object v2 = object.get(triple);
                if (v2 == null) {
                    boolean bl7 = false;
                    list = new ArrayList();
                    object.put(triple, list);
                    object7 = list;
                } else {
                    object7 = v2;
                }
                ((List)object7).add(entry);
            }
            resultSet.close();
            object5 = table.getColumns();
            boolean bl8 = false;
            n = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)object5, (int)10)), (int)16);
            object3 = object5;
            object2 = new LinkedHashMap(n);
            bl = false;
            entry = object3.iterator();
            while (entry.hasNext()) {
                Object e = entry.next();
                object = (Column)e;
                Object object9 = object2;
                boolean bl9 = false;
                object9.put(transaction.identity((Column)object), e);
            }
            object6 = object2;
            object5 = hashMap;
            bl8 = false;
            Object object10 = object5;
            object3 = new LinkedHashMap();
            boolean bl10 = false;
            Object object11 = object10.entrySet().iterator();
            while (object11.hasNext()) {
                Map.Entry entry2 = entry = object11.next();
                boolean bl11 = false;
                if (arrayList.contains(((Triple)entry2.getKey()).getFirst())) continue;
                object3.put(entry.getKey(), entry.getValue());
            }
            object5 = object3;
            bl8 = false;
            object10 = object5;
            object3 = new ArrayList();
            bl10 = false;
            object11 = object10;
            boolean bl12 = false;
            Iterator iterator = object11.entrySet().iterator();
            while (iterator.hasNext()) {
                Index index;
                Object object12;
                boolean bl13;
                Collection<Column> collection;
                Object object132;
                Map.Entry entry3;
                Map.Entry entry4 = entry3 = iterator.next();
                boolean bl14 = false;
                Map.Entry entry5 = entry4;
                boolean bl15 = false;
                list = (Triple)entry5.getKey();
                List list2 = (List)entry5.getValue();
                Iterable iterable = CollectionsKt.distinct((Iterable)list2);
                boolean bl16 = false;
                ArrayList arrayList2 = new ArrayList();
                ArrayList arrayList3 = new ArrayList();
                for (Object object132 : iterable) {
                    collection = (String)object132;
                    bl13 = false;
                    if (object6.get(collection) == null) {
                        arrayList2.add(object132);
                        continue;
                    }
                    arrayList3.add(object132);
                }
                Pair pair2 = new Pair(arrayList2, arrayList3);
                iterable = (List)pair2.component1();
                List list3 = (List)pair2.component2();
                arrayList3 = list3;
                boolean bl17 = false;
                object132 = arrayList3;
                collection = new ArrayList(CollectionsKt.collectionSizeOrDefault(arrayList3, (int)10));
                bl13 = false;
                Iterator iterator2 = object132.iterator();
                while (iterator2.hasNext()) {
                    object12 = iterator2.next();
                    String string7 = (String)object12;
                    Collection<Column> collection2 = collection;
                    boolean bl18 = false;
                    Object v3 = object6.get(string7);
                    Intrinsics.checkNotNull(v3);
                    collection2.add((Column)v3);
                }
                ArrayList arrayList4 = arrayList3 = (List)collection;
                boolean bl19 = false;
                ArrayList arrayList5 = arrayList4.size() + iterable.size() == list2.size() ? arrayList3 : null;
                if (arrayList5 != null) {
                    Collection<Column> collection3;
                    Collection<Column> collection4;
                    arrayList4 = arrayList5;
                    bl19 = false;
                    collection = iterable;
                    Op op = (Op)list.getThird();
                    iterator2 = null;
                    object12 = (String)list.getFirst();
                    boolean bl20 = (Boolean)list.getSecond();
                    ArrayList arrayList6 = arrayList4;
                    boolean bl21 = false;
                    Collection<Column> collection5 = collection;
                    Collection collection6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)collection, (int)10));
                    boolean bl22 = false;
                    for (Object t : collection5) {
                        String string8 = (String)t;
                        collection4 = collection6;
                        boolean bl23 = false;
                        collection4.add((Column)OpKt.stringLiteral((String)string8));
                    }
                    collection4 = (List)collection6;
                    ArrayList arrayList7 = arrayList6;
                    boolean bl24 = bl20;
                    Object object14 = object12;
                    Iterator iterator3 = iterator2;
                    Op op2 = op;
                    collection = collection4;
                    if (collection.isEmpty()) {
                        op = op2;
                        iterator2 = iterator3;
                        object12 = object14;
                        bl20 = bl24;
                        arrayList6 = arrayList7;
                        bl21 = false;
                        collection4 = null;
                        arrayList7 = arrayList6;
                        bl24 = bl20;
                        object14 = object12;
                        iterator3 = iterator2;
                        op2 = op;
                        collection3 = collection4;
                    } else {
                        collection3 = collection;
                    }
                    DefaultConstructorMarker defaultConstructorMarker = null;
                    int n2 = 8;
                    Table table2 = !((Collection)iterable).isEmpty() ? table : null;
                    List list4 = (List)collection3;
                    Op op3 = op2;
                    Iterator iterator4 = iterator3;
                    Object object15 = object14;
                    boolean bl25 = bl24;
                    ArrayList arrayList8 = arrayList7;
                    index = new Index(arrayList8, bl25, object15, iterator4, op3, list4, table2, n2, defaultConstructorMarker);
                } else {
                    index = null;
                }
                if (index == null) continue;
                Index index2 = index;
                boolean bl26 = false;
                object3.add(index2);
            }
            List list5 = (List)object3;
            map.put(table, list5);
        }
        return new HashMap(this.existingIndicesCache);
    }

    public Map<Table, PrimaryKeyMetadata> existingPrimaryKeys(Table ... tableArray) {
        Intrinsics.checkNotNullParameter((Object)tableArray, (String)"");
        Table[] tableArray2 = tableArray;
        boolean bl = false;
        LinkedHashMap linkedHashMap = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)tableArray2.length), (int)16));
        Table[] tableArray3 = tableArray2;
        boolean bl2 = false;
        int n = tableArray3.length;
        for (int i = 0; i < n; ++i) {
            Table table;
            Table table2 = table = tableArray3[i];
            Table table3 = table;
            Map map = linkedHashMap;
            boolean bl3 = false;
            Pair<String, String> pair = this.tableCatalogAndSchema(table2);
            String string = (String)pair.component1();
            String string2 = (String)pair.component2();
            ResultSet resultSet = this.metadata.getPrimaryKeys(string, string2, table2.nameInDatabaseCaseUnquoted());
            boolean bl4 = false;
            List list = new ArrayList();
            String string3 = null;
            string3 = "";
            while (resultSet.next()) {
                String string4;
                String string5 = string4 = resultSet.getString("PK_NAME");
                if (string5 != null) {
                    Intrinsics.checkNotNull((Object)string5);
                    String string6 = string4;
                    boolean bl5 = false;
                    string3 = string6;
                }
                ((Collection)list).add(resultSet.getString("COLUMN_NAME"));
            }
            resultSet.close();
            PrimaryKeyMetadata primaryKeyMetadata = ((CharSequence)string3).length() == 0 ? null : new PrimaryKeyMetadata(string3, list);
            map.put(table3, primaryKeyMetadata);
        }
        return linkedHashMap;
    }

    public List<String> sequences() {
        List list = new ArrayList();
        String[] stringArray = new String[]{"SEQUENCE"};
        ResultSet resultSet = this.metadata.getTables(null, null, null, stringArray);
        while (resultSet.next()) {
            String string = resultSet.getString(3);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            list.add(string);
        }
        return list;
    }

    public synchronized Map<String, List<ForeignKeyConstraint>> tableConstraints(List<? extends Table> list) {
        Map map;
        Intrinsics.checkNotNullParameter(list, (String)"");
        Iterable iterable = SchemaUtils.INSTANCE.sortTablesByReferences((Iterable)list);
        boolean bl = false;
        int n = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10)), (int)16);
        Iterable iterable2 = iterable;
        Map map2 = new LinkedHashMap(n);
        boolean bl2 = false;
        for (Object object4 : iterable2) {
            Table table = (Table)object4;
            map = map2;
            boolean bl3 = false;
            map.put(table.nameInDatabaseCaseUnquoted(), object4);
        }
        Map map3 = map2;
        iterable = map3.keySet();
        bl = false;
        LinkedHashMap linkedHashMap = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10)), (int)16));
        iterable2 = iterable;
        boolean bl4 = false;
        for (Iterator iterator : iterable2) {
            List list2;
            Object object;
            Object object2;
            boolean bl5;
            Object object3;
            Object object4;
            object4 = (String)((Object)iterator);
            Iterator iterator2 = iterator;
            map = linkedHashMap;
            boolean bl6 = false;
            Object v = map3.get(object4);
            Intrinsics.checkNotNull(v);
            Pair<String, String> pair = this.tableCatalogAndSchema((Table)v);
            String string = (String)pair.component1();
            String string2 = (String)pair.component2();
            ResultSet resultSet = this.metadata.getImportedKeys(string, this.getIdentifierManager().inProperCase(string2), (String)object4);
            Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"");
            Iterable iterable3 = CollectionsKt.filterNotNull((Iterable)JdbcDatabaseMetadataImplKt.access$iterate(resultSet, (Function1)new Function1<ResultSet, ForeignKeyConstraint>(this, (Map<String, ? extends Table>)map3){
                final /* synthetic */ JdbcDatabaseMetadataImpl this$0;
                final /* synthetic */ Map<String, Table> $allTables;
                {
                    this.this$0 = jdbcDatabaseMetadataImpl;
                    this.$allTables = map;
                    super(1);
                }

                public final ForeignKeyConstraint invoke(ResultSet resultSet) {
                    ReferenceOption referenceOption;
                    Object object;
                    String string;
                    Object object2;
                    int n;
                    JdbcDatabaseMetadataImpl jdbcDatabaseMetadataImpl;
                    Iterable iterable;
                    block15: {
                        block14: {
                            Object v11;
                            block11: {
                                Object object3;
                                Object object42;
                                Object object5;
                                block13: {
                                    block12: {
                                        Object v4;
                                        block10: {
                                            Intrinsics.checkNotNullParameter((Object)resultSet, (String)"");
                                            String string2 = resultSet.getString("FKTABLE_NAME");
                                            Intrinsics.checkNotNull((Object)string2);
                                            String string3 = string2;
                                            IdentifierManagerApi identifierManagerApi = this.this$0.getIdentifierManager();
                                            String string4 = resultSet.getString("FKCOLUMN_NAME");
                                            Intrinsics.checkNotNull((Object)string4);
                                            String string5 = identifierManagerApi.quoteIdentifierWhenWrongCaseOrNecessary(string4);
                                            object5 = this.$allTables.get(string3);
                                            if (object5 == null || (object5 = object5.getColumns()) == null) break block12;
                                            iterable = (Iterable)object5;
                                            jdbcDatabaseMetadataImpl = this.this$0;
                                            boolean bl = false;
                                            for (Object object42 : iterable) {
                                                object3 = (Column)object42;
                                                n = 0;
                                                if (!Intrinsics.areEqual((Object)jdbcDatabaseMetadataImpl.getIdentifierManager().quoteIdentifierWhenWrongCaseOrNecessary(object3.getName()), (Object)string5)) continue;
                                                v4 = object42;
                                                break block10;
                                            }
                                            v4 = null;
                                        }
                                        if ((object5 = (Column)v4) != null) break block13;
                                    }
                                    return null;
                                }
                                object2 = object5;
                                String string6 = resultSet.getString("FK_NAME");
                                Intrinsics.checkNotNull((Object)string6);
                                string = string6;
                                String string7 = resultSet.getString("PKTABLE_NAME");
                                Intrinsics.checkNotNull((Object)string7);
                                String string8 = string7;
                                IdentifierManagerApi identifierManagerApi = this.this$0.getIdentifierManager();
                                IdentifierManagerApi identifierManagerApi2 = this.this$0.getIdentifierManager();
                                String string9 = resultSet.getString("PKCOLUMN_NAME");
                                Intrinsics.checkNotNull((Object)string9);
                                String string10 = identifierManagerApi.quoteIdentifierWhenWrongCaseOrNecessary(identifierManagerApi2.inProperCase(string9));
                                object = this.$allTables.get(string8);
                                if (object == null || (object = object.getColumns()) == null) break block14;
                                object42 = (Iterable)object;
                                object3 = this.this$0;
                                n = 0;
                                Iterator<T> iterator = object42.iterator();
                                while (iterator.hasNext()) {
                                    T t = iterator.next();
                                    Column column = (Column)t;
                                    boolean bl = false;
                                    if (!Intrinsics.areEqual((Object)((JdbcDatabaseMetadataImpl)((Object)object3)).getIdentifierManager().quoteIdentifierWhenWrongCaseOrNecessary(column.nameInDatabaseCase()), (Object)string10)) continue;
                                    v11 = t;
                                    break block11;
                                }
                                v11 = null;
                            }
                            if ((object = (Column)v11) != null) break block15;
                        }
                        return null;
                    }
                    iterable = object;
                    Object object6 = resultSet.getObject("UPDATE_RULE");
                    if (object6 != null && (object6 = object6.toString()) != null && (object6 = StringsKt.toIntOrNull((String)object6)) != null) {
                        n = ((Number)object6).intValue();
                        boolean bl = false;
                        referenceOption = DatabaseDialectKt.getCurrentDialect().resolveRefOptionFromJdbc(n);
                    } else {
                        referenceOption = null;
                    }
                    jdbcDatabaseMetadataImpl = referenceOption;
                    ReferenceOption referenceOption2 = DatabaseDialectKt.getCurrentDialect().resolveRefOptionFromJdbc(resultSet.getInt("DELETE_RULE"));
                    return new ForeignKeyConstraint((Column)iterable, (Column)object2, (ReferenceOption)jdbcDatabaseMetadataImpl, referenceOption2, string);
                }
            }));
            boolean bl7 = false;
            Iterable iterable4 = iterable3;
            Object object5 = new LinkedHashMap();
            boolean bl8 = false;
            for (Object t : iterable4) {
                Object object6;
                object3 = (ForeignKeyConstraint)t;
                bl5 = false;
                object2 = object3.getFkName();
                Map map4 = object5;
                boolean bl9 = false;
                object = map4.get(object2);
                if (object == null) {
                    boolean bl10 = false;
                    list2 = new ArrayList();
                    map4.put(object2, list2);
                    object6 = list2;
                } else {
                    object6 = object;
                }
                object3 = (List)object6;
                object3.add(t);
            }
            iterable3 = object5.values();
            bl7 = false;
            iterable4 = iterable3;
            object5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable3, (int)10));
            bl8 = false;
            for (Object t : iterable4) {
                object3 = (List)t;
                Object object7 = object5;
                bl5 = false;
                object2 = (Iterable)object3;
                boolean bl11 = false;
                Iterator iterator3 = object2.iterator();
                if (!iterator3.hasNext()) {
                    throw new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                object = iterator3.next();
                while (iterator3.hasNext()) {
                    list2 = (ForeignKeyConstraint)iterator3.next();
                    ForeignKeyConstraint foreignKeyConstraint = (ForeignKeyConstraint)object;
                    boolean bl12 = false;
                    object = foreignKeyConstraint.plus((ForeignKeyConstraint)list2);
                }
                object7.add((ForeignKeyConstraint)object);
            }
            List list3 = (List)object5;
            map.put(iterator2, list3);
        }
        return linkedHashMap;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Pair<String, String> tableCatalogAndSchema(Table table) {
        Pair pair;
        IdentifierManagerApi identifierManagerApi = this.getIdentifierManager();
        String string = table.getSchemaName();
        if (string == null) {
            String string2 = this.getCurrentSchema();
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        }
        String string3 = identifierManagerApi.inProperCase(string);
        if (DatabaseDialectKt.getCurrentDialect() instanceof MysqlDialect) {
            String string4 = this.getCurrentSchema();
            Intrinsics.checkNotNull((Object)string4);
            if (!Intrinsics.areEqual((Object)string3, (Object)string4)) {
                pair = TuplesKt.to((Object)string3, (Object)string3);
                return pair;
            }
        }
        pair = TuplesKt.to((Object)this.getDatabaseName(), (Object)string3);
        return pair;
    }

    public synchronized void cleanCache() {
        this.existingIndicesCache.clear();
    }

    private final <T> Lazy<T> lazyMetadata(Function1<? super DatabaseMetaData, ? extends T> function1) {
        return LazyKt.lazy((Function0)new Function0<T>(function1, this){
            final /* synthetic */ Function1<DatabaseMetaData, T> $body;
            final /* synthetic */ JdbcDatabaseMetadataImpl this$0;
            {
                this.$body = function1;
                this.this$0 = jdbcDatabaseMetadataImpl;
                super(0);
            }

            public final T invoke() {
                return (T)this.$body.invoke((Object)this.this$0.getMetadata());
            }
        });
    }

    public static final /* synthetic */ List access$tableNamesFor(JdbcDatabaseMetadataImpl jdbcDatabaseMetadataImpl, String string) {
        return jdbcDatabaseMetadataImpl.tableNamesFor(string);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getIdentityManagerCache$cp() {
        return identityManagerCache;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0010&\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\b\u0082\u0004\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B/\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00028\u0001H\u0096\u0001\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010 \u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001c\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020\u001bH\u0016R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR$\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\r0\fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00020\u0013X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00010\u0017X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006#"}, d2={"Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl$CachableMapWithDefault;", "K", "V", "", "map", "", "default", "Lkotlin/Function1;", "(Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl;Ljava/util/Map;Lkotlin/jvm/functions/Function1;)V", "getDefault", "()Lkotlin/jvm/functions/Function1;", "entries", "", "", "getEntries", "()Ljava/util/Set;", "keys", "getKeys", "size", "", "getSize", "()I", "values", "", "getValues", "()Ljava/util/Collection;", "containsKey", "", "key", "(Ljava/lang/Object;)Z", "containsValue", "value", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "isEmpty", "exposed-jdbc"})
    private final class CachableMapWithDefault<K, V>
    implements Map<K, V>,
    KMappedMarker {
        private final Map<K, V> map;
        private final Function1<K, V> default;
        final /* synthetic */ JdbcDatabaseMetadataImpl this$0;

        public CachableMapWithDefault(JdbcDatabaseMetadataImpl jdbcDatabaseMetadataImpl, Map<K, V> map, Function1<? super K, ? extends V> function1) {
            Intrinsics.checkNotNullParameter(map, (String)"");
            Intrinsics.checkNotNullParameter(function1, (String)"");
            this.this$0 = jdbcDatabaseMetadataImpl;
            this.map = map;
            this.default = function1;
        }

        public /* synthetic */ CachableMapWithDefault(JdbcDatabaseMetadataImpl jdbcDatabaseMetadataImpl, Map map, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = new LinkedHashMap();
            }
            this(jdbcDatabaseMetadataImpl, map, function1);
        }

        public final Function1<K, V> getDefault() {
            return this.default;
        }

        public Set<Map.Entry<K, V>> getEntries() {
            return this.map.entrySet();
        }

        public Set<K> getKeys() {
            return this.map.keySet();
        }

        public int getSize() {
            return this.map.size();
        }

        public Collection<V> getValues() {
            return this.map.values();
        }

        @Override
        public boolean containsValue(Object object) {
            return this.map.containsValue(object);
        }

        @Override
        public V get(Object object) {
            Object object2;
            Map<Object, Object> map = this.map;
            boolean bl = false;
            V v = map.get(object);
            if (v == null) {
                boolean bl2 = false;
                Object object3 = this.default.invoke(object);
                map.put(object, object3);
                object2 = object3;
            } else {
                object2 = v;
            }
            return object2;
        }

        @Override
        public boolean containsKey(Object object) {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V compute(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V computeIfAbsent(K k, Function<? super K, ? extends V> function) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V computeIfPresent(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V merge(K k, V v, BiFunction<? super V, ? super V, ? extends V> biFunction) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V put(K k, V v) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V putIfAbsent(K k, V v) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V remove(Object object) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public boolean remove(Object object, Object object2) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public boolean replace(K k, V v, V v2) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V replace(K k, V v) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public final Set<Map.Entry<K, V>> entrySet() {
            return this.getEntries();
        }

        @Override
        public final Set<K> keySet() {
            return this.getKeys();
        }

        @Override
        public final int size() {
            return this.getSize();
        }

        @Override
        public final Collection<V> values() {
            return this.getValues();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl$Companion;", "", "()V", "identityManagerCache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcIdentifierManager;", "exposed-jdbc"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

