/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.vector;

import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.Matrix;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.SkiaBackedPath_skikoKt;
import androidx.compose.ui.graphics.SolidColor;
import androidx.compose.ui.graphics.drawscope.DrawContext;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.drawscope.DrawTransform;
import androidx.compose.ui.graphics.vector.PathComponent;
import androidx.compose.ui.graphics.vector.PathNode;
import androidx.compose.ui.graphics.vector.PathParserKt;
import androidx.compose.ui.graphics.vector.VNode;
import androidx.compose.ui.graphics.vector.VectorKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0018\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0017\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0001H\u0002J\b\u0010\u001c\u001a\u00020\u0013H\u0002J\b\u00100\u001a\u00020\u0013H\u0002J\b\u0010T\u001a\u00020\u0013H\u0002J\u0016\u0010U\u001a\u00020\u00132\u0006\u0010V\u001a\u00020P2\u0006\u0010W\u001a\u00020\u0001J\u001e\u0010X\u001a\u00020\u00132\u0006\u0010Y\u001a\u00020P2\u0006\u0010Z\u001a\u00020P2\u0006\u0010[\u001a\u00020PJ\u0016\u0010\\\u001a\u00020\u00132\u0006\u0010V\u001a\u00020P2\u0006\u0010[\u001a\u00020PJ\f\u0010]\u001a\u00020\u0013*\u00020^H\u0016J\b\u0010_\u001a\u000201H\u0016R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR \u0010\u000e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R0\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\fR\u000e\u0010&\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010)\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0013\u0018\u00010*X\u0090\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00130*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u00102\u001a\u0002012\u0006\u0010\t\u001a\u000201@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R$\u00108\u001a\u0002072\u0006\u0010\t\u001a\u000207@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R$\u0010=\u001a\u0002072\u0006\u0010\t\u001a\u000207@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010:\"\u0004\b?\u0010<R$\u0010@\u001a\u0002072\u0006\u0010\t\u001a\u000207@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010:\"\u0004\bB\u0010<R$\u0010C\u001a\u0002072\u0006\u0010\t\u001a\u000207@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010:\"\u0004\bE\u0010<R$\u0010F\u001a\u0002072\u0006\u0010\t\u001a\u000207@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010:\"\u0004\bH\u0010<R$\u0010I\u001a\u0002072\u0006\u0010\t\u001a\u000207@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010:\"\u0004\bK\u0010<R$\u0010L\u001a\u0002072\u0006\u0010\t\u001a\u000207@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010:\"\u0004\bN\u0010<R\u0011\u0010O\u001a\u00020P8F\u00a2\u0006\u0006\u001a\u0004\bQ\u0010RR\u000e\u0010S\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006`"}, d2={"Landroidx/compose/ui/graphics/vector/GroupComponent;", "Landroidx/compose/ui/graphics/vector/VNode;", "<init>", "()V", "groupMatrix", "Landroidx/compose/ui/graphics/Matrix;", "[F", "children", "", "value", "", "isTintable", "()Z", "Landroidx/compose/ui/graphics/Color;", "tintColor", "getTintColor-0d7_KjU", "()J", "J", "markTintForBrush", "", "brush", "Landroidx/compose/ui/graphics/Brush;", "markTintForColor", "color", "markTintForColor-8_81llA", "(J)V", "markTintForVNode", "node", "markNotTintable", "", "Landroidx/compose/ui/graphics/vector/PathNode;", "clipPathData", "getClipPathData", "()Ljava/util/List;", "setClipPathData", "(Ljava/util/List;)V", "willClipPath", "getWillClipPath", "isClipPathDirty", "clipPath", "Landroidx/compose/ui/graphics/Path;", "invalidateListener", "Lkotlin/Function1;", "getInvalidateListener$ui", "()Lkotlin/jvm/functions/Function1;", "setInvalidateListener$ui", "(Lkotlin/jvm/functions/Function1;)V", "wrappedListener", "updateClipPath", "", "name", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "", "rotation", "getRotation", "()F", "setRotation", "(F)V", "pivotX", "getPivotX", "setPivotX", "pivotY", "getPivotY", "setPivotY", "scaleX", "getScaleX", "setScaleX", "scaleY", "getScaleY", "setScaleY", "translationX", "getTranslationX", "setTranslationX", "translationY", "getTranslationY", "setTranslationY", "numChildren", "", "getNumChildren", "()I", "isMatrixDirty", "updateMatrix", "insertAt", "index", "instance", "move", "from", "to", "count", "remove", "draw", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "toString", "ui"})
public final class GroupComponent
extends VNode {
    private float[] groupMatrix;
    private final List<VNode> children = new ArrayList();
    private boolean isTintable = true;
    private long tintColor = Color.Companion.getUnspecified-0d7_KjU();
    private List<? extends PathNode> clipPathData = VectorKt.getEmptyPath();
    private boolean isClipPathDirty = true;
    private Path clipPath;
    private Function1<? super VNode, Unit> invalidateListener;
    private final Function1<VNode, Unit> wrappedListener = arg_0 -> GroupComponent.wrappedListener$lambda$0(this, arg_0);
    private String name = "";
    private float rotation;
    private float pivotX;
    private float pivotY;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float translationX;
    private float translationY;
    private boolean isMatrixDirty = true;
    public static final int $stable = 8;

    public GroupComponent() {
        super(null);
    }

    public final boolean isTintable() {
        return this.isTintable;
    }

    public final long getTintColor-0d7_KjU() {
        return this.tintColor;
    }

    private final void markTintForBrush(Brush brush) {
        if (!this.isTintable) {
            return;
        }
        if (brush != null) {
            if (brush instanceof SolidColor) {
                this.markTintForColor-8_81llA(((SolidColor)brush).getValue-0d7_KjU());
            } else {
                this.markNotTintable();
            }
        }
    }

    private final void markTintForColor-8_81llA(long l) {
        if (!this.isTintable) {
            return;
        }
        long l2 = l;
        boolean bl = false;
        if (l2 != 16L) {
            l2 = this.tintColor;
            bl = false;
            if (l2 == 16L) {
                this.tintColor = l;
            } else if (!VectorKt.rgbEqual--OWjLjI(this.tintColor, l)) {
                this.markNotTintable();
            }
        }
    }

    private final void markTintForVNode(VNode vNode) {
        if (vNode instanceof PathComponent) {
            this.markTintForBrush(((PathComponent)vNode).getFill());
            this.markTintForBrush(((PathComponent)vNode).getStroke());
        } else if (vNode instanceof GroupComponent) {
            if (((GroupComponent)vNode).isTintable && this.isTintable) {
                this.markTintForColor-8_81llA(((GroupComponent)vNode).tintColor);
            } else {
                this.markNotTintable();
            }
        }
    }

    private final void markNotTintable() {
        this.isTintable = false;
        this.tintColor = Color.Companion.getUnspecified-0d7_KjU();
    }

    public final List<PathNode> getClipPathData() {
        return this.clipPathData;
    }

    public final void setClipPathData(List<? extends PathNode> list) {
        Intrinsics.checkNotNullParameter(list, (String)"");
        this.clipPathData = list;
        this.isClipPathDirty = true;
        this.invalidate();
    }

    private final boolean getWillClipPath() {
        return !((Collection)this.clipPathData).isEmpty();
    }

    @Override
    public Function1<VNode, Unit> getInvalidateListener$ui() {
        return this.invalidateListener;
    }

    @Override
    public void setInvalidateListener$ui(Function1<? super VNode, Unit> function1) {
        this.invalidateListener = function1;
    }

    private final void updateClipPath() {
        if (this.getWillClipPath()) {
            Path path = this.clipPath;
            if (path == null) {
                this.clipPath = path = SkiaBackedPath_skikoKt.Path();
            }
            PathParserKt.toPath(this.clipPathData, (Path)path);
        }
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        this.name = string;
        this.invalidate();
    }

    public final float getRotation() {
        return this.rotation;
    }

    public final void setRotation(float f) {
        this.rotation = f;
        this.isMatrixDirty = true;
        this.invalidate();
    }

    public final float getPivotX() {
        return this.pivotX;
    }

    public final void setPivotX(float f) {
        this.pivotX = f;
        this.isMatrixDirty = true;
        this.invalidate();
    }

    public final float getPivotY() {
        return this.pivotY;
    }

    public final void setPivotY(float f) {
        this.pivotY = f;
        this.isMatrixDirty = true;
        this.invalidate();
    }

    public final float getScaleX() {
        return this.scaleX;
    }

    public final void setScaleX(float f) {
        this.scaleX = f;
        this.isMatrixDirty = true;
        this.invalidate();
    }

    public final float getScaleY() {
        return this.scaleY;
    }

    public final void setScaleY(float f) {
        this.scaleY = f;
        this.isMatrixDirty = true;
        this.invalidate();
    }

    public final float getTranslationX() {
        return this.translationX;
    }

    public final void setTranslationX(float f) {
        this.translationX = f;
        this.isMatrixDirty = true;
        this.invalidate();
    }

    public final float getTranslationY() {
        return this.translationY;
    }

    public final void setTranslationY(float f) {
        this.translationY = f;
        this.isMatrixDirty = true;
        this.invalidate();
    }

    public final int getNumChildren() {
        return this.children.size();
    }

    private final void updateMatrix() {
        float[] fArray = null;
        float[] fArray2 = this.groupMatrix;
        if (fArray2 == null) {
            this.groupMatrix = fArray = Matrix.constructor-impl$default(null, (int)1, null);
        } else {
            fArray = fArray2;
            Matrix.reset-impl((float[])fArray);
        }
        Matrix.translate-impl$default((float[])fArray, (float)(this.translationX + this.pivotX), (float)(this.translationY + this.pivotY), (float)0.0f, (int)4, null);
        Matrix.rotateZ-impl((float[])fArray, (float)this.rotation);
        Matrix.scale-impl((float[])fArray, (float)this.scaleX, (float)this.scaleY, (float)1.0f);
        Matrix.translate-impl$default((float[])fArray, (float)(-this.pivotX), (float)(-this.pivotY), (float)0.0f, (int)4, null);
    }

    public final void insertAt(int n, VNode vNode) {
        Intrinsics.checkNotNullParameter((Object)vNode, (String)"");
        if (n < this.getNumChildren()) {
            this.children.set(n, vNode);
        } else {
            this.children.add(vNode);
        }
        this.markTintForVNode(vNode);
        vNode.setInvalidateListener$ui(this.wrappedListener);
        this.invalidate();
    }

    public final void move(int n, int n2, int n3) {
        if (n > n2) {
            int n4 = 0;
            n4 = n2;
            int n5 = 0;
            while (n5 < n3) {
                int n6 = n5++;
                boolean bl = false;
                VNode vNode = this.children.get(n);
                this.children.remove(n);
                this.children.add(n4, vNode);
                ++n4;
            }
        } else {
            int n7 = 0;
            while (n7 < n3) {
                int n8 = n7++;
                boolean bl = false;
                VNode vNode = this.children.get(n);
                this.children.remove(n);
                this.children.add(n2 - 1, vNode);
            }
        }
        this.invalidate();
    }

    public final void remove(int n, int n2) {
        for (int j = 0; j < n2; ++j) {
            int n3 = j;
            boolean bl = false;
            if (n >= this.children.size()) continue;
            this.children.get(n).setInvalidateListener$ui(null);
            this.children.remove(n);
        }
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(DrawScope drawScope) {
        Intrinsics.checkNotNullParameter((Object)drawScope, (String)"");
        if (this.isMatrixDirty) {
            this.updateMatrix();
            this.isMatrixDirty = false;
        }
        if (this.isClipPathDirty) {
            this.updateClipPath();
            this.isClipPathDirty = false;
        }
        DrawScope drawScope2 = drawScope;
        boolean bl = false;
        DrawContext drawContext = drawScope2.getDrawContext();
        boolean bl2 = false;
        long l = drawContext.getSize-NH-jbRc();
        drawContext.getCanvas().save();
        try {
            boolean bl3;
            Object object;
            DrawTransform drawTransform = drawContext.getTransform();
            boolean bl4 = false;
            if (this.groupMatrix != null) {
                object = (this.groupMatrix != null ? Matrix.box-impl((float[])this.groupMatrix) : null).unbox-impl();
                bl3 = false;
                drawTransform.transform-58bKbWc((float[])object);
            }
            Path path = this.clipPath;
            if (this.getWillClipPath() && path != null) {
                DrawTransform.clipPath-mtrdD-E$default((DrawTransform)drawTransform, (Path)path, (int)0, (int)2, null);
            }
            drawTransform = drawScope2;
            bl4 = false;
            object = this.children;
            bl3 = false;
            int n = ((Collection)object).size();
            for (int j = 0; j < n; ++j) {
                Object e = object.get(j);
                VNode vNode = (VNode)e;
                boolean bl5 = false;
                VNode vNode2 = vNode;
                boolean bl6 = false;
                vNode2.draw(drawScope);
            }
        }
        finally {
            drawContext.getCanvas().restore();
            drawContext.setSize-uvyYCjk(l);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("VGroup: ").append(this.name);
        List<VNode> list = this.children;
        boolean bl = false;
        int n = ((Collection)list).size();
        for (int j = 0; j < n; ++j) {
            VNode vNode;
            VNode vNode2 = vNode = list.get(j);
            boolean bl2 = false;
            stringBuilder.append("\t").append(vNode2.toString()).append("\n");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    private static final Unit wrappedListener$lambda$0(GroupComponent groupComponent, VNode vNode) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)vNode, (String)"");
            groupComponent.markTintForVNode(vNode);
            Function1<VNode, Unit> function1 = groupComponent.getInvalidateListener$ui();
            if (function1 == null) break block0;
            function1.invoke((Object)vNode);
        }
        return Unit.INSTANCE;
    }
}

