/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.CodecOutputList;
import io.netty.handler.codec.DecoderException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.TypeParameterMatcher;
import java.util.List;

public abstract class MessageToMessageDecoder<I>
extends ChannelInboundHandlerAdapter {
    private final TypeParameterMatcher matcher;
    private boolean decodeCalled;
    private boolean messageProduced;

    protected MessageToMessageDecoder() {
        this.matcher = TypeParameterMatcher.find((Object)((Object)this), MessageToMessageDecoder.class, (String)"I");
    }

    protected MessageToMessageDecoder(Class<? extends I> clazz) {
        this.matcher = TypeParameterMatcher.get(clazz);
    }

    public boolean acceptInboundMessage(Object object) {
        return this.matcher.match(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        CodecOutputList codecOutputList;
        block17: {
            this.decodeCalled = true;
            codecOutputList = CodecOutputList.newInstance();
            try {
                if (this.acceptInboundMessage(object)) {
                    Object object2 = object;
                    try {
                        this.decode(channelHandlerContext, object2, codecOutputList);
                        break block17;
                    }
                    finally {
                        ReferenceCountUtil.release((Object)object2);
                    }
                }
                codecOutputList.add(object);
            }
            catch (DecoderException decoderException) {
                try {
                    throw decoderException;
                    catch (Exception exception) {
                        throw new DecoderException(exception);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        int n = codecOutputList.size();
                        this.messageProduced |= n > 0;
                        for (int i = 0; i < n; ++i) {
                            channelHandlerContext.fireChannelRead(codecOutputList.getUnsafe(i));
                        }
                        throw throwable;
                    }
                    finally {
                        codecOutputList.recycle();
                    }
                }
            }
        }
        try {
            int n = codecOutputList.size();
            this.messageProduced |= n > 0;
            for (int i = 0; i < n; ++i) {
                channelHandlerContext.fireChannelRead(codecOutputList.getUnsafe(i));
            }
            return;
        }
        finally {
            codecOutputList.recycle();
        }
    }

    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        if (!this.isSharable()) {
            if (this.decodeCalled && !this.messageProduced && !channelHandlerContext.channel().config().isAutoRead()) {
                channelHandlerContext.read();
            }
            this.decodeCalled = false;
            this.messageProduced = false;
        }
        channelHandlerContext.fireChannelReadComplete();
    }

    protected abstract void decode(ChannelHandlerContext var1, I var2, List<Object> var3);
}

