/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.util.ByteProcessor;
import io.netty.util.Signal;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

final class ReplayingDecoderByteBuf
extends ByteBuf {
    private static final Signal REPLAY = ReplayingDecoder.REPLAY;
    private ByteBuf buffer;
    private boolean terminated;
    private SwappedByteBuf swapped;
    static final ReplayingDecoderByteBuf EMPTY_BUFFER = new ReplayingDecoderByteBuf(Unpooled.EMPTY_BUFFER);

    ReplayingDecoderByteBuf() {
    }

    ReplayingDecoderByteBuf(ByteBuf byteBuf) {
        this.setCumulation(byteBuf);
    }

    void setCumulation(ByteBuf byteBuf) {
        this.buffer = byteBuf;
    }

    void terminate() {
        this.terminated = true;
    }

    public int capacity() {
        if (this.terminated) {
            return this.buffer.capacity();
        }
        return Integer.MAX_VALUE;
    }

    public ByteBuf capacity(int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public int maxCapacity() {
        return this.capacity();
    }

    public ByteBufAllocator alloc() {
        return this.buffer.alloc();
    }

    public boolean isReadOnly() {
        return false;
    }

    public ByteBuf asReadOnly() {
        return Unpooled.unmodifiableBuffer((ByteBuf)this);
    }

    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    public boolean hasArray() {
        return false;
    }

    public byte[] array() {
        throw new UnsupportedOperationException();
    }

    public int arrayOffset() {
        throw new UnsupportedOperationException();
    }

    public boolean hasMemoryAddress() {
        return false;
    }

    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    public ByteBuf clear() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int compareTo(ByteBuf byteBuf) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf copy() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf copy(int n, int n2) {
        this.checkIndex(n, n2);
        return this.buffer.copy(n, n2);
    }

    public ByteBuf discardReadBytes() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf ensureWritable(int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public int ensureWritable(int n, boolean bl) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf duplicate() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf retainedDuplicate() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public boolean getBoolean(int n) {
        this.checkIndex(n, 1);
        return this.buffer.getBoolean(n);
    }

    public byte getByte(int n) {
        this.checkIndex(n, 1);
        return this.buffer.getByte(n);
    }

    public short getUnsignedByte(int n) {
        this.checkIndex(n, 1);
        return this.buffer.getUnsignedByte(n);
    }

    public ByteBuf getBytes(int n, byte[] byArray, int n2, int n3) {
        this.checkIndex(n, n3);
        this.buffer.getBytes(n, byArray, n2, n3);
        return this;
    }

    public ByteBuf getBytes(int n, byte[] byArray) {
        this.checkIndex(n, byArray.length);
        this.buffer.getBytes(n, byArray);
        return this;
    }

    public ByteBuf getBytes(int n, ByteBuffer byteBuffer) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf getBytes(int n, ByteBuf byteBuf, int n2, int n3) {
        this.checkIndex(n, n3);
        this.buffer.getBytes(n, byteBuf, n2, n3);
        return this;
    }

    public ByteBuf getBytes(int n, ByteBuf byteBuf, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf getBytes(int n, ByteBuf byteBuf) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public int getBytes(int n, GatheringByteChannel gatheringByteChannel, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public int getBytes(int n, FileChannel fileChannel, long l, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf getBytes(int n, OutputStream outputStream, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public int getInt(int n) {
        this.checkIndex(n, 4);
        return this.buffer.getInt(n);
    }

    public int getIntLE(int n) {
        this.checkIndex(n, 4);
        return this.buffer.getIntLE(n);
    }

    public long getUnsignedInt(int n) {
        this.checkIndex(n, 4);
        return this.buffer.getUnsignedInt(n);
    }

    public long getUnsignedIntLE(int n) {
        this.checkIndex(n, 4);
        return this.buffer.getUnsignedIntLE(n);
    }

    public long getLong(int n) {
        this.checkIndex(n, 8);
        return this.buffer.getLong(n);
    }

    public long getLongLE(int n) {
        this.checkIndex(n, 8);
        return this.buffer.getLongLE(n);
    }

    public int getMedium(int n) {
        this.checkIndex(n, 3);
        return this.buffer.getMedium(n);
    }

    public int getMediumLE(int n) {
        this.checkIndex(n, 3);
        return this.buffer.getMediumLE(n);
    }

    public int getUnsignedMedium(int n) {
        this.checkIndex(n, 3);
        return this.buffer.getUnsignedMedium(n);
    }

    public int getUnsignedMediumLE(int n) {
        this.checkIndex(n, 3);
        return this.buffer.getUnsignedMediumLE(n);
    }

    public short getShort(int n) {
        this.checkIndex(n, 2);
        return this.buffer.getShort(n);
    }

    public short getShortLE(int n) {
        this.checkIndex(n, 2);
        return this.buffer.getShortLE(n);
    }

    public int getUnsignedShort(int n) {
        this.checkIndex(n, 2);
        return this.buffer.getUnsignedShort(n);
    }

    public int getUnsignedShortLE(int n) {
        this.checkIndex(n, 2);
        return this.buffer.getUnsignedShortLE(n);
    }

    public char getChar(int n) {
        this.checkIndex(n, 2);
        return this.buffer.getChar(n);
    }

    public float getFloat(int n) {
        this.checkIndex(n, 4);
        return this.buffer.getFloat(n);
    }

    public double getDouble(int n) {
        this.checkIndex(n, 8);
        return this.buffer.getDouble(n);
    }

    public CharSequence getCharSequence(int n, int n2, Charset charset) {
        this.checkIndex(n, n2);
        return this.buffer.getCharSequence(n, n2, charset);
    }

    public int hashCode() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public int indexOf(int n, int n2, byte by) {
        if (n == n2) {
            return -1;
        }
        if (Math.max(n, n2) > this.buffer.writerIndex()) {
            throw REPLAY;
        }
        return this.buffer.indexOf(n, n2, by);
    }

    public int bytesBefore(byte by) {
        int n = this.buffer.bytesBefore(by);
        if (n < 0) {
            throw REPLAY;
        }
        return n;
    }

    public int bytesBefore(int n, byte by) {
        return this.bytesBefore(this.buffer.readerIndex(), n, by);
    }

    public int bytesBefore(int n, int n2, byte by) {
        int n3 = this.buffer.writerIndex();
        if (n >= n3) {
            throw REPLAY;
        }
        if (n <= n3 - n2) {
            return this.buffer.bytesBefore(n, n2, by);
        }
        int n4 = this.buffer.bytesBefore(n, n3 - n, by);
        if (n4 < 0) {
            throw REPLAY;
        }
        return n4;
    }

    public int forEachByte(ByteProcessor byteProcessor) {
        int n = this.buffer.forEachByte(byteProcessor);
        if (n < 0) {
            throw REPLAY;
        }
        return n;
    }

    public int forEachByte(int n, int n2, ByteProcessor byteProcessor) {
        int n3 = this.buffer.writerIndex();
        if (n >= n3) {
            throw REPLAY;
        }
        if (n <= n3 - n2) {
            return this.buffer.forEachByte(n, n2, byteProcessor);
        }
        int n4 = this.buffer.forEachByte(n, n3 - n, byteProcessor);
        if (n4 < 0) {
            throw REPLAY;
        }
        return n4;
    }

    public int forEachByteDesc(ByteProcessor byteProcessor) {
        if (this.terminated) {
            return this.buffer.forEachByteDesc(byteProcessor);
        }
        throw ReplayingDecoderByteBuf.reject();
    }

    public int forEachByteDesc(int n, int n2, ByteProcessor byteProcessor) {
        if (n + n2 > this.buffer.writerIndex()) {
            throw REPLAY;
        }
        return this.buffer.forEachByteDesc(n, n2, byteProcessor);
    }

    public ByteBuf markReaderIndex() {
        this.buffer.markReaderIndex();
        return this;
    }

    public ByteBuf markWriterIndex() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteOrder order() {
        return this.buffer.order();
    }

    public ByteBuf order(ByteOrder byteOrder) {
        if (ObjectUtil.checkNotNull((Object)byteOrder, (String)"endianness") == this.order()) {
            return this;
        }
        SwappedByteBuf swappedByteBuf = this.swapped;
        if (swappedByteBuf == null) {
            this.swapped = swappedByteBuf = new SwappedByteBuf((ByteBuf)this);
        }
        return swappedByteBuf;
    }

    public boolean isReadable() {
        return !this.terminated || this.buffer.isReadable();
    }

    public boolean isReadable(int n) {
        return !this.terminated || this.buffer.isReadable(n);
    }

    public int readableBytes() {
        if (this.terminated) {
            return this.buffer.readableBytes();
        }
        return Integer.MAX_VALUE - this.buffer.readerIndex();
    }

    public boolean readBoolean() {
        this.checkReadableBytes(1);
        return this.buffer.readBoolean();
    }

    public byte readByte() {
        this.checkReadableBytes(1);
        return this.buffer.readByte();
    }

    public short readUnsignedByte() {
        this.checkReadableBytes(1);
        return this.buffer.readUnsignedByte();
    }

    public ByteBuf readBytes(byte[] byArray, int n, int n2) {
        this.checkReadableBytes(n2);
        this.buffer.readBytes(byArray, n, n2);
        return this;
    }

    public ByteBuf readBytes(byte[] byArray) {
        this.checkReadableBytes(byArray.length);
        this.buffer.readBytes(byArray);
        return this;
    }

    public ByteBuf readBytes(ByteBuffer byteBuffer) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf readBytes(ByteBuf byteBuf, int n, int n2) {
        this.checkReadableBytes(n2);
        this.buffer.readBytes(byteBuf, n, n2);
        return this;
    }

    public ByteBuf readBytes(ByteBuf byteBuf, int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf readBytes(ByteBuf byteBuf) {
        this.checkReadableBytes(byteBuf.writableBytes());
        this.buffer.readBytes(byteBuf);
        return this;
    }

    public int readBytes(GatheringByteChannel gatheringByteChannel, int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public int readBytes(FileChannel fileChannel, long l, int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf readBytes(int n) {
        this.checkReadableBytes(n);
        return this.buffer.readBytes(n);
    }

    public ByteBuf readSlice(int n) {
        this.checkReadableBytes(n);
        return this.buffer.readSlice(n);
    }

    public ByteBuf readRetainedSlice(int n) {
        this.checkReadableBytes(n);
        return this.buffer.readRetainedSlice(n);
    }

    public ByteBuf readBytes(OutputStream outputStream, int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public int readerIndex() {
        return this.buffer.readerIndex();
    }

    public ByteBuf readerIndex(int n) {
        this.buffer.readerIndex(n);
        return this;
    }

    public int readInt() {
        this.checkReadableBytes(4);
        return this.buffer.readInt();
    }

    public int readIntLE() {
        this.checkReadableBytes(4);
        return this.buffer.readIntLE();
    }

    public long readUnsignedInt() {
        this.checkReadableBytes(4);
        return this.buffer.readUnsignedInt();
    }

    public long readUnsignedIntLE() {
        this.checkReadableBytes(4);
        return this.buffer.readUnsignedIntLE();
    }

    public long readLong() {
        this.checkReadableBytes(8);
        return this.buffer.readLong();
    }

    public long readLongLE() {
        this.checkReadableBytes(8);
        return this.buffer.readLongLE();
    }

    public int readMedium() {
        this.checkReadableBytes(3);
        return this.buffer.readMedium();
    }

    public int readMediumLE() {
        this.checkReadableBytes(3);
        return this.buffer.readMediumLE();
    }

    public int readUnsignedMedium() {
        this.checkReadableBytes(3);
        return this.buffer.readUnsignedMedium();
    }

    public int readUnsignedMediumLE() {
        this.checkReadableBytes(3);
        return this.buffer.readUnsignedMediumLE();
    }

    public short readShort() {
        this.checkReadableBytes(2);
        return this.buffer.readShort();
    }

    public short readShortLE() {
        this.checkReadableBytes(2);
        return this.buffer.readShortLE();
    }

    public int readUnsignedShort() {
        this.checkReadableBytes(2);
        return this.buffer.readUnsignedShort();
    }

    public int readUnsignedShortLE() {
        this.checkReadableBytes(2);
        return this.buffer.readUnsignedShortLE();
    }

    public char readChar() {
        this.checkReadableBytes(2);
        return this.buffer.readChar();
    }

    public float readFloat() {
        this.checkReadableBytes(4);
        return this.buffer.readFloat();
    }

    public double readDouble() {
        this.checkReadableBytes(8);
        return this.buffer.readDouble();
    }

    public CharSequence readCharSequence(int n, Charset charset) {
        this.checkReadableBytes(n);
        return this.buffer.readCharSequence(n, charset);
    }

    public ByteBuf resetReaderIndex() {
        this.buffer.resetReaderIndex();
        return this;
    }

    public ByteBuf resetWriterIndex() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf setBoolean(int n, boolean bl) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf setByte(int n, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf setBytes(int n, byte[] byArray, int n2, int n3) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf setBytes(int n, byte[] byArray) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf setBytes(int n, ByteBuffer byteBuffer) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf setBytes(int n, ByteBuf byteBuf, int n2, int n3) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf setBytes(int n, ByteBuf byteBuf, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf setBytes(int n, ByteBuf byteBuf) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public int setBytes(int n, InputStream inputStream, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf setZero(int n, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public int setBytes(int n, ScatteringByteChannel scatteringByteChannel, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public int setBytes(int n, FileChannel fileChannel, long l, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf setIndex(int n, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf setInt(int n, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf setIntLE(int n, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf setLong(int n, long l) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf setLongLE(int n, long l) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf setMedium(int n, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf setMediumLE(int n, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf setShort(int n, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf setShortLE(int n, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf setChar(int n, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf setFloat(int n, float f) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf setDouble(int n, double d) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf skipBytes(int n) {
        this.checkReadableBytes(n);
        this.buffer.skipBytes(n);
        return this;
    }

    public ByteBuf slice() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf retainedSlice() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf slice(int n, int n2) {
        this.checkIndex(n, n2);
        return this.buffer.slice(n, n2);
    }

    public ByteBuf retainedSlice(int n, int n2) {
        this.checkIndex(n, n2);
        return this.buffer.retainedSlice(n, n2);
    }

    public int nioBufferCount() {
        return this.buffer.nioBufferCount();
    }

    public ByteBuffer nioBuffer() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuffer nioBuffer(int n, int n2) {
        this.checkIndex(n, n2);
        return this.buffer.nioBuffer(n, n2);
    }

    public ByteBuffer[] nioBuffers() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuffer[] nioBuffers(int n, int n2) {
        this.checkIndex(n, n2);
        return this.buffer.nioBuffers(n, n2);
    }

    public ByteBuffer internalNioBuffer(int n, int n2) {
        this.checkIndex(n, n2);
        return this.buffer.internalNioBuffer(n, n2);
    }

    public String toString(int n, int n2, Charset charset) {
        this.checkIndex(n, n2);
        return this.buffer.toString(n, n2, charset);
    }

    public String toString(Charset charset) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public String toString() {
        return StringUtil.simpleClassName((Object)((Object)this)) + '(' + "ridx=" + this.readerIndex() + ", widx=" + this.writerIndex() + ')';
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isWritable(int n) {
        return false;
    }

    public int writableBytes() {
        return 0;
    }

    public int maxWritableBytes() {
        return 0;
    }

    public ByteBuf writeBoolean(boolean bl) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf writeByte(int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf writeBytes(byte[] byArray, int n, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf writeBytes(byte[] byArray) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf writeBytes(ByteBuffer byteBuffer) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf writeBytes(ByteBuf byteBuf, int n, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf writeBytes(ByteBuf byteBuf, int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf writeBytes(ByteBuf byteBuf) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public int writeBytes(InputStream inputStream, int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public int writeBytes(ScatteringByteChannel scatteringByteChannel, int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public int writeBytes(FileChannel fileChannel, long l, int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf writeInt(int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf writeIntLE(int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf writeLong(long l) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf writeLongLE(long l) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf writeMedium(int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf writeMediumLE(int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf writeZero(int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public int writerIndex() {
        return this.buffer.writerIndex();
    }

    public ByteBuf writerIndex(int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf writeShort(int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf writeShortLE(int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf writeChar(int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf writeFloat(float f) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf writeDouble(double d) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public int setCharSequence(int n, CharSequence charSequence, Charset charset) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public int writeCharSequence(CharSequence charSequence, Charset charset) {
        throw ReplayingDecoderByteBuf.reject();
    }

    private void checkIndex(int n, int n2) {
        if (n + n2 > this.buffer.writerIndex()) {
            throw REPLAY;
        }
    }

    private void checkReadableBytes(int n) {
        if (this.buffer.readableBytes() < n) {
            throw REPLAY;
        }
    }

    public ByteBuf discardSomeReadBytes() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public int refCnt() {
        return this.buffer.refCnt();
    }

    public ByteBuf retain() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf retain(int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf touch() {
        this.buffer.touch();
        return this;
    }

    public ByteBuf touch(Object object) {
        this.buffer.touch(object);
        return this;
    }

    public boolean release() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public boolean release(int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public ByteBuf unwrap() {
        throw ReplayingDecoderByteBuf.reject();
    }

    private static UnsupportedOperationException reject() {
        return new UnsupportedOperationException("not a replayable operation");
    }

    static {
        EMPTY_BUFFER.terminate();
    }
}

