/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import com.github.luben.zstd.ZstdInputStreamNoFinalizer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.compression.DecompressionException;
import io.netty.handler.codec.compression.Zstd;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public final class ZstdDecoder
extends ByteToMessageDecoder {
    private final MutableByteBufInputStream inputStream;
    private ZstdInputStreamNoFinalizer zstdIs;
    private State currentState;

    public ZstdDecoder() {
        try {
            Zstd.ensureAvailability();
        }
        catch (Throwable throwable) {
            throw new ExceptionInInitializerError(throwable);
        }
        this.inputStream = new MutableByteBufInputStream();
        this.currentState = State.DECOMPRESS_DATA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        try {
            if (this.currentState == State.CORRUPTED) {
                byteBuf.skipBytes(byteBuf.readableBytes());
                return;
            }
            int n = byteBuf.readableBytes();
            this.inputStream.current = byteBuf;
            ByteBuf byteBuf2 = null;
            try {
                int n2;
                do {
                    if (byteBuf2 == null) {
                        byteBuf2 = channelHandlerContext.alloc().heapBuffer(n * 2);
                    }
                    while ((n2 = byteBuf2.writeBytes((InputStream)this.zstdIs, byteBuf2.writableBytes())) != -1 && byteBuf2.isWritable()) {
                    }
                    if (!byteBuf2.isReadable()) continue;
                    list.add(byteBuf2);
                    byteBuf2 = null;
                } while (n2 != -1);
            }
            finally {
                if (byteBuf2 != null) {
                    byteBuf2.release();
                }
            }
        }
        catch (Exception exception) {
            this.currentState = State.CORRUPTED;
            throw new DecompressionException(exception);
        }
        finally {
            this.inputStream.current = null;
        }
    }

    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        super.handlerAdded(channelHandlerContext);
        this.zstdIs = new ZstdInputStreamNoFinalizer((InputStream)this.inputStream);
        this.zstdIs.setContinuous(true);
    }

    @Override
    protected void handlerRemoved0(ChannelHandlerContext channelHandlerContext) {
        try {
            ZstdDecoder.closeSilently((Closeable)this.zstdIs);
        }
        finally {
            super.handlerRemoved0(channelHandlerContext);
        }
    }

    private static void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static final class MutableByteBufInputStream
    extends InputStream {
        ByteBuf current;

        private MutableByteBufInputStream() {
        }

        @Override
        public int read() {
            if (this.current == null || !this.current.isReadable()) {
                return -1;
            }
            return this.current.readByte() & 0xFF;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) {
            int n3 = this.available();
            if (n3 == 0) {
                return -1;
            }
            n2 = Math.min(n3, n2);
            this.current.readBytes(byArray, n, n2);
            return n2;
        }

        @Override
        public int available() {
            return this.current == null ? 0 : this.current.readableBytes();
        }
    }

    private static enum State {
        DECOMPRESS_DATA,
        CORRUPTED;

    }
}

