/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.protobuf;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.CorruptedFrameException;
import java.util.List;

public class ProtobufVarint32FrameDecoder
extends ByteToMessageDecoder {
    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        byteBuf.markReaderIndex();
        int n = byteBuf.readerIndex();
        int n2 = ProtobufVarint32FrameDecoder.readRawVarint32(byteBuf);
        if (n == byteBuf.readerIndex()) {
            return;
        }
        if (n2 < 0) {
            throw new CorruptedFrameException("negative length: " + n2);
        }
        if (byteBuf.readableBytes() < n2) {
            byteBuf.resetReaderIndex();
        } else {
            list.add(byteBuf.readRetainedSlice(n2));
        }
    }

    static int readRawVarint32(ByteBuf byteBuf) {
        if (byteBuf.readableBytes() < 4) {
            return ProtobufVarint32FrameDecoder.readRawVarint24(byteBuf);
        }
        int n = byteBuf.getIntLE(byteBuf.readerIndex());
        int n2 = ~n & 0x80808080;
        if (n2 == 0) {
            return ProtobufVarint32FrameDecoder.readRawVarint40(byteBuf, n);
        }
        int n3 = Integer.numberOfTrailingZeros(n2) + 1;
        byteBuf.skipBytes(n3 >> 3);
        int n4 = n2 ^ n2 - 1;
        int n5 = n & n4;
        n5 = n5 & 0x7F007F | (n5 & 0x7F007F00) >> 1;
        return n5 & 0x3FFF | (n5 & 0x3FFF0000) >> 2;
    }

    private static int readRawVarint40(ByteBuf byteBuf, int n) {
        byte by;
        if (byteBuf.readableBytes() == 4 || (by = byteBuf.getByte(byteBuf.readerIndex() + 4)) < 0) {
            throw new CorruptedFrameException("malformed varint.");
        }
        byteBuf.skipBytes(5);
        return n & 0x7F | (n >> 8 & 0x7F) << 7 | (n >> 16 & 0x7F) << 14 | (n >> 24 & 0x7F) << 21 | by << 28;
    }

    private static int readRawVarint24(ByteBuf byteBuf) {
        if (!byteBuf.isReadable()) {
            return 0;
        }
        byteBuf.markReaderIndex();
        byte by = byteBuf.readByte();
        if (by >= 0) {
            return by;
        }
        int n = by & 0x7F;
        if (!byteBuf.isReadable()) {
            byteBuf.resetReaderIndex();
            return 0;
        }
        by = byteBuf.readByte();
        if (by >= 0) {
            return n | by << 7;
        }
        n |= (by & 0x7F) << 7;
        if (!byteBuf.isReadable()) {
            byteBuf.resetReaderIndex();
            return 0;
        }
        by = byteBuf.readByte();
        if (by >= 0) {
            return n | by << 14;
        }
        return n | (by & 0x7F) << 14;
    }
}

