/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty.http2;

import io.ktor.http.URLUtilsKt;
import io.ktor.http.Url;
import io.ktor.server.application.Application;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.netty.NettyApplicationCallHandler;
import io.ktor.server.netty.NettyHttpHandlerState;
import io.ktor.server.netty.cio.NettyHttpResponsePipeline;
import io.ktor.server.netty.http2.NettyHttp2ApplicationCall;
import io.ktor.server.netty.http2.NettyHttp2ApplicationRequest;
import io.ktor.server.response.ResponsePushBuilder;
import io.ktor.server.response.UseHttp2Push;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2MultiplexCodec;
import io.netty.handler.codec.http2.Http2ResetFrame;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelBootstrap;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.channels.ClosedChannelException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.E;
import kotlinx.coroutines.Z;
import kotlinx.coroutines.aS;
import kotlinx.coroutines.aw;
import kotlinx.coroutines.channels.j;
import kotlinx.coroutines.channels.w;
import kotlinx.coroutines.y;

@ChannelHandler.Sharable
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0001\u0018\u0000 O2\u00020\u00012\u00020\u0002:\u0002POB/\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0017J\u001f\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010 \u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b \u0010!J\u001f\u0010&\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\"H\u0001\u00a2\u0006\u0004\b$\u0010%J\u001b\u0010)\u001a\u00020\u0013*\u00020'2\u0006\u0010(\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b)\u0010*J#\u00101\u001a\u000200*\u00020+2\u0006\u0010-\u001a\u00020,2\u0006\u0010/\u001a\u00020.H\u0002\u00a2\u0006\u0004\b1\u00102J\u0018\u00105\u001a\u000204*\u0006\u0012\u0002\b\u000303H\u0082\u0010\u00a2\u0006\u0004\b5\u00106R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u00107R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u00108R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u00109R\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010:R\u0014\u0010<\u001a\u00020;8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b<\u0010=R\u0014\u0010?\u001a\u00020>8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b?\u0010@R\u0016\u0010B\u001a\u00020A8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\bB\u0010CR\u0014\u0010F\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u0010ER\u001d\u0010K\u001a\u0004\u0018\u0001048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bG\u0010H\u001a\u0004\bI\u0010JR\u0018\u0010N\u001a\u000204*\u00020+8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bL\u0010M\u00a8\u0006Q"}, d2={"Lio/ktor/server/netty/http2/NettyHttp2Handler;", "Lio/netty/channel/ChannelInboundHandlerAdapter;", "Lkotlinx/coroutines/CoroutineScope;", "Lio/ktor/server/engine/EnginePipeline;", "enginePipeline", "Lio/ktor/server/application/Application;", "application", "Lio/netty/util/concurrent/EventExecutorGroup;", "callEventGroup", "Lkotlin/coroutines/CoroutineContext;", "userCoroutineContext", "", "runningLimit", "<init>", "(Lio/ktor/server/engine/EnginePipeline;Lio/ktor/server/application/Application;Lio/netty/util/concurrent/EventExecutorGroup;Lkotlin/coroutines/CoroutineContext;I)V", "Lio/netty/channel/ChannelHandlerContext;", "context", "", "message", "", "channelRead", "(Lio/netty/channel/ChannelHandlerContext;Ljava/lang/Object;)V", "channelActive", "(Lio/netty/channel/ChannelHandlerContext;)V", "channelReadComplete", "ctx", "", "cause", "exceptionCaught", "(Lio/netty/channel/ChannelHandlerContext;Ljava/lang/Throwable;)V", "Lio/netty/handler/codec/http2/Http2Headers;", "headers", "startHttp2", "(Lio/netty/channel/ChannelHandlerContext;Lio/netty/handler/codec/http2/Http2Headers;)V", "Lio/ktor/server/response/ResponsePushBuilder;", "builder", "startHttp2PushPromise$ktor_server_netty", "(Lio/netty/channel/ChannelHandlerContext;Lio/ktor/server/response/ResponsePushBuilder;)V", "startHttp2PushPromise", "Lio/netty/handler/codec/http2/Http2StreamChannel;", "streamId", "setId", "(Lio/netty/handler/codec/http2/Http2StreamChannel;I)V", "Lio/netty/handler/codec/http2/Http2FrameStream;", "Lio/netty/handler/codec/http2/Http2FrameCodec;", "codec", "Lio/netty/handler/codec/http2/Http2Stream;", "childStream", "", "setStreamAndProperty", "(Lio/netty/handler/codec/http2/Http2FrameStream;Lio/netty/handler/codec/http2/Http2FrameCodec;Lio/netty/handler/codec/http2/Http2Stream;)Z", "Ljava/lang/Class;", "Ljava/lang/reflect/Field;", "findIdField", "(Ljava/lang/Class;)Ljava/lang/reflect/Field;", "Lio/ktor/server/engine/EnginePipeline;", "Lio/ktor/server/application/Application;", "Lio/netty/util/concurrent/EventExecutorGroup;", "Lkotlin/coroutines/CoroutineContext;", "Lkotlinx/coroutines/CompletableJob;", "handlerJob", "Lkotlinx/coroutines/CompletableJob;", "Lio/ktor/server/netty/NettyHttpHandlerState;", "state", "Lio/ktor/server/netty/NettyHttpHandlerState;", "Lio/ktor/server/netty/cio/NettyHttpResponsePipeline;", "responseWriter", "Lio/ktor/server/netty/cio/NettyHttpResponsePipeline;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "coroutineContext", "streamKeyField$delegate", "Lkotlin/Lazy;", "getStreamKeyField", "()Ljava/lang/reflect/Field;", "streamKeyField", "getIdField", "(Lio/netty/handler/codec/http2/Http2FrameStream;)Ljava/lang/reflect/Field;", "idField", "Companion", "Http2ClosedChannelException", "ktor-server-netty"})
public final class NettyHttp2Handler
extends ChannelInboundHandlerAdapter
implements CoroutineScope {
    public static final Companion Companion = new Companion(null);
    private final EnginePipeline enginePipeline;
    private final Application application;
    private final EventExecutorGroup callEventGroup;
    private final CoroutineContext userCoroutineContext;
    private final y handlerJob;
    private final NettyHttpHandlerState state;
    private NettyHttpResponsePipeline responseWriter;
    private final Lazy streamKeyField$delegate;
    private static final AttributeKey<NettyHttp2ApplicationCall> ApplicationCallKey = AttributeKey.newInstance((String)"ktor.ApplicationCall");

    public NettyHttp2Handler(EnginePipeline enginePipeline, Application application, EventExecutorGroup eventExecutorGroup, CoroutineContext coroutineContext, int n2) {
        Intrinsics.checkNotNullParameter((Object)enginePipeline, (String)"");
        Intrinsics.checkNotNullParameter((Object)application, (String)"");
        Intrinsics.checkNotNullParameter((Object)eventExecutorGroup, (String)"");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"");
        this.enginePipeline = enginePipeline;
        this.application = application;
        this.callEventGroup = eventExecutorGroup;
        this.userCoroutineContext = coroutineContext;
        this.handlerJob = aS.a((aw)((aw)this.userCoroutineContext.get((CoroutineContext.Key)aw.a)));
        this.state = new NettyHttpHandlerState(n2);
        this.streamKeyField$delegate = LazyKt.lazy(NettyHttp2Handler::streamKeyField_delegate$lambda$6);
    }

    public CoroutineContext getCoroutineContext() {
        return (CoroutineContext)this.handlerJob;
    }

    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        Intrinsics.checkNotNullParameter((Object)channelHandlerContext, (String)"");
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Object object2 = object;
        if (object2 instanceof Http2HeadersFrame) {
            NettyHttpHandlerState.isChannelReadCompleted$FU$internal.compareAndSet(this.state, 1, 0);
            NettyHttpHandlerState.activeRequests$FU$internal.incrementAndGet(this.state);
            Http2Headers http2Headers = ((Http2HeadersFrame)object).headers();
            Intrinsics.checkNotNullExpressionValue((Object)http2Headers, (String)"");
            this.startHttp2(channelHandlerContext, http2Headers);
        } else if (object2 instanceof Http2DataFrame) {
            Object object3 = NettyHttp2Handler.Companion.getApplicationCall(channelHandlerContext);
            if (object3 != null && (object3 = object3.getRequest()) != null) {
                boolean bl;
                Object object4;
                Object object5 = object4 = object3;
                boolean bl2 = false;
                boolean bl3 = ((Http2DataFrame)object).isEndStream();
                j.a((Object)((NettyHttp2ApplicationRequest)((Object)object5)).getContentActor().trySend-JP2dKIU(object));
                if (bl3) {
                    w.a.a(((NettyHttp2ApplicationRequest)((Object)object5)).getContentActor(), null, (int)1, null);
                    bl = NettyHttpHandlerState.isCurrentRequestFullyRead$FU$internal.compareAndSet(this.state, 0, 1);
                } else {
                    bl = NettyHttpHandlerState.isCurrentRequestFullyRead$FU$internal.compareAndSet(this.state, 1, 0);
                }
            } else {
                ((Http2DataFrame)object).release();
            }
        } else if (object2 instanceof Http2ResetFrame) {
            Object object6 = NettyHttp2Handler.Companion.getApplicationCall(channelHandlerContext);
            if (object6 != null && (object6 = object6.getRequest()) != null) {
                NettyHttp2ApplicationCall nettyHttp2ApplicationCall = object6;
                boolean bl = false;
                Http2ClosedChannelException http2ClosedChannelException = ((Http2ResetFrame)object).errorCode() == 0L ? null : new Http2ClosedChannelException(((Http2ResetFrame)object).errorCode());
                ((NettyHttp2ApplicationRequest)((Object)nettyHttp2ApplicationCall)).getContentActor().close((Throwable)http2ClosedChannelException);
            }
        } else {
            channelHandlerContext.fireChannelRead(object);
        }
    }

    public void channelActive(ChannelHandlerContext channelHandlerContext) {
        Intrinsics.checkNotNullParameter((Object)channelHandlerContext, (String)"");
        this.responseWriter = new NettyHttpResponsePipeline(channelHandlerContext, this.state, this.getCoroutineContext());
        ChannelPipeline channelPipeline = channelHandlerContext.pipeline();
        if (channelPipeline != null) {
            ChannelPipeline channelPipeline2;
            ChannelPipeline channelPipeline3 = channelPipeline2 = channelPipeline;
            boolean bl = false;
            ChannelHandler[] channelHandlerArray = new ChannelHandler[]{new NettyApplicationCallHandler(this.userCoroutineContext, this.enginePipeline)};
            channelPipeline3.addLast(this.callEventGroup, channelHandlerArray);
        }
        channelHandlerContext.fireChannelActive();
    }

    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        Intrinsics.checkNotNullParameter((Object)channelHandlerContext, (String)"");
        NettyHttpHandlerState.isChannelReadCompleted$FU$internal.compareAndSet(this.state, 0, 1);
        NettyHttpResponsePipeline nettyHttpResponsePipeline = this.responseWriter;
        if (nettyHttpResponsePipeline == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"");
            nettyHttpResponsePipeline = null;
        }
        nettyHttpResponsePipeline.flushIfNeeded$ktor_server_netty();
        channelHandlerContext.fireChannelReadComplete();
    }

    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)channelHandlerContext, (String)"");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"");
        channelHandlerContext.close();
    }

    private final void startHttp2(ChannelHandlerContext channelHandlerContext, Http2Headers http2Headers) {
        NettyHttp2ApplicationCall nettyHttp2ApplicationCall = new NettyHttp2ApplicationCall(this.application, channelHandlerContext, http2Headers, this, this.handlerJob.plus((CoroutineContext)Z.c()), this.userCoroutineContext);
        NettyHttp2Handler.Companion.setApplicationCall(channelHandlerContext, nettyHttp2ApplicationCall);
        channelHandlerContext.fireChannelRead((Object)nettyHttp2ApplicationCall);
        NettyHttpResponsePipeline nettyHttpResponsePipeline = this.responseWriter;
        if (nettyHttpResponsePipeline == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"");
            nettyHttpResponsePipeline = null;
        }
        nettyHttpResponsePipeline.processResponse$ktor_server_netty(nettyHttp2ApplicationCall);
    }

    @UseHttp2Push
    public final void startHttp2PushPromise$ktor_server_netty(ChannelHandlerContext channelHandlerContext, ResponsePushBuilder responsePushBuilder) {
        DefaultHttp2Headers defaultHttp2Headers;
        Intrinsics.checkNotNullParameter((Object)channelHandlerContext, (String)"");
        Intrinsics.checkNotNullParameter((Object)responsePushBuilder, (String)"");
        Channel channel = channelHandlerContext.channel();
        Intrinsics.checkNotNull((Object)channel);
        Http2StreamChannel http2StreamChannel = (Http2StreamChannel)channel;
        int n2 = http2StreamChannel.stream().id();
        ChannelHandler channelHandler = http2StreamChannel.parent().pipeline().get(Http2MultiplexCodec.class);
        Intrinsics.checkNotNull((Object)channelHandler);
        Http2MultiplexCodec http2MultiplexCodec = (Http2MultiplexCodec)channelHandler;
        Http2Connection http2Connection = http2MultiplexCodec.connection();
        if (!http2Connection.remote().allowPushTo()) {
            return;
        }
        ChannelHandlerContext channelHandlerContext2 = http2StreamChannel.parent().pipeline().lastContext();
        int n3 = http2Connection.local().incrementAndGetNextStreamId();
        DefaultHttp2Headers defaultHttp2Headers2 = defaultHttp2Headers = new DefaultHttp2Headers();
        boolean bl = false;
        Url url = responsePushBuilder.getUrl().build();
        defaultHttp2Headers2.method((CharSequence)responsePushBuilder.getMethod().getValue());
        defaultHttp2Headers2.authority((CharSequence)URLUtilsKt.getHostWithPort((Url)url));
        defaultHttp2Headers2.scheme((CharSequence)url.getProtocol().getName());
        defaultHttp2Headers2.path((CharSequence)url.getEncodedPathAndQuery());
        DefaultHttp2Headers defaultHttp2Headers3 = defaultHttp2Headers;
        defaultHttp2Headers = new Http2StreamChannelBootstrap(http2StreamChannel.parent()).handler((ChannelHandler)this);
        defaultHttp2Headers2 = (Http2StreamChannel)defaultHttp2Headers.open().get();
        Intrinsics.checkNotNull((Object)defaultHttp2Headers2);
        this.setId((Http2StreamChannel)defaultHttp2Headers2, n3);
        ChannelPromise channelPromise = channelHandlerContext2.newPromise();
        url = http2Connection.local().createStream(n3, false);
        Http2FrameStream http2FrameStream = defaultHttp2Headers2.stream();
        Intrinsics.checkNotNullExpressionValue((Object)http2FrameStream, (String)"");
        Http2FrameCodec http2FrameCodec = (Http2FrameCodec)http2MultiplexCodec;
        Intrinsics.checkNotNull((Object)url);
        if (!this.setStreamAndProperty(http2FrameStream, http2FrameCodec, (Http2Stream)url)) {
            url.close();
            defaultHttp2Headers2.close();
            return;
        }
        http2MultiplexCodec.encoder().frameWriter().writePushPromise(channelHandlerContext2, n2, n3, (Http2Headers)defaultHttp2Headers3, 0, channelPromise);
        if (channelPromise.isSuccess()) {
            ChannelHandlerContext channelHandlerContext3 = defaultHttp2Headers2.pipeline().firstContext();
            Intrinsics.checkNotNullExpressionValue((Object)channelHandlerContext3, (String)"");
            this.startHttp2(channelHandlerContext3, (Http2Headers)defaultHttp2Headers3);
        } else {
            channelPromise.addListener(arg_0 -> NettyHttp2Handler.startHttp2PushPromise$lambda$4(this, (Http2StreamChannel)defaultHttp2Headers2, defaultHttp2Headers3, arg_0));
        }
    }

    private final void setId(Http2StreamChannel http2StreamChannel, int n2) {
        Http2FrameStream http2FrameStream = http2StreamChannel.stream();
        Intrinsics.checkNotNull((Object)http2FrameStream);
        Http2FrameStream http2FrameStream2 = http2FrameStream;
        this.getIdField(http2FrameStream2).setInt(http2FrameStream2, n2);
    }

    private final Field getStreamKeyField() {
        Lazy lazy = this.streamKeyField$delegate;
        return (Field)lazy.getValue();
    }

    private final boolean setStreamAndProperty(Http2FrameStream http2FrameStream, Http2FrameCodec http2FrameCodec, Http2Stream http2Stream) {
        Object[] objectArray;
        Object object;
        Http2Connection.PropertyKey propertyKey;
        Object[] objectArray2;
        block5: {
            Field field = this.getStreamKeyField();
            objectArray2 = field != null ? field.get(http2FrameCodec) : null;
            Http2Connection.PropertyKey propertyKey2 = objectArray2 instanceof Http2Connection.PropertyKey ? (Http2Connection.PropertyKey)objectArray2 : null;
            if (propertyKey2 == null) {
                return false;
            }
            propertyKey = propertyKey2;
            Method[] methodArray = http2FrameStream.getClass().getDeclaredMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"");
            Object[] objectArray3 = methodArray;
            boolean bl = false;
            for (Object object2 : objectArray3) {
                Method method = (Method)object2;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)method.getName(), (Object)"setStreamAndProperty")) continue;
                object = object2;
                break block5;
            }
            object = null;
        }
        objectArray2 = (Method)object;
        if (objectArray2 == null) {
            return false;
        }
        Object[] objectArray4 = objectArray = objectArray2;
        int n2 = 0;
        objectArray4.setAccessible(true);
        Object[] objectArray5 = objectArray;
        try {
            objectArray2 = new Object[]{propertyKey, http2Stream};
            objectArray5.invoke((Object)http2FrameStream, objectArray2);
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    private final Field getIdField(Http2FrameStream http2FrameStream) {
        return this.findIdField(http2FrameStream.getClass());
    }

    private final Field findIdField(Class<?> annotatedElement) {
        NettyHttp2Handler nettyHttp2Handler = this;
        while (true) {
            AnnotatedElement annotatedElement2;
            try {
                annotatedElement2 = annotatedElement.getDeclaredField("id");
            }
            catch (NoSuchFieldException noSuchFieldException) {
                annotatedElement2 = null;
            }
            Field field = annotatedElement2;
            if (field != null) {
                field.setAccessible(true);
                return field;
            }
            Class<?> clazz = annotatedElement.getSuperclass();
            if (clazz == null) {
                throw new NoSuchFieldException("id field not found");
            }
            annotatedElement2 = clazz;
            annotatedElement = annotatedElement2;
        }
    }

    private static final void startHttp2PushPromise$lambda$4(NettyHttp2Handler nettyHttp2Handler, Http2StreamChannel http2StreamChannel, DefaultHttp2Headers defaultHttp2Headers, Future future) {
        future.get();
        ChannelHandlerContext channelHandlerContext = http2StreamChannel.pipeline().firstContext();
        Intrinsics.checkNotNullExpressionValue((Object)channelHandlerContext, (String)"");
        nettyHttp2Handler.startHttp2(channelHandlerContext, (Http2Headers)defaultHttp2Headers);
    }

    private static final Field streamKeyField_delegate$lambda$6() {
        Field field;
        try {
            Field field2 = field = Http2FrameCodec.class.getDeclaredField("streamKey");
            boolean bl = false;
            field2.setAccessible(true);
        }
        catch (Throwable throwable) {
            field = null;
        }
        return field;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R8\u0010\u0007\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\bR,\u0010\u000f\u001a\u0004\u0018\u00010\u0005*\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00058B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lio/ktor/server/netty/http2/NettyHttp2Handler$Companion;", "", "<init>", "()V", "Lio/netty/util/AttributeKey;", "Lio/ktor/server/netty/http2/NettyHttp2ApplicationCall;", "kotlin.jvm.PlatformType", "ApplicationCallKey", "Lio/netty/util/AttributeKey;", "Lio/netty/channel/ChannelHandlerContext;", "newValue", "getApplicationCall", "(Lio/netty/channel/ChannelHandlerContext;)Lio/ktor/server/netty/http2/NettyHttp2ApplicationCall;", "setApplicationCall", "(Lio/netty/channel/ChannelHandlerContext;Lio/ktor/server/netty/http2/NettyHttp2ApplicationCall;)V", "applicationCall", "ktor-server-netty"})
    public static final class Companion {
        private Companion() {
        }

        private final NettyHttp2ApplicationCall getApplicationCall(ChannelHandlerContext channelHandlerContext) {
            return (NettyHttp2ApplicationCall)((Object)channelHandlerContext.channel().attr(ApplicationCallKey).get());
        }

        private final void setApplicationCall(ChannelHandlerContext channelHandlerContext, NettyHttp2ApplicationCall nettyHttp2ApplicationCall) {
            channelHandlerContext.channel().attr(ApplicationCallKey).set((Object)nettyHttp2ApplicationCall);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0000H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\t\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u000f\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lio/ktor/server/netty/http2/NettyHttp2Handler$Http2ClosedChannelException;", "Ljava/nio/channels/ClosedChannelException;", "Lkotlinx/coroutines/CopyableThrowable;", "", "errorCode", "<init>", "(J)V", "createCopy", "()Lio/ktor/server/netty/http2/NettyHttp2Handler$Http2ClosedChannelException;", "J", "getErrorCode", "()J", "", "getMessage", "()Ljava/lang/String;", "message", "ktor-server-netty"})
    private static final class Http2ClosedChannelException
    extends ClosedChannelException
    implements E<Http2ClosedChannelException> {
        private final long errorCode;

        public Http2ClosedChannelException(long l) {
            this.errorCode = l;
        }

        public final long getErrorCode() {
            return this.errorCode;
        }

        @Override
        public String getMessage() {
            return "Got close frame with code " + this.errorCode;
        }

        public Http2ClosedChannelException createCopy() {
            Http2ClosedChannelException http2ClosedChannelException;
            Http2ClosedChannelException http2ClosedChannelException2 = http2ClosedChannelException = new Http2ClosedChannelException(this.errorCode);
            boolean bl = false;
            http2ClosedChannelException2.initCause(this);
            return http2ClosedChannelException;
        }
    }
}

