/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AbstractCoalescingBufferQueue;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.CoalescingBufferQueue;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http2.DefaultHttp2RemoteFlowController;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameSizePolicy;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.handler.codec.http2.Http2LifecycleManager;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2SettingsReceivedConsumer;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayDeque;
import java.util.Queue;

public class DefaultHttp2ConnectionEncoder
implements Http2ConnectionEncoder,
Http2SettingsReceivedConsumer {
    private final Http2FrameWriter frameWriter;
    private final Http2Connection connection;
    private Http2LifecycleManager lifecycleManager;
    private final Queue<Http2Settings> outstandingLocalSettingsQueue = new ArrayDeque<Http2Settings>(4);
    private Queue<Http2Settings> outstandingRemoteSettingsQueue;

    public DefaultHttp2ConnectionEncoder(Http2Connection http2Connection, Http2FrameWriter http2FrameWriter) {
        this.connection = (Http2Connection)ObjectUtil.checkNotNull((Object)http2Connection, (String)"connection");
        this.frameWriter = (Http2FrameWriter)ObjectUtil.checkNotNull((Object)http2FrameWriter, (String)"frameWriter");
        if (http2Connection.remote().flowController() == null) {
            http2Connection.remote().flowController(new DefaultHttp2RemoteFlowController(http2Connection));
        }
    }

    @Override
    public void lifecycleManager(Http2LifecycleManager http2LifecycleManager) {
        this.lifecycleManager = (Http2LifecycleManager)ObjectUtil.checkNotNull((Object)http2LifecycleManager, (String)"lifecycleManager");
    }

    @Override
    public Http2FrameWriter frameWriter() {
        return this.frameWriter;
    }

    @Override
    public Http2Connection connection() {
        return this.connection;
    }

    @Override
    public final Http2RemoteFlowController flowController() {
        return this.connection().remote().flowController();
    }

    @Override
    public void remoteSettings(Http2Settings http2Settings) {
        Integer n;
        Integer n2;
        Long l;
        Long l2;
        Long l3;
        Boolean bl = http2Settings.pushEnabled();
        Http2FrameWriter.Configuration configuration = this.configuration();
        Http2HeadersEncoder.Configuration configuration2 = configuration.headersConfiguration();
        Http2FrameSizePolicy http2FrameSizePolicy = configuration.frameSizePolicy();
        if (bl != null) {
            if (!this.connection.isServer() && bl.booleanValue()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Client received a value of ENABLE_PUSH specified to other than 0", new Object[0]);
            }
            this.connection.remote().allowPushTo(bl);
        }
        if ((l3 = http2Settings.maxConcurrentStreams()) != null) {
            this.connection.local().maxActiveStreams((int)Math.min(l3, Integer.MAX_VALUE));
        }
        if ((l2 = http2Settings.headerTableSize()) != null) {
            configuration2.maxHeaderTableSize(l2);
        }
        if ((l = http2Settings.maxHeaderListSize()) != null) {
            configuration2.maxHeaderListSize(l);
        }
        if ((n2 = http2Settings.maxFrameSize()) != null) {
            http2FrameSizePolicy.maxFrameSize(n2);
        }
        if ((n = http2Settings.initialWindowSize()) != null) {
            this.flowController().initialWindowSize(n);
        }
    }

    @Override
    public ChannelFuture writeData(ChannelHandlerContext channelHandlerContext, int n, ByteBuf byteBuf, int n2, boolean bl, ChannelPromise channelPromise) {
        Http2Stream http2Stream;
        channelPromise = channelPromise.unvoid();
        try {
            http2Stream = this.requireStream(n);
            switch (http2Stream.state()) {
                case OPEN: 
                case HALF_CLOSED_REMOTE: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Stream " + http2Stream.id() + " in unexpected state " + (Object)((Object)http2Stream.state()));
                }
            }
        }
        catch (Throwable throwable) {
            byteBuf.release();
            return channelPromise.setFailure(throwable);
        }
        this.flowController().addFlowControlled(http2Stream, new FlowControlledData(http2Stream, byteBuf, n2, bl, channelPromise));
        return channelPromise;
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, boolean bl, ChannelPromise channelPromise) {
        return this.writeHeaders0(channelHandlerContext, n, http2Headers, false, 0, (short)0, false, n2, bl, channelPromise);
    }

    private static boolean validateHeadersSentState(Http2Stream http2Stream, Http2Headers http2Headers, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = bl && HttpStatusClass.valueOf((CharSequence)http2Headers.status()) == HttpStatusClass.INFORMATIONAL;
        if ((bl3 || !bl2) && http2Stream.isHeadersSent() || http2Stream.isTrailersSent()) {
            throw new IllegalStateException("Stream " + http2Stream.id() + " sent too many headers EOS: " + bl2);
        }
        return bl3;
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, short s, boolean bl, int n3, boolean bl2, ChannelPromise channelPromise) {
        return this.writeHeaders0(channelHandlerContext, n, http2Headers, true, n2, s, bl, n3, bl2, channelPromise);
    }

    private static ChannelFuture sendHeaders(Http2FrameWriter http2FrameWriter, ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, boolean bl, int n2, short s, boolean bl2, int n3, boolean bl3, ChannelPromise channelPromise) {
        if (bl) {
            return http2FrameWriter.writeHeaders(channelHandlerContext, n, http2Headers, n2, s, bl2, n3, bl3, channelPromise);
        }
        return http2FrameWriter.writeHeaders(channelHandlerContext, n, http2Headers, n3, bl3, channelPromise);
    }

    private ChannelFuture writeHeaders0(ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, boolean bl, int n2, short s, boolean bl2, int n3, boolean bl3, ChannelPromise channelPromise) {
        try {
            Http2Stream http2Stream = this.connection.stream(n);
            if (http2Stream == null) {
                try {
                    http2Stream = this.connection.local().createStream(n, false);
                }
                catch (Http2Exception http2Exception) {
                    if (this.connection.remote().mayHaveCreatedStream(n)) {
                        channelPromise.tryFailure((Throwable)new IllegalStateException("Stream no longer exists: " + n, http2Exception));
                        return channelPromise;
                    }
                    throw http2Exception;
                }
            } else {
                switch (http2Stream.state()) {
                    case RESERVED_LOCAL: {
                        http2Stream.open(bl3);
                        break;
                    }
                    case OPEN: 
                    case HALF_CLOSED_REMOTE: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Stream " + http2Stream.id() + " in unexpected state " + (Object)((Object)http2Stream.state()));
                    }
                }
            }
            Http2RemoteFlowController http2RemoteFlowController = this.flowController();
            if (!bl3 || !http2RemoteFlowController.hasFlowControlled(http2Stream)) {
                channelPromise = channelPromise.unvoid();
                boolean bl4 = DefaultHttp2ConnectionEncoder.validateHeadersSentState(http2Stream, http2Headers, this.connection.isServer(), bl3);
                ChannelFuture channelFuture = DefaultHttp2ConnectionEncoder.sendHeaders(this.frameWriter, channelHandlerContext, n, http2Headers, bl, n2, s, bl2, n3, bl3, channelPromise);
                Throwable throwable = channelFuture.cause();
                if (throwable == null) {
                    http2Stream.headersSent(bl4);
                    if (!channelFuture.isSuccess()) {
                        this.notifyLifecycleManagerOnError(channelFuture, channelHandlerContext);
                    }
                } else {
                    this.lifecycleManager.onError(channelHandlerContext, true, throwable);
                }
                if (bl3) {
                    this.lifecycleManager.closeStreamLocal(http2Stream, channelFuture);
                }
                return channelFuture;
            }
            http2RemoteFlowController.addFlowControlled(http2Stream, new FlowControlledHeaders(http2Stream, http2Headers, bl, n2, s, bl2, n3, true, channelPromise));
            return channelPromise;
        }
        catch (Throwable throwable) {
            this.lifecycleManager.onError(channelHandlerContext, true, throwable);
            channelPromise.tryFailure(throwable);
            return channelPromise;
        }
    }

    @Override
    public ChannelFuture writePriority(ChannelHandlerContext channelHandlerContext, int n, int n2, short s, boolean bl, ChannelPromise channelPromise) {
        return this.frameWriter.writePriority(channelHandlerContext, n, n2, s, bl, channelPromise);
    }

    @Override
    public ChannelFuture writeRstStream(ChannelHandlerContext channelHandlerContext, int n, long l, ChannelPromise channelPromise) {
        return this.lifecycleManager.resetStream(channelHandlerContext, n, l, channelPromise);
    }

    @Override
    public ChannelFuture writeSettings(ChannelHandlerContext channelHandlerContext, Http2Settings http2Settings, ChannelPromise channelPromise) {
        this.outstandingLocalSettingsQueue.add(http2Settings);
        try {
            Boolean bl = http2Settings.pushEnabled();
            if (bl != null && this.connection.isServer()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Server sending SETTINGS frame with ENABLE_PUSH specified", new Object[0]);
            }
        }
        catch (Throwable throwable) {
            return channelPromise.setFailure(throwable);
        }
        return this.frameWriter.writeSettings(channelHandlerContext, http2Settings, channelPromise);
    }

    @Override
    public ChannelFuture writeSettingsAck(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        if (this.outstandingRemoteSettingsQueue == null) {
            return this.frameWriter.writeSettingsAck(channelHandlerContext, channelPromise);
        }
        Http2Settings http2Settings = this.outstandingRemoteSettingsQueue.poll();
        if (http2Settings == null) {
            return channelPromise.setFailure((Throwable)new Http2Exception(Http2Error.INTERNAL_ERROR, "attempted to write a SETTINGS ACK with no  pending SETTINGS"));
        }
        Http2CodecUtil.SimpleChannelPromiseAggregator simpleChannelPromiseAggregator = new Http2CodecUtil.SimpleChannelPromiseAggregator(channelPromise, channelHandlerContext.channel(), channelHandlerContext.executor());
        this.frameWriter.writeSettingsAck(channelHandlerContext, simpleChannelPromiseAggregator.newPromise());
        ChannelPromise channelPromise2 = simpleChannelPromiseAggregator.newPromise();
        try {
            this.remoteSettings(http2Settings);
            channelPromise2.setSuccess();
        }
        catch (Throwable throwable) {
            channelPromise2.setFailure(throwable);
            this.lifecycleManager.onError(channelHandlerContext, true, throwable);
        }
        return simpleChannelPromiseAggregator.doneAllocatingPromises();
    }

    @Override
    public ChannelFuture writePing(ChannelHandlerContext channelHandlerContext, boolean bl, long l, ChannelPromise channelPromise) {
        return this.frameWriter.writePing(channelHandlerContext, bl, l, channelPromise);
    }

    @Override
    public ChannelFuture writePushPromise(ChannelHandlerContext channelHandlerContext, int n, int n2, Http2Headers http2Headers, int n3, ChannelPromise channelPromise) {
        try {
            if (this.connection.goAwayReceived()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Sending PUSH_PROMISE after GO_AWAY received.", new Object[0]);
            }
            Http2Stream http2Stream = this.requireStream(n);
            this.connection.local().reservePushStream(n2, http2Stream);
            channelPromise = channelPromise.unvoid();
            ChannelFuture channelFuture = this.frameWriter.writePushPromise(channelHandlerContext, n, n2, http2Headers, n3, channelPromise);
            Throwable throwable = channelFuture.cause();
            if (throwable == null) {
                http2Stream.pushPromiseSent();
                if (!channelFuture.isSuccess()) {
                    this.notifyLifecycleManagerOnError(channelFuture, channelHandlerContext);
                }
            } else {
                this.lifecycleManager.onError(channelHandlerContext, true, throwable);
            }
            return channelFuture;
        }
        catch (Throwable throwable) {
            this.lifecycleManager.onError(channelHandlerContext, true, throwable);
            channelPromise.tryFailure(throwable);
            return channelPromise;
        }
    }

    @Override
    public ChannelFuture writeGoAway(ChannelHandlerContext channelHandlerContext, int n, long l, ByteBuf byteBuf, ChannelPromise channelPromise) {
        return this.lifecycleManager.goAway(channelHandlerContext, n, l, byteBuf, channelPromise);
    }

    @Override
    public ChannelFuture writeWindowUpdate(ChannelHandlerContext channelHandlerContext, int n, int n2, ChannelPromise channelPromise) {
        return channelPromise.setFailure((Throwable)new UnsupportedOperationException("Use the Http2[Inbound|Outbound]FlowController objects to control window sizes"));
    }

    @Override
    public ChannelFuture writeFrame(ChannelHandlerContext channelHandlerContext, byte by, int n, Http2Flags http2Flags, ByteBuf byteBuf, ChannelPromise channelPromise) {
        return this.frameWriter.writeFrame(channelHandlerContext, by, n, http2Flags, byteBuf, channelPromise);
    }

    @Override
    public void close() {
        this.frameWriter.close();
    }

    @Override
    public Http2Settings pollSentSettings() {
        return this.outstandingLocalSettingsQueue.poll();
    }

    @Override
    public Http2FrameWriter.Configuration configuration() {
        return this.frameWriter.configuration();
    }

    private Http2Stream requireStream(int n) {
        Http2Stream http2Stream = this.connection.stream(n);
        if (http2Stream == null) {
            String string = this.connection.streamMayHaveExisted(n) ? "Stream no longer exists: " + n : "Stream does not exist: " + n;
            throw new IllegalArgumentException(string);
        }
        return http2Stream;
    }

    @Override
    public void consumeReceivedSettings(Http2Settings http2Settings) {
        if (this.outstandingRemoteSettingsQueue == null) {
            this.outstandingRemoteSettingsQueue = new ArrayDeque<Http2Settings>(2);
        }
        this.outstandingRemoteSettingsQueue.add(http2Settings);
    }

    private void notifyLifecycleManagerOnError(ChannelFuture channelFuture, final ChannelHandlerContext channelHandlerContext) {
        channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture) {
                Throwable throwable = channelFuture.cause();
                if (throwable != null) {
                    DefaultHttp2ConnectionEncoder.this.lifecycleManager.onError(channelHandlerContext, true, throwable);
                }
            }
        });
    }

    public abstract class FlowControlledBase
    implements ChannelFutureListener,
    Http2RemoteFlowController.FlowControlled {
        protected final Http2Stream stream;
        protected ChannelPromise promise;
        protected boolean endOfStream;
        protected int padding;

        FlowControlledBase(Http2Stream http2Stream, int n, boolean bl, ChannelPromise channelPromise) {
            ObjectUtil.checkPositiveOrZero((int)n, (String)"padding");
            this.padding = n;
            this.endOfStream = bl;
            this.stream = http2Stream;
            this.promise = channelPromise;
        }

        @Override
        public void writeComplete() {
            if (this.endOfStream) {
                DefaultHttp2ConnectionEncoder.this.lifecycleManager.closeStreamLocal(this.stream, (ChannelFuture)this.promise);
            }
        }

        public void operationComplete(ChannelFuture channelFuture) {
            if (!channelFuture.isSuccess()) {
                this.error(DefaultHttp2ConnectionEncoder.this.flowController().channelHandlerContext(), channelFuture.cause());
            }
        }
    }

    private final class FlowControlledHeaders
    extends FlowControlledBase {
        private final Http2Headers headers;
        private final boolean hasPriority;
        private final int streamDependency;
        private final short weight;
        private final boolean exclusive;

        FlowControlledHeaders(Http2Stream http2Stream, Http2Headers http2Headers, boolean bl, int n, short s, boolean bl2, int n2, boolean bl3, ChannelPromise channelPromise) {
            super(http2Stream, n2, bl3, channelPromise.unvoid());
            this.headers = http2Headers;
            this.hasPriority = bl;
            this.streamDependency = n;
            this.weight = s;
            this.exclusive = bl2;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void error(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
            if (channelHandlerContext != null) {
                DefaultHttp2ConnectionEncoder.this.lifecycleManager.onError(channelHandlerContext, true, throwable);
            }
            this.promise.tryFailure(throwable);
        }

        @Override
        public void write(ChannelHandlerContext channelHandlerContext, int n) {
            boolean bl = DefaultHttp2ConnectionEncoder.validateHeadersSentState(this.stream, this.headers, DefaultHttp2ConnectionEncoder.this.connection.isServer(), this.endOfStream);
            this.promise.addListener((GenericFutureListener)this);
            ChannelFuture channelFuture = DefaultHttp2ConnectionEncoder.sendHeaders(DefaultHttp2ConnectionEncoder.this.frameWriter, channelHandlerContext, this.stream.id(), this.headers, this.hasPriority, this.streamDependency, this.weight, this.exclusive, this.padding, this.endOfStream, this.promise);
            Throwable throwable = channelFuture.cause();
            if (throwable == null) {
                this.stream.headersSent(bl);
            }
        }

        @Override
        public boolean merge(ChannelHandlerContext channelHandlerContext, Http2RemoteFlowController.FlowControlled flowControlled) {
            return false;
        }
    }

    private final class FlowControlledData
    extends FlowControlledBase {
        private final CoalescingBufferQueue queue;
        private int dataSize;

        FlowControlledData(Http2Stream http2Stream, ByteBuf byteBuf, int n, boolean bl, ChannelPromise channelPromise) {
            super(http2Stream, n, bl, channelPromise);
            this.queue = new CoalescingBufferQueue(channelPromise.channel());
            this.queue.add(byteBuf, channelPromise);
            this.dataSize = this.queue.readableBytes();
        }

        @Override
        public int size() {
            return this.dataSize + this.padding;
        }

        @Override
        public void error(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
            this.queue.releaseAndFailAll(throwable);
            DefaultHttp2ConnectionEncoder.this.lifecycleManager.onError(channelHandlerContext, true, throwable);
        }

        @Override
        public void write(ChannelHandlerContext channelHandlerContext, int n) {
            int n2 = this.queue.readableBytes();
            if (!this.endOfStream) {
                if (n2 == 0) {
                    if (this.queue.isEmpty()) {
                        this.dataSize = 0;
                        this.padding = 0;
                    } else {
                        ChannelPromise channelPromise = channelHandlerContext.newPromise().addListener((GenericFutureListener)this);
                        channelHandlerContext.write((Object)this.queue.remove(0, channelPromise), channelPromise);
                    }
                    return;
                }
                if (n == 0) {
                    return;
                }
            }
            int n3 = Math.min(n2, n);
            ChannelPromise channelPromise = channelHandlerContext.newPromise().addListener((GenericFutureListener)this);
            ByteBuf byteBuf = this.queue.remove(n3, channelPromise);
            this.dataSize = this.queue.readableBytes();
            int n4 = Math.min(n - n3, this.padding);
            this.padding -= n4;
            DefaultHttp2ConnectionEncoder.this.frameWriter().writeData(channelHandlerContext, this.stream.id(), byteBuf, n4, this.endOfStream && this.size() == 0, channelPromise);
        }

        @Override
        public boolean merge(ChannelHandlerContext channelHandlerContext, Http2RemoteFlowController.FlowControlled flowControlled) {
            FlowControlledData flowControlledData;
            if (FlowControlledData.class != flowControlled.getClass() || Integer.MAX_VALUE - (flowControlledData = (FlowControlledData)flowControlled).size() < this.size()) {
                return false;
            }
            flowControlledData.queue.copyTo((AbstractCoalescingBufferQueue)this.queue);
            this.dataSize = this.queue.readableBytes();
            this.padding = Math.max(this.padding, flowControlledData.padding);
            this.endOfStream = flowControlledData.endOfStream;
            return true;
        }
    }
}

