/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.AbstractHttp2StreamFrame;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2PriorityFrame;

public final class DefaultHttp2PriorityFrame
extends AbstractHttp2StreamFrame
implements Http2PriorityFrame {
    private final int streamDependency;
    private final short weight;
    private final boolean exclusive;

    public DefaultHttp2PriorityFrame(int n, short s, boolean bl) {
        this.streamDependency = n;
        this.weight = s;
        this.exclusive = bl;
    }

    @Override
    public int streamDependency() {
        return this.streamDependency;
    }

    @Override
    public short weight() {
        return this.weight;
    }

    @Override
    public boolean exclusive() {
        return this.exclusive;
    }

    @Override
    public DefaultHttp2PriorityFrame stream(Http2FrameStream http2FrameStream) {
        super.stream(http2FrameStream);
        return this;
    }

    @Override
    public String name() {
        return "PRIORITY_FRAME";
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DefaultHttp2PriorityFrame)) {
            return false;
        }
        DefaultHttp2PriorityFrame defaultHttp2PriorityFrame = (DefaultHttp2PriorityFrame)object;
        boolean bl = super.equals(defaultHttp2PriorityFrame);
        return bl && this.streamDependency == defaultHttp2PriorityFrame.streamDependency && this.weight == defaultHttp2PriorityFrame.weight && this.exclusive == defaultHttp2PriorityFrame.exclusive;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = n * 31 + this.streamDependency;
        n = n * 31 + this.weight;
        n = n * 31 + (this.exclusive ? 1 : 0);
        return n;
    }

    public String toString() {
        return "DefaultHttp2PriorityFrame(stream=" + this.stream() + ", streamDependency=" + this.streamDependency + ", weight=" + this.weight + ", exclusive=" + this.exclusive + ')';
    }
}

