/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http2.HpackHeaderField;
import io.netty.handler.codec.http2.HpackHuffmanEncoder;
import io.netty.handler.codec.http2.HpackStaticTable;
import io.netty.handler.codec.http2.HpackUtil;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.MathUtil;
import java.util.Iterator;
import java.util.Map;

final class HpackEncoder {
    static final int NOT_FOUND = -1;
    static final int HUFF_CODE_THRESHOLD = 512;
    private final NameEntry[] nameEntries;
    private final NameValueEntry[] nameValueEntries;
    private final NameValueEntry head;
    private NameValueEntry latest;
    private final HpackHuffmanEncoder hpackHuffmanEncoder;
    private final byte hashMask;
    private final boolean ignoreMaxHeaderListSize;
    private final int huffCodeThreshold;
    private long size;
    private long maxHeaderTableSize;
    private long maxHeaderListSize;

    HpackEncoder() {
        this(false);
    }

    HpackEncoder(boolean bl) {
        this(bl, 64, 512);
    }

    HpackEncoder(boolean bl, int n, int n2) {
        this.latest = this.head = new NameValueEntry(-1, (CharSequence)AsciiString.EMPTY_STRING, (CharSequence)AsciiString.EMPTY_STRING, Integer.MAX_VALUE, null);
        this.hpackHuffmanEncoder = new HpackHuffmanEncoder();
        this.ignoreMaxHeaderListSize = bl;
        this.maxHeaderTableSize = 4096L;
        this.maxHeaderListSize = 0xFFFFFFFFL;
        this.nameEntries = new NameEntry[MathUtil.findNextPositivePowerOfTwo((int)Math.max(2, Math.min(n, 128)))];
        this.nameValueEntries = new NameValueEntry[this.nameEntries.length];
        this.hashMask = (byte)(this.nameEntries.length - 1);
        this.huffCodeThreshold = n2;
    }

    public void encodeHeaders(int n, ByteBuf byteBuf, Http2Headers http2Headers, Http2HeadersEncoder.SensitivityDetector sensitivityDetector) {
        if (this.ignoreMaxHeaderListSize) {
            this.encodeHeadersIgnoreMaxHeaderListSize(byteBuf, http2Headers, sensitivityDetector);
        } else {
            this.encodeHeadersEnforceMaxHeaderListSize(n, byteBuf, http2Headers, sensitivityDetector);
        }
    }

    private void encodeHeadersEnforceMaxHeaderListSize(int n, ByteBuf byteBuf, Http2Headers http2Headers, Http2HeadersEncoder.SensitivityDetector sensitivityDetector) {
        long l = 0L;
        Iterator<Map.Entry<CharSequence, CharSequence>> iterator = http2Headers.iterator();
        while (iterator.hasNext()) {
            CharSequence charSequence;
            Map.Entry<CharSequence, CharSequence> entry = iterator.next();
            CharSequence charSequence2 = entry.getKey();
            if ((l += HpackHeaderField.sizeOf(charSequence2, charSequence = entry.getValue())) <= this.maxHeaderListSize) continue;
            Http2CodecUtil.headerListSizeExceeded(n, this.maxHeaderListSize, false);
        }
        this.encodeHeadersIgnoreMaxHeaderListSize(byteBuf, http2Headers, sensitivityDetector);
    }

    private void encodeHeadersIgnoreMaxHeaderListSize(ByteBuf byteBuf, Http2Headers http2Headers, Http2HeadersEncoder.SensitivityDetector sensitivityDetector) {
        Iterator<Map.Entry<CharSequence, CharSequence>> iterator = http2Headers.iterator();
        while (iterator.hasNext()) {
            Map.Entry<CharSequence, CharSequence> entry = iterator.next();
            CharSequence charSequence = entry.getKey();
            CharSequence charSequence2 = entry.getValue();
            this.encodeHeader(byteBuf, charSequence, charSequence2, sensitivityDetector.isSensitive(charSequence, charSequence2), HpackHeaderField.sizeOf(charSequence, charSequence2));
        }
    }

    private void encodeHeader(ByteBuf byteBuf, CharSequence charSequence, CharSequence charSequence2, boolean bl, long l) {
        int n;
        if (bl) {
            int n2 = this.getNameIndex(charSequence);
            this.encodeLiteral(byteBuf, charSequence, charSequence2, HpackUtil.IndexType.NEVER, n2);
            return;
        }
        if (this.maxHeaderTableSize == 0L) {
            int n3 = HpackStaticTable.getIndexInsensitive(charSequence, charSequence2);
            if (n3 == -1) {
                int n4 = HpackStaticTable.getIndex(charSequence);
                this.encodeLiteral(byteBuf, charSequence, charSequence2, HpackUtil.IndexType.NONE, n4);
            } else {
                HpackEncoder.encodeInteger(byteBuf, 128, 7, n3);
            }
            return;
        }
        if (l > this.maxHeaderTableSize) {
            int n5 = this.getNameIndex(charSequence);
            this.encodeLiteral(byteBuf, charSequence, charSequence2, HpackUtil.IndexType.NONE, n5);
            return;
        }
        int n6 = AsciiString.hashCode((CharSequence)charSequence);
        NameValueEntry nameValueEntry = this.getEntryInsensitive(charSequence, n6, charSequence2, n = AsciiString.hashCode((CharSequence)charSequence2));
        if (nameValueEntry != null) {
            HpackEncoder.encodeInteger(byteBuf, 128, 7, this.getIndexPlusOffset(nameValueEntry.counter));
        } else {
            int n7 = HpackStaticTable.getIndexInsensitive(charSequence, charSequence2);
            if (n7 != -1) {
                HpackEncoder.encodeInteger(byteBuf, 128, 7, n7);
            } else {
                this.ensureCapacity(l);
                this.encodeAndAddEntries(byteBuf, charSequence, n6, charSequence2, n);
                this.size += l;
            }
        }
    }

    private void encodeAndAddEntries(ByteBuf byteBuf, CharSequence charSequence, int n, CharSequence charSequence2, int n2) {
        int n3 = HpackStaticTable.getIndex(charSequence);
        int n4 = this.latestCounter() - 1;
        if (n3 == -1) {
            NameEntry nameEntry = this.getEntry(charSequence, n);
            if (nameEntry == null) {
                this.encodeLiteral(byteBuf, charSequence, charSequence2, HpackUtil.IndexType.INCREMENTAL, -1);
                this.addNameEntry(charSequence, n, n4);
                this.addNameValueEntry(charSequence, charSequence2, n, n2, n4);
            } else {
                this.encodeLiteral(byteBuf, charSequence, charSequence2, HpackUtil.IndexType.INCREMENTAL, this.getIndexPlusOffset(nameEntry.counter));
                this.addNameValueEntry(nameEntry.name, charSequence2, n, n2, n4);
                nameEntry.counter = n4;
            }
        } else {
            this.encodeLiteral(byteBuf, charSequence, charSequence2, HpackUtil.IndexType.INCREMENTAL, n3);
            this.addNameValueEntry(HpackStaticTable.getEntry((int)n3).name, charSequence2, n, n2, n4);
        }
    }

    public void setMaxHeaderTableSize(ByteBuf byteBuf, long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header Table Size must be >= %d and <= %d but was %d", 0L, 0xFFFFFFFFL, l);
        }
        if (this.maxHeaderTableSize == l) {
            return;
        }
        this.maxHeaderTableSize = l;
        this.ensureCapacity(0L);
        HpackEncoder.encodeInteger(byteBuf, 32, 5, l);
    }

    public long getMaxHeaderTableSize() {
        return this.maxHeaderTableSize;
    }

    public void setMaxHeaderListSize(long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header List Size must be >= %d and <= %d but was %d", 0L, 0xFFFFFFFFL, l);
        }
        this.maxHeaderListSize = l;
    }

    public long getMaxHeaderListSize() {
        return this.maxHeaderListSize;
    }

    private static void encodeInteger(ByteBuf byteBuf, int n, int n2, int n3) {
        HpackEncoder.encodeInteger(byteBuf, n, n2, (long)n3);
    }

    private static void encodeInteger(ByteBuf byteBuf, int n, int n2, long l) {
        assert (n2 >= 0 && n2 <= 8) : "N: " + n2;
        int n3 = 255 >>> 8 - n2;
        if (l < (long)n3) {
            byteBuf.writeByte((int)((long)n | l));
        } else {
            byteBuf.writeByte(n | n3);
            long l2 = l - (long)n3;
            while ((l2 & 0xFFFFFFFFFFFFFF80L) != 0L) {
                byteBuf.writeByte((int)(l2 & 0x7FL | 0x80L));
                l2 >>>= 7;
            }
            byteBuf.writeByte((int)l2);
        }
    }

    private void encodeStringLiteral(ByteBuf byteBuf, CharSequence charSequence) {
        int n;
        if (charSequence.length() >= this.huffCodeThreshold && (n = this.hpackHuffmanEncoder.getEncodedLength(charSequence)) < charSequence.length()) {
            HpackEncoder.encodeInteger(byteBuf, 128, 7, n);
            this.hpackHuffmanEncoder.encode(byteBuf, charSequence);
        } else {
            HpackEncoder.encodeInteger(byteBuf, 0, 7, charSequence.length());
            if (charSequence instanceof AsciiString) {
                AsciiString asciiString = (AsciiString)charSequence;
                byteBuf.writeBytes(asciiString.array(), asciiString.arrayOffset(), asciiString.length());
            } else {
                byteBuf.writeCharSequence(charSequence, CharsetUtil.ISO_8859_1);
            }
        }
    }

    private void encodeLiteral(ByteBuf byteBuf, CharSequence charSequence, CharSequence charSequence2, HpackUtil.IndexType indexType, int n) {
        boolean bl = n != -1;
        switch (indexType) {
            case INCREMENTAL: {
                HpackEncoder.encodeInteger(byteBuf, 64, 6, bl ? n : 0);
                break;
            }
            case NONE: {
                HpackEncoder.encodeInteger(byteBuf, 0, 4, bl ? n : 0);
                break;
            }
            case NEVER: {
                HpackEncoder.encodeInteger(byteBuf, 16, 4, bl ? n : 0);
                break;
            }
            default: {
                throw new Error("should not reach here");
            }
        }
        if (!bl) {
            this.encodeStringLiteral(byteBuf, charSequence);
        }
        this.encodeStringLiteral(byteBuf, charSequence2);
    }

    private int getNameIndex(CharSequence charSequence) {
        int n = HpackStaticTable.getIndex(charSequence);
        if (n != -1) {
            return n;
        }
        NameEntry nameEntry = this.getEntry(charSequence, AsciiString.hashCode((CharSequence)charSequence));
        return nameEntry == null ? -1 : this.getIndexPlusOffset(nameEntry.counter);
    }

    private void ensureCapacity(long l) {
        while (this.maxHeaderTableSize - this.size < l) {
            this.remove();
        }
    }

    int length() {
        return this.isEmpty() ? 0 : this.getIndex(this.head.after.counter);
    }

    long size() {
        return this.size;
    }

    HpackHeaderField getHeaderField(int n) {
        NameValueEntry nameValueEntry = this.head;
        while (n++ < this.length()) {
            nameValueEntry = nameValueEntry.after;
        }
        return nameValueEntry;
    }

    private NameValueEntry getEntryInsensitive(CharSequence charSequence, int n, CharSequence charSequence2, int n2) {
        int n3 = HpackEncoder.hash(n, n2);
        NameValueEntry nameValueEntry = this.nameValueEntries[this.bucket(n3)];
        while (nameValueEntry != null) {
            if (nameValueEntry.hash == n3 && HpackUtil.equalsVariableTime(charSequence2, nameValueEntry.value) && HpackUtil.equalsVariableTime(charSequence, nameValueEntry.name)) {
                return nameValueEntry;
            }
            nameValueEntry = nameValueEntry.next;
        }
        return null;
    }

    private NameEntry getEntry(CharSequence charSequence, int n) {
        NameEntry nameEntry = this.nameEntries[this.bucket(n)];
        while (nameEntry != null) {
            if (nameEntry.hash == n && HpackUtil.equalsConstantTime(charSequence, nameEntry.name) != 0) {
                return nameEntry;
            }
            nameEntry = nameEntry.next;
        }
        return null;
    }

    private int getIndexPlusOffset(int n) {
        return this.getIndex(n) + HpackStaticTable.length;
    }

    private int getIndex(int n) {
        return n - this.latestCounter() + 1;
    }

    private int latestCounter() {
        return this.latest.counter;
    }

    private void addNameEntry(CharSequence charSequence, int n, int n2) {
        int n3 = this.bucket(n);
        this.nameEntries[n3] = new NameEntry(n, charSequence, n2, this.nameEntries[n3]);
    }

    private void addNameValueEntry(CharSequence charSequence, CharSequence charSequence2, int n, int n2, int n3) {
        NameValueEntry nameValueEntry;
        int n4 = HpackEncoder.hash(n, n2);
        int n5 = this.bucket(n4);
        this.nameValueEntries[n5] = nameValueEntry = new NameValueEntry(n4, charSequence, charSequence2, n3, this.nameValueEntries[n5]);
        this.latest.after = nameValueEntry;
        this.latest = nameValueEntry;
    }

    private void remove() {
        NameValueEntry nameValueEntry = this.head.after;
        this.removeNameValueEntry(nameValueEntry);
        this.removeNameEntryMatchingCounter(nameValueEntry.name, nameValueEntry.counter);
        this.head.after = nameValueEntry.after;
        nameValueEntry.unlink();
        this.size -= (long)nameValueEntry.size();
        if (this.isEmpty()) {
            this.latest = this.head;
        }
    }

    private boolean isEmpty() {
        return this.size == 0L;
    }

    private void removeNameValueEntry(NameValueEntry nameValueEntry) {
        int n = this.bucket(nameValueEntry.hash);
        NameValueEntry nameValueEntry2 = this.nameValueEntries[n];
        if (nameValueEntry2 == nameValueEntry) {
            this.nameValueEntries[n] = nameValueEntry.next;
        } else {
            while (nameValueEntry2.next != nameValueEntry) {
                nameValueEntry2 = nameValueEntry2.next;
            }
            nameValueEntry2.next = nameValueEntry.next;
        }
    }

    private void removeNameEntryMatchingCounter(CharSequence charSequence, int n) {
        int n2 = AsciiString.hashCode((CharSequence)charSequence);
        int n3 = this.bucket(n2);
        NameEntry nameEntry = this.nameEntries[n3];
        if (nameEntry == null) {
            return;
        }
        if (n == nameEntry.counter) {
            this.nameEntries[n3] = nameEntry.next;
            nameEntry.unlink();
        } else {
            NameEntry nameEntry2 = nameEntry;
            nameEntry = nameEntry.next;
            while (nameEntry != null) {
                if (n == nameEntry.counter) {
                    nameEntry2.next = nameEntry.next;
                    nameEntry.unlink();
                    break;
                }
                nameEntry2 = nameEntry;
                nameEntry = nameEntry.next;
            }
        }
    }

    private int bucket(int n) {
        return n & this.hashMask;
    }

    private static int hash(int n, int n2) {
        return 31 * n + n2;
    }

    private static final class NameValueEntry
    extends HpackHeaderField {
        NameValueEntry after;
        NameValueEntry next;
        final int hash;
        final int counter;

        NameValueEntry(int n, CharSequence charSequence, CharSequence charSequence2, int n2, NameValueEntry nameValueEntry) {
            super(charSequence, charSequence2);
            this.next = nameValueEntry;
            this.hash = n;
            this.counter = n2;
        }

        void unlink() {
            this.after = null;
            this.next = null;
        }
    }

    private static final class NameEntry {
        NameEntry next;
        final CharSequence name;
        final int hash;
        int counter;

        NameEntry(int n, CharSequence charSequence, int n2, NameEntry nameEntry) {
            this.hash = n;
            this.name = charSequence;
            this.counter = n2;
            this.next = nameEntry;
        }

        void unlink() {
            this.next = null;
        }
    }
}

