/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DecoratingHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2LifecycleManager;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

final class Http2ControlFrameLimitEncoder
extends DecoratingHttp2ConnectionEncoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Http2ControlFrameLimitEncoder.class);
    private final int maxOutstandingControlFrames;
    private final ChannelFutureListener outstandingControlFramesListener = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture channelFuture) {
            Http2ControlFrameLimitEncoder.this.outstandingControlFrames--;
        }
    };
    private Http2LifecycleManager lifecycleManager;
    private int outstandingControlFrames;
    private boolean limitReached;

    Http2ControlFrameLimitEncoder(Http2ConnectionEncoder http2ConnectionEncoder, int n) {
        super(http2ConnectionEncoder);
        this.maxOutstandingControlFrames = ObjectUtil.checkPositive((int)n, (String)"maxOutstandingControlFrames");
    }

    @Override
    public void lifecycleManager(Http2LifecycleManager http2LifecycleManager) {
        this.lifecycleManager = http2LifecycleManager;
        super.lifecycleManager(http2LifecycleManager);
    }

    @Override
    public ChannelFuture writeSettingsAck(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        ChannelPromise channelPromise2 = this.handleOutstandingControlFrames(channelHandlerContext, channelPromise);
        if (channelPromise2 == null) {
            return channelPromise;
        }
        return super.writeSettingsAck(channelHandlerContext, channelPromise2);
    }

    @Override
    public ChannelFuture writePing(ChannelHandlerContext channelHandlerContext, boolean bl, long l, ChannelPromise channelPromise) {
        if (bl) {
            ChannelPromise channelPromise2 = this.handleOutstandingControlFrames(channelHandlerContext, channelPromise);
            if (channelPromise2 == null) {
                return channelPromise;
            }
            return super.writePing(channelHandlerContext, bl, l, channelPromise2);
        }
        return super.writePing(channelHandlerContext, bl, l, channelPromise);
    }

    @Override
    public ChannelFuture writeRstStream(ChannelHandlerContext channelHandlerContext, int n, long l, ChannelPromise channelPromise) {
        ChannelPromise channelPromise2 = this.handleOutstandingControlFrames(channelHandlerContext, channelPromise);
        if (channelPromise2 == null) {
            return channelPromise;
        }
        return super.writeRstStream(channelHandlerContext, n, l, channelPromise2);
    }

    private ChannelPromise handleOutstandingControlFrames(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        if (!this.limitReached) {
            if (this.outstandingControlFrames == this.maxOutstandingControlFrames) {
                channelHandlerContext.flush();
            }
            if (this.outstandingControlFrames == this.maxOutstandingControlFrames) {
                this.limitReached = true;
                Http2Exception http2Exception = Http2Exception.connectionError(Http2Error.ENHANCE_YOUR_CALM, "Maximum number %d of outstanding control frames reached", this.maxOutstandingControlFrames);
                logger.info("Maximum number {} of outstanding control frames reached. Closing channel {}", new Object[]{this.maxOutstandingControlFrames, channelHandlerContext.channel(), http2Exception});
                this.lifecycleManager.onError(channelHandlerContext, true, http2Exception);
                channelHandlerContext.close();
            }
            ++this.outstandingControlFrames;
            return channelPromise.unvoid().addListener((GenericFutureListener)this.outstandingControlFramesListener);
        }
        return channelPromise;
    }
}

