/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.annotation.ValueGetter;
import org.bytedeco.javacpp.annotation.ValueSetter;
import org.bytedeco.javacpp.presets.javacpp;
import org.bytedeco.javacpp.tools.Logger;

@Properties(inherit={javacpp.class})
public class BytePointer
extends Pointer {
    private static final Logger logger;

    public BytePointer(String string, String string2) {
        this(string.getBytes(string2).length + 1);
        this.putString(string, string2);
    }

    public BytePointer(String string, Charset charset) {
        this(string.getBytes(charset).length + 1);
        this.putString(string, charset);
    }

    public BytePointer(String string) {
        this(string.getBytes().length + 1);
        this.putString(string);
    }

    public BytePointer(byte ... byArray) {
        this(byArray.length);
        this.put(byArray);
    }

    public BytePointer(ByteBuffer byteBuffer) {
        super(byteBuffer);
        if (byteBuffer != null && !byteBuffer.isDirect() && byteBuffer.hasArray()) {
            byte[] byArray = byteBuffer.array();
            this.allocateArray(byArray.length - byteBuffer.arrayOffset());
            this.put(byArray, byteBuffer.arrayOffset(), byArray.length - byteBuffer.arrayOffset());
            this.position(byteBuffer.position());
            this.limit(byteBuffer.limit());
        }
    }

    public BytePointer(long l) {
        try {
            this.allocateArray(l);
            if (l > 0L && this.address == 0L) {
                throw new OutOfMemoryError("Native allocator returned address == 0");
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new RuntimeException("No native JavaCPP library in memory. (Has Loader.load() been called?)", unsatisfiedLinkError);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            OutOfMemoryError outOfMemoryError2 = new OutOfMemoryError("Cannot allocate new BytePointer(" + l + "): totalBytes = " + BytePointer.formatBytes(BytePointer.totalBytes()) + ", physicalBytes = " + BytePointer.formatBytes(BytePointer.physicalBytes()));
            outOfMemoryError2.initCause(outOfMemoryError);
            throw outOfMemoryError2;
        }
    }

    public BytePointer() {
    }

    public BytePointer(Pointer pointer) {
        super(pointer);
    }

    private native void allocateArray(long var1);

    public BytePointer position(long l) {
        return (BytePointer)super.position(l);
    }

    public BytePointer limit(long l) {
        return (BytePointer)super.limit(l);
    }

    public BytePointer capacity(long l) {
        return (BytePointer)super.capacity(l);
    }

    @Override
    public int sizeof() {
        return this.getClass() == BytePointer.class ? 1 : super.sizeof();
    }

    public BytePointer getPointer(long l) {
        return (BytePointer)new BytePointer(this).offsetAddress(l);
    }

    public byte[] getStringBytes() {
        long l = this.limit - this.position;
        if (l <= 0L) {
            l = BytePointer.strlen(this);
        }
        byte[] byArray = new byte[(int)Math.min(l, Integer.MAX_VALUE)];
        this.get(byArray);
        return byArray;
    }

    public String getString(String string) {
        return new String(this.getStringBytes(), string);
    }

    public String getString(Charset charset) {
        return new String(this.getStringBytes(), charset);
    }

    public String getString() {
        return new String(this.getStringBytes());
    }

    public BytePointer putString(String string, String string2) {
        byte[] byArray = string.getBytes(string2);
        return this.put(byArray).put(byArray.length, (byte)0).limit(byArray.length);
    }

    public BytePointer putString(String string, Charset charset) {
        byte[] byArray = string.getBytes(charset);
        return this.put(byArray).put(byArray.length, (byte)0).limit(byArray.length);
    }

    public BytePointer putString(String string) {
        byte[] byArray = string.getBytes();
        return this.put(byArray).put(byArray.length, (byte)0).limit(byArray.length);
    }

    public byte get() {
        return this.get(0L);
    }

    public native byte get(long var1);

    public BytePointer put(byte by) {
        return this.put(0L, by);
    }

    public native BytePointer put(long var1, byte var3);

    public BytePointer get(byte[] byArray) {
        return this.get(byArray, 0, byArray.length);
    }

    public BytePointer put(byte ... byArray) {
        return this.put(byArray, 0, byArray.length);
    }

    public native BytePointer get(byte[] var1, int var2, int var3);

    public native BytePointer put(byte[] var1, int var2, int var3);

    @Override
    public final ByteBuffer asBuffer() {
        return this.asByteBuffer();
    }

    public int getUnsigned() {
        return this.getUnsigned(0L);
    }

    public int getUnsigned(long l) {
        return this.get(l) & 0xFF;
    }

    public BytePointer putUnsigned(int n) {
        return this.putUnsigned(0L, n);
    }

    public BytePointer putUnsigned(long l, int n) {
        return this.put(l, (byte)n);
    }

    public short getShort() {
        return this.getShort(0L);
    }

    @ValueGetter
    @Cast(value={"short"})
    public native short getShort(long var1);

    public BytePointer putShort(short s) {
        return this.putShort(0L, s);
    }

    @ValueSetter
    @Cast(value={"short"})
    public native BytePointer putShort(long var1, short var3);

    public int getInt() {
        return this.getInt(0L);
    }

    @ValueGetter
    @Cast(value={"int"})
    public native int getInt(long var1);

    public BytePointer putInt(int n) {
        return this.putInt(0L, n);
    }

    @ValueSetter
    @Cast(value={"int"})
    public native BytePointer putInt(long var1, int var3);

    public long getLong() {
        return this.getLong(0L);
    }

    @ValueGetter
    @Cast(value={"long long"})
    public native long getLong(long var1);

    public BytePointer putLong(long l) {
        return this.putLong(0L, l);
    }

    @ValueSetter
    @Cast(value={"long long"})
    public native BytePointer putLong(long var1, long var3);

    public float getFloat() {
        return this.getFloat(0L);
    }

    @ValueGetter
    @Cast(value={"float"})
    public native float getFloat(long var1);

    public BytePointer putFloat(float f) {
        return this.putFloat(0L, f);
    }

    @ValueSetter
    @Cast(value={"float"})
    public native BytePointer putFloat(long var1, float var3);

    public double getDouble() {
        return this.getDouble(0L);
    }

    @ValueGetter
    @Cast(value={"double"})
    public native double getDouble(long var1);

    public BytePointer putDouble(double d) {
        return this.putDouble(0L, d);
    }

    @ValueSetter
    @Cast(value={"double"})
    public native BytePointer putDouble(long var1, double var3);

    public boolean getBool() {
        return this.getBool(0L);
    }

    @ValueGetter
    @Cast(value={"bool"})
    public native boolean getBool(long var1);

    public BytePointer putBool(boolean bl) {
        return this.putBool(0L, bl);
    }

    @ValueSetter
    @Cast(value={"bool"})
    public native BytePointer putBool(long var1, boolean var3);

    public char getChar() {
        return this.getChar(0L);
    }

    @ValueGetter
    @Cast(value={"short"})
    public native char getChar(long var1);

    public BytePointer putChar(char c) {
        return this.putChar(0L, c);
    }

    @ValueSetter
    @Cast(value={"short"})
    public native BytePointer putChar(long var1, char var3);

    public Pointer getPointerValue() {
        return this.getPointerValue(0L);
    }

    @ValueGetter
    @Cast(value={"void*"})
    public native Pointer getPointerValue(long var1);

    public BytePointer putPointerValue(Pointer pointer) {
        return this.putPointerValue(0L, pointer);
    }

    @ValueSetter
    @Cast(value={"void*"})
    public native BytePointer putPointerValue(long var1, Pointer var3);

    @Cast(value={"char*"})
    public static native BytePointer strcat(@Cast(value={"char*"}) BytePointer var0, @Cast(value={"char*"}) BytePointer var1);

    @Cast(value={"char*"})
    public static native BytePointer strchr(@Cast(value={"char*"}) BytePointer var0, int var1);

    public static native int strcmp(@Cast(value={"char*"}) BytePointer var0, @Cast(value={"char*"}) BytePointer var1);

    public static native int strcoll(@Cast(value={"char*"}) BytePointer var0, @Cast(value={"char*"}) BytePointer var1);

    @Cast(value={"char*"})
    public static native BytePointer strcpy(@Cast(value={"char*"}) BytePointer var0, @Cast(value={"char*"}) BytePointer var1);

    @Cast(value={"size_t"})
    public static native long strcspn(@Cast(value={"char*"}) BytePointer var0, @Cast(value={"char*"}) BytePointer var1);

    @Cast(value={"char*"})
    public static native BytePointer strerror(int var0);

    @Cast(value={"size_t"})
    public static native long strlen(@Cast(value={"char*"}) BytePointer var0);

    @Cast(value={"char*"})
    public static native BytePointer strncat(@Cast(value={"char*"}) BytePointer var0, @Cast(value={"char*"}) BytePointer var1, @Cast(value={"size_t"}) long var2);

    public static native int strncmp(@Cast(value={"char*"}) BytePointer var0, @Cast(value={"char*"}) BytePointer var1, @Cast(value={"size_t"}) long var2);

    @Cast(value={"char*"})
    public static native BytePointer strncpy(@Cast(value={"char*"}) BytePointer var0, @Cast(value={"char*"}) BytePointer var1, @Cast(value={"size_t"}) long var2);

    @Cast(value={"char*"})
    public static native BytePointer strpbrk(@Cast(value={"char*"}) BytePointer var0, @Cast(value={"char*"}) BytePointer var1);

    @Cast(value={"char*"})
    public static native BytePointer strrchr(@Cast(value={"char*"}) BytePointer var0, int var1);

    @Cast(value={"size_t"})
    public static native long strspn(@Cast(value={"char*"}) BytePointer var0, @Cast(value={"char*"}) BytePointer var1);

    @Cast(value={"char*"})
    public static native BytePointer strstr(@Cast(value={"char*"}) BytePointer var0, @Cast(value={"char*"}) BytePointer var1);

    @Cast(value={"char*"})
    public static native BytePointer strtok(@Cast(value={"char*"}) BytePointer var0, @Cast(value={"char*"}) BytePointer var1);

    @Cast(value={"size_t"})
    public static native long strxfrm(@Cast(value={"char*"}) BytePointer var0, @Cast(value={"char*"}) BytePointer var1, @Cast(value={"size_t"}) long var2);

    static {
        block2: {
            logger = Logger.create(BytePointer.class);
            try {
                Loader.load();
            }
            catch (Throwable throwable) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Could not load BytePointer: " + throwable);
            }
        }
    }
}

