/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp;

import java.nio.FloatBuffer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.presets.javacpp;
import org.bytedeco.javacpp.tools.Logger;

@Properties(inherit={javacpp.class})
public class FloatPointer
extends Pointer {
    private static final Logger logger;

    public FloatPointer(float ... fArray) {
        this(fArray.length);
        this.put(fArray);
    }

    public FloatPointer(FloatBuffer floatBuffer) {
        super(floatBuffer);
        if (floatBuffer != null && !floatBuffer.isDirect() && floatBuffer.hasArray()) {
            float[] fArray = floatBuffer.array();
            this.allocateArray(fArray.length - floatBuffer.arrayOffset());
            this.put(fArray, floatBuffer.arrayOffset(), fArray.length - floatBuffer.arrayOffset());
            this.position(floatBuffer.position());
            this.limit(floatBuffer.limit());
        }
    }

    public FloatPointer(long l) {
        try {
            this.allocateArray(l);
            if (l > 0L && this.address == 0L) {
                throw new OutOfMemoryError("Native allocator returned address == 0");
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new RuntimeException("No native JavaCPP library in memory. (Has Loader.load() been called?)", unsatisfiedLinkError);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            OutOfMemoryError outOfMemoryError2 = new OutOfMemoryError("Cannot allocate new FloatPointer(" + l + "): totalBytes = " + FloatPointer.formatBytes(FloatPointer.totalBytes()) + ", physicalBytes = " + FloatPointer.formatBytes(FloatPointer.physicalBytes()));
            outOfMemoryError2.initCause(outOfMemoryError);
            throw outOfMemoryError2;
        }
    }

    public FloatPointer() {
    }

    public FloatPointer(Pointer pointer) {
        super(pointer);
    }

    private native void allocateArray(long var1);

    public FloatPointer position(long l) {
        return (FloatPointer)super.position(l);
    }

    public FloatPointer limit(long l) {
        return (FloatPointer)super.limit(l);
    }

    public FloatPointer capacity(long l) {
        return (FloatPointer)super.capacity(l);
    }

    @Override
    public int sizeof() {
        return this.getClass() == FloatPointer.class ? 4 : super.sizeof();
    }

    public FloatPointer getPointer(long l) {
        return (FloatPointer)new FloatPointer(this).offsetAddress(l);
    }

    public float get() {
        return this.get(0L);
    }

    public native float get(long var1);

    public FloatPointer put(float f) {
        return this.put(0L, f);
    }

    public native FloatPointer put(long var1, float var3);

    public FloatPointer get(float[] fArray) {
        return this.get(fArray, 0, fArray.length);
    }

    public FloatPointer put(float ... fArray) {
        return this.put(fArray, 0, fArray.length);
    }

    public native FloatPointer get(float[] var1, int var2, int var3);

    public native FloatPointer put(float[] var1, int var2, int var3);

    @Override
    public final FloatBuffer asBuffer() {
        return this.asByteBuffer().asFloatBuffer();
    }

    static {
        block2: {
            logger = Logger.create(FloatPointer.class);
            try {
                Loader.load();
            }
            catch (Throwable throwable) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Could not load FloatPointer: " + throwable);
            }
        }
    }
}

