/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp;

import java.nio.LongBuffer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.presets.javacpp;
import org.bytedeco.javacpp.tools.Logger;

@Properties(inherit={javacpp.class})
public class LongPointer
extends Pointer {
    private static final Logger logger;

    public LongPointer(long ... lArray) {
        this((long)lArray.length);
        this.put(lArray);
    }

    public LongPointer(LongBuffer longBuffer) {
        super(longBuffer);
        if (longBuffer != null && !longBuffer.isDirect() && longBuffer.hasArray()) {
            long[] lArray = longBuffer.array();
            this.allocateArray(lArray.length - longBuffer.arrayOffset());
            this.put(lArray, longBuffer.arrayOffset(), lArray.length - longBuffer.arrayOffset());
            this.position(longBuffer.position());
            this.limit(longBuffer.limit());
        }
    }

    public LongPointer(long l) {
        try {
            this.allocateArray(l);
            if (l > 0L && this.address == 0L) {
                throw new OutOfMemoryError("Native allocator returned address == 0");
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new RuntimeException("No native JavaCPP library in memory. (Has Loader.load() been called?)", unsatisfiedLinkError);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            OutOfMemoryError outOfMemoryError2 = new OutOfMemoryError("Cannot allocate new LongPointer(" + l + "): totalBytes = " + LongPointer.formatBytes(LongPointer.totalBytes()) + ", physicalBytes = " + LongPointer.formatBytes(LongPointer.physicalBytes()));
            outOfMemoryError2.initCause(outOfMemoryError);
            throw outOfMemoryError2;
        }
    }

    public LongPointer() {
    }

    public LongPointer(Pointer pointer) {
        super(pointer);
    }

    private native void allocateArray(long var1);

    public LongPointer position(long l) {
        return (LongPointer)super.position(l);
    }

    public LongPointer limit(long l) {
        return (LongPointer)super.limit(l);
    }

    public LongPointer capacity(long l) {
        return (LongPointer)super.capacity(l);
    }

    @Override
    public int sizeof() {
        return this.getClass() == LongPointer.class ? 8 : super.sizeof();
    }

    public LongPointer getPointer(long l) {
        return (LongPointer)new LongPointer(this).offsetAddress(l);
    }

    public long get() {
        return this.get(0L);
    }

    public native long get(long var1);

    public LongPointer put(long l) {
        return this.put(0L, l);
    }

    public native LongPointer put(long var1, long var3);

    public LongPointer get(long[] lArray) {
        return this.get(lArray, 0, lArray.length);
    }

    public LongPointer put(long ... lArray) {
        return this.put(lArray, 0, lArray.length);
    }

    public native LongPointer get(long[] var1, int var2, int var3);

    public native LongPointer put(long[] var1, int var2, int var3);

    @Override
    public final LongBuffer asBuffer() {
        return this.asByteBuffer().asLongBuffer();
    }

    static {
        block2: {
            logger = Logger.create(LongPointer.class);
            try {
                Loader.load();
            }
            catch (Throwable throwable) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Could not load LongPointer: " + throwable);
            }
        }
    }
}

