/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.nio.ShortBuffer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.indexer.HalfArrayIndexer;
import org.bytedeco.javacpp.indexer.HalfBufferIndexer;
import org.bytedeco.javacpp.indexer.HalfRawIndexer;
import org.bytedeco.javacpp.indexer.Index;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.Raw;

public abstract class HalfIndexer
extends Indexer {
    public static final int VALUE_BYTES = 2;

    protected HalfIndexer(Index index) {
        super(index);
    }

    protected HalfIndexer(long[] lArray, long[] lArray2) {
        super(lArray, lArray2);
    }

    public static HalfIndexer create(short[] sArray) {
        return new HalfArrayIndexer(sArray);
    }

    public static HalfIndexer create(ShortBuffer shortBuffer) {
        return new HalfBufferIndexer(shortBuffer);
    }

    public static HalfIndexer create(ShortPointer shortPointer) {
        return new HalfRawIndexer(shortPointer);
    }

    public static HalfIndexer create(short[] sArray, Index index) {
        return new HalfArrayIndexer(sArray, index);
    }

    public static HalfIndexer create(ShortBuffer shortBuffer, Index index) {
        return new HalfBufferIndexer(shortBuffer, index);
    }

    public static HalfIndexer create(ShortPointer shortPointer, Index index) {
        return new HalfRawIndexer(shortPointer, index);
    }

    public static HalfIndexer create(short[] sArray, long ... lArray) {
        return new HalfArrayIndexer(sArray, lArray);
    }

    public static HalfIndexer create(ShortBuffer shortBuffer, long ... lArray) {
        return new HalfBufferIndexer(shortBuffer, lArray);
    }

    public static HalfIndexer create(ShortPointer shortPointer, long ... lArray) {
        return new HalfRawIndexer(shortPointer, lArray);
    }

    public static HalfIndexer create(short[] sArray, long[] lArray, long[] lArray2) {
        return new HalfArrayIndexer(sArray, lArray, lArray2);
    }

    public static HalfIndexer create(ShortBuffer shortBuffer, long[] lArray, long[] lArray2) {
        return new HalfBufferIndexer(shortBuffer, lArray, lArray2);
    }

    public static HalfIndexer create(ShortPointer shortPointer, long[] lArray, long[] lArray2) {
        return new HalfRawIndexer(shortPointer, lArray, lArray2);
    }

    public static HalfIndexer create(ShortPointer shortPointer, long[] lArray, long[] lArray2, boolean bl) {
        return HalfIndexer.create(shortPointer, Index.create(lArray, lArray2), bl);
    }

    public static HalfIndexer create(final ShortPointer shortPointer, Index index, boolean bl) {
        if (bl) {
            return Raw.getInstance() != null ? new HalfRawIndexer(shortPointer, index) : new HalfBufferIndexer(shortPointer.asBuffer(), index);
        }
        final long l = shortPointer.position();
        short[] sArray = new short[(int)Math.min(shortPointer.limit() - l, Integer.MAX_VALUE)];
        shortPointer.get(sArray);
        return new HalfArrayIndexer(sArray, index){

            @Override
            public void release() {
                shortPointer.position(l).put(this.array);
                super.release();
            }
        };
    }

    public static float toFloat(int n) {
        int n2 = n & 0x3FF;
        int n3 = n & 0x7C00;
        if (n3 == 31744) {
            n3 = 261120;
        } else if (n3 != 0) {
            n3 += 114688;
        } else if (n2 != 0) {
            n3 = 115712;
            do {
                n3 -= 1024;
            } while (((n2 <<= 1) & 0x400) == 0);
            n2 &= 0x3FF;
        }
        return Float.intBitsToFloat((n & 0x8000) << 16 | (n3 | n2) << 13);
    }

    public static int fromFloat(float f) {
        int n = Float.floatToIntBits(f);
        int n2 = n >>> 16 & 0x8000;
        int n3 = (n & Integer.MAX_VALUE) + 4096;
        if (n3 >= 1199570944) {
            if ((n & Integer.MAX_VALUE) >= 1199570944) {
                if (n3 < 2139095040) {
                    return n2 | 0x7C00;
                }
                return n2 | 0x7C00 | (n & 0x7FFFFF) >>> 13;
            }
            return n2 | 0x7BFF;
        }
        if (n3 >= 0x38800000) {
            return n2 | n3 - 0x38000000 >>> 13;
        }
        if (n3 < 0x33000000) {
            return n2;
        }
        n3 = (n & Integer.MAX_VALUE) >>> 23;
        return n2 | (n & 0x7FFFFF | 0x800000) + (0x800000 >>> n3 - 102) >>> 126 - n3;
    }

    public abstract float get(long var1);

    public HalfIndexer get(long l, float[] fArray) {
        return this.get(l, fArray, 0, fArray.length);
    }

    public abstract HalfIndexer get(long var1, float[] var3, int var4, int var5);

    public abstract float get(long var1, long var3);

    public HalfIndexer get(long l, long l2, float[] fArray) {
        return this.get(l, l2, fArray, 0, fArray.length);
    }

    public abstract HalfIndexer get(long var1, long var3, float[] var5, int var6, int var7);

    public abstract float get(long var1, long var3, long var5);

    public abstract float get(long ... var1);

    public HalfIndexer get(long[] lArray, float[] fArray) {
        return this.get(lArray, fArray, 0, fArray.length);
    }

    public abstract HalfIndexer get(long[] var1, float[] var2, int var3, int var4);

    public abstract HalfIndexer put(long var1, float var3);

    public HalfIndexer put(long l, float ... fArray) {
        return this.put(l, fArray, 0, fArray.length);
    }

    public abstract HalfIndexer put(long var1, float[] var3, int var4, int var5);

    public abstract HalfIndexer put(long var1, long var3, float var5);

    public HalfIndexer put(long l, long l2, float ... fArray) {
        return this.put(l, l2, fArray, 0, fArray.length);
    }

    public abstract HalfIndexer put(long var1, long var3, float[] var5, int var6, int var7);

    public abstract HalfIndexer put(long var1, long var3, long var5, float var7);

    public abstract HalfIndexer put(long[] var1, float var2);

    public HalfIndexer put(long[] lArray, float ... fArray) {
        return this.put(lArray, fArray, 0, fArray.length);
    }

    public abstract HalfIndexer put(long[] var1, float[] var2, int var3, int var4);

    @Override
    public double getDouble(long ... lArray) {
        return this.get(lArray);
    }

    @Override
    public HalfIndexer putDouble(long[] lArray, double d) {
        return this.put(lArray, (float)d);
    }
}

