/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.Index;
import org.bytedeco.javacpp.indexer.LongIndexer;
import org.bytedeco.javacpp.indexer.Raw;

public class LongRawIndexer
extends LongIndexer {
    protected static final Raw RAW = Raw.getInstance();
    protected LongPointer pointer;
    final long base;
    final long size;

    public LongRawIndexer(LongPointer longPointer) {
        this(longPointer, Index.create(longPointer.limit() - longPointer.position()));
    }

    public LongRawIndexer(LongPointer longPointer, long ... lArray) {
        this(longPointer, Index.create(lArray));
    }

    public LongRawIndexer(LongPointer longPointer, long[] lArray, long[] lArray2) {
        this(longPointer, Index.create(lArray, lArray2));
    }

    public LongRawIndexer(LongPointer longPointer, Index index) {
        super(index);
        this.pointer = longPointer;
        this.base = longPointer.address() + longPointer.position() * 8L;
        this.size = longPointer.limit() - longPointer.position();
    }

    @Override
    public Pointer pointer() {
        return this.pointer;
    }

    public LongIndexer reindex(Index index) {
        return new LongRawIndexer(this.pointer, index);
    }

    public long getRaw(long l) {
        return RAW.getLong(this.base + LongRawIndexer.checkIndex(l, this.size) * 8L);
    }

    @Override
    public long get(long l) {
        return this.getRaw(this.index(l));
    }

    @Override
    public LongIndexer get(long l, long[] lArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            lArray[n + i] = this.getRaw(this.index(l) + (long)i);
        }
        return this;
    }

    @Override
    public long get(long l, long l2) {
        return this.getRaw(this.index(l, l2));
    }

    @Override
    public LongIndexer get(long l, long l2, long[] lArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            lArray[n + i] = this.getRaw(this.index(l, l2) + (long)i);
        }
        return this;
    }

    @Override
    public long get(long l, long l2, long l3) {
        return this.getRaw(this.index(l, l2, l3));
    }

    @Override
    public long get(long ... lArray) {
        return this.getRaw(this.index(lArray));
    }

    @Override
    public LongIndexer get(long[] lArray, long[] lArray2, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            lArray2[n + i] = this.getRaw(this.index(lArray) + (long)i);
        }
        return this;
    }

    public LongIndexer putRaw(long l, long l2) {
        RAW.putLong(this.base + LongRawIndexer.checkIndex(l, this.size) * 8L, l2);
        return this;
    }

    @Override
    public LongIndexer put(long l, long l2) {
        return this.putRaw(this.index(l), l2);
    }

    @Override
    public LongIndexer put(long l, long[] lArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(l) + (long)i, lArray[n + i]);
        }
        return this;
    }

    @Override
    public LongIndexer put(long l, long l2, long l3) {
        this.putRaw(this.index(l, l2), l3);
        return this;
    }

    @Override
    public LongIndexer put(long l, long l2, long[] lArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(l, l2) + (long)i, lArray[n + i]);
        }
        return this;
    }

    @Override
    public LongIndexer put(long l, long l2, long l3, long l4) {
        this.putRaw(this.index(l, l2, l3), l4);
        return this;
    }

    @Override
    public LongIndexer put(long[] lArray, long l) {
        this.putRaw(this.index(lArray), l);
        return this;
    }

    @Override
    public LongIndexer put(long[] lArray, long[] lArray2, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(lArray) + (long)i, lArray2[n + i]);
        }
        return this;
    }

    @Override
    public void release() {
        this.pointer = null;
    }
}

