/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.Index;
import org.bytedeco.javacpp.indexer.Raw;
import org.bytedeco.javacpp.indexer.UIntIndexer;

public class UIntRawIndexer
extends UIntIndexer {
    protected static final Raw RAW = Raw.getInstance();
    protected IntPointer pointer;
    final long base;
    final long size;

    public UIntRawIndexer(IntPointer intPointer) {
        this(intPointer, Index.create(intPointer.limit() - intPointer.position()));
    }

    public UIntRawIndexer(IntPointer intPointer, long ... lArray) {
        this(intPointer, Index.create(lArray));
    }

    public UIntRawIndexer(IntPointer intPointer, long[] lArray, long[] lArray2) {
        this(intPointer, Index.create(lArray, lArray2));
    }

    public UIntRawIndexer(IntPointer intPointer, Index index) {
        super(index);
        this.pointer = intPointer;
        this.base = intPointer.address() + intPointer.position() * 4L;
        this.size = intPointer.limit() - intPointer.position();
    }

    @Override
    public Pointer pointer() {
        return this.pointer;
    }

    public UIntIndexer reindex(Index index) {
        return new UIntRawIndexer(this.pointer, index);
    }

    public long getRaw(long l) {
        return (long)RAW.getInt(this.base + UIntRawIndexer.checkIndex(l, this.size) * 4L) & 0xFFFFFFFFL;
    }

    @Override
    public long get(long l) {
        return this.getRaw(this.index(l));
    }

    @Override
    public UIntIndexer get(long l, long[] lArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            lArray[n + i] = this.getRaw(this.index(l) + (long)i) & 0xFFFFFFFFL;
        }
        return this;
    }

    @Override
    public long get(long l, long l2) {
        return this.getRaw(this.index(l, l2)) & 0xFFFFFFFFL;
    }

    @Override
    public UIntIndexer get(long l, long l2, long[] lArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            lArray[n + i] = this.getRaw(this.index(l, l2) + (long)i) & 0xFFFFFFFFL;
        }
        return this;
    }

    @Override
    public long get(long l, long l2, long l3) {
        return this.getRaw(this.index(l, l2, l3)) & 0xFFFFFFFFL;
    }

    @Override
    public long get(long ... lArray) {
        return this.getRaw(this.index(lArray)) & 0xFFFFFFFFL;
    }

    @Override
    public UIntIndexer get(long[] lArray, long[] lArray2, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            lArray2[n + i] = this.getRaw(this.index(lArray) + (long)i) & 0xFFFFFFFFL;
        }
        return this;
    }

    public UIntIndexer putRaw(long l, long l2) {
        RAW.putInt(this.base + UIntRawIndexer.checkIndex(l, this.size) * 4L, (int)l2);
        return this;
    }

    @Override
    public UIntIndexer put(long l, long l2) {
        return this.putRaw(this.index(l), l2);
    }

    @Override
    public UIntIndexer put(long l, long[] lArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(l) + (long)i, lArray[n + i]);
        }
        return this;
    }

    @Override
    public UIntIndexer put(long l, long l2, long l3) {
        this.putRaw(this.index(l, l2), l3);
        return this;
    }

    @Override
    public UIntIndexer put(long l, long l2, long[] lArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(l, l2) + (long)i, lArray[n + i]);
        }
        return this;
    }

    @Override
    public UIntIndexer put(long l, long l2, long l3, long l4) {
        this.putRaw(this.index(l, l2, l3), l4);
        return this;
    }

    @Override
    public UIntIndexer put(long[] lArray, long l) {
        this.putRaw(this.index(lArray), l);
        return this;
    }

    @Override
    public UIntIndexer put(long[] lArray, long[] lArray2, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(lArray) + (long)i, lArray2[n + i]);
        }
        return this;
    }

    @Override
    public void release() {
        this.pointer = null;
    }
}

