/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.indexer.Index;
import org.bytedeco.javacpp.indexer.Raw;
import org.bytedeco.javacpp.indexer.UShortIndexer;

public class UShortRawIndexer
extends UShortIndexer {
    protected static final Raw RAW = Raw.getInstance();
    protected ShortPointer pointer;
    final long base;
    final long size;

    public UShortRawIndexer(ShortPointer shortPointer) {
        this(shortPointer, Index.create(shortPointer.limit() - shortPointer.position()));
    }

    public UShortRawIndexer(ShortPointer shortPointer, long ... lArray) {
        this(shortPointer, Index.create(lArray));
    }

    public UShortRawIndexer(ShortPointer shortPointer, long[] lArray, long[] lArray2) {
        this(shortPointer, Index.create(lArray, lArray2));
    }

    public UShortRawIndexer(ShortPointer shortPointer, Index index) {
        super(index);
        this.pointer = shortPointer;
        this.base = shortPointer.address() + shortPointer.position() * 2L;
        this.size = shortPointer.limit() - shortPointer.position();
    }

    @Override
    public Pointer pointer() {
        return this.pointer;
    }

    public UShortIndexer reindex(Index index) {
        return new UShortRawIndexer(this.pointer, index);
    }

    public int getRaw(long l) {
        return RAW.getShort(this.base + UShortRawIndexer.checkIndex(l, this.size) * 2L) & 0xFFFF;
    }

    @Override
    public int get(long l) {
        return this.getRaw(this.index(l));
    }

    @Override
    public UShortIndexer get(long l, int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            nArray[n + i] = this.getRaw(this.index(l) + (long)i) & 0xFFFF;
        }
        return this;
    }

    @Override
    public int get(long l, long l2) {
        return this.getRaw(this.index(l, l2)) & 0xFFFF;
    }

    @Override
    public UShortIndexer get(long l, long l2, int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            nArray[n + i] = this.getRaw(this.index(l, l2) + (long)i) & 0xFFFF;
        }
        return this;
    }

    @Override
    public int get(long l, long l2, long l3) {
        return this.getRaw(this.index(l, l2, l3)) & 0xFFFF;
    }

    @Override
    public int get(long ... lArray) {
        return this.getRaw(this.index(lArray)) & 0xFFFF;
    }

    @Override
    public UShortIndexer get(long[] lArray, int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            nArray[n + i] = this.getRaw(this.index(lArray) + (long)i) & 0xFFFF;
        }
        return this;
    }

    public UShortIndexer putRaw(long l, int n) {
        RAW.putShort(this.base + UShortRawIndexer.checkIndex(l, this.size) * 2L, (short)n);
        return this;
    }

    @Override
    public UShortIndexer put(long l, int n) {
        return this.putRaw(this.index(l), n);
    }

    @Override
    public UShortIndexer put(long l, int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(l) + (long)i, nArray[n + i]);
        }
        return this;
    }

    @Override
    public UShortIndexer put(long l, long l2, int n) {
        this.putRaw(this.index(l, l2), n);
        return this;
    }

    @Override
    public UShortIndexer put(long l, long l2, int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(l, l2) + (long)i, nArray[n + i]);
        }
        return this;
    }

    @Override
    public UShortIndexer put(long l, long l2, long l3, int n) {
        this.putRaw(this.index(l, l2, l3), n);
        return this;
    }

    @Override
    public UShortIndexer put(long[] lArray, int n) {
        this.putRaw(this.index(lArray), n);
        return this;
    }

    @Override
    public UShortIndexer put(long[] lArray, int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(lArray) + (long)i, nArray[n + i]);
        }
        return this;
    }

    @Override
    public void release() {
        this.pointer = null;
    }
}

