/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.cio.internals;

import io.ktor.http.cio.internals.CharArrayPoolKt;
import io.ktor.utils.io.pool.ObjectPool;
import java.util.ArrayList;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0002\b\u0011\n\u0002\u0010!\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u00012\u00060\u0002j\u0002`\u0003:\u0001FB\u0017\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0096\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000e\u0010\rJ\u001f\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001a\u0010\u0019\u001a\u00020\u00182\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0096\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001b\u0010\u001e\u001a\u00060\u0002j\u0002`\u00032\u0006\u0010\u001d\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ-\u0010\u001e\u001a\u00060\u0002j\u0002`\u00032\b\u0010\u001d\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u001e\u0010 J\u001d\u0010\u001e\u001a\u00060\u0002j\u0002`\u00032\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0004\b\u001e\u0010!J\r\u0010#\u001a\u00020\"\u00a2\u0006\u0004\b#\u0010$J\u001f\u0010%\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b%\u0010\u0012J\u0017\u0010&\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010)\u001a\u00020(2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b)\u0010*J\u000f\u0010+\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b+\u0010,J\u000f\u0010-\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b-\u0010,J/\u00101\u001a\u00020\u00182\u0006\u0010.\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010/\u001a\u00020\t2\u0006\u00100\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b1\u00102J\u001f\u00104\u001a\u00020\t2\u0006\u0010.\u001a\u00020\t2\u0006\u00103\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b4\u00105J\u000f\u00106\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b6\u0010\u001cR\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u00107\u001a\u0004\b8\u00109R\u001e\u0010;\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010:8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b;\u0010<R\u0018\u0010=\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b=\u0010>R\u0018\u0010?\u001a\u0004\u0018\u00010\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b?\u0010@R\u0016\u0010A\u001a\u00020\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bA\u0010BR\u0016\u0010C\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bC\u0010DR$\u00100\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\t8\u0016@RX\u0096\u000e\u00a2\u0006\f\n\u0004\b0\u0010D\u001a\u0004\bE\u0010\u001c\u00a8\u0006G"}, d2={"Lio/ktor/http/cio/internals/CharArrayBuilder;", "", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "Lio/ktor/utils/io/pool/ObjectPool;", "", "pool", "<init>", "(Lio/ktor/utils/io/pool/ObjectPool;)V", "", "index", "", "get", "(I)C", "getImpl", "startIndex", "endIndex", "subSequence", "(II)Ljava/lang/CharSequence;", "", "toString", "()Ljava/lang/String;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "value", "append", "(C)Ljava/lang/Appendable;", "(Ljava/lang/CharSequence;II)Ljava/lang/Appendable;", "(Ljava/lang/CharSequence;)Ljava/lang/Appendable;", "", "release", "()V", "copy", "bufferForIndex", "(I)[C", "", "throwSingleBuffer", "(I)Ljava/lang/Void;", "nonFullBuffer", "()[C", "appendNewArray", "start", "otherStart", "length", "rangeEqualsImpl", "(ILjava/lang/CharSequence;II)Z", "end", "hashCodeImpl", "(II)I", "currentPosition", "Lio/ktor/utils/io/pool/ObjectPool;", "getPool", "()Lio/ktor/utils/io/pool/ObjectPool;", "", "buffers", "Ljava/util/List;", "current", "[C", "stringified", "Ljava/lang/String;", "released", "Z", "remaining", "I", "getLength", "SubSequenceImpl", "ktor-http-cio"})
public final class CharArrayBuilder
implements Appendable,
CharSequence {
    private final ObjectPool<char[]> pool;
    private List<char[]> buffers;
    private char[] current;
    private String stringified;
    private boolean released;
    private int remaining;
    private int length;

    public CharArrayBuilder(ObjectPool<char[]> objectPool) {
        Intrinsics.checkNotNullParameter(objectPool, (String)"");
        this.pool = objectPool;
    }

    public /* synthetic */ CharArrayBuilder(ObjectPool objectPool, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            objectPool = CharArrayPoolKt.getCharArrayPool();
        }
        this(objectPool);
    }

    public final ObjectPool<char[]> getPool() {
        return this.pool;
    }

    public int getLength() {
        return this.length;
    }

    public char get(int n2) {
        if (!(n2 >= 0)) {
            boolean bl = false;
            String string = "index is negative: " + n2;
            throw new IllegalArgumentException(string.toString());
        }
        if (!(n2 < this.length())) {
            boolean bl = false;
            String string = "index " + n2 + " is not in range [0, " + this.length() + ')';
            throw new IllegalArgumentException(string.toString());
        }
        return this.getImpl(n2);
    }

    private final char getImpl(int n2) {
        char[] cArray = this.bufferForIndex(n2);
        Intrinsics.checkNotNull((Object)this.current);
        return cArray[n2 % this.current.length];
    }

    @Override
    public CharSequence subSequence(int n2, int n3) {
        if (!(n2 <= n3)) {
            boolean bl = false;
            String string = "startIndex (" + n2 + ") should be less or equal to endIndex (" + n3 + ')';
            throw new IllegalArgumentException(string.toString());
        }
        if (!(n2 >= 0)) {
            boolean bl = false;
            String string = "startIndex is negative: " + n2;
            throw new IllegalArgumentException(string.toString());
        }
        if (!(n3 <= this.length())) {
            boolean bl = false;
            String string = "endIndex (" + n3 + ") is greater than length (" + this.length() + ')';
            throw new IllegalArgumentException(string.toString());
        }
        return new SubSequenceImpl(n2, n3);
    }

    @Override
    public String toString() {
        String string = this.stringified;
        if (string == null) {
            String string2;
            String string3 = string2 = ((Object)this.copy(0, this.length())).toString();
            boolean bl = false;
            this.stringified = string3;
            string = string2;
        }
        return string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CharSequence)) {
            return false;
        }
        if (this.length() != ((CharSequence)object).length()) {
            return false;
        }
        return this.rangeEqualsImpl(0, (CharSequence)object, 0, this.length());
    }

    public int hashCode() {
        String string = this.stringified;
        return string != null ? string.hashCode() : this.hashCodeImpl(0, this.length());
    }

    @Override
    public Appendable append(char c2) {
        char[] cArray = this.nonFullBuffer();
        Intrinsics.checkNotNull((Object)this.current);
        cArray[this.current.length - this.remaining] = c2;
        this.stringified = null;
        --this.remaining;
        int n2 = this.length();
        this.length = n2 + 1;
        return this;
    }

    @Override
    public Appendable append(CharSequence charSequence, int n2, int n3) {
        if (charSequence == null) {
            return this;
        }
        int n4 = n2;
        while (n4 < n3) {
            char[] cArray = this.nonFullBuffer();
            int n5 = cArray.length - this.remaining;
            int n6 = Math.min(n3 - n4, this.remaining);
            for (int k = 0; k < n6; ++k) {
                cArray[n5 + k] = charSequence.charAt(n4 + k);
            }
            n4 += n6;
            this.remaining -= n6;
        }
        this.stringified = null;
        this.length = this.length() + (n3 - n2);
        return this;
    }

    @Override
    public Appendable append(CharSequence charSequence) {
        if (charSequence == null) {
            return this;
        }
        return this.append(charSequence, 0, charSequence.length());
    }

    public final void release() {
        List<char[]> list = this.buffers;
        if (list != null) {
            this.current = null;
            int n2 = list.size();
            for (int k = 0; k < n2; ++k) {
                this.pool.recycle((Object)list.get(k));
            }
        } else {
            if (this.current != null) {
                char[] cArray = this.current;
                boolean bl = false;
                this.pool.recycle((Object)cArray);
            }
            this.current = null;
        }
        this.released = true;
        this.buffers = null;
        this.stringified = null;
        this.length = 0;
        this.remaining = 0;
    }

    private final CharSequence copy(int n2, int n3) {
        if (n2 == n3) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(n3 - n2);
        char[] cArray = null;
        for (int k = n2 - n2 % 2048; k < n3; k += 2048) {
            cArray = this.bufferForIndex(k);
            int n4 = Math.max(0, n2 - k);
            int n5 = Math.min(n3 - k, 2048);
            for (int i2 = n4; i2 < n5; ++i2) {
                stringBuilder.append(cArray[i2]);
            }
        }
        return stringBuilder;
    }

    private final char[] bufferForIndex(int n2) {
        List<char[]> list = this.buffers;
        if (list == null) {
            if (n2 >= 2048) {
                this.throwSingleBuffer(n2);
                throw new KotlinNothingValueException();
            }
            if (this.current == null) {
                this.throwSingleBuffer(n2);
                throw new KotlinNothingValueException();
            }
            return this.current;
        }
        Intrinsics.checkNotNull((Object)this.current);
        return list.get(n2 / this.current.length);
    }

    private final Void throwSingleBuffer(int n2) {
        if (this.released) {
            throw new IllegalStateException("Buffer is already released");
        }
        throw new IndexOutOfBoundsException(n2 + " is not in range [0; " + this.currentPosition() + ')');
    }

    private final char[] nonFullBuffer() {
        char[] cArray;
        if (this.remaining == 0) {
            cArray = this.appendNewArray();
        } else {
            cArray = this.current;
            Intrinsics.checkNotNull((Object)this.current);
        }
        return cArray;
    }

    private final char[] appendNewArray() {
        char[] cArray = (char[])this.pool.borrow();
        char[] cArray2 = this.current;
        this.current = cArray;
        this.remaining = cArray.length;
        this.released = false;
        if (cArray2 != null) {
            List list = this.buffers;
            if (list == null) {
                ArrayList<char[]> arrayList;
                ArrayList<char[]> arrayList2 = arrayList = new ArrayList<char[]>();
                boolean bl = false;
                this.buffers = arrayList2;
                arrayList2.add(cArray2);
                list = arrayList;
            }
            List list2 = list;
            list2.add((char[])cArray);
        }
        return cArray;
    }

    private final boolean rangeEqualsImpl(int n2, CharSequence charSequence, int n3, int n4) {
        for (int k = 0; k < n4; ++k) {
            if (this.getImpl(n2 + k) == charSequence.charAt(n3 + k)) continue;
            return false;
        }
        return true;
    }

    private final int hashCodeImpl(int n2, int n3) {
        int n4 = 0;
        for (int k = n2; k < n3; ++k) {
            n4 = 31 * n4 + this.getImpl(k);
        }
        return n4;
    }

    private final int currentPosition() {
        Intrinsics.checkNotNull((Object)this.current);
        return this.current.length - this.remaining;
    }

    public CharArrayBuilder() {
        this(null, 1, null);
    }

    @Override
    public final int length() {
        return this.getLength();
    }

    @Override
    public final char charAt(int n2) {
        return this.get(n2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\r\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0015\u001a\u00020\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0096\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0019\u001a\u0004\b\u001a\u0010\u0018R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0019\u001a\u0004\b\u001b\u0010\u0018R\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001f\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0018\u00a8\u0006 "}, d2={"Lio/ktor/http/cio/internals/CharArrayBuilder$SubSequenceImpl;", "", "", "start", "end", "<init>", "(Lio/ktor/http/cio/internals/CharArrayBuilder;II)V", "index", "", "get", "(I)C", "startIndex", "endIndex", "subSequence", "(II)Ljava/lang/CharSequence;", "", "toString", "()Ljava/lang/String;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "I", "getStart", "getEnd", "stringified", "Ljava/lang/String;", "getLength", "length", "ktor-http-cio"})
    private final class SubSequenceImpl
    implements CharSequence {
        private final int start;
        private final int end;
        private String stringified;

        public SubSequenceImpl(int n2, int n3) {
            this.start = n2;
            this.end = n3;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        public int getLength() {
            return this.end - this.start;
        }

        public char get(int n2) {
            int n3 = n2 + this.start;
            if (!(n2 >= 0)) {
                boolean bl = false;
                String string = "index is negative: " + n2;
                throw new IllegalArgumentException(string.toString());
            }
            if (!(n3 < this.end)) {
                boolean bl = false;
                String string = "index (" + n2 + ") should be less than length (" + this.length() + ')';
                throw new IllegalArgumentException(string.toString());
            }
            return CharArrayBuilder.this.getImpl(n3);
        }

        @Override
        public CharSequence subSequence(int n2, int n3) {
            if (!(n2 >= 0)) {
                boolean bl = false;
                String string = "start is negative: " + n2;
                throw new IllegalArgumentException(string.toString());
            }
            if (!(n2 <= n3)) {
                boolean bl = false;
                String string = "start (" + n2 + ") should be less or equal to end (" + n3 + ')';
                throw new IllegalArgumentException(string.toString());
            }
            if (!(n3 <= this.end - this.start)) {
                boolean bl = false;
                String string = "end should be less than length (" + this.length() + ')';
                throw new IllegalArgumentException(string.toString());
            }
            if (n2 == n3) {
                return "";
            }
            return new SubSequenceImpl(this.start + n2, this.start + n3);
        }

        @Override
        public String toString() {
            String string = this.stringified;
            if (string == null) {
                String string2;
                String string3 = string2 = ((Object)CharArrayBuilder.this.copy(this.start, this.end)).toString();
                boolean bl = false;
                this.stringified = string3;
                string = string2;
            }
            return string;
        }

        public boolean equals(Object object) {
            if (!(object instanceof CharSequence)) {
                return false;
            }
            if (((CharSequence)object).length() != this.length()) {
                return false;
            }
            return CharArrayBuilder.this.rangeEqualsImpl(this.start, (CharSequence)object, 0, this.length());
        }

        public int hashCode() {
            String string = this.stringified;
            return string != null ? string.hashCode() : CharArrayBuilder.this.hashCodeImpl(this.start, this.end);
        }

        @Override
        public final int length() {
            return this.getLength();
        }

        @Override
        public final char charAt(int n2) {
            return this.get(n2);
        }
    }
}

