/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.OaIdl;
import com.sun.jna.platform.win32.Variant;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinDef;
import java.lang.reflect.Array;

public abstract class OaIdlUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object toPrimitiveArray(OaIdl.SAFEARRAY sAFEARRAY, boolean bl) {
        Pointer pointer = sAFEARRAY.accessData();
        try {
            Object object;
            Object[] objectArray;
            int n;
            int n2 = sAFEARRAY.getDimensionCount();
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            int n3 = sAFEARRAY.getVarType().intValue();
            for (n = 0; n < n2; ++n) {
                nArray[n] = sAFEARRAY.getUBound(n) - sAFEARRAY.getLBound(n) + 1;
            }
            for (n = n2 - 1; n >= 0; --n) {
                nArray2[n] = n == n2 - 1 ? 1 : nArray2[n + 1] * nArray[n + 1];
            }
            if (n2 == 0) {
                throw new IllegalArgumentException("Supplied Array has no dimensions.");
            }
            n = nArray2[0] * nArray[0];
            switch (n3) {
                case 16: 
                case 17: {
                    objectArray = pointer.getByteArray(0L, n);
                    break;
                }
                case 2: 
                case 11: 
                case 18: {
                    objectArray = pointer.getShortArray(0L, n);
                    break;
                }
                case 3: 
                case 10: 
                case 19: 
                case 22: 
                case 23: {
                    objectArray = pointer.getIntArray(0L, n);
                    break;
                }
                case 4: {
                    objectArray = pointer.getFloatArray(0L, n);
                    break;
                }
                case 5: 
                case 7: {
                    objectArray = pointer.getDoubleArray(0L, n);
                    break;
                }
                case 8: {
                    objectArray = pointer.getPointerArray(0L, n);
                    break;
                }
                case 12: {
                    object = new Variant.VARIANT(pointer);
                    objectArray = object.toArray(n);
                    break;
                }
                default: {
                    throw new IllegalStateException("Type not supported: " + n3);
                }
            }
            object = Array.newInstance(Object.class, nArray);
            OaIdlUtil.toPrimitiveArray(objectArray, object, nArray, nArray2, n3, new int[0]);
            Object object2 = object;
            return object2;
        }
        finally {
            sAFEARRAY.unaccessData();
            if (bl) {
                sAFEARRAY.destroy();
            }
        }
    }

    private static void toPrimitiveArray(Object object, Object object2, int[] nArray, int[] nArray2, int n, int[] nArray3) {
        int n2 = nArray3.length;
        int[] nArray4 = new int[nArray3.length + 1];
        System.arraycopy(nArray3, 0, nArray4, 0, n2);
        for (int i = 0; i < nArray[n2]; ++i) {
            nArray4[n2] = i;
            if (n2 == nArray.length - 1) {
                int n3;
                int n4 = 0;
                for (n3 = 0; n3 < n2; ++n3) {
                    n4 += nArray2[n3] * nArray3[n3];
                }
                n4 += nArray4[n2];
                n3 = nArray4[n2];
                block0 : switch (n) {
                    case 11: {
                        Array.set(object2, n3, Array.getShort(object, n4) != 0);
                        break;
                    }
                    case 16: 
                    case 17: {
                        Array.set(object2, n3, Array.getByte(object, n4));
                        break;
                    }
                    case 2: 
                    case 18: {
                        Array.set(object2, n3, Array.getShort(object, n4));
                        break;
                    }
                    case 3: 
                    case 19: 
                    case 22: 
                    case 23: {
                        Array.set(object2, n3, Array.getInt(object, n4));
                        break;
                    }
                    case 10: {
                        Array.set(object2, n3, new WinDef.SCODE(Array.getInt(object, n4)));
                        break;
                    }
                    case 4: {
                        Array.set(object2, n3, Float.valueOf(Array.getFloat(object, n4)));
                        break;
                    }
                    case 5: {
                        Array.set(object2, n3, Array.getDouble(object, n4));
                        break;
                    }
                    case 7: {
                        Array.set(object2, n3, new OaIdl.DATE(Array.getDouble(object, n4)).getAsJavaDate());
                        break;
                    }
                    case 8: {
                        Array.set(object2, n3, new WTypes.BSTR((Pointer)Array.get(object, n4)).getValue());
                        break;
                    }
                    case 12: {
                        Variant.VARIANT vARIANT = (Variant.VARIANT)((Object)Array.get(object, n4));
                        switch (vARIANT.getVarType().intValue()) {
                            case 0: 
                            case 1: {
                                Array.set(object2, n3, null);
                                break block0;
                            }
                            case 11: {
                                Array.set(object2, n3, vARIANT.booleanValue());
                                break block0;
                            }
                            case 16: 
                            case 17: {
                                Array.set(object2, n3, vARIANT.byteValue());
                                break block0;
                            }
                            case 2: 
                            case 18: {
                                Array.set(object2, n3, vARIANT.shortValue());
                                break block0;
                            }
                            case 3: 
                            case 19: 
                            case 22: 
                            case 23: {
                                Array.set(object2, n3, vARIANT.intValue());
                                break block0;
                            }
                            case 10: {
                                Array.set(object2, n3, new WinDef.SCODE(vARIANT.intValue()));
                                break block0;
                            }
                            case 4: {
                                Array.set(object2, n3, Float.valueOf(vARIANT.floatValue()));
                                break block0;
                            }
                            case 5: {
                                Array.set(object2, n3, vARIANT.doubleValue());
                                break block0;
                            }
                            case 7: {
                                Array.set(object2, n3, vARIANT.dateValue());
                                break block0;
                            }
                            case 8: {
                                Array.set(object2, n3, vARIANT.stringValue());
                                break block0;
                            }
                        }
                        throw new IllegalStateException("Type not supported: " + vARIANT.getVarType().intValue());
                    }
                    default: {
                        throw new IllegalStateException("Type not supported: " + n);
                    }
                }
                continue;
            }
            OaIdlUtil.toPrimitiveArray(object, Array.get(object2, i), nArray, nArray2, n, nArray4);
        }
    }
}

