/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.List;
import org.e.a.i;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.c2s.XmppClientToServerTransport;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.rce.RemoteConnectionEndpoint;
import org.jivesoftware.smack.util.rce.RemoteConnectionEndpointLookupFailure;
import org.jivesoftware.smack.util.rce.RemoteConnectionException;

public abstract class SmackException
extends Exception {
    private static final long serialVersionUID = 1844674365368214458L;

    protected SmackException(Throwable throwable) {
        super(throwable);
    }

    protected SmackException(String string) {
        super(string);
    }

    protected SmackException(String string, Throwable throwable) {
        super(string, throwable);
    }

    protected SmackException() {
    }

    public static class SmackCertificateException
    extends SmackException {
        private static final long serialVersionUID = 1L;
        private final CertificateException certificateException;

        public SmackCertificateException(CertificateException certificateException) {
            this.certificateException = certificateException;
        }

        public CertificateException getCertificateException() {
            return this.certificateException;
        }
    }

    public static class SmackSaslException
    extends SmackException {
        private static final long serialVersionUID = 1L;

        public SmackSaslException(Exception exception) {
            super(exception);
        }

        public SmackSaslException(String string) {
            super(string);
        }

        public SmackSaslException(String string, Exception exception) {
            super(string, exception);
        }
    }

    public static class SmackMessageException
    extends SmackException {
        private static final long serialVersionUID = 1L;

        public SmackMessageException(String string) {
            super(string);
        }
    }

    public static class SmackWrappedException
    extends SmackException {
        private static final long serialVersionUID = 1L;

        public SmackWrappedException(Exception exception) {
            super(exception);
        }

        public SmackWrappedException(String string, Exception exception) {
            super(string, exception);
        }
    }

    public static class ResourceBindingNotOfferedException
    extends SmackException {
        private static final long serialVersionUID = 2346934138253437571L;

        public ResourceBindingNotOfferedException() {
            super("Resource binding was not offered by server");
        }
    }

    public static class FeatureNotSupportedException
    extends SmackException {
        private static final long serialVersionUID = 4713404802621452016L;
        private final String feature;
        private final i jid;

        public FeatureNotSupportedException(String string) {
            this(string, (i)null);
        }

        public FeatureNotSupportedException(String string, i i2) {
            super(string + " not supported" + (i2 == null ? "" : " by '" + i2 + "'"));
            this.jid = i2;
            this.feature = string;
        }

        public String getFeature() {
            return this.feature;
        }

        public i getJid() {
            return this.jid;
        }
    }

    public static final class NoEndpointsDiscoveredException
    extends ConnectionException {
        private static final long serialVersionUID = 1L;
        private final List<XmppClientToServerTransport.LookupConnectionEndpointsFailed> lookupFailures;

        private NoEndpointsDiscoveredException(String string, List<XmppClientToServerTransport.LookupConnectionEndpointsFailed> list) {
            super(string);
            this.lookupFailures = Collections.unmodifiableList(list);
        }

        public List<XmppClientToServerTransport.LookupConnectionEndpointsFailed> getLookupFailures() {
            return this.lookupFailures;
        }

        public static NoEndpointsDiscoveredException from(List<XmppClientToServerTransport.LookupConnectionEndpointsFailed> list) {
            StringBuilder stringBuilder = new StringBuilder();
            if (list.isEmpty()) {
                stringBuilder.append("No endpoint lookup finished within the timeout");
            } else {
                stringBuilder.append("No endpoints could be discovered due the following lookup failures: ");
                StringUtils.appendTo(list, stringBuilder);
            }
            return new NoEndpointsDiscoveredException(stringBuilder.toString(), list);
        }
    }

    public static final class EndpointConnectionException
    extends ConnectionException {
        private static final long serialVersionUID = 1L;
        private final List<RemoteConnectionEndpointLookupFailure> lookupFailures;
        private final List<? extends RemoteConnectionException<?>> connectionExceptions;

        private EndpointConnectionException(String string, List<RemoteConnectionEndpointLookupFailure> list, List<? extends RemoteConnectionException<?>> list2) {
            super(string);
            assert (!list.isEmpty() || !list2.isEmpty());
            this.lookupFailures = list;
            this.connectionExceptions = list2;
        }

        public static EndpointConnectionException from(List<RemoteConnectionEndpointLookupFailure> list, List<? extends RemoteConnectionException<?>> list2) {
            StringBuilder stringBuilder = new StringBuilder(256);
            if (!list.isEmpty()) {
                stringBuilder.append("Could not lookup the following endpoints: ");
                StringUtils.appendTo(list, stringBuilder);
            }
            if (!list2.isEmpty()) {
                stringBuilder.append("The following addresses failed: ");
                StringUtils.appendTo(list2, stringBuilder, remoteConnectionException -> stringBuilder.append(remoteConnectionException.getErrorMessage()));
            }
            return new EndpointConnectionException(stringBuilder.toString(), list, list2);
        }

        public List<RemoteConnectionEndpointLookupFailure> getLookupFailures() {
            return this.lookupFailures;
        }

        public List<? extends RemoteConnectionException<? extends RemoteConnectionEndpoint>> getConnectionExceptions() {
            return this.connectionExceptions;
        }
    }

    public static final class GenericConnectionException
    extends ConnectionException {
        private static final long serialVersionUID = 1L;

        @Deprecated
        public GenericConnectionException(Throwable throwable) {
            super(throwable);
        }
    }

    public static abstract class ConnectionException
    extends SmackException {
        private static final long serialVersionUID = 1L;

        protected ConnectionException(Throwable throwable) {
            super(throwable);
        }

        protected ConnectionException(String string) {
            super(string);
        }
    }

    public static class SecurityNotPossibleException
    extends SmackException {
        private static final long serialVersionUID = -6836090872690331336L;

        public SecurityNotPossibleException(String string) {
            super(string);
        }
    }

    public static class SecurityRequiredByServerException
    extends SecurityRequiredException {
        private static final long serialVersionUID = 8268148813117631819L;

        public SecurityRequiredByServerException() {
            super("SSL/TLS required by server but disabled in client");
        }
    }

    public static class SecurityRequiredByClientException
    extends SecurityRequiredException {
        private static final long serialVersionUID = 2395325821201543159L;

        public SecurityRequiredByClientException() {
            super("SSL/TLS required by client but not supported by server");
        }
    }

    public static abstract class SecurityRequiredException
    extends SmackException {
        private static final long serialVersionUID = 384291845029773545L;

        public SecurityRequiredException(String string) {
            super(string);
        }
    }

    public static class IllegalStateChangeException
    extends SmackException {
        private static final long serialVersionUID = -1766023961577168927L;
    }

    public static class NotConnectedException
    extends SmackException {
        private static final long serialVersionUID = 9197980400776001173L;

        public NotConnectedException() {
            this((String)null);
        }

        public NotConnectedException(String string) {
            super("Client is not, or no longer, connected." + (string != null ? ' ' + string : ""));
        }

        public NotConnectedException(XMPPConnection xMPPConnection, String string) {
            super("The connection " + xMPPConnection.toString() + " is no longer connected. " + string);
        }

        public NotConnectedException(XMPPConnection xMPPConnection, StanzaFilter stanzaFilter) {
            super("The connection " + xMPPConnection + " is no longer connected while waiting for response with " + stanzaFilter);
        }

        public NotConnectedException(XMPPConnection xMPPConnection, StanzaFilter stanzaFilter, Exception exception) {
            super("The connection " + xMPPConnection + " is no longer connected while waiting for response with " + stanzaFilter + " because of " + exception, exception);
        }
    }

    public static class AlreadyConnectedException
    extends SmackException {
        private static final long serialVersionUID = 5011416918049135231L;

        public AlreadyConnectedException() {
            super("Client is already connected");
        }
    }

    public static class AlreadyLoggedInException
    extends SmackException {
        private static final long serialVersionUID = 5011416918049935231L;

        public AlreadyLoggedInException() {
            super("Client is already logged in");
        }
    }

    public static class NotLoggedInException
    extends SmackException {
        private static final long serialVersionUID = 3216216839100019278L;

        public NotLoggedInException() {
            super("Client is not logged in");
        }
    }

    public static final class NoResponseException
    extends SmackException {
        private static final long serialVersionUID = -6523363748984543636L;
        private final StanzaFilter filter;

        private NoResponseException(String string) {
            this(string, (StanzaFilter)null);
        }

        private NoResponseException(String string, StanzaFilter stanzaFilter) {
            super(string);
            this.filter = stanzaFilter;
        }

        public StanzaFilter getFilter() {
            return this.filter;
        }

        public static NoResponseException newWith(XMPPConnection xMPPConnection, String string) {
            StringBuilder stringBuilder = NoResponseException.getWaitingFor(xMPPConnection);
            stringBuilder.append(" While waiting for ").append(string);
            stringBuilder.append(" [").append(xMPPConnection).append(']');
            return new NoResponseException(stringBuilder.toString());
        }

        public static NoResponseException newWith(long l, StanzaCollector stanzaCollector, boolean bl) {
            return NoResponseException.newWith(l, stanzaCollector.getStanzaFilter(), bl);
        }

        public static NoResponseException newWith(XMPPConnection xMPPConnection, StanzaFilter stanzaFilter) {
            return NoResponseException.newWith(xMPPConnection.getReplyTimeout(), stanzaFilter, false);
        }

        public static NoResponseException newWith(long l, StanzaFilter stanzaFilter, boolean bl) {
            StringBuilder stringBuilder = NoResponseException.getWaitingFor(l);
            if (bl) {
                stringBuilder.append(" StanzaCollector has been cancelled.");
            }
            stringBuilder.append(" Waited for response using: ");
            if (stanzaFilter != null) {
                stringBuilder.append(stanzaFilter.toString());
            } else {
                stringBuilder.append("No filter used or filter was 'null'");
            }
            stringBuilder.append('.');
            return new NoResponseException(stringBuilder.toString(), stanzaFilter);
        }

        private static StringBuilder getWaitingFor(XMPPConnection xMPPConnection) {
            return NoResponseException.getWaitingFor(xMPPConnection.getReplyTimeout());
        }

        private static StringBuilder getWaitingFor(long l) {
            StringBuilder stringBuilder = new StringBuilder(256);
            stringBuilder.append("No response received within reply timeout. Timeout was " + l + "ms (~" + l / 1000L + "s).");
            return stringBuilder;
        }
    }
}

