/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.altconnections;

import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import org.e.a.b;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;

public final class HttpLookupMethod {
    private static final String XRD_NAMESPACE = "http://docs.oasis-open.org/ns/xri/xrd-1.0";

    public static List<URI> lookup(b b2, String string) {
        try (InputStream inputStream = HttpLookupMethod.getXrdStream(b2);){
            List<URI> list;
            XmlPullParser xmlPullParser = PacketParserUtils.getParserFor(inputStream);
            List<URI> list2 = list = HttpLookupMethod.parseXrdLinkReferencesFor(xmlPullParser, string);
            return list2;
        }
    }

    public static List<URI> lookup(b b2, LinkRelation linkRelation) {
        return HttpLookupMethod.lookup(b2, linkRelation.attribute);
    }

    public static InputStream getXrdStream(b b2) {
        String string = "https://" + b2 + "/.well-known/host-meta";
        URL uRL = new URL(string);
        URLConnection uRLConnection = uRL.openConnection();
        return uRLConnection.getInputStream();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static List<URI> parseXrdLinkReferencesFor(XmlPullParser xmlPullParser, String string) {
        ParserUtils.forwardToStartElement(xmlPullParser);
        ArrayList<URI> arrayList = new ArrayList<URI>();
        int n = xmlPullParser.getDepth();
        block4: while (true) {
            XmlPullParser.TagEvent tagEvent = xmlPullParser.nextTag();
            switch (tagEvent) {
                case START_ELEMENT: {
                    String string2 = xmlPullParser.getName();
                    String string3 = xmlPullParser.getNamespace();
                    String string4 = xmlPullParser.getAttributeValue("rel");
                    if (!string3.equals(XRD_NAMESPACE) || !string2.equals("Link") || !string4.equals(string)) continue block4;
                    String string5 = xmlPullParser.getAttributeValue("href");
                    URI uRI = new URI(string5);
                    arrayList.add(uRI);
                    break;
                }
                case END_ELEMENT: {
                    if (xmlPullParser.getDepth() != n) break;
                    return arrayList;
                }
            }
        }
    }

    public static List<URI> parseXrdLinkReferencesFor(XmlPullParser xmlPullParser, LinkRelation linkRelation) {
        return HttpLookupMethod.parseXrdLinkReferencesFor(xmlPullParser, linkRelation.attribute);
    }

    public static enum LinkRelation {
        BOSH("urn:xmpp:alt-connections:xbosh"),
        WEBSOCKET("urn:xmpp:alt-connections:websocket");

        private final String attribute;

        private LinkRelation(String string2) {
            this.attribute = string2;
        }
    }
}

