/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.Objects;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.AbstractIqBuilder;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.IqBuilder;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.StanzaError;

public final class ErrorIQ
extends IQ {
    public static final String ELEMENT = "error";
    private final IQ request;

    private ErrorIQ(Builder builder, QName qName) {
        super(builder, qName);
        Objects.requireNonNull(builder.getError(), "Must provide an stanza error when building error IQs");
        this.request = builder.request;
    }

    public static ErrorIQ createErrorResponse(IQ iQ, StanzaError stanzaError) {
        Builder builder = new Builder(stanzaError, iQ);
        builder.setError(stanzaError);
        return builder.build();
    }

    @Override
    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder iQChildElementXmlStringBuilder) {
        if (this.request == null) {
            return null;
        }
        return this.request.getIQChildElementBuilder(iQChildElementXmlStringBuilder);
    }

    public static Builder builder(StanzaError stanzaError) {
        return new Builder(stanzaError, IqData.EMPTY.ofType(IQ.Type.error));
    }

    public static Builder builder(StanzaError stanzaError, IqData iqData) {
        return new Builder(stanzaError, iqData);
    }

    public static final class Builder
    extends IqBuilder<Builder, ErrorIQ> {
        private IQ request;

        Builder(StanzaError stanzaError, IqData iqData) {
            super(iqData);
            if (iqData.getType() != IQ.Type.error) {
                throw new IllegalArgumentException("Error IQs must be of type 'error'");
            }
            Objects.requireNonNull(stanzaError, "Must provide an stanza error when building error IQs");
            this.setError(stanzaError);
        }

        Builder(StanzaError stanzaError, IQ iQ) {
            this(stanzaError, AbstractIqBuilder.createErrorResponse(iQ));
            this.request = iQ;
        }

        @Override
        public Builder getThis() {
            return this;
        }

        @Override
        public ErrorIQ build() {
            QName qName = null;
            if (this.request != null) {
                qName = this.request.getChildElementQName();
            }
            return new ErrorIQ(this, qName);
        }
    }
}

