/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sasl.core;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.security.auth.callback.CallbackHandler;
import org.e.c.a.a;
import org.e.c.a.c;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.sasl.core.ScramHmac;
import org.jivesoftware.smack.util.ByteUtils;
import org.jivesoftware.smack.util.SHA1;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.stringencoder.Base64;

public abstract class ScramMechanism
extends SASLMechanism {
    private static final int RANDOM_ASCII_BYTE_COUNT = 32;
    private static final byte[] CLIENT_KEY_BYTES = ScramMechanism.toBytes("Client Key");
    private static final byte[] SERVER_KEY_BYTES = ScramMechanism.toBytes("Server Key");
    private static final byte[] ONE = new byte[]{0, 0, 0, 1};
    private static final ThreadLocal<SecureRandom> SECURE_RANDOM = new ThreadLocal<SecureRandom>(){

        @Override
        protected SecureRandom initialValue() {
            return new SecureRandom();
        }
    };
    private static final a<String, Keys> CACHE = new c(10);
    private final ScramHmac scramHmac;
    private State state = State.INITIAL;
    private String clientRandomAscii;
    private String clientFirstMessageBare;
    private byte[] serverSignature;

    protected ScramMechanism(ScramHmac scramHmac) {
        this.scramHmac = scramHmac;
    }

    @Override
    protected void authenticateInternal(CallbackHandler callbackHandler) {
        throw new UnsupportedOperationException("CallbackHandler not (yet) supported");
    }

    @Override
    protected byte[] getAuthenticationText() {
        this.clientRandomAscii = this.getRandomAscii();
        String string = ScramMechanism.saslPrep(this.authenticationId);
        this.clientFirstMessageBare = "n=" + ScramMechanism.escape(string) + ",r=" + this.clientRandomAscii;
        String string2 = this.getGS2Header() + this.clientFirstMessageBare;
        this.state = State.AUTH_TEXT_SENT;
        return ScramMechanism.toBytes(string2);
    }

    @Override
    public String getName() {
        String string = "SCRAM-" + this.scramHmac.getHmacName();
        return string;
    }

    @Override
    public void checkIfSuccessfulOrThrow() {
        if (this.state != State.VALID_SERVER_RESPONSE) {
            throw new SmackException.SmackSaslException("SCRAM-SHA1 is missing valid server response");
        }
    }

    @Override
    public boolean authzidSupported() {
        return true;
    }

    @Override
    protected byte[] evaluateChallenge(byte[] byArray) {
        String string = new String(byArray, StandardCharsets.UTF_8);
        switch (this.state) {
            case AUTH_TEXT_SENT: {
                byte[] byArray2;
                byte[] byArray3;
                byte[] byArray4;
                int n;
                String string2 = string;
                Map<Character, String> map = ScramMechanism.parseAttributes(string);
                String string3 = map.get(Character.valueOf('r'));
                if (string3 == null) {
                    throw new SmackException.SmackSaslException("Server random ASCII is null");
                }
                if (string3.length() <= this.clientRandomAscii.length()) {
                    throw new SmackException.SmackSaslException("Server random ASCII is shorter then client random ASCII");
                }
                String string4 = string3.substring(0, this.clientRandomAscii.length());
                if (!string4.equals(this.clientRandomAscii)) {
                    throw new SmackException.SmackSaslException("Received client random ASCII does not match client random ASCII");
                }
                String string5 = map.get(Character.valueOf('i'));
                if (string5 == null) {
                    throw new SmackException.SmackSaslException("Iterations attribute not set");
                }
                try {
                    n = Integer.parseInt(string5);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SmackException.SmackSaslException("Exception parsing iterations", numberFormatException);
                }
                String string6 = map.get(Character.valueOf('s'));
                if (string6 == null) {
                    throw new SmackException.SmackSaslException("SALT not send");
                }
                String string7 = "c=" + Base64.encodeToString(this.getCBindInput());
                String string8 = string7 + ",r=" + string3;
                byte[] byArray5 = ScramMechanism.toBytes(this.clientFirstMessageBare + ',' + string2 + ',' + string8);
                String string9 = this.password + ',' + string6 + ',' + this.getName();
                Keys keys = (Keys)CACHE.a((Object)string9);
                if (keys == null) {
                    byArray4 = this.hi(ScramMechanism.saslPrep(this.password), Base64.decode(string6), n);
                    byArray3 = this.hmac(byArray4, SERVER_KEY_BYTES);
                    byArray2 = this.hmac(byArray4, CLIENT_KEY_BYTES);
                    keys = new Keys(byArray2, byArray3);
                    CACHE.put((Object)string9, (Object)keys);
                } else {
                    byArray3 = keys.serverKey;
                    byArray2 = keys.clientKey;
                }
                this.serverSignature = this.hmac(byArray3, byArray5);
                byArray4 = SHA1.bytes(byArray2);
                byte[] byArray6 = this.hmac(byArray4, byArray5);
                byte[] byArray7 = new byte[byArray2.length];
                for (int k = 0; k < byArray7.length; ++k) {
                    byArray7[k] = (byte)(byArray2[k] ^ byArray6[k]);
                }
                String string10 = string8 + ",p=" + Base64.encodeToString(byArray7);
                this.state = State.RESPONSE_SENT;
                return ScramMechanism.toBytes(string10);
            }
            case RESPONSE_SENT: {
                String string11 = "v=" + Base64.encodeToString(this.serverSignature);
                if (!string11.equals(string)) {
                    throw new SmackException.SmackSaslException("Server final message does not match calculated one");
                }
                this.state = State.VALID_SERVER_RESPONSE;
                break;
            }
            default: {
                throw new SmackException.SmackSaslException("Invalid state");
            }
        }
        return null;
    }

    private String getGS2Header() {
        String string = "";
        if (this.authorizationId != null) {
            string = "a=" + this.authorizationId;
        }
        String string2 = this.getGs2CbindFlag();
        assert (StringUtils.isNotEmpty((CharSequence)string2));
        return string2 + ',' + string + ",";
    }

    private byte[] getCBindInput() {
        byte[] byArray = this.getChannelBindingData();
        byte[] byArray2 = ScramMechanism.toBytes(this.getGS2Header());
        if (byArray == null) {
            return byArray2;
        }
        return ByteUtils.concat(byArray2, byArray);
    }

    protected String getGs2CbindFlag() {
        if (this.sslSession != null && this.connectionConfiguration.isEnabledSaslMechanism(this.getName() + "-PLUS")) {
            return "y";
        }
        return "n";
    }

    protected byte[] getChannelBindingData() {
        return null;
    }

    private static Map<Character, String> parseAttributes(String string) {
        if (string.length() == 0) {
            return Collections.emptyMap();
        }
        String[] stringArray = string.split(",");
        HashMap<Character, String> hashMap = new HashMap<Character, String>(stringArray.length, 1.0f);
        for (String string2 : stringArray) {
            if (string2.length() < 3) {
                throw new SmackException.SmackSaslException("Invalid Key-Value pair: " + string2);
            }
            char c2 = string2.charAt(0);
            if (string2.charAt(1) != '=') {
                throw new SmackException.SmackSaslException("Invalid Key-Value pair: " + string2);
            }
            String string3 = string2.substring(2);
            hashMap.put(Character.valueOf(c2), string3);
        }
        return hashMap;
    }

    String getRandomAscii() {
        int n = 0;
        char[] cArray = new char[32];
        Random random = SECURE_RANDOM.get();
        while (n < 32) {
            int n2 = random.nextInt(128);
            char c2 = (char)n2;
            if (!ScramMechanism.isPrintableNonCommaAsciiChar(c2)) continue;
            cArray[n++] = c2;
        }
        return new String(cArray);
    }

    private static boolean isPrintableNonCommaAsciiChar(char c2) {
        if (c2 == ',') {
            return false;
        }
        return c2 > ' ' && c2 < '\u007f';
    }

    private static String escape(String string) {
        StringBuilder stringBuilder = new StringBuilder((int)((double)string.length() * 1.1));
        block4: for (int k = 0; k < string.length(); ++k) {
            char c2 = string.charAt(k);
            switch (c2) {
                case ',': {
                    stringBuilder.append("=2C");
                    continue block4;
                }
                case '=': {
                    stringBuilder.append("=3D");
                    continue block4;
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
        }
        return stringBuilder.toString();
    }

    private byte[] hmac(byte[] byArray, byte[] byArray2) {
        try {
            return this.scramHmac.hmac(byArray, byArray2);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SmackException.SmackSaslException(this.getName() + " Exception", invalidKeyException);
        }
    }

    private byte[] hi(String string, byte[] byArray, int n) {
        byte[] byArray2 = string.getBytes(StandardCharsets.UTF_8);
        byte[] byArray3 = this.hmac(byArray2, ByteUtils.concat(byArray, ONE));
        byte[] byArray4 = (byte[])byArray3.clone();
        for (int k = 1; k < n; ++k) {
            byArray3 = this.hmac(byArray2, byArray3);
            for (int i2 = 0; i2 < byArray3.length; ++i2) {
                int n2 = i2;
                byArray4[n2] = (byte)(byArray4[n2] ^ byArray3[i2]);
            }
        }
        return byArray4;
    }

    private static class Keys {
        private final byte[] clientKey;
        private final byte[] serverKey;

        Keys(byte[] byArray, byte[] byArray2) {
            this.clientKey = byArray;
            this.serverKey = byArray2;
        }
    }

    private static enum State {
        INITIAL,
        AUTH_TEXT_SENT,
        RESPONSE_SENT,
        VALID_SERVER_RESPONSE;

    }
}

