/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.util.WriterListener;

public class ObservableWriter
extends Writer {
    private static final int MAX_STRING_BUILDER_SIZE = 4096;
    Writer wrappedWriter = null;
    final List<WriterListener> listeners = new ArrayList<WriterListener>();
    private final StringBuilder stringBuilder = new StringBuilder(4096);

    public ObservableWriter(Writer writer) {
        this.wrappedWriter = writer;
    }

    @Override
    public void write(char[] cArray, int n, int n2) {
        this.wrappedWriter.write(cArray, n, n2);
        String string = new String(cArray, n, n2);
        this.maybeNotifyListeners(string);
    }

    @Override
    public void flush() {
        this.notifyListeners();
        this.wrappedWriter.flush();
    }

    @Override
    public void close() {
        this.wrappedWriter.close();
    }

    @Override
    public void write(int n) {
        this.wrappedWriter.write(n);
    }

    @Override
    public void write(char[] cArray) {
        this.wrappedWriter.write(cArray);
        String string = new String(cArray);
        this.maybeNotifyListeners(string);
    }

    @Override
    public void write(String string) {
        this.wrappedWriter.write(string);
        this.maybeNotifyListeners(string);
    }

    @Override
    public void write(String string, int n, int n2) {
        this.wrappedWriter.write(string, n, n2);
        string = string.substring(n, n + n2);
        this.maybeNotifyListeners(string);
    }

    private void maybeNotifyListeners(String string) {
        this.stringBuilder.append(string);
        if (this.stringBuilder.length() > 4096) {
            this.notifyListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        WriterListener[] writerListenerArray;
        Object object = this.listeners;
        synchronized (object) {
            writerListenerArray = new WriterListener[this.listeners.size()];
            this.listeners.toArray(writerListenerArray);
        }
        object = this.stringBuilder.toString();
        this.stringBuilder.setLength(0);
        for (WriterListener writerListener : writerListenerArray) {
            writerListener.write((String)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWriterListener(WriterListener writerListener) {
        if (writerListener == null) {
            return;
        }
        List<WriterListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(writerListener)) {
                this.listeners.add(writerListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWriterListener(WriterListener writerListener) {
        List<WriterListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(writerListener);
        }
    }
}

