/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import androidx.b.e;
import androidx.compose.ui.graphics.PathSegment;
import androidx.compose.ui.util.MathHelpersKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\u0002\n\u0002\b\u001d\u001a\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0002\u001a\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0007\u001a \u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002\u001a(\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002\u001a0\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002\u001a \u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0007\u001a\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0004H\u0007\u001a\u0019\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0082\b\u001a \u0010\u0016\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002\u001a(\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0007\u001a+\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u0019H\u0082\b\u001a2\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u0019H\u0002\u001a(\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0002\u001a'\u0010!\u001a\u00020\"2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u0019H\u0007\u00a2\u0006\u0002\u0010#\u001a'\u0010$\u001a\u00020\"2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\u0010#\u001a?\u0010%\u001a\u00020\"2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u0019H\u0007\u00a2\u0006\u0002\u0010(\u001a\u0015\u0010)\u001a\u00020 *\u00020\u00012\u0006\u0010*\u001a\u00020\u0001H\u0080\b\u001a\u0015\u0010)\u001a\u00020 *\u00020\u00042\u0006\u0010*\u001a\u00020\u0004H\u0080\b\u001a\u0011\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020\u0004H\u0082\b\u001a \u0010-\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0002\u001a \u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u001b2\u0006\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u0004H\u0000\u001a \u00102\u001a\u00020 2\u0006\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u0004H\u0002\u001a0\u00106\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u001b2\u0006\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u001b2\u0006\u00108\u001a\u00020\u001bH\u0000\u001a0\u00109\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u001b2\u0006\u0010:\u001a\u00020\u00192\u0006\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u001bH\u0002\u001a\u0018\u0010;\u001a\u00020\u00192\u0006\u0010<\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020\u001bH\u0002\u001a \u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u0004H\u0002\u001a\u0018\u0010A\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u0004H\u0002\u001a0\u0010B\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u001b2\u0006\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u00042\u0006\u0010C\u001a\u00020\u001b2\u0006\u00108\u001a\u00020\u001bH\u0000\u001a(\u0010D\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u001b2\u0006\u0010:\u001a\u00020\u00192\u0006\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u0004H\u0002\u001a \u0010E\u001a\u00020\u00192\u0006\u0010F\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020\u001b2\u0006\u0010G\u001a\u00020\u001bH\u0002\u001a\u0018\u0010H\u001a\u00020\u00192\u0006\u0010F\u001a\u00020\u001b2\u0006\u0010I\u001a\u00020\u001bH\u0002\u001a0\u0010J\u001a\u00020?2\u0006\u0010@\u001a\u00020\u001b2\u0006\u0010K\u001a\u00020\u00192\u0006\u0010=\u001a\u00020\u001b2\u0006\u0010L\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\u0004H\u0002\u001aH\u0010M\u001a\u00020\u00042\u0006\u0010N\u001a\u00020\u00042\u0006\u00103\u001a\u00020\u00042\u0006\u0010O\u001a\u00020\u00042\u0006\u00104\u001a\u00020\u00042\u0006\u0010P\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u00042\u0006\u0010Q\u001a\u00020\u00042\u0006\u0010R\u001a\u00020\u0004H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0019\u0010S\u001a\u00020\u0004*\u00020\u00078\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bT\u0010U\"\u0018\u0010V\u001a\u00020\u0004*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bW\u0010U\"\u0019\u0010X\u001a\u00020\u0004*\u00020\u00078\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bY\u0010U\"\u0018\u0010Z\u001a\u00020\u0004*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b[\u0010U\u00a8\u0006\\"}, d2={"Tau", "", "Epsilon", "FloatEpsilon", "", "evaluateX", "segment", "Landroidx/compose/ui/graphics/PathSegment;", "t", "evaluateY", "evaluateLine", "p0y", "p1y", "evaluateQuadratic", "p0", "p1", "p2", "evaluateCubic", "p3", "findFirstRoot", "fraction", "findFirstLineRoot", "findFirstQuadraticRoot", "findFirstCubicRoot", "findLineRoot", "", "roots", "", "index", "findQuadraticRoots", "findDerivativeRoots", "horizontal", "", "computeHorizontalBounds", "Landroidx/collection/FloatFloatPair;", "(Landroidx/compose/ui/graphics/PathSegment;[FI)J", "computeVerticalBounds", "computeCubicVerticalBounds", "p2y", "p3y", "(FFFF[FI)J", "closeTo", "b", "clampValidRootInUnitRange", "r", "writeValidRootInUnitRange", "lineWinding", "points", "x", "y", "isQuadraticMonotonic", "y0", "y1", "y2", "quadraticWinding", "tmpQuadratics", "tmpRoots", "monotonicQuadraticWinding", "offset", "quadraticToMonotonicQuadratics", "quadratic", "dst", "splitQuadraticAt", "", "src", "unitDivide", "cubicWinding", "tmpCubics", "monotonicCubicWinding", "cubicToMonotonicCubics", "cubic", "tmpRoot", "findCubicExtremaY", "dstRoots", "splitCubicAt", "srcOffset", "dstOffset", "cubicArea", "x0", "x1", "x2", "x3", "y3", "startX", "getStartX", "(Landroidx/compose/ui/graphics/PathSegment;)F", "endX", "getEndX", "startY", "getStartY", "endY", "getEndY", "ui-graphics"})
public final class BezierKt {
    private static final double Tau = Math.PI * 2;
    private static final double Epsilon = 1.0E-7;
    private static final float FloatEpsilon = 1.05E-6f;

    private static final float evaluateX(PathSegment pathSegment, float f) {
        float f2;
        float[] fArray = pathSegment.getPoints();
        switch (WhenMappings.$EnumSwitchMapping$0[pathSegment.getType().ordinal()]) {
            case 1: {
                f2 = fArray[0];
                break;
            }
            case 2: {
                f2 = BezierKt.evaluateLine(fArray[0], fArray[2], f);
                break;
            }
            case 3: {
                f2 = BezierKt.evaluateQuadratic(fArray[0], fArray[2], fArray[4], f);
                break;
            }
            case 4: {
                f2 = BezierKt.evaluateCubic(fArray[0], fArray[2], fArray[4], fArray[6], f);
                break;
            }
            default: {
                f2 = Float.NaN;
            }
        }
        return f2;
    }

    public static final float evaluateY(PathSegment pathSegment, float f) {
        float f2;
        Intrinsics.checkNotNullParameter((Object)pathSegment, (String)"");
        float[] fArray = pathSegment.getPoints();
        switch (WhenMappings.$EnumSwitchMapping$0[pathSegment.getType().ordinal()]) {
            case 1: {
                f2 = fArray[1];
                break;
            }
            case 2: {
                f2 = BezierKt.evaluateLine(fArray[1], fArray[3], f);
                break;
            }
            case 3: {
                f2 = BezierKt.evaluateQuadratic(fArray[1], fArray[3], fArray[5], f);
                break;
            }
            case 4: {
                f2 = BezierKt.evaluateCubic(fArray[1], fArray[3], fArray[5], fArray[7], f);
                break;
            }
            default: {
                f2 = Float.NaN;
            }
        }
        return f2;
    }

    private static final float evaluateLine(float f, float f2, float f3) {
        return (f2 - f) * f3 + f;
    }

    private static final float evaluateQuadratic(float f, float f2, float f3, float f4) {
        float f5 = 2.0f * (f2 - f);
        float f6 = f3 - 2.0f * f2 + f;
        return (f6 * f4 + f5) * f4 + f;
    }

    private static final float evaluateCubic(float f, float f2, float f3, float f4, float f5) {
        float f6 = f4 + 3.0f * (f2 - f3) - f;
        float f7 = 3.0f * (f3 - 2.0f * f2 + f);
        float f8 = 3.0f * (f2 - f);
        return ((f6 * f5 + f7) * f5 + f8) * f5 + f;
    }

    public static final float evaluateCubic(float f, float f2, float f3) {
        float f4 = 0.33333334f + (f - f2);
        float f5 = f2 - 2.0f * f;
        float f6 = f;
        return 3.0f * ((f4 * f3 + f5) * f3 + f6) * f3;
    }

    public static final float findFirstRoot(PathSegment pathSegment, float f) {
        float f2;
        Intrinsics.checkNotNullParameter((Object)pathSegment, (String)"");
        float[] fArray = pathSegment.getPoints();
        switch (WhenMappings.$EnumSwitchMapping$0[pathSegment.getType().ordinal()]) {
            case 1: {
                f2 = Float.NaN;
                break;
            }
            case 2: {
                float f3 = fArray[0] - f;
                float f4 = fArray[2] - f;
                boolean bl = false;
                float f5 = -f3 / (f4 - f3);
                boolean bl2 = false;
                float f6 = f5;
                float f7 = 0.0f;
                float f8 = 1.0f;
                boolean bl3 = false;
                float f9 = f6;
                float f10 = f7;
                boolean bl4 = false;
                f9 = f9 < f10 ? f10 : f9;
                f10 = f8;
                bl4 = false;
                float f11 = f9 > f10 ? f10 : f9;
                float f12 = f11;
                if (Math.abs(f12 - f5) > 1.05E-6f) {
                    f2 = Float.NaN;
                    break;
                }
                f2 = f12;
                break;
            }
            case 3: {
                f2 = BezierKt.findFirstQuadraticRoot(fArray[0] - f, fArray[2] - f, fArray[4] - f);
                break;
            }
            case 5: {
                f2 = Float.NaN;
                break;
            }
            case 4: {
                f2 = BezierKt.findFirstCubicRoot(fArray[0] - f, fArray[2] - f, fArray[4] - f, fArray[6] - f);
                break;
            }
            case 6: {
                f2 = Float.NaN;
                break;
            }
            case 7: {
                f2 = Float.NaN;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return f2;
    }

    private static final float findFirstLineRoot(float f, float f2) {
        boolean bl = false;
        float f3 = -f / (f2 - f);
        boolean bl2 = false;
        float f4 = f3;
        float f5 = 0.0f;
        float f6 = 1.0f;
        boolean bl3 = false;
        float f7 = f4;
        float f8 = f5;
        boolean bl4 = false;
        f7 = f7 < f8 ? f8 : f7;
        f8 = f6;
        bl4 = false;
        float f9 = f7 > f8 ? f8 : f7;
        return Math.abs(f9 - f3) > 1.05E-6f ? Float.NaN : f9;
    }

    private static final float findFirstQuadraticRoot(float f, float f2, float f3) {
        double d = f;
        double d2 = f2;
        double d3 = f3;
        double d4 = d - 2.0 * d2 + d3;
        if (!(d4 == 0.0)) {
            float f4;
            double d5 = -Math.sqrt(d2 * d2 - d * d3);
            double d6 = -d + d2;
            float f5 = (float)(-(d5 + d6) / d4);
            boolean bl = false;
            float f6 = f5;
            float f7 = 0.0f;
            float f8 = 1.0f;
            boolean bl2 = false;
            float f9 = f6;
            float f10 = f7;
            boolean bl3 = false;
            f9 = f9 < f10 ? f10 : f9;
            f10 = f8;
            bl3 = false;
            float f11 = f9 > f10 ? f10 : f9;
            float f12 = f4 = Math.abs(f11 - f5) > 1.05E-6f ? Float.NaN : f11;
            if (!Float.isNaN(f4)) {
                return f4;
            }
            f5 = (float)((d5 - d6) / d4);
            bl = false;
            f6 = f5;
            f7 = 0.0f;
            f8 = 1.0f;
            bl2 = false;
            f9 = f6;
            f10 = f7;
            bl3 = false;
            f9 = f9 < f10 ? f10 : f9;
            f10 = f8;
            bl3 = false;
            f11 = f9 > f10 ? f10 : f9;
            return Math.abs(f11 - f5) > 1.05E-6f ? Float.NaN : f11;
        }
        if (!(d2 == d3)) {
            float f13 = (float)((2.0 * d2 - d3) / (2.0 * d2 - 2.0 * d3));
            boolean bl = false;
            float f14 = f13;
            float f15 = 0.0f;
            float f16 = 1.0f;
            boolean bl4 = false;
            float f17 = f14;
            float f18 = f15;
            boolean bl5 = false;
            f17 = f17 < f18 ? f18 : f17;
            f18 = f16;
            bl5 = false;
            float f19 = f17 > f18 ? f18 : f17;
            return Math.abs(f19 - f13) > 1.05E-6f ? Float.NaN : f19;
        }
        return Float.NaN;
    }

    public static final float findFirstCubicRoot(float f, float f2, float f3, float f4) {
        double d;
        double d2 = 3.0 * ((double)f - 2.0 * (double)f2 + (double)f3);
        double d3 = 3.0 * (double)(f2 - f);
        double d4 = f;
        double d5 = d = (double)(-f) + 3.0 * (double)(f2 - f3) + (double)f4;
        double d6 = 0.0;
        boolean bl = false;
        if (Math.abs(d5 - d6) < 1.0E-7) {
            float f5;
            d5 = d2;
            d6 = 0.0;
            bl = false;
            if (Math.abs(d5 - d6) < 1.0E-7) {
                d5 = d3;
                d6 = 0.0;
                bl = false;
                if (Math.abs(d5 - d6) < 1.0E-7) {
                    return Float.NaN;
                }
                float f6 = (float)(-d4 / d3);
                boolean bl2 = false;
                float f7 = f6;
                float f8 = 0.0f;
                float f9 = 1.0f;
                boolean bl3 = false;
                float f10 = f7;
                float f11 = f8;
                boolean bl4 = false;
                f10 = f10 < f11 ? f11 : f10;
                f11 = f9;
                bl4 = false;
                float f12 = f10 > f11 ? f11 : f10;
                return Math.abs(f12 - f6) > 1.05E-6f ? Float.NaN : f12;
            }
            d5 = Math.sqrt(d3 * d3 - 4.0 * d2 * d4);
            d6 = 2.0 * d2;
            float f13 = (float)((d5 - d3) / d6);
            boolean bl5 = false;
            float f14 = f13;
            float f15 = 0.0f;
            float f16 = 1.0f;
            boolean bl6 = false;
            float f17 = f14;
            float f18 = f15;
            boolean bl7 = false;
            f17 = f17 < f18 ? f18 : f17;
            f18 = f16;
            bl7 = false;
            float f19 = f17 > f18 ? f18 : f17;
            float f20 = f5 = Math.abs(f19 - f13) > 1.05E-6f ? Float.NaN : f19;
            if (!Float.isNaN(f5)) {
                return f5;
            }
            f13 = (float)((-d3 - d5) / d6);
            bl5 = false;
            f14 = f13;
            f15 = 0.0f;
            f16 = 1.0f;
            bl6 = false;
            f17 = f14;
            f18 = f15;
            bl7 = false;
            f17 = f17 < f18 ? f18 : f17;
            f18 = f16;
            bl7 = false;
            f19 = f17 > f18 ? f18 : f17;
            return Math.abs(f19 - f13) > 1.05E-6f ? Float.NaN : f19;
        }
        d5 = (3.0 * (d3 /= d) - (d2 /= d) * d2) / 9.0;
        d6 = (2.0 * d2 * d2 * d2 - 9.0 * d2 * d3 + 27.0 * (d4 /= d)) / 54.0;
        double d7 = d6 * d6 + d5 * d5 * d5;
        double d8 = d2 / 3.0;
        if (d7 < 0.0) {
            float f21;
            double d9;
            double d10 = -(d5 * d5 * d5);
            double d11 = Math.sqrt(d10);
            double d12 = d9 = -d6 / d11;
            double d13 = -1.0;
            double d14 = 1.0;
            boolean bl8 = false;
            double d15 = d12;
            double d16 = d13;
            boolean bl9 = false;
            d15 = d15 < d16 ? d16 : d15;
            d16 = d14;
            bl9 = false;
            double d17 = d15 > d16 ? d16 : d15;
            d12 = Math.acos(d17);
            float f22 = 2.0f * MathHelpersKt.fastCbrt((float)((float)d11));
            float f23 = (float)((double)f22 * Math.cos(d12 / 3.0) - d8);
            boolean bl10 = false;
            float f24 = f23;
            float f25 = 0.0f;
            float f26 = 1.0f;
            boolean bl11 = false;
            float f27 = f24;
            float f28 = f25;
            boolean bl12 = false;
            f27 = f27 < f28 ? f28 : f27;
            f28 = f26;
            bl12 = false;
            float f29 = f27 > f28 ? f28 : f27;
            float f30 = f21 = Math.abs(f29 - f23) > 1.05E-6f ? Float.NaN : f29;
            if (!Float.isNaN(f21)) {
                return f21;
            }
            f23 = (float)((double)f22 * Math.cos((d12 + Math.PI * 2) / 3.0) - d8);
            bl10 = false;
            f24 = f23;
            f25 = 0.0f;
            f26 = 1.0f;
            bl11 = false;
            f27 = f24;
            f28 = f25;
            bl12 = false;
            f27 = f27 < f28 ? f28 : f27;
            f28 = f26;
            bl12 = false;
            f29 = f27 > f28 ? f28 : f27;
            float f31 = f21 = Math.abs(f29 - f23) > 1.05E-6f ? Float.NaN : f29;
            if (!Float.isNaN(f21)) {
                return f21;
            }
            f23 = (float)((double)f22 * Math.cos((d12 + Math.PI * 4) / 3.0) - d8);
            bl10 = false;
            f24 = f23;
            f25 = 0.0f;
            f26 = 1.0f;
            bl11 = false;
            f27 = f24;
            f28 = f25;
            bl12 = false;
            f27 = f27 < f28 ? f28 : f27;
            f28 = f26;
            bl12 = false;
            f29 = f27 > f28 ? f28 : f27;
            return Math.abs(f29 - f23) > 1.05E-6f ? Float.NaN : f29;
        }
        if (d7 == 0.0) {
            float f32;
            float f33 = -MathHelpersKt.fastCbrt((float)((float)d6));
            float f34 = 2.0f * f33 - (float)d8;
            boolean bl13 = false;
            float f35 = f34;
            float f36 = 0.0f;
            float f37 = 1.0f;
            boolean bl14 = false;
            float f38 = f35;
            float f39 = f36;
            boolean bl15 = false;
            f38 = f38 < f39 ? f39 : f38;
            f39 = f37;
            bl15 = false;
            float f40 = f38 > f39 ? f39 : f38;
            float f41 = f32 = Math.abs(f40 - f34) > 1.05E-6f ? Float.NaN : f40;
            if (!Float.isNaN(f32)) {
                return f32;
            }
            f34 = -f33 - (float)d8;
            bl13 = false;
            f35 = f34;
            f36 = 0.0f;
            f37 = 1.0f;
            bl14 = false;
            f38 = f35;
            f39 = f36;
            bl15 = false;
            f38 = f38 < f39 ? f39 : f38;
            f39 = f37;
            bl15 = false;
            f40 = f38 > f39 ? f39 : f38;
            return Math.abs(f40 - f34) > 1.05E-6f ? Float.NaN : f40;
        }
        double d18 = Math.sqrt(d7);
        float f42 = MathHelpersKt.fastCbrt((float)((float)(-d6 + d18)));
        float f43 = MathHelpersKt.fastCbrt((float)((float)(d6 + d18)));
        float f44 = (float)((double)(f42 - f43) - d8);
        boolean bl16 = false;
        float f45 = f44;
        float f46 = 0.0f;
        float f47 = 1.0f;
        boolean bl17 = false;
        float f48 = f45;
        float f49 = f46;
        boolean bl18 = false;
        f48 = f48 < f49 ? f49 : f48;
        f49 = f47;
        bl18 = false;
        float f50 = f48 > f49 ? f49 : f48;
        return Math.abs(f50 - f44) > 1.05E-6f ? Float.NaN : f50;
    }

    private static final int findLineRoot(float f, float f2, float[] fArray, int n) {
        boolean bl = false;
        return BezierKt.writeValidRootInUnitRange(-f / (f2 - f), fArray, n);
    }

    static /* synthetic */ int findLineRoot$default(float f, float f2, float[] fArray, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = 0;
        }
        n2 = 0;
        return BezierKt.writeValidRootInUnitRange(-f / (f2 - f), fArray, n);
    }

    private static final int findQuadraticRoots(float f, float f2, float f3, float[] fArray, int n) {
        double d = f;
        double d2 = f2;
        double d3 = f3;
        double d4 = d - 2.0 * d2 + d3;
        int n2 = 0;
        if (!(d4 == 0.0)) {
            double d5 = -Math.sqrt(d2 * d2 - d * d3);
            double d6 = -d + d2;
            n2 += BezierKt.writeValidRootInUnitRange((float)(-(d5 + d6) / d4), fArray, n);
            if ((n2 += BezierKt.writeValidRootInUnitRange((float)((d5 - d6) / d4), fArray, n + n2)) > 1) {
                float f4 = fArray[n];
                float f5 = fArray[n + 1];
                if (f4 > f5) {
                    fArray[n] = f5;
                    fArray[n + 1] = f4;
                } else if (f4 == f5) {
                    --n2;
                }
            }
        } else if (!(d2 == d3)) {
            n2 += BezierKt.writeValidRootInUnitRange((float)((2.0 * d2 - d3) / (2.0 * d2 - 2.0 * d3)), fArray, n);
        }
        return n2;
    }

    static /* synthetic */ int findQuadraticRoots$default(float f, float f2, float f3, float[] fArray, int n, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        return BezierKt.findQuadraticRoots(f, f2, f3, fArray, n);
    }

    private static final int findDerivativeRoots(PathSegment pathSegment, boolean bl, float[] fArray, int n) {
        int n2;
        int n3 = bl ? 0 : 1;
        float[] fArray2 = pathSegment.getPoints();
        switch (WhenMappings.$EnumSwitchMapping$0[pathSegment.getType().ordinal()]) {
            case 3: {
                float f = (float)2 * (fArray2[n3 + 2] - fArray2[n3 + 0]);
                float f2 = (float)2 * (fArray2[n3 + 4] - fArray2[n3 + 2]);
                float f3 = f;
                float f4 = f2;
                float[] fArray3 = fArray;
                int n4 = n;
                boolean bl2 = false;
                n2 = BezierKt.writeValidRootInUnitRange(-f3 / (f4 - f3), fArray3, n4);
                break;
            }
            case 4: {
                float f = 3.0f * (fArray2[n3 + 2] - fArray2[n3 + 0]);
                float f5 = 3.0f * (fArray2[n3 + 4] - fArray2[n3 + 2]);
                float f6 = 3.0f * (fArray2[n3 + 6] - fArray2[n3 + 4]);
                int n5 = BezierKt.findQuadraticRoots(f, f5, f6, fArray, n);
                float f7 = 2.0f * (f5 - f);
                float f8 = 2.0f * (f6 - f5);
                float f9 = f7;
                float f10 = f8;
                float[] fArray4 = fArray;
                int n6 = n + n5;
                boolean bl3 = false;
                n2 = n5 + BezierKt.writeValidRootInUnitRange(-f9 / (f10 - f9), fArray4, n6);
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    public static final long computeHorizontalBounds(PathSegment pathSegment, float[] fArray, int n) {
        Intrinsics.checkNotNullParameter((Object)pathSegment, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        int n2 = BezierKt.findDerivativeRoots(pathSegment, true, fArray, n);
        PathSegment pathSegment2 = pathSegment;
        boolean bl = false;
        float f = pathSegment2.getPoints()[0];
        float f2 = BezierKt.getEndX(pathSegment);
        float f3 = Math.min(f, f2);
        PathSegment pathSegment3 = pathSegment;
        boolean bl2 = false;
        float f4 = pathSegment3.getPoints()[0];
        float f5 = BezierKt.getEndX(pathSegment);
        f = Math.max(f4, f5);
        for (int i = 0; i < n2; ++i) {
            f5 = fArray[i];
            float f6 = BezierKt.evaluateX(pathSegment, f5);
            f3 = Math.min(f3, f6);
            f = Math.max(f, f6);
        }
        return e.a((float)f3, (float)f);
    }

    public static /* synthetic */ long computeHorizontalBounds$default(PathSegment pathSegment, float[] fArray, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return BezierKt.computeHorizontalBounds(pathSegment, fArray, n);
    }

    public static final long computeVerticalBounds(PathSegment pathSegment, float[] fArray, int n) {
        Intrinsics.checkNotNullParameter((Object)pathSegment, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        int n2 = BezierKt.findDerivativeRoots(pathSegment, false, fArray, n);
        PathSegment pathSegment2 = pathSegment;
        boolean bl = false;
        float f = pathSegment2.getPoints()[1];
        float f2 = BezierKt.getEndY(pathSegment);
        float f3 = Math.min(f, f2);
        PathSegment pathSegment3 = pathSegment;
        boolean bl2 = false;
        float f4 = pathSegment3.getPoints()[1];
        float f5 = BezierKt.getEndY(pathSegment);
        f = Math.max(f4, f5);
        for (int i = 0; i < n2; ++i) {
            f5 = fArray[i];
            float f6 = BezierKt.evaluateY(pathSegment, f5);
            f3 = Math.min(f3, f6);
            f = Math.max(f, f6);
        }
        return e.a((float)f3, (float)f);
    }

    public static /* synthetic */ long computeVerticalBounds$default(PathSegment pathSegment, float[] fArray, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return BezierKt.computeVerticalBounds(pathSegment, fArray, n);
    }

    public static final long computeCubicVerticalBounds(float f, float f2, float f3, float f4, float[] fArray, int n) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        float f5 = 3.0f * (f2 - f);
        float f6 = 3.0f * (f3 - f2);
        float f7 = 3.0f * (f4 - f3);
        int n2 = BezierKt.findQuadraticRoots(f5, f6, f7, fArray, n);
        float f8 = 2.0f * (f6 - f5);
        float f9 = 2.0f * (f7 - f6);
        float f10 = f8;
        float f11 = f9;
        float[] fArray2 = fArray;
        int n3 = n + n2;
        boolean bl = false;
        n2 += BezierKt.writeValidRootInUnitRange(-f10 / (f11 - f10), fArray2, n3);
        f10 = Math.min(f, f4);
        f11 = Math.max(f, f4);
        n3 = n2;
        for (int i = 0; i < n3; ++i) {
            float f12 = fArray[i];
            float f13 = BezierKt.evaluateCubic(f, f2, f3, f4, f12);
            f10 = Math.min(f10, f13);
            f11 = Math.max(f11, f13);
        }
        return e.a((float)f10, (float)f11);
    }

    public static /* synthetic */ long computeCubicVerticalBounds$default(float f, float f2, float f3, float f4, float[] fArray, int n, int n2, Object object) {
        if ((n2 & 0x20) != 0) {
            n = 0;
        }
        return BezierKt.computeCubicVerticalBounds(f, f2, f3, f4, fArray, n);
    }

    public static final boolean closeTo(double d, double d2) {
        boolean bl = false;
        return Math.abs(d - d2) < 1.0E-7;
    }

    public static final boolean closeTo(float f, float f2) {
        boolean bl = false;
        return Math.abs(f - f2) < 1.05E-6f;
    }

    private static final float clampValidRootInUnitRange(float f) {
        boolean bl = false;
        float f2 = f;
        float f3 = 0.0f;
        float f4 = 1.0f;
        boolean bl2 = false;
        float f5 = f2;
        float f6 = f3;
        boolean bl3 = false;
        f5 = f5 < f6 ? f6 : f5;
        f6 = f4;
        bl3 = false;
        float f7 = f5 > f6 ? f6 : f5;
        return Math.abs(f7 - f) > 1.05E-6f ? Float.NaN : f7;
    }

    private static final int writeValidRootInUnitRange(float f, float[] fArray, int n) {
        float f2;
        float f3 = f;
        boolean bl = false;
        float f4 = f3;
        float f5 = 0.0f;
        float f6 = 1.0f;
        boolean bl2 = false;
        float f7 = f4;
        float f8 = f5;
        boolean bl3 = false;
        f7 = f7 < f8 ? f8 : f7;
        f8 = f6;
        bl3 = false;
        float f9 = f7 > f8 ? f8 : f7;
        fArray[n] = f2 = Math.abs(f9 - f3) > 1.05E-6f ? Float.NaN : f9;
        return Float.isNaN(f2) ? 0 : 1;
    }

    public static final int lineWinding(float[] fArray, float f, float f2) {
        float f3;
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        if (fArray.length < 4) {
            return 0;
        }
        float f4 = fArray[0];
        float f5 = f3 = fArray[1];
        float f6 = fArray[2];
        float f7 = fArray[3];
        float f8 = f7 - f3;
        int n = 1;
        if (f3 > f7) {
            f3 = f7;
            f7 = f5;
            n = -1;
        }
        if (f2 < f3 || f2 >= f7) {
            return 0;
        }
        float f9 = (f6 - f4) * (f2 - f5) - f8 * (f - f4);
        if (f9 == 0.0f) {
            n = 0;
        } else if ((int)Math.signum(f9) == n) {
            n = 0;
        }
        return n;
    }

    private static final boolean isQuadraticMonotonic(float f, float f2, float f3) {
        return !(Math.signum(f - f2) + Math.signum(f2 - f3) == 0.0f);
    }

    public static final int quadraticWinding(float[] fArray, float f, float f2, float[] fArray2, float[] fArray3) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray2, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray3, (String)"");
        float f3 = fArray[1];
        float f4 = fArray[3];
        float f5 = fArray[5];
        if (BezierKt.isQuadraticMonotonic(f3, f4, f5)) {
            return BezierKt.monotonicQuadraticWinding(fArray, 0, f, f2, fArray3);
        }
        int n = BezierKt.quadraticToMonotonicQuadratics(fArray, fArray2);
        int n2 = BezierKt.monotonicQuadraticWinding(fArray2, 0, f, f2, fArray3);
        if (n > 0) {
            n2 += BezierKt.monotonicQuadraticWinding(fArray2, 4, f, f2, fArray3);
        }
        return n2;
    }

    private static final int monotonicQuadraticWinding(float[] fArray, int n, float f, float f2, float[] fArray2) {
        float f3;
        float f4;
        float f5 = fArray[n + 1];
        float f6 = fArray[n + 5];
        int n2 = 1;
        if (f5 > f6) {
            f4 = f6;
            f6 = f5;
            f5 = f4;
            n2 = -1;
        }
        if (f2 < f5 || f2 >= f6) {
            return 0;
        }
        f5 = fArray[n + 1];
        f4 = fArray[n + 3];
        f6 = fArray[n + 5];
        int n3 = BezierKt.findQuadraticRoots$default(f5 - 2.0f * f4 + f6, 2.0f * (f4 - f5), f5 - f2, fArray2, 0, 16, null);
        float f7 = f3 = n3 == 0 ? fArray[(1 - n2) * 2] : BezierKt.evaluateQuadratic(fArray[0], fArray[2], fArray[4], fArray2[0]);
        float f8 = f;
        boolean bl = false;
        if (!(!(Math.abs(f7 - f8) < 1.05E-6f) || f == fArray[4] && f2 == f6)) {
            return 0;
        }
        return f3 < f ? n2 : 0;
    }

    private static final int quadraticToMonotonicQuadratics(float[] fArray, float[] fArray2) {
        if (fArray.length < 6) {
            return 0;
        }
        if (fArray2.length < 6) {
            return 0;
        }
        float f = fArray[1];
        float f2 = fArray[3];
        float f3 = fArray[5];
        if (!BezierKt.isQuadraticMonotonic(f, f2, f3)) {
            float f4 = BezierKt.unitDivide(f - f2, f - f2 - f2 + f3);
            if (!Float.isNaN(f4)) {
                BezierKt.splitQuadraticAt(fArray, fArray2, f4);
                return 1;
            }
            f2 = Math.abs(f - f2) < Math.abs(f2 - f3) ? f : f3;
        }
        ArraysKt.copyInto((float[])fArray, (float[])fArray2, (int)0, (int)0, (int)6);
        fArray2[3] = f2;
        return 0;
    }

    private static final void splitQuadraticAt(float[] fArray, float[] fArray2, float f) {
        if (fArray.length < 6) {
            return;
        }
        if (fArray2.length < 10) {
            return;
        }
        float f2 = fArray[0];
        float f3 = fArray[1];
        float f4 = fArray[2];
        float f5 = fArray[3];
        float f6 = fArray[4];
        float f7 = fArray[5];
        float f8 = MathHelpersKt.lerp((float)f2, (float)f4, (float)f);
        float f9 = MathHelpersKt.lerp((float)f3, (float)f5, (float)f);
        fArray2[0] = f2;
        fArray2[1] = f3;
        fArray2[2] = f8;
        fArray2[3] = f9;
        float f10 = MathHelpersKt.lerp((float)f4, (float)f6, (float)f);
        float f11 = MathHelpersKt.lerp((float)f5, (float)f7, (float)f);
        float f12 = MathHelpersKt.lerp((float)f8, (float)f10, (float)f);
        float f13 = MathHelpersKt.lerp((float)f9, (float)f11, (float)f);
        fArray2[4] = f12;
        fArray2[5] = f13;
        fArray2[6] = f10;
        fArray2[7] = f11;
        fArray2[8] = f6;
        fArray2[9] = f7;
    }

    private static final float unitDivide(float f, float f2) {
        float f3 = f;
        float f4 = f2;
        if (f3 < 0.0f) {
            f3 = -f3;
            f4 = -f4;
        }
        if (f4 == 0.0f || f3 == 0.0f || f3 >= f4) {
            return Float.NaN;
        }
        float f5 = f3 / f4;
        if (f5 == 0.0f) {
            return Float.NaN;
        }
        return f5;
    }

    public static final int cubicWinding(float[] fArray, float f, float f2, float[] fArray2, float[] fArray3) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray2, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray3, (String)"");
        int n = BezierKt.cubicToMonotonicCubics(fArray, fArray2, fArray3);
        int n2 = 0;
        int n3 = 0;
        if (n3 <= n) {
            while (true) {
                n2 += BezierKt.monotonicCubicWinding(fArray2, n3 * 3 * 2, f, f2);
                if (n3 == n) break;
                ++n3;
            }
        }
        return n2;
    }

    private static final int monotonicCubicWinding(float[] fArray, int n, float f, float f2) {
        float f3;
        float f4 = fArray[n + 1];
        float f5 = fArray[n + 7];
        int n2 = 1;
        if (f4 > f5) {
            f3 = f5;
            f5 = f4;
            f4 = f3;
            n2 = -1;
        }
        if (f2 < f4 || f2 >= f5) {
            return 0;
        }
        f3 = fArray[n + 0];
        float f6 = fArray[n + 2];
        float f7 = fArray[n + 4];
        float f8 = fArray[n + 6];
        float f9 = f3;
        float f10 = f6;
        float f11 = f7;
        float f12 = f8;
        boolean bl = false;
        float f13 = Math.min(f9, Math.min(f10, Math.min(f11, f12)));
        if (f < f13) {
            return 0;
        }
        f10 = f3;
        f11 = f6;
        f12 = f7;
        float f14 = f8;
        boolean bl2 = false;
        f9 = Math.max(f10, Math.max(f11, Math.max(f12, f14)));
        if (f > f9) {
            return n2;
        }
        f4 = fArray[n + 1];
        f10 = fArray[n + 3];
        f11 = fArray[n + 5];
        f5 = fArray[n + 7];
        f12 = BezierKt.findFirstCubicRoot(f4 - f2, f10 - f2, f11 - f2, f5 - f2);
        if (Float.isNaN(f12)) {
            return 0;
        }
        float f15 = f14 = BezierKt.evaluateCubic(f3, f6, f7, f8, f12);
        float f16 = f;
        boolean bl3 = false;
        if (!(!(Math.abs(f15 - f16) < 1.05E-6f) || f == f8 && f2 == f5)) {
            return 0;
        }
        return f14 < f ? n2 : 0;
    }

    private static final int cubicToMonotonicCubics(float[] fArray, float[] fArray2, float[] fArray3) {
        int n = BezierKt.findCubicExtremaY(fArray, fArray3);
        if (n == 0) {
            if (fArray2.length < 8) {
                return 0;
            }
            ArraysKt.copyInto((float[])fArray, (float[])fArray2, (int)0, (int)0, (int)8);
        } else {
            float f = 0.0f;
            int n2 = 0;
            float[] fArray4 = fArray;
            for (int i = 0; i < n; ++i) {
                float f2 = fArray3[i];
                float f3 = (f2 - f) / (1.0f - f);
                float f4 = 0.0f;
                float f5 = 1.0f;
                boolean bl = false;
                float f6 = f3;
                float f7 = f4;
                boolean bl2 = false;
                f6 = f6 < f7 ? f7 : f6;
                f7 = f5;
                bl2 = false;
                f = f2 = f6 > f7 ? f7 : f6;
                BezierKt.splitCubicAt(fArray4, n2, fArray2, n2, f2);
                fArray4 = fArray2;
                n2 += 6;
            }
        }
        return n;
    }

    private static final int findCubicExtremaY(float[] fArray, float[] fArray2) {
        float f = fArray[1];
        float f2 = fArray[3];
        float f3 = fArray[5];
        float f4 = fArray[7];
        float f5 = f4 - f + 3.0f * (f2 - f3);
        float f6 = 2.0f * (f - f2 - f2 - f3);
        float f7 = f2 - f;
        return BezierKt.findQuadraticRoots(f5, f6, f7, fArray2, 0);
    }

    private static final void splitCubicAt(float[] fArray, int n, float[] fArray2, int n2, float f) {
        if (fArray.length < n + 8) {
            return;
        }
        if (fArray2.length < n2 + 14) {
            return;
        }
        if (f >= 1.0f) {
            ArraysKt.copyInto((float[])fArray, (float[])fArray2, (int)n2, (int)n, (int)8);
            float f2 = fArray[n + 6];
            float f3 = fArray[n + 7];
            fArray2[n2 + 8] = f2;
            fArray2[n2 + 9] = f3;
            fArray2[n2 + 10] = f2;
            fArray2[n2 + 11] = f3;
            fArray2[n2 + 12] = f2;
            fArray2[n2 + 13] = f3;
            return;
        }
        float f4 = fArray[n + 0];
        float f5 = fArray[n + 1];
        fArray2[n2 + 0] = f4;
        fArray2[n2 + 1] = f5;
        float f6 = fArray[n + 2];
        float f7 = fArray[n + 3];
        float f8 = MathHelpersKt.lerp((float)f4, (float)f6, (float)f);
        float f9 = MathHelpersKt.lerp((float)f5, (float)f7, (float)f);
        fArray2[n2 + 2] = f8;
        fArray2[n2 + 3] = f9;
        float f10 = fArray[n + 4];
        float f11 = fArray[n + 5];
        float f12 = MathHelpersKt.lerp((float)f6, (float)f10, (float)f);
        float f13 = MathHelpersKt.lerp((float)f7, (float)f11, (float)f);
        float f14 = MathHelpersKt.lerp((float)f8, (float)f12, (float)f);
        float f15 = MathHelpersKt.lerp((float)f9, (float)f13, (float)f);
        fArray2[n2 + 4] = f14;
        fArray2[n2 + 5] = f15;
        float f16 = fArray[n + 6];
        float f17 = fArray[n + 7];
        float f18 = MathHelpersKt.lerp((float)f10, (float)f16, (float)f);
        float f19 = MathHelpersKt.lerp((float)f11, (float)f17, (float)f);
        float f20 = MathHelpersKt.lerp((float)f12, (float)f18, (float)f);
        float f21 = MathHelpersKt.lerp((float)f13, (float)f19, (float)f);
        float f22 = MathHelpersKt.lerp((float)f14, (float)f20, (float)f);
        float f23 = MathHelpersKt.lerp((float)f15, (float)f21, (float)f);
        fArray2[n2 + 6] = f22;
        fArray2[n2 + 7] = f23;
        fArray2[n2 + 8] = f20;
        fArray2[n2 + 9] = f21;
        fArray2[n2 + 10] = f18;
        fArray2[n2 + 11] = f19;
        fArray2[n2 + 12] = f16;
        fArray2[n2 + 13] = f17;
    }

    public static final float cubicArea(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        return ((f8 - f2) * (f3 + f5) - (f7 - f) * (f4 + f6) + f4 * (f - f5) - f3 * (f2 - f6) + f8 * (f5 + f / 3.0f) - f7 * (f6 + f2 / 3.0f)) * 3.0f / 20.0f;
    }

    private static final float getStartX(PathSegment pathSegment) {
        boolean bl = false;
        return pathSegment.getPoints()[0];
    }

    private static final float getEndX(PathSegment pathSegment) {
        int n;
        float[] fArray = pathSegment.getPoints();
        switch (WhenMappings.$EnumSwitchMapping$0[pathSegment.getType().ordinal()]) {
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 4;
                break;
            }
            case 5: {
                n = 4;
                break;
            }
            case 4: {
                n = 6;
                break;
            }
            default: {
                n = 0;
            }
        }
        return fArray[n];
    }

    private static final float getStartY(PathSegment pathSegment) {
        boolean bl = false;
        return pathSegment.getPoints()[1];
    }

    private static final float getEndY(PathSegment pathSegment) {
        int n;
        float[] fArray = pathSegment.getPoints();
        switch (WhenMappings.$EnumSwitchMapping$0[pathSegment.getType().ordinal()]) {
            case 2: {
                n = 3;
                break;
            }
            case 3: {
                n = 5;
                break;
            }
            case 5: {
                n = 5;
                break;
            }
            case 4: {
                n = 7;
                break;
            }
            default: {
                n = 0;
            }
        }
        return fArray[n];
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PathSegment.Type.values().length];
            try {
                nArray[PathSegment.Type.Move.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Line.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Quadratic.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Cubic.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Conic.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Close.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Done.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

