/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import androidx.compose.ui.graphics.DesktopImageAsset_desktopKt;
import androidx.compose.ui.graphics.ImageBitmap;
import androidx.compose.ui.graphics.SkiaImageAsset_skikoKt;
import androidx.compose.ui.graphics.colorspace.ColorSpace;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ColorInfo;
import org.jetbrains.skia.ColorType;
import org.jetbrains.skia.ImageInfo;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001a\u001a\u00020\u001bH\u0016J@\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000fR\u0014\u0010\u0018\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000f\u00a8\u0006#"}, d2={"Landroidx/compose/ui/graphics/SkiaBackedImageBitmap;", "Landroidx/compose/ui/graphics/ImageBitmap;", "bitmap", "Lorg/jetbrains/skia/Bitmap;", "<init>", "(Lorg/jetbrains/skia/Bitmap;)V", "getBitmap", "()Lorg/jetbrains/skia/Bitmap;", "colorSpace", "Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "getColorSpace", "()Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "config", "Landroidx/compose/ui/graphics/ImageBitmapConfig;", "getConfig-_sVssgQ", "()I", "I", "hasAlpha", "", "getHasAlpha", "()Z", "height", "", "getHeight", "width", "getWidth", "prepareToDraw", "", "readPixels", "buffer", "", "startX", "startY", "bufferOffset", "stride", "ui-graphics"})
final class SkiaBackedImageBitmap
implements ImageBitmap {
    private final Bitmap bitmap;
    private final ColorSpace colorSpace;
    private final int config;
    private final boolean hasAlpha;

    public SkiaBackedImageBitmap(Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"");
        this.bitmap = bitmap;
        this.colorSpace = SkiaImageAsset_skikoKt.access$toComposeColorSpace(this.bitmap.getColorSpace());
        this.config = SkiaImageAsset_skikoKt.access$toComposeConfig(this.bitmap.getColorType());
        this.hasAlpha = !this.bitmap.isOpaque();
    }

    public final Bitmap getBitmap() {
        return this.bitmap;
    }

    @Override
    public ColorSpace getColorSpace() {
        return this.colorSpace;
    }

    @Override
    public int getConfig-_sVssgQ() {
        return this.config;
    }

    @Override
    public boolean getHasAlpha() {
        return this.hasAlpha;
    }

    @Override
    public int getHeight() {
        return this.bitmap.getHeight();
    }

    @Override
    public int getWidth() {
        return this.bitmap.getWidth();
    }

    @Override
    public void prepareToDraw() {
    }

    @Override
    public void readPixels(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"");
        int n7 = n5 + (n4 - 1) * n6;
        if (!(n >= 0 && n2 >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(n3 > 0 && n + n3 <= this.getWidth())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(n4 > 0 && n2 + n4 <= this.getHeight())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(Math.abs(n6) >= n3)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(n5 >= 0 && n5 + n3 <= nArray.length)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(n7 >= 0 && n7 + n3 <= nArray.length)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        ColorInfo colorInfo = new ColorInfo(ColorType.BGRA_8888, ColorAlphaType.UNPREMUL, org.jetbrains.skia.ColorSpace.Companion.getSRGB());
        ImageInfo imageInfo = new ImageInfo(colorInfo, n3, n4);
        int n8 = 4;
        byte[] byArray = this.bitmap.readPixels(imageInfo, n6 * n8, n, n2);
        Intrinsics.checkNotNull((Object)byArray);
        byte[] byArray2 = byArray;
        DesktopImageAsset_desktopKt.putBytesInto(byArray2, nArray, n5, byArray2.length / n8);
    }
}

